import * as sqs from 'aws-cdk-lib/aws-sqs';
import * as sfn from 'aws-cdk-lib/aws-stepfunctions';
import { Construct } from 'constructs';
export interface StepFunctionsTPSTokenBucketProps {
    readonly tokenLimit: number;
    readonly tokenBucketDDBTableName?: string;
    readonly tokenBucketDDBTableID?: string;
    /** queue to use for the task token requests - allows for distribution of tokens across different workflows. Queue and DDB table should obviously be the same if spreading */
    readonly sqsQueue?: sqs.IQueue;
    /** TODO Implement */
    readonly sqsQueueVisibilityTimeoutInSeconds?: number;
}
export declare class StepFunctionsTPSTokenBucket extends sfn.StateMachineFragment {
    readonly startState: sfn.State;
    readonly endStates: sfn.INextable[];
    constructor(parent: Construct, id: string, props: StepFunctionsTPSTokenBucketProps);
}
