# DO NOT EDIT: Autogenerated by src/docker_composer/_utils/generate_class.py
# for docker-compose version 1.25.0, build unknown

from typing import List, Optional

import attr

from docker_composer.base import DockerBaseRunner


@attr.s(auto_attribs=True)
class DockerComposeUp(DockerBaseRunner):
    """
    Builds, (re)creates, starts, and attaches to containers for a service.

    Unless they are already running, this command also starts any linked services.

    The `docker-compose up` command aggregates the output of each container. When
    the command exits, all containers are stopped. Running `docker-compose up -d`
    starts the containers in the background and leaves them running.

    If there are existing containers for a service, and the service's configuration
    or image was changed after the container's creation, `docker-compose up` picks
    up the changes by stopping and recreating the containers (preserving mounted
    volumes). To prevent Compose from picking up changes, use the `--no-recreate`
    flag.

    If you want to force Compose to stop and recreate all containers, use the
    `--force-recreate` flag.

    Usage: up [options] [--scale SERVICE=NUM...] [SERVICE...]

    """

    detach: Optional[bool] = None
    """Detached mode: Run containers in the background,
       print new container names. Incompatible with
       --abort-on-container-exit."""
    no_color: Optional[bool] = None
    """Produce monochrome output."""
    quiet_pull: Optional[bool] = None
    """Pull without printing progress information"""
    no_deps: Optional[bool] = None
    """Don't start linked services."""
    force_recreate: Optional[bool] = None
    """Recreate containers even if their configuration
       and image haven't changed."""
    always_recreate_deps: Optional[bool] = None
    """Recreate dependent containers.
       Incompatible with --no-recreate."""
    no_recreate: Optional[bool] = None
    """If containers already exist, don't recreate
       them. Incompatible with --force-recreate and -V."""
    no_build: Optional[bool] = None
    """Don't build an image, even if it's missing."""
    no_start: Optional[bool] = None
    """Don't start the services after creating them."""
    build: Optional[bool] = None
    """Build images before starting containers."""
    abort_on_container_exit: Optional[bool] = None
    """Stops all containers if any container was
       stopped. Incompatible with -d."""
    timeout: Optional[int] = None
    """Use this timeout in seconds for container
       shutdown when attached or when containers are
       already running. (default: 10)"""
    renew_anon_volumes: Optional[bool] = None
    """Recreate anonymous volumes instead of retrieving
       data from the previous containers."""
    remove_orphans: Optional[bool] = None
    """Remove containers for services not defined
       in the Compose file."""
    exit_code_from: Optional[str] = None
    """Return the exit code of the selected service
       container. Implies --abort-on-container-exit."""
    scale: Optional[dict] = None
    """Scale SERVICE to NUM instances. Overrides the
       `scale` setting in the Compose file if present."""
    _cmd: str = "up"
    _options: List[str] = [
        "detach",
        "no_color",
        "quiet_pull",
        "no_deps",
        "force_recreate",
        "always_recreate_deps",
        "no_recreate",
        "no_build",
        "no_start",
        "build",
        "abort_on_container_exit",
        "renew_anon_volumes",
        "remove_orphans",
    ]
