# DO NOT EDIT: Autogenerated by src/docker_composer/_utils/generate_class.py
# for docker-compose version 1.25.0, build unknown

from typing import List, Optional

import attr

from docker_composer.base import DockerBaseRunner


@attr.s(auto_attribs=True)
class DockerComposeBuild(DockerBaseRunner):
    """
    Build or rebuild services.

    Services are built once and then tagged as `project_service`,
    e.g. `composetest_db`. If you change a service's `Dockerfile` or the
    contents of its build directory, you can run `docker-compose build` to rebuild it.

    Usage: build [options] [--build-arg key=val...] [SERVICE...]

    """

    build_arg: Optional[dict] = None
    """Set build-time variables for services."""
    compress: Optional[bool] = None
    """Compress the build context using gzip."""
    force_rm: Optional[bool] = None
    """Always remove intermediate containers."""
    memory: Optional[int] = None
    """Set memory limit for the build container."""
    no_cache: Optional[bool] = None
    """Do not use cache when building the image."""
    no_rm: Optional[bool] = None
    """Do not remove intermediate containers after a successful build."""
    parallel: Optional[bool] = None
    """Build images in parallel."""
    progress: Optional[str] = None
    """Set type of progress output (auto, plain, tty).
       EXPERIMENTAL flag for native builder.
       To enable, run with COMPOSE_DOCKER_CLI_BUILD=1)"""
    pull: Optional[bool] = None
    """Always attempt to pull a newer version of the image."""
    quiet: Optional[bool] = None
    """Don't print anything to STDOUT"""
    _cmd: str = "build"
    _options: List[str] = [
        "compress",
        "force_rm",
        "no_cache",
        "no_rm",
        "parallel",
        "pull",
        "quiet",
    ]
