# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AviatrixSpokeGatewaySubnetGroupArgs', 'AviatrixSpokeGatewaySubnetGroup']

@pulumi.input_type
class AviatrixSpokeGatewaySubnetGroupArgs:
    def __init__(__self__, *,
                 gw_name: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AviatrixSpokeGatewaySubnetGroup resource.
        :param pulumi.Input[str] gw_name: Aviatrix spoke gateway name.
        :param pulumi.Input[str] name: Name of spoke gateway subnet group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A set of subnets in the subnet group. The format of each subnet must be "CIDR~~subnet name". Example: `["10.2.48.0/20~~subnet1", "10.2.64.0/20~~subnet2"]`
        """
        pulumi.set(__self__, "gw_name", gw_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Input[str]:
        """
        Aviatrix spoke gateway name.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of spoke gateway subnet group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of subnets in the subnet group. The format of each subnet must be "CIDR~~subnet name". Example: `["10.2.48.0/20~~subnet1", "10.2.64.0/20~~subnet2"]`
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)


@pulumi.input_type
class _AviatrixSpokeGatewaySubnetGroupState:
    def __init__(__self__, *,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering AviatrixSpokeGatewaySubnetGroup resources.
        :param pulumi.Input[str] gw_name: Aviatrix spoke gateway name.
        :param pulumi.Input[str] name: Name of spoke gateway subnet group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A set of subnets in the subnet group. The format of each subnet must be "CIDR~~subnet name". Example: `["10.2.48.0/20~~subnet1", "10.2.64.0/20~~subnet2"]`
        """
        if gw_name is not None:
            pulumi.set(__self__, "gw_name", gw_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subnets is not None:
            pulumi.set(__self__, "subnets", subnets)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> Optional[pulumi.Input[str]]:
        """
        Aviatrix spoke gateway name.
        """
        return pulumi.get(self, "gw_name")

    @gw_name.setter
    def gw_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gw_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of spoke gateway subnet group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of subnets in the subnet group. The format of each subnet must be "CIDR~~subnet name". Example: `["10.2.48.0/20~~subnet1", "10.2.64.0/20~~subnet2"]`
        """
        return pulumi.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnets", value)


class AviatrixSpokeGatewaySubnetGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        The **aviatrix_spoke_gateway_subnet_group** resource creates and manages the spoke gateway subnet groups.

        > **NOTE:** This feature is only valid for Azure.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Spoke Inspection Subnet Group
        test = aviatrix.AviatrixSpokeGatewaySubnetGroup("test",
            gw_name="spoke",
            subnets=[
                "10.2.48.0/20~~subnet1",
                "10.2.64.0/20~~subnet2",
            ])
        ```

        ## Import

        **spoke_gateway_subnet_group** can be imported using the `gw_name` and `name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSpokeGatewaySubnetGroup:AviatrixSpokeGatewaySubnetGroup test gw_name~name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] gw_name: Aviatrix spoke gateway name.
        :param pulumi.Input[str] name: Name of spoke gateway subnet group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A set of subnets in the subnet group. The format of each subnet must be "CIDR~~subnet name". Example: `["10.2.48.0/20~~subnet1", "10.2.64.0/20~~subnet2"]`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AviatrixSpokeGatewaySubnetGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The **aviatrix_spoke_gateway_subnet_group** resource creates and manages the spoke gateway subnet groups.

        > **NOTE:** This feature is only valid for Azure.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_aviatrix as aviatrix

        # Create an Aviatrix Spoke Inspection Subnet Group
        test = aviatrix.AviatrixSpokeGatewaySubnetGroup("test",
            gw_name="spoke",
            subnets=[
                "10.2.48.0/20~~subnet1",
                "10.2.64.0/20~~subnet2",
            ])
        ```

        ## Import

        **spoke_gateway_subnet_group** can be imported using the `gw_name` and `name`, e.g.

        ```sh
         $ pulumi import aviatrix:index/aviatrixSpokeGatewaySubnetGroup:AviatrixSpokeGatewaySubnetGroup test gw_name~name
        ```

        :param str resource_name: The name of the resource.
        :param AviatrixSpokeGatewaySubnetGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AviatrixSpokeGatewaySubnetGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 gw_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AviatrixSpokeGatewaySubnetGroupArgs.__new__(AviatrixSpokeGatewaySubnetGroupArgs)

            if gw_name is None and not opts.urn:
                raise TypeError("Missing required property 'gw_name'")
            __props__.__dict__["gw_name"] = gw_name
            __props__.__dict__["name"] = name
            __props__.__dict__["subnets"] = subnets
        super(AviatrixSpokeGatewaySubnetGroup, __self__).__init__(
            'aviatrix:index/aviatrixSpokeGatewaySubnetGroup:AviatrixSpokeGatewaySubnetGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            gw_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'AviatrixSpokeGatewaySubnetGroup':
        """
        Get an existing AviatrixSpokeGatewaySubnetGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] gw_name: Aviatrix spoke gateway name.
        :param pulumi.Input[str] name: Name of spoke gateway subnet group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnets: A set of subnets in the subnet group. The format of each subnet must be "CIDR~~subnet name". Example: `["10.2.48.0/20~~subnet1", "10.2.64.0/20~~subnet2"]`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AviatrixSpokeGatewaySubnetGroupState.__new__(_AviatrixSpokeGatewaySubnetGroupState)

        __props__.__dict__["gw_name"] = gw_name
        __props__.__dict__["name"] = name
        __props__.__dict__["subnets"] = subnets
        return AviatrixSpokeGatewaySubnetGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="gwName")
    def gw_name(self) -> pulumi.Output[str]:
        """
        Aviatrix spoke gateway name.
        """
        return pulumi.get(self, "gw_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of spoke gateway subnet group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def subnets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of subnets in the subnet group. The format of each subnet must be "CIDR~~subnet name". Example: `["10.2.48.0/20~~subnet1", "10.2.64.0/20~~subnet2"]`
        """
        return pulumi.get(self, "subnets")

