import * as cloudfront from '@aws-cdk/aws-cloudfront';
import { Construct } from '@aws-cdk/core';
/**
 * Construction properties for {@link OriginGroup}.
 *
 * @stability stable
 */
export interface OriginGroupProps {
    /**
     * The primary origin that should serve requests for this group.
     *
     * @stability stable
     */
    readonly primaryOrigin: cloudfront.IOrigin;
    /**
     * The fallback origin that should serve requests when the primary fails.
     *
     * @stability stable
     */
    readonly fallbackOrigin: cloudfront.IOrigin;
    /**
     * The list of HTTP status codes that, when returned from the primary origin, would cause querying the fallback origin.
     *
     * @default - 500, 502, 503 and 504
     * @stability stable
     */
    readonly fallbackStatusCodes?: number[];
}
/**
 * An Origin that represents a group.
 *
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 *
 * @stability stable
 */
export declare class OriginGroup implements cloudfront.IOrigin {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: OriginGroupProps);
    /**
     * The method called when a given Origin is added (for the first time) to a Distribution.
     *
     * @stability stable
     */
    bind(scope: Construct, options: cloudfront.OriginBindOptions): cloudfront.OriginBindConfig;
}
