# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SshTunnel(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'host': 'str',
        'port': 'int',
        'user': 'str',
        'user_key_pair': 'bool'
    }

    attribute_map = {
        'host': 'host',
        'port': 'port',
        'user': 'user',
        'user_key_pair': 'userKeyPair'
    }

    def __init__(self, host=None, port=None, user=None, user_key_pair=False):
        """
        SshTunnel - a model defined in Swagger
        """

        self._host = None
        self._port = None
        self._user = None
        self._user_key_pair = None

        self.host = host
        if port is not None:
          self.port = port
        self.user = user
        self.user_key_pair = user_key_pair

    @property
    def host(self):
        """
        Gets the host of this SshTunnel.
        ssh tunnel host

        :return: The host of this SshTunnel.
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        Sets the host of this SshTunnel.
        ssh tunnel host

        :param host: The host of this SshTunnel.
        :type: str
        """
        if host is None:
            raise ValueError("Invalid value for `host`, must not be `None`")

        self._host = host

    @property
    def port(self):
        """
        Gets the port of this SshTunnel.
        Tunnel Port

        :return: The port of this SshTunnel.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this SshTunnel.
        Tunnel Port

        :param port: The port of this SshTunnel.
        :type: int
        """
        if port is not None and port > 65535:
            raise ValueError("Invalid value for `port`, must be a value less than or equal to `65535`")
        if port is not None and port < 1:
            raise ValueError("Invalid value for `port`, must be a value greater than or equal to `1`")

        self._port = port

    @property
    def user(self):
        """
        Gets the user of this SshTunnel.
        user name

        :return: The user of this SshTunnel.
        :rtype: str
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Sets the user of this SshTunnel.
        user name

        :param user: The user of this SshTunnel.
        :type: str
        """
        if user is None:
            raise ValueError("Invalid value for `user`, must not be `None`")
        if user is not None and len(user) > 1024:
            raise ValueError("Invalid value for `user`, length must be less than or equal to `1024`")
        if user is not None and len(user) < 0:
            raise ValueError("Invalid value for `user`, length must be greater than or equal to `0`")

        self._user = user

    @property
    def user_key_pair(self):
        """
        Gets the user_key_pair of this SshTunnel.
        whether authentication is required

        :return: The user_key_pair of this SshTunnel.
        :rtype: bool
        """
        return self._user_key_pair

    @user_key_pair.setter
    def user_key_pair(self, user_key_pair):
        """
        Sets the user_key_pair of this SshTunnel.
        whether authentication is required

        :param user_key_pair: The user_key_pair of this SshTunnel.
        :type: bool
        """
        if user_key_pair is None:
            raise ValueError("Invalid value for `user_key_pair`, must not be `None`")

        self._user_key_pair = user_key_pair

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SshTunnel):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
