# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class SearchRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'query': 'str',
        'category': 'list[str]',
        'resource_id': 'list[str]',
        'type': 'list[str]',
        'owner': 'list[str]',
        'min_access_level': 'str',
        'tag': 'list[str]',
        'visibility': 'str',
        'created_range': 'Range',
        'updated_range': 'Range'
    }

    attribute_map = {
        'query': 'query',
        'category': 'category',
        'resource_id': 'resourceId',
        'type': 'type',
        'owner': 'owner',
        'min_access_level': 'minAccessLevel',
        'tag': 'tag',
        'visibility': 'visibility',
        'created_range': 'createdRange',
        'updated_range': 'updatedRange'
    }

    def __init__(self, query=None, category=None, resource_id=None, type=None, owner=None, min_access_level=None, tag=None, visibility=None, created_range=None, updated_range=None):
        """
        SearchRequest - a model defined in Swagger
        """

        self._query = None
        self._category = None
        self._resource_id = None
        self._type = None
        self._owner = None
        self._min_access_level = None
        self._tag = None
        self._visibility = None
        self._created_range = None
        self._updated_range = None

        self.query = query
        if category is not None:
          self.category = category
        if resource_id is not None:
          self.resource_id = resource_id
        if type is not None:
          self.type = type
        if owner is not None:
          self.owner = owner
        if min_access_level is not None:
          self.min_access_level = min_access_level
        if tag is not None:
          self.tag = tag
        if visibility is not None:
          self.visibility = visibility
        if created_range is not None:
          self.created_range = created_range
        if updated_range is not None:
          self.updated_range = updated_range

    @property
    def query(self):
        """
        Gets the query of this SearchRequest.

        :return: The query of this SearchRequest.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this SearchRequest.

        :param query: The query of this SearchRequest.
        :type: str
        """
        if query is None:
            raise ValueError("Invalid value for `query`, must not be `None`")

        self._query = query

    @property
    def category(self):
        """
        Gets the category of this SearchRequest.
        Filter by categories.

        :return: The category of this SearchRequest.
        :rtype: list[str]
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this SearchRequest.
        Filter by categories.

        :param category: The category of this SearchRequest.
        :type: list[str]
        """
        allowed_values = ["catalogAnalysis", "catalogBusinessTerm", "catalogDataset", "catalogDataType", "catalogTable", "collection", "comment", "dataset", "datatable", "file", "insight", "integration", "project", "query"]
        if not set(category).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `category` [{0}], must be a subset of [{1}]"
                .format(", ".join(map(str, set(category)-set(allowed_values))),
                        ", ".join(map(str, allowed_values)))
            )

        self._category = category

    @property
    def resource_id(self):
        """
        Gets the resource_id of this SearchRequest.
        Filter by resource IDs.

        :return: The resource_id of this SearchRequest.
        :rtype: list[str]
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this SearchRequest.
        Filter by resource IDs.

        :param resource_id: The resource_id of this SearchRequest.
        :type: list[str]
        """

        self._resource_id = resource_id

    @property
    def type(self):
        """
        Gets the type of this SearchRequest.
        Filter by type of metadata resource. Both IRI and label are accepted.

        :return: The type of this SearchRequest.
        :rtype: list[str]
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this SearchRequest.
        Filter by type of metadata resource. Both IRI and label are accepted.

        :param type: The type of this SearchRequest.
        :type: list[str]
        """

        self._type = type

    @property
    def owner(self):
        """
        Gets the owner of this SearchRequest.
        Filter by owners. Owners are identified by their IDs.

        :return: The owner of this SearchRequest.
        :rtype: list[str]
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this SearchRequest.
        Filter by owners. Owners are identified by their IDs.

        :param owner: The owner of this SearchRequest.
        :type: list[str]
        """

        self._owner = owner

    @property
    def min_access_level(self):
        """
        Gets the min_access_level of this SearchRequest.
        Minimum access level to filter by.

        :return: The min_access_level of this SearchRequest.
        :rtype: str
        """
        return self._min_access_level

    @min_access_level.setter
    def min_access_level(self, min_access_level):
        """
        Sets the min_access_level of this SearchRequest.
        Minimum access level to filter by.

        :param min_access_level: The min_access_level of this SearchRequest.
        :type: str
        """
        allowed_values = ["NONE", "SAML_GATED", "DISCOVER", "READ", "WRITE", "ADMIN"]
        if min_access_level not in allowed_values:
            raise ValueError(
                "Invalid value for `min_access_level` ({0}), must be one of {1}"
                .format(min_access_level, allowed_values)
            )

        self._min_access_level = min_access_level

    @property
    def tag(self):
        """
        Gets the tag of this SearchRequest.
        Filter by tags.

        :return: The tag of this SearchRequest.
        :rtype: list[str]
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """
        Sets the tag of this SearchRequest.
        Filter by tags.

        :param tag: The tag of this SearchRequest.
        :type: list[str]
        """

        self._tag = tag

    @property
    def visibility(self):
        """
        Gets the visibility of this SearchRequest.
        Filter by visibility.

        :return: The visibility of this SearchRequest.
        :rtype: str
        """
        return self._visibility

    @visibility.setter
    def visibility(self, visibility):
        """
        Sets the visibility of this SearchRequest.
        Filter by visibility.

        :param visibility: The visibility of this SearchRequest.
        :type: str
        """
        allowed_values = ["DISCOVERABLE", "OPEN", "PRIVATE"]
        if visibility not in allowed_values:
            raise ValueError(
                "Invalid value for `visibility` ({0}), must be one of {1}"
                .format(visibility, allowed_values)
            )

        self._visibility = visibility

    @property
    def created_range(self):
        """
        Gets the created_range of this SearchRequest.
        Filter by range of date that the resource was created.

        :return: The created_range of this SearchRequest.
        :rtype: Range
        """
        return self._created_range

    @created_range.setter
    def created_range(self, created_range):
        """
        Sets the created_range of this SearchRequest.
        Filter by range of date that the resource was created.

        :param created_range: The created_range of this SearchRequest.
        :type: Range
        """

        self._created_range = created_range

    @property
    def updated_range(self):
        """
        Gets the updated_range of this SearchRequest.
        Filter by range of date that the resource was updated.

        :return: The updated_range of this SearchRequest.
        :rtype: Range
        """
        return self._updated_range

    @updated_range.setter
    def updated_range(self, updated_range):
        """
        Sets the updated_range of this SearchRequest.
        Filter by range of date that the resource was updated.

        :param updated_range: The updated_range of this SearchRequest.
        :type: Range
        """

        self._updated_range = updated_range

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, SearchRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
