# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class LinkedDatasetSummaryResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_level': 'str',
        'created': 'str',
        'description': 'str',
        'id': 'str',
        'license': 'str',
        'owner': 'str',
        'summary': 'str',
        'tags': 'list[str]',
        'title': 'str',
        'updated': 'str',
        'version': 'str',
        'visibility': 'str'
    }

    attribute_map = {
        'access_level': 'accessLevel',
        'created': 'created',
        'description': 'description',
        'id': 'id',
        'license': 'license',
        'owner': 'owner',
        'summary': 'summary',
        'tags': 'tags',
        'title': 'title',
        'updated': 'updated',
        'version': 'version',
        'visibility': 'visibility'
    }

    def __init__(self, access_level=None, created=None, description=None, id=None, license=None, owner=None, summary=None, tags=None, title=None, updated=None, version=None, visibility=None):
        """
        LinkedDatasetSummaryResponse - a model defined in Swagger
        """

        self._access_level = None
        self._created = None
        self._description = None
        self._id = None
        self._license = None
        self._owner = None
        self._summary = None
        self._tags = None
        self._title = None
        self._updated = None
        self._version = None
        self._visibility = None

        self.access_level = access_level
        self.created = created
        if description is not None:
          self.description = description
        self.id = id
        if license is not None:
          self.license = license
        self.owner = owner
        if summary is not None:
          self.summary = summary
        if tags is not None:
          self.tags = tags
        self.title = title
        self.updated = updated
        if version is not None:
          self.version = version
        self.visibility = visibility

    @property
    def access_level(self):
        """
        Gets the access_level of this LinkedDatasetSummaryResponse.
        The level of access the authenticated user is allowed with respect to dataset:   * `NONE` Not allowed any access.   * `READ` Allowed to know that the dataset exists, view and download data and metadata.  * `WRITE` Allowed to update data and metadata, in addition to what READ allows.  * `ADMIN` Allowed to delete dataset, in addition to what WRITE allows.

        :return: The access_level of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._access_level

    @access_level.setter
    def access_level(self, access_level):
        """
        Sets the access_level of this LinkedDatasetSummaryResponse.
        The level of access the authenticated user is allowed with respect to dataset:   * `NONE` Not allowed any access.   * `READ` Allowed to know that the dataset exists, view and download data and metadata.  * `WRITE` Allowed to update data and metadata, in addition to what READ allows.  * `ADMIN` Allowed to delete dataset, in addition to what WRITE allows.

        :param access_level: The access_level of this LinkedDatasetSummaryResponse.
        :type: str
        """
        if access_level is None:
            raise ValueError("Invalid value for `access_level`, must not be `None`")

        self._access_level = access_level

    @property
    def created(self):
        """
        Gets the created of this LinkedDatasetSummaryResponse.
        Date and time when the dataset was created.

        :return: The created of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._created

    @created.setter
    def created(self, created):
        """
        Sets the created of this LinkedDatasetSummaryResponse.
        Date and time when the dataset was created.

        :param created: The created of this LinkedDatasetSummaryResponse.
        :type: str
        """
        if created is None:
            raise ValueError("Invalid value for `created`, must not be `None`")

        self._created = created

    @property
    def description(self):
        """
        Gets the description of this LinkedDatasetSummaryResponse.
        Short dataset description.

        :return: The description of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this LinkedDatasetSummaryResponse.
        Short dataset description.

        :param description: The description of this LinkedDatasetSummaryResponse.
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """
        Gets the id of this LinkedDatasetSummaryResponse.
        Unique identifier of dataset.

        :return: The id of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LinkedDatasetSummaryResponse.
        Unique identifier of dataset.

        :param id: The id of this LinkedDatasetSummaryResponse.
        :type: str
        """
        if id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")

        self._id = id

    @property
    def license(self):
        """
        Gets the license of this LinkedDatasetSummaryResponse.
        Dataset license. Find additional info for allowed values [here](https://data.world/license-help).

        :return: The license of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._license

    @license.setter
    def license(self, license):
        """
        Sets the license of this LinkedDatasetSummaryResponse.
        Dataset license. Find additional info for allowed values [here](https://data.world/license-help).

        :param license: The license of this LinkedDatasetSummaryResponse.
        :type: str
        """

        self._license = license

    @property
    def owner(self):
        """
        Gets the owner of this LinkedDatasetSummaryResponse.
        User name and unique identifier of the creator of the dataset.

        :return: The owner of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._owner

    @owner.setter
    def owner(self, owner):
        """
        Sets the owner of this LinkedDatasetSummaryResponse.
        User name and unique identifier of the creator of the dataset.

        :param owner: The owner of this LinkedDatasetSummaryResponse.
        :type: str
        """
        if owner is None:
            raise ValueError("Invalid value for `owner`, must not be `None`")

        self._owner = owner

    @property
    def summary(self):
        """
        Gets the summary of this LinkedDatasetSummaryResponse.
        Long-form dataset summary (Markdown supported).

        :return: The summary of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._summary

    @summary.setter
    def summary(self, summary):
        """
        Sets the summary of this LinkedDatasetSummaryResponse.
        Long-form dataset summary (Markdown supported).

        :param summary: The summary of this LinkedDatasetSummaryResponse.
        :type: str
        """

        self._summary = summary

    @property
    def tags(self):
        """
        Gets the tags of this LinkedDatasetSummaryResponse.
        Dataset tags. Letters numbers and spaces only (max 25 characters).

        :return: The tags of this LinkedDatasetSummaryResponse.
        :rtype: list[str]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this LinkedDatasetSummaryResponse.
        Dataset tags. Letters numbers and spaces only (max 25 characters).

        :param tags: The tags of this LinkedDatasetSummaryResponse.
        :type: list[str]
        """

        self._tags = tags

    @property
    def title(self):
        """
        Gets the title of this LinkedDatasetSummaryResponse.
        Dataset name.

        :return: The title of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this LinkedDatasetSummaryResponse.
        Dataset name.

        :param title: The title of this LinkedDatasetSummaryResponse.
        :type: str
        """
        if title is None:
            raise ValueError("Invalid value for `title`, must not be `None`")

        self._title = title

    @property
    def updated(self):
        """
        Gets the updated of this LinkedDatasetSummaryResponse.
        Date and time when the dataset was last updated.

        :return: The updated of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """
        Sets the updated of this LinkedDatasetSummaryResponse.
        Date and time when the dataset was last updated.

        :param updated: The updated of this LinkedDatasetSummaryResponse.
        :type: str
        """
        if updated is None:
            raise ValueError("Invalid value for `updated`, must not be `None`")

        self._updated = updated

    @property
    def version(self):
        """
        Gets the version of this LinkedDatasetSummaryResponse.
        Dataset version

        :return: The version of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this LinkedDatasetSummaryResponse.
        Dataset version

        :param version: The version of this LinkedDatasetSummaryResponse.
        :type: str
        """

        self._version = version

    @property
    def visibility(self):
        """
        Gets the visibility of this LinkedDatasetSummaryResponse.
        Dataset visibility. `OPEN` if the dataset can be seen by any member of data.world. `PRIVATE` if the dataset can be seen by its owner and authorized collaborators. `DISCOVERABLE` if the dataset can be seen by any member of data.world, but only files marked `sample` or `preview` are visible

        :return: The visibility of this LinkedDatasetSummaryResponse.
        :rtype: str
        """
        return self._visibility

    @visibility.setter
    def visibility(self, visibility):
        """
        Sets the visibility of this LinkedDatasetSummaryResponse.
        Dataset visibility. `OPEN` if the dataset can be seen by any member of data.world. `PRIVATE` if the dataset can be seen by its owner and authorized collaborators. `DISCOVERABLE` if the dataset can be seen by any member of data.world, but only files marked `sample` or `preview` are visible

        :param visibility: The visibility of this LinkedDatasetSummaryResponse.
        :type: str
        """
        if visibility is None:
            raise ValueError("Invalid value for `visibility`, must not be `None`")

        self._visibility = visibility

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, LinkedDatasetSummaryResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
