# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class InsightHydrationDto(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'body': 'str',
        'created_by': 'AgentHydrationDto',
        'dataset': 'DatasetHydrationDto',
        'datasetid': 'str',
        'data_sources': 'list[str]',
        'description': 'str',
        'insightid': 'str',
        'thumbnail': 'str',
        'title': 'str',
        'type': 'str',
        'updated': 'datetime'
    }

    attribute_map = {
        'body': 'body',
        'created_by': 'createdBy',
        'dataset': 'dataset',
        'datasetid': 'datasetid',
        'data_sources': 'dataSources',
        'description': 'description',
        'insightid': 'insightid',
        'thumbnail': 'thumbnail',
        'title': 'title',
        'type': 'type',
        'updated': 'updated'
    }

    def __init__(self, body=None, created_by=None, dataset=None, datasetid=None, data_sources=None, description=None, insightid=None, thumbnail=None, title=None, type=None, updated=None):
        """
        InsightHydrationDto - a model defined in Swagger
        """

        self._body = None
        self._created_by = None
        self._dataset = None
        self._datasetid = None
        self._data_sources = None
        self._description = None
        self._insightid = None
        self._thumbnail = None
        self._title = None
        self._type = None
        self._updated = None

        if body is not None:
          self.body = body
        if created_by is not None:
          self.created_by = created_by
        if dataset is not None:
          self.dataset = dataset
        if datasetid is not None:
          self.datasetid = datasetid
        if data_sources is not None:
          self.data_sources = data_sources
        if description is not None:
          self.description = description
        if insightid is not None:
          self.insightid = insightid
        if thumbnail is not None:
          self.thumbnail = thumbnail
        if title is not None:
          self.title = title
        if type is not None:
          self.type = type
        if updated is not None:
          self.updated = updated

    @property
    def body(self):
        """
        Gets the body of this InsightHydrationDto.

        :return: The body of this InsightHydrationDto.
        :rtype: str
        """
        return self._body

    @body.setter
    def body(self, body):
        """
        Sets the body of this InsightHydrationDto.

        :param body: The body of this InsightHydrationDto.
        :type: str
        """

        self._body = body

    @property
    def created_by(self):
        """
        Gets the created_by of this InsightHydrationDto.

        :return: The created_by of this InsightHydrationDto.
        :rtype: AgentHydrationDto
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this InsightHydrationDto.

        :param created_by: The created_by of this InsightHydrationDto.
        :type: AgentHydrationDto
        """

        self._created_by = created_by

    @property
    def dataset(self):
        """
        Gets the dataset of this InsightHydrationDto.

        :return: The dataset of this InsightHydrationDto.
        :rtype: DatasetHydrationDto
        """
        return self._dataset

    @dataset.setter
    def dataset(self, dataset):
        """
        Sets the dataset of this InsightHydrationDto.

        :param dataset: The dataset of this InsightHydrationDto.
        :type: DatasetHydrationDto
        """

        self._dataset = dataset

    @property
    def datasetid(self):
        """
        Gets the datasetid of this InsightHydrationDto.

        :return: The datasetid of this InsightHydrationDto.
        :rtype: str
        """
        return self._datasetid

    @datasetid.setter
    def datasetid(self, datasetid):
        """
        Sets the datasetid of this InsightHydrationDto.

        :param datasetid: The datasetid of this InsightHydrationDto.
        :type: str
        """

        self._datasetid = datasetid

    @property
    def data_sources(self):
        """
        Gets the data_sources of this InsightHydrationDto.

        :return: The data_sources of this InsightHydrationDto.
        :rtype: list[str]
        """
        return self._data_sources

    @data_sources.setter
    def data_sources(self, data_sources):
        """
        Sets the data_sources of this InsightHydrationDto.

        :param data_sources: The data_sources of this InsightHydrationDto.
        :type: list[str]
        """

        self._data_sources = data_sources

    @property
    def description(self):
        """
        Gets the description of this InsightHydrationDto.

        :return: The description of this InsightHydrationDto.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this InsightHydrationDto.

        :param description: The description of this InsightHydrationDto.
        :type: str
        """

        self._description = description

    @property
    def insightid(self):
        """
        Gets the insightid of this InsightHydrationDto.

        :return: The insightid of this InsightHydrationDto.
        :rtype: str
        """
        return self._insightid

    @insightid.setter
    def insightid(self, insightid):
        """
        Sets the insightid of this InsightHydrationDto.

        :param insightid: The insightid of this InsightHydrationDto.
        :type: str
        """

        self._insightid = insightid

    @property
    def thumbnail(self):
        """
        Gets the thumbnail of this InsightHydrationDto.

        :return: The thumbnail of this InsightHydrationDto.
        :rtype: str
        """
        return self._thumbnail

    @thumbnail.setter
    def thumbnail(self, thumbnail):
        """
        Sets the thumbnail of this InsightHydrationDto.

        :param thumbnail: The thumbnail of this InsightHydrationDto.
        :type: str
        """

        self._thumbnail = thumbnail

    @property
    def title(self):
        """
        Gets the title of this InsightHydrationDto.

        :return: The title of this InsightHydrationDto.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this InsightHydrationDto.

        :param title: The title of this InsightHydrationDto.
        :type: str
        """

        self._title = title

    @property
    def type(self):
        """
        Gets the type of this InsightHydrationDto.

        :return: The type of this InsightHydrationDto.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this InsightHydrationDto.

        :param type: The type of this InsightHydrationDto.
        :type: str
        """

        self._type = type

    @property
    def updated(self):
        """
        Gets the updated of this InsightHydrationDto.

        :return: The updated of this InsightHydrationDto.
        :rtype: datetime
        """
        return self._updated

    @updated.setter
    def updated(self, updated):
        """
        Sets the updated of this InsightHydrationDto.

        :param updated: The updated of this InsightHydrationDto.
        :type: datetime
        """

        self._updated = updated

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, InsightHydrationDto):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
