# coding: utf-8

"""
    data.world API

    # data.world in a nutshell  data.world is a productive, secure platform for modern data teamwork.  We bring together your data practitioners, subject matter experts, and other stakeholders by removing costly barriers to data discovery, comprehension, integration, and sharing.   Everything your team needs to quickly understand and use data stays with it.   Social features and integrations encourage collaborators to ask and answer questions, share discoveries, and coordinate closely while still using their preferred tools.  Our focus on interoperability helps you enhance your own data with data from any source, including our vast and growing library of free public datasets.   Sophisticated permissions, auditing features, and more make it easy to manage who views your data and what they do with it.  # Conventions  ## Authentication  All data.world API calls require an API token.   OAuth2 is the preferred and most secure method for authenticating users of your data.world applications. Visit our [oauth documentation](https://apidocs.data.world/toolkit/oauth) for additional information. Alternatively, you can obtain a token for _personal use or testing_ by navigating to your profile settings, under the Advanced tab ([https://data.world/settings/advanced](https://data.world/settings/advanced)).  Authentication must be provided in API requests via the `Authorization` header. For example, for a user whose API token is `my_api_token`, the request header should be `Authorization: Bearer my_api_token` (note the `Bearer` prefix).  ## Content type   By default, `application/json` is the content type used in request and response bodies. Exceptions are noted in respective endpoint documentation.  ## HTTPS only   Our APIs can only be accessed via HTTPS.  # Interested in building data.world apps?  Check out our [developer portal](https://apidocs.data.world) for tips on how to get started, tutorials, and to interact with the API endpoints right within your browser.

    OpenAPI spec version: 0.21.0
    Contact: help@data.world
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class FileCreateRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'labels': 'list[str]',
        'name': 'str',
        'source': 'FileSourceCreateRequest'
    }

    attribute_map = {
        'description': 'description',
        'labels': 'labels',
        'name': 'name',
        'source': 'source'
    }

    def __init__(self, description=None, labels=None, name=None, source=None):
        """
        FileCreateRequest - a model defined in Swagger
        """

        self._description = None
        self._labels = None
        self._name = None
        self._source = None

        if description is not None:
          self.description = description
        if labels is not None:
          self.labels = labels
        self.name = name
        self.source = source

    @property
    def description(self):
        """
        Gets the description of this FileCreateRequest.
        File description.

        :return: The description of this FileCreateRequest.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this FileCreateRequest.
        File description.

        :param description: The description of this FileCreateRequest.
        :type: str
        """
        if description is not None and len(description) > 240:
            raise ValueError("Invalid value for `description`, length must be less than or equal to `240`")
        if description is not None and len(description) < 1:
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `1`")

        self._description = description

    @property
    def labels(self):
        """
        Gets the labels of this FileCreateRequest.
        File labels.

        :return: The labels of this FileCreateRequest.
        :rtype: list[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """
        Sets the labels of this FileCreateRequest.
        File labels.

        :param labels: The labels of this FileCreateRequest.
        :type: list[str]
        """
        allowed_values = ["raw data", "documentation", "visualization", "clean data", "script", "report"]
        if not set(labels).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `labels` [{0}], must be a subset of [{1}]"
                .format(", ".join(map(str, set(labels)-set(allowed_values))),
                        ", ".join(map(str, allowed_values)))
            )

        self._labels = labels

    @property
    def name(self):
        """
        Gets the name of this FileCreateRequest.
        File name. Should include type extension always when possible. Must not include slashes.

        :return: The name of this FileCreateRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this FileCreateRequest.
        File name. Should include type extension always when possible. Must not include slashes.

        :param name: The name of this FileCreateRequest.
        :type: str
        """
        if name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")
        if name is not None and len(name) > 128:
            raise ValueError("Invalid value for `name`, length must be less than or equal to `128`")
        if name is not None and len(name) < 1:
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")
        if name is not None and not re.search('^[^\/]+$', name):
            raise ValueError("Invalid value for `name`, must be a follow pattern or equal to `/^[^\/]+$/`")

        self._name = name

    @property
    def source(self):
        """
        Gets the source of this FileCreateRequest.

        :return: The source of this FileCreateRequest.
        :rtype: FileSourceCreateRequest
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this FileCreateRequest.

        :param source: The source of this FileCreateRequest.
        :type: FileSourceCreateRequest
        """
        if source is None:
            raise ValueError("Invalid value for `source`, must not be `None`")

        self._source = source

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, FileCreateRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
