from fpl.models.fixture import Fixture

fixture_data = {
    "code": 1059760,
    "event": 6,
    "finished": True,
    "finished_provisional": True,
    "id": 59,
    "kickoff_time": "2019-09-20T19:00:00Z",
    "minutes": 90,
    "provisional_start_time": False,
    "started": True,
    "team_a": 3,
    "team_a_score": 3,
    "team_h": 16,
    "team_h_score": 1,
    "stats": [
        {
            "identifier": "goals_scored",
            "a": [
                {
                    "value": 1,
                    "element": 59
                },
                {
                    "value": 1,
                    "element": 67
                },
                {
                    "value": 1,
                    "element": 505
                }
            ],
            "h": [
                {
                    "value": 1,
                    "element": 321
                }
            ]
        },
        {
            "identifier": "assists",
            "a": [
                {
                    "value": 1,
                    "element": 65
                },
                {
                    "value": 1,
                    "element": 476
                },
                {
                    "value": 1,
                    "element": 494
                }
            ],
            "h": [
                {
                    "value": 1,
                    "element": 437
                }
            ]
        },
        {
            "identifier": "own_goals",
            "a": [

            ],
            "h": [

            ]
        },
        {
            "identifier": "penalties_saved",
            "a": [

            ],
            "h": [

            ]
        },
        {
            "identifier": "penalties_missed",
            "a": [

            ],
            "h": [

            ]
        },
        {
            "identifier": "yellow_cards",
            "a": [
                {
                    "value": 1,
                    "element": 82
                },
                {
                    "value": 1,
                    "element": 446
                },
                {
                    "value": 1,
                    "element": 505
                }
            ],
            "h": [
                {
                    "value": 1,
                    "element": 328
                }
            ]
        },
        {
            "identifier": "red_cards",
            "a": [

            ],
            "h": [

            ]
        },
        {
            "identifier": "saves",
            "a": [
                {
                    "value": 6,
                    "element": 494
                }
            ],
            "h": [

            ]
        },
        {
            "identifier": "bonus",
            "a": [
                {
                    "value": 3,
                    "element": 494
                },
                {
                    "value": 1,
                    "element": 67
                }
            ],
            "h": [
                {
                    "value": 2,
                    "element": 321
                }
            ]
        },
        {
            "identifier": "bps",
            "a": [
                {
                    "value": 34,
                    "element": 494
                },
                {
                    "value": 30,
                    "element": 67
                },
                {
                    "value": 26,
                    "element": 59
                },
                {
                    "value": 25,
                    "element": 65
                },
                {
                    "value": 23,
                    "element": 476
                },
                {
                    "value": 23,
                    "element": 505
                },
                {
                    "value": 14,
                    "element": 58
                },
                {
                    "value": 7,
                    "element": 82
                },
                {
                    "value": 6,
                    "element": 446
                },
                {
                    "value": 4,
                    "element": 79
                },
                {
                    "value": 3,
                    "element": 75
                },
                {
                    "value": 3,
                    "element": 80
                },
                {
                    "value": 2,
                    "element": 68
                }
            ],
            "h": [
                {
                    "value": 31,
                    "element": 321
                },
                {
                    "value": 23,
                    "element": 328
                },
                {
                    "value": 17,
                    "element": 437
                },
                {
                    "value": 16,
                    "element": 486
                },
                {
                    "value": 14,
                    "element": 304
                },
                {
                    "value": 14,
                    "element": 508
                },
                {
                    "value": 13,
                    "element": 307
                },
                {
                    "value": 9,
                    "element": 320
                },
                {
                    "value": 9,
                    "element": 325
                },
                {
                    "value": 7,
                    "element": 319
                },
                {
                    "value": 6,
                    "element": 305
                },
                {
                    "value": 4,
                    "element": 313
                },
                {
                    "value": 3,
                    "element": 532
                },
                {
                    "value": 2,
                    "element": 323
                }
            ]
        }
    ],
    "team_h_difficulty": 2,
    "team_a_difficulty": 2
}
fixture_data_not_finished = {
    "code": 1059760,
    "event": 6,
    "finished": False,
    "finished_provisional": False,
    "id": 59,
    "kickoff_time": "2019-09-20T19:00:00Z",
    "minutes": 90,
    "provisional_start_time": False,
    "started": True,
    "team_a": 3,
    "team_a_score": 3,
    "team_h": 16,
    "team_h_score": 1,
    "stats": [
        {
            "identifier": "goals_scored",
            "a": [
                {
                    "value": 1,
                    "element": 59
                },
                {
                    "value": 1,
                    "element": 67
                },
                {
                    "value": 1,
                    "element": 505
                }
            ],
            "h": [
                {
                    "value": 1,
                    "element": 321
                }
            ]
        },
        {
            "identifier": "assists",
            "a": [
                {
                    "value": 1,
                    "element": 65
                },
                {
                    "value": 1,
                    "element": 476
                },
                {
                    "value": 1,
                    "element": 494
                }
            ],
            "h": [
                {
                    "value": 1,
                    "element": 437
                }
            ]
        },
        {
            "identifier": "own_goals",
            "a": [

            ],
            "h": [

            ]
        },
        {
            "identifier": "penalties_saved",
            "a": [

            ],
            "h": [

            ]
        },
        {
            "identifier": "penalties_missed",
            "a": [

            ],
            "h": [

            ]
        },
        {
            "identifier": "yellow_cards",
            "a": [
                {
                    "value": 1,
                    "element": 82
                },
                {
                    "value": 1,
                    "element": 446
                },
                {
                    "value": 1,
                    "element": 505
                }
            ],
            "h": [
                {
                    "value": 1,
                    "element": 328
                }
            ]
        },
        {
            "identifier": "red_cards",
            "a": [

            ],
            "h": [

            ]
        },
        {
            "identifier": "saves",
            "a": [
                {
                    "value": 6,
                    "element": 494
                }
            ],
            "h": [

            ]
        },
        {
            "identifier": "bonus",
            "a": [],
            "h": []
        },
        {
            "identifier": "bps",
            "a": [
                {
                    "value": 34,
                    "element": 494
                },
                {
                    "value": 30,
                    "element": 67
                },
                {
                    "value": 26,
                    "element": 59
                },
                {
                    "value": 25,
                    "element": 65
                },
                {
                    "value": 23,
                    "element": 476
                },
                {
                    "value": 23,
                    "element": 505
                },
                {
                    "value": 14,
                    "element": 58
                },
                {
                    "value": 7,
                    "element": 82
                },
                {
                    "value": 6,
                    "element": 446
                },
                {
                    "value": 4,
                    "element": 79
                },
                {
                    "value": 3,
                    "element": 75
                },
                {
                    "value": 3,
                    "element": 80
                },
                {
                    "value": 2,
                    "element": 68
                }
            ],
            "h": [
                {
                    "value": 31,
                    "element": 321
                },
                {
                    "value": 23,
                    "element": 328
                },
                {
                    "value": 17,
                    "element": 437
                },
                {
                    "value": 16,
                    "element": 486
                },
                {
                    "value": 14,
                    "element": 304
                },
                {
                    "value": 14,
                    "element": 508
                },
                {
                    "value": 13,
                    "element": 307
                },
                {
                    "value": 9,
                    "element": 320
                },
                {
                    "value": 9,
                    "element": 325
                },
                {
                    "value": 7,
                    "element": 319
                },
                {
                    "value": 6,
                    "element": 305
                },
                {
                    "value": 4,
                    "element": 313
                },
                {
                    "value": 3,
                    "element": 532
                },
                {
                    "value": 2,
                    "element": 323
                }
            ]
        }
    ],
    "team_h_difficulty": 2,
    "team_a_difficulty": 2
}


class TestFixture(object):
    @staticmethod
    def test_init():
        fixture = Fixture(fixture_data)
        for k, v in fixture_data.items():
            if k != 'stats':
                assert getattr(fixture, k) == v

    @staticmethod
    def _do_test_not_finished(fixture, method):
        fixture.finished = False
        fixture.stats['bonus']['a'] = []
        fixture.stats['bonus']['h'] = []
        data_dict = getattr(fixture, method)()
        assert isinstance(data_dict, dict)
        assert len(data_dict) == 2

    @staticmethod
    def _do_test_finished(fixture, method):
        data_dict = getattr(fixture, method)()
        assert isinstance(data_dict, dict)
        assert tuple(data_dict.keys()) == ('a', 'h')
        assert isinstance(data_dict['a'], list)
        assert isinstance(data_dict['h'], list)
        assert all([isinstance(d, dict) for d in data_dict['a']])
        assert all([isinstance(d, dict) for d in data_dict['h']])
        assert all([tuple(d.keys()) == ('value', 'element') for d in data_dict['a']])
        assert all([tuple(d.keys()) == ('value', 'element') for d in data_dict['h']])
        assert all([all([isinstance(v, int) for v in d.values()]) for d in data_dict['a']])
        assert all([all([isinstance(v, int) for v in d.values()]) for d in data_dict['h']])

    def test_get_goalscorers_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_goalscorers")

    def test_get_goalscorers_finished(self, fixture):
        self._do_test_finished(fixture, "get_goalscorers")

    def test_get_assisters_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_assisters")

    def test_get_assisters_finished(self, fixture):
        self._do_test_finished(fixture, "get_assisters")

    def test_get_own_goalscorers_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_own_goalscorers")

    def test_get_own_goalscorers_finished(self, fixture):
        self._do_test_finished(fixture, "get_own_goalscorers")

    def test_get_yellow_cards_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_yellow_cards")

    def test_get_yellow_cards(self, fixture):
        self._do_test_finished(fixture, "get_yellow_cards")

    def test_get_red_cards_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_red_cards")

    def test_get_red_cards_finished(self, fixture):
        self._do_test_finished(fixture, "get_red_cards")

    def test_get_penalty_saves_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_penalty_saves")

    def test_get_penalty_saves_finished(self, fixture):
        self._do_test_finished(fixture, "get_penalty_saves")

    def test_get_penalty_misses_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_penalty_misses")

    def test_get_penalty_misses_finished(self, fixture):
        self._do_test_finished(fixture, "get_penalty_misses")

    def test_get_saves_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_saves")

    def test_get_saves_finished(self, fixture):
        self._do_test_finished(fixture, "get_saves")

    def test_get_bonus_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_bonus")

    def test_get_bonus_finished(self, fixture):
        self._do_test_finished(fixture, "get_bonus")

    def test_get_bps_not_finished(self, fixture):
        self._do_test_not_finished(fixture, "get_bps")

    def test_get_bps_finished(self, fixture):
        self._do_test_finished(fixture, "get_bps")

    @staticmethod
    def test_str(fixture):
        assert str(fixture) == "Southampton vs. Bournemouth - 2019-09-20T19:00:00Z"
