""" The FastAreader class """
# pylint: disable=R1732
#         file open suggestion: use with
import sys


class FastAreader:
    """
    Define objects to read FastA files.

    instantiation:
    thisReader = FastAreader ('testTiny.fa')
    usage:
    for head, seq in thisReader.readFasta():
    print (head,seq)
    """

    def __init__(self, fname=""):
        """contructor: saves attribute fname"""
        self.fname = fname

    def doOpen(self):
        """Handle file opens, allowing STDIN."""
        if self.fname == "":
            return sys.stdin
        return open(self.fname)

    def readFasta(self):
        """Read an entire FastA record and return the sequence header/sequence"""
        header = ""
        sequence = ""

        with self.doOpen() as fileH:

            header = ""
            sequence = ""

            # skip to first fasta header
            line = fileH.readline()

            while not line.startswith(">"):
                if not line:  # we are at EOF
                    return header, sequence
                line = fileH.readline()

            header = line[1:].rstrip()

            for line in fileH:
                if line.startswith(">"):
                    yield header, sequence
                    header = line[1:].rstrip()
                    sequence = ""
                else:
                    sequence += "".join(line.rstrip().split()).upper()

        yield header, sequence
