from typing import Any, List, Optional, Union

from com.inductiveautomation.ignition.common.model.values import (
    BasicQualifiedValue,
    QualityCode,
)
from com.inductiveautomation.ignition.common.opc import BasicOPCBrowseElement
from com.inductiveautomation.ignition.common.script.builtin import AbstractOPCUtilities
from com.inductiveautomation.ignition.common.script.builtin.ialabs import OPCBrowseTag
from dev.thecesrom.helper.types import AnyStr

BrowseServerResult = List[Union[BasicOPCBrowseElement, AbstractOPCUtilities.PyOPCTag]]

def browse(
    opcServer: AnyStr, device: AnyStr, folderPath: AnyStr, opcItemPath: AnyStr
) -> List[OPCBrowseTag]: ...
def browseServer(opcServer: AnyStr, nodeId: AnyStr) -> BrowseServerResult: ...
def browseSimple(
    opcServer: AnyStr, device: AnyStr, folderPath: AnyStr, opcItemPath: AnyStr
) -> List[OPCBrowseTag]: ...
def getServerState(opcServer: AnyStr) -> Optional[AnyStr]: ...
def getServers(includeDisabled: Optional[bool] = ...) -> List[AnyStr]: ...
def isServerEnabled(serverName: AnyStr) -> bool: ...
def readValue(opcServer: AnyStr, itemPath: AnyStr) -> BasicQualifiedValue: ...
def readValues(
    opcServer: AnyStr, itemPaths: List[AnyStr]
) -> List[BasicQualifiedValue]: ...
def setServerEnabled(serverName: AnyStr, enabled: bool) -> None: ...
def writeValue(opcServer: AnyStr, itemPath: AnyStr, value: Any) -> QualityCode: ...
def writeValues(
    opcServer: AnyStr, itemPaths: List[AnyStr], values: List[Any]
) -> List[QualityCode]: ...
