from typing import List, Optional

from com.inductiveautomation.ignition.common.i18n import LocalizedString
from com.inductiveautomation.ignition.common.model.values import Quality, QualityCode
from dev.thecesrom.helper.types import AnyStr
from java.lang import Enum, Object
from java.util import Locale

class DataQuality(Object):
    @staticmethod
    def fromIntValue(value: int) -> DataQuality: ...
    def getDescription(self) -> LocalizedString: ...
    def getIntValue(self) -> int: ...
    def getLevel(self) -> Quality.Level: ...
    def getName(self) -> str: ...
    def getQualityCode(self) -> QualityCode: ...
    @staticmethod
    def getQualityFor(value: int) -> DataQuality: ...
    def isDataUsed(self) -> bool: ...
    def isGood(self) -> bool: ...
    def isGoodData(self) -> bool: ...
    def isOpcBadData(self) -> bool: ...
    def toString(self, locale: Optional[Locale] = ...) -> AnyStr: ...
    @staticmethod
    def valueOf(name: str) -> DataQuality: ...
    @staticmethod
    def values() -> List[DataQuality]: ...
    @staticmethod
    def worstOf(q1: DataQuality, q2: DataQuality) -> DataQuality: ...
    @staticmethod
    def worstOfAll(*args: DataQuality) -> DataQuality: ...

class DataType(Enum):
    def fromIntValue(self, val) -> None: ...
    def getComponentDataType(self) -> None: ...
    def getIntValue(self) -> None: ...
    def getJavaType(self) -> None: ...
    def getTypeClass(self) -> None: ...
    def getTypeForClass(self, clazz) -> None: ...
    def getTypeForValue(self, val) -> None: ...
    def isArray(self) -> None: ...
    def isFloatingPoint(self) -> None: ...
    def isNumeric(self) -> None: ...
    def legacyDataType(self) -> None: ...
    def values(self) -> None: ...
