from typing import Any

from dev.thecesrom.helper.types import AnyStr as AnyStr
from enum import Enum
from java.io import Closeable, Flushable, Reader, Writer
from java.lang import Object

class JsonReader(Object, Closeable):
    def __init__(self, in_: Reader) -> None: ...
    def beginArray(self) -> None: ...
    def beginObject(self) -> None: ...
    def close(self) -> None: ...
    def endArray(self) -> None: ...
    def endObject(self) -> None: ...
    def getPath(self) -> AnyStr: ...
    def hasNext(self) -> bool: ...
    def isLenient(self) -> bool: ...
    def nextBoolean(self) -> bool: ...
    def nextDouble(self) -> float: ...
    def nextInt(self) -> int: ...
    def nextLong(self) -> long: ...
    def nextName(self) -> AnyStr: ...
    def nextNull(self) -> None: ...
    def nextString(self) -> AnyStr: ...
    def peek(self) -> JsonToken: ...
    def setLenient(self, lenient: bool) -> None: ...
    def skipValue(self) -> None: ...

class JsonToken(Enum):
    BEGIN_ARRAY: JsonToken
    BEGIN_OBJECT: JsonToken
    BOOLEAN: JsonToken
    END_ARRAY: JsonToken
    END_DOCUMENT: JsonToken
    END_OBJECT: JsonToken
    NAME: JsonToken
    NULL: JsonToken
    NUMBER: JsonToken
    STRING: JsonToken

class JsonWriter(Object, Closeable, Flushable):
    def __init__(self, out: Writer) -> None: ...
    def beginArray(self) -> JsonWriter: ...
    def beginObject(self) -> JsonWriter: ...
    def close(self) -> None: ...
    def endArray(self) -> JsonWriter: ...
    def endObject(self) -> JsonWriter: ...
    def flush(self) -> None: ...
    def getSerializeNulls(self) -> bool: ...
    def isHtmlSafe(self) -> bool: ...
    def isLenient(self) -> bool: ...
    def jsonValue(self, value: AnyStr) -> JsonWriter: ...
    def name(self, name: AnyStr) -> JsonWriter: ...
    def setHtmlSafe(self, htmlSafe: bool) -> None: ...
    def setIndent(self, indent: AnyStr) -> None: ...
    def setLenient(self, lenient: bool) -> None: ...
    def setSerializeNulls(self, serializeNulls: bool) -> None: ...
    def value(self, arg: Any) -> JsonWriter: ...
