"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.patchModule = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
const LOG_PREFIX = 'awscdk-81-patch:';
function patchModule(module, expectedVersion) {
    let moduleRoot;
    try {
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        require(module); // ensure the module is loaded
        moduleRoot = require.resolve(module + '/package.json');
    }
    catch (e) {
        console.error(LOG_PREFIX + `${module} not found. patch skipped`);
        return; // module not in closure
    }
    const pkg = JSON.parse(fs_1.readFileSync(moduleRoot, 'utf-8'));
    if (pkg.version !== expectedVersion) {
        throw new Error(`this patch only applies to AWS CDK version ${expectedVersion}. got ${pkg.version}`);
    }
    const layerdir = path_1.join(path_1.dirname(moduleRoot), 'layer');
    const dockerfile = path_1.join(layerdir, 'Dockerfile');
    if (!fs_1.existsSync(layerdir)) {
        fs_1.mkdirSync(layerdir);
        fs_1.writeFileSync(dockerfile, '# dummy');
        console.error(LOG_PREFIX + `created ${dockerfile}`);
    }
    else {
        console.error(LOG_PREFIX + `skipped ${dockerfile}`);
    }
}
exports.patchModule = patchModule;
//# sourceMappingURL=data:application/json;base64,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