"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
class CompositeAlarmIntegrationTest extends core_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const testMetric = new lib_1.Metric({
            namespace: 'CDK/Test',
            metricName: 'Metric',
        });
        const alarm1 = new lib_1.Alarm(this, 'Alarm1', {
            metric: testMetric,
            threshold: 100,
            evaluationPeriods: 3,
        });
        const alarm2 = new lib_1.Alarm(this, 'Alarm2', {
            metric: testMetric,
            threshold: 1000,
            evaluationPeriods: 3,
        });
        const alarm3 = new lib_1.Alarm(this, 'Alarm3', {
            metric: testMetric,
            threshold: 10000,
            evaluationPeriods: 3,
        });
        const alarm4 = new lib_1.Alarm(this, 'Alarm4', {
            metric: testMetric,
            threshold: 100000,
            evaluationPeriods: 3,
        });
        const alarmRule = lib_1.AlarmRule.anyOf(lib_1.AlarmRule.allOf(lib_1.AlarmRule.anyOf(alarm1, lib_1.AlarmRule.fromAlarm(alarm2, lib_1.AlarmState.OK), alarm3), lib_1.AlarmRule.not(lib_1.AlarmRule.fromAlarm(alarm4, lib_1.AlarmState.INSUFFICIENT_DATA))), lib_1.AlarmRule.fromBoolean(false));
        new lib_1.CompositeAlarm(this, 'CompositeAlarm', {
            alarmRule,
        });
    }
}
const app = new core_1.App();
new CompositeAlarmIntegrationTest(app, 'CompositeAlarmIntegrationTest');
app.synth();
//# sourceMappingURL=data:application/json;base64,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