"""
    Apicurio Registry API [v2]

    Apicurio Registry is a datastore for standard event schemas and API designs. Apicurio Registry enables developers to manage and share the structure of their data using a REST interface. For example, client applications can dynamically push or pull the latest updates to or from the registry without needing to redeploy. Apicurio Registry also enables developers to create rules that govern how registry content can evolve over time. For example, this includes rules for content validation and version compatibility.  The Apicurio Registry REST API enables client applications to manage the artifacts in the registry. This API provides create, read, update, and delete operations for schema and API artifacts, rules, versions, and metadata.   The supported artifact types include: - Apache Avro schema - AsyncAPI specification - Google protocol buffers - GraphQL schema - JSON Schema - Kafka Connect schema - OpenAPI specification - Web Services Description Language - XML Schema Definition   **Important**: The Apicurio Registry REST API is available from `https://MY-REGISTRY-URL/apis/registry/v2` by default. Therefore you must prefix all API operation paths with `../apis/registry/v2` in this case. For example: `../apis/registry/v2/ids/globalIds/{globalId}`.   # noqa: E501

    The version of the OpenAPI document: 2.2.0.Final
    Contact: apicurio@lists.jboss.org
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from apicurioregistryclient.api_client import ApiClient, Endpoint as _Endpoint
from apicurioregistryclient.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from apicurioregistryclient.model.error import Error
from apicurioregistryclient.model.rule import Rule
from apicurioregistryclient.model.rule_type import RuleType
from apicurioregistryclient.model.rule_violation_error import RuleViolationError


class ArtifactRulesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_artifact_rule_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}/rules',
                'operation_id': 'create_artifact_rule',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                    'rule',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                    'rule',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                    'rule':
                        (Rule,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                    'rule': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.delete_artifact_rule_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}/rules/{rule}',
                'operation_id': 'delete_artifact_rule',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                    'rule',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                    'rule',
                ],
                'nullable': [
                ],
                'enum': [
                    'rule',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('rule',): {

                        "VALIDITY": "VALIDITY",
                        "COMPATIBILITY": "COMPATIBILITY"
                    },
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                    'rule':
                        (str,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                    'rule': 'rule',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                    'rule': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.delete_artifact_rules_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}/rules',
                'operation_id': 'delete_artifact_rules',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_artifact_rule_config_endpoint = _Endpoint(
            settings={
                'response_type': (Rule,),
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}/rules/{rule}',
                'operation_id': 'get_artifact_rule_config',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                    'rule',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                    'rule',
                ],
                'nullable': [
                ],
                'enum': [
                    'rule',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('rule',): {

                        "VALIDITY": "VALIDITY",
                        "COMPATIBILITY": "COMPATIBILITY"
                    },
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                    'rule':
                        (str,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                    'rule': 'rule',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                    'rule': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_artifact_rules_endpoint = _Endpoint(
            settings={
                'response_type': ([RuleType],),
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}/rules',
                'operation_id': 'list_artifact_rules',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.test_update_artifact_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}/test',
                'operation_id': 'test_update_artifact',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                    'body',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                    'body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                    'body':
                        (file_type,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_artifact_rule_config_endpoint = _Endpoint(
            settings={
                'response_type': (Rule,),
                'auth': [],
                'endpoint_path': '/groups/{groupId}/artifacts/{artifactId}/rules/{rule}',
                'operation_id': 'update_artifact_rule_config',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'group_id',
                    'artifact_id',
                    'rule',
                    'rule2',
                ],
                'required': [
                    'group_id',
                    'artifact_id',
                    'rule',
                    'rule2',
                ],
                'nullable': [
                ],
                'enum': [
                    'rule',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('rule',): {

                        "VALIDITY": "VALIDITY",
                        "COMPATIBILITY": "COMPATIBILITY"
                    },
                },
                'openapi_types': {
                    'group_id':
                        (str,),
                    'artifact_id':
                        (str,),
                    'rule':
                        (str,),
                    'rule2':
                        (Rule,),
                },
                'attribute_map': {
                    'group_id': 'groupId',
                    'artifact_id': 'artifactId',
                    'rule': 'rule',
                },
                'location_map': {
                    'group_id': 'path',
                    'artifact_id': 'path',
                    'rule': 'path',
                    'rule2': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_artifact_rule(
        self,
        group_id,
        artifact_id,
        rule,
        **kwargs
    ):
        """Create artifact rule  # noqa: E501

        Adds a rule to the list of rules that get applied to the artifact when adding new versions.  All configured rules must pass to successfully add a new artifact version.  This operation can fail for the following reasons:  * No artifact with this `artifactId` exists (HTTP error `404`) * Rule (named in the request body) is unknown (HTTP error `400`) * A server error occurred (HTTP error `500`)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_artifact_rule(group_id, artifact_id, rule, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.
            rule (Rule):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        kwargs['rule'] = \
            rule
        return self.create_artifact_rule_endpoint.call_with_http_info(**kwargs)

    def delete_artifact_rule(
        self,
        group_id,
        artifact_id,
        rule,
        **kwargs
    ):
        """Delete artifact rule  # noqa: E501

        Deletes a rule from the artifact.  This results in the rule no longer applying for this artifact.  If this is the only rule configured for the artifact, this is the  same as deleting **all** rules, and the globally configured rules now apply to this artifact.  This operation can fail for the following reasons:  * No artifact with this `artifactId` exists (HTTP error `404`) * No rule with this name/type is configured for this artifact (HTTP error `404`) * Invalid rule type (HTTP error `400`) * A server error occurred (HTTP error `500`)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_artifact_rule(group_id, artifact_id, rule, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.
            rule (str): The unique name/type of a rule.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        kwargs['rule'] = \
            rule
        return self.delete_artifact_rule_endpoint.call_with_http_info(**kwargs)

    def delete_artifact_rules(
        self,
        group_id,
        artifact_id,
        **kwargs
    ):
        """Delete artifact rules  # noqa: E501

        Deletes all of the rules configured for the artifact.  After this is done, the global rules apply to the artifact again.  This operation can fail for the following reasons:  * No artifact with this `artifactId` exists (HTTP error `404`) * A server error occurred (HTTP error `500`)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.delete_artifact_rules(group_id, artifact_id, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        return self.delete_artifact_rules_endpoint.call_with_http_info(**kwargs)

    def get_artifact_rule_config(
        self,
        group_id,
        artifact_id,
        rule,
        **kwargs
    ):
        """Get artifact rule configuration  # noqa: E501

        Returns information about a single rule configured for an artifact.  This is useful when you want to know what the current configuration settings are for a specific rule.  This operation can fail for the following reasons:  * No artifact with this `artifactId` exists (HTTP error `404`) * No rule with this name/type is configured for this artifact (HTTP error `404`) * Invalid rule type (HTTP error `400`) * A server error occurred (HTTP error `500`)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_artifact_rule_config(group_id, artifact_id, rule, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.
            rule (str): The unique name/type of a rule.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Rule
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        kwargs['rule'] = \
            rule
        return self.get_artifact_rule_config_endpoint.call_with_http_info(**kwargs)

    def list_artifact_rules(
        self,
        group_id,
        artifact_id,
        **kwargs
    ):
        """List artifact rules  # noqa: E501

        Returns a list of all rules configured for the artifact.  The set of rules determines how the content of an artifact can evolve over time.  If no rules are configured for an artifact, the set of globally configured rules are used.  If no global rules  are defined, there are no restrictions on content evolution.  This operation can fail for the following reasons:  * No artifact with this `artifactId` exists (HTTP error `404`) * A server error occurred (HTTP error `500`)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_artifact_rules(group_id, artifact_id, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            [RuleType]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        return self.list_artifact_rules_endpoint.call_with_http_info(**kwargs)

    def test_update_artifact(
        self,
        group_id,
        artifact_id,
        body,
        **kwargs
    ):
        """Test update artifact  # noqa: E501

        Tests whether an update to the artifact's content *would* succeed for the provided content. Ultimately, this applies any rules configured for the artifact against the given content to determine whether the rules would pass or fail, but without actually updating the artifact content.  The body of the request should be the raw content of the artifact.  This is typically in  JSON format for *most* of the supported types, but may be in another format for a few  (for example, `PROTOBUF`).  The update could fail for a number of reasons including:  * Provided content (request body) was empty (HTTP error `400`) * No artifact with the `artifactId` exists (HTTP error `404`) * The new content violates one of the rules configured for the artifact (HTTP error `409`) * The provided artifact type is not recognized (HTTP error `404`) * A server error occurred (HTTP error `500`)  When successful, this operation simply returns a *No Content* response.  This response indicates that the content is valid against the configured content rules for the  artifact (or the global rules if no artifact rules are enabled).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.test_update_artifact(group_id, artifact_id, body, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.
            body (file_type): The content of the artifact being tested. This is often, but not always, JSON data representing one of the supported artifact types:  * Avro (`AVRO`) * Protobuf (`PROTOBUF`) * JSON Schema (`JSON`) * Kafka Connect (`KCONNECT`) * OpenAPI (`OPENAPI`) * AsyncAPI (`ASYNCAPI`) * GraphQL (`GRAPHQL`) * Web Services Description Language (`WSDL`) * XML Schema (`XSD`) 

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        kwargs['body'] = \
            body
        return self.test_update_artifact_endpoint.call_with_http_info(**kwargs)

    def update_artifact_rule_config(
        self,
        group_id,
        artifact_id,
        rule,
        rule2,
        **kwargs
    ):
        """Update artifact rule configuration  # noqa: E501

        Updates the configuration of a single rule for the artifact.  The configuration data is specific to each rule type, so the configuration of the `COMPATIBILITY` rule  is in a different format from the configuration of the `VALIDITY` rule.  This operation can fail for the following reasons:  * No artifact with this `artifactId` exists (HTTP error `404`) * No rule with this name/type is configured for this artifact (HTTP error `404`) * Invalid rule type (HTTP error `400`) * A server error occurred (HTTP error `500`)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_artifact_rule_config(group_id, artifact_id, rule, rule2, async_req=True)
        >>> result = thread.get()

        Args:
            group_id (str): The artifact group ID.  Must be a string provided by the client, representing the name of the grouping of artifacts.
            artifact_id (str): The artifact ID.  Can be a string (client-provided) or UUID (server-generated), representing the unique artifact identifier.
            rule (str): The unique name/type of a rule.
            rule2 (Rule):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            Rule
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['group_id'] = \
            group_id
        kwargs['artifact_id'] = \
            artifact_id
        kwargs['rule'] = \
            rule
        kwargs['rule2'] = \
            rule2
        return self.update_artifact_rule_config_endpoint.call_with_http_info(**kwargs)

