import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manages an Okta Group
 *
 * @schema CfnGroupProps
 */
export interface CfnGroupProps {
    /**
     * @schema CfnGroupProps#Profile
     */
    readonly profile: Profile;
}
/**
 * Converts an object of type 'CfnGroupProps' to JSON representation.
 */
export declare function toJson_CfnGroupProps(obj: CfnGroupProps | undefined): Record<string, any> | undefined;
/**
 * @schema Profile
 */
export interface Profile {
    /**
     * Name of the Group
     *
     * @schema Profile#Name
     */
    readonly name: string;
    /**
     * Description of the Group
     *
     * @schema Profile#Description
     */
    readonly description?: string;
}
/**
 * Converts an object of type 'Profile' to JSON representation.
 */
export declare function toJson_Profile(obj: Profile | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Okta::Group::Group`
 *
 * @cloudformationResource Okta::Group::Group
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-okta-resource-providers.git
 */
export declare class CfnGroup extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Okta::Group::Group";
    /**
     * Resource props.
     */
    readonly props: CfnGroupProps;
    /**
     * Attribute `Okta::Group::Group.Id`
     * @link https://github.com/aws-ia/cloudformation-okta-resource-providers.git
     */
    readonly attrId: string;
    /**
     * Create a new `Okta::Group::Group`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnGroupProps);
}
