from typing import Callable, Optional

from grpc.aio import Channel

from pyinjective.proto.exchange import (
    injective_auction_rpc_pb2 as exchange_auction_pb,
    injective_auction_rpc_pb2_grpc as exchange_auction_grpc,
)
from pyinjective.utils.grpc_api_stream_assistant import GrpcApiStreamAssistant


class IndexerGrpcAuctionStream:
    def __init__(self, channel: Channel, metadata_provider: Callable):
        self._stub = self._stub = exchange_auction_grpc.InjectiveAuctionRPCStub(channel)
        self._assistant = GrpcApiStreamAssistant(metadata_provider=metadata_provider)

    async def stream_bids(
        self,
        callback: Callable,
        on_end_callback: Optional[Callable] = None,
        on_status_callback: Optional[Callable] = None,
    ):
        request = exchange_auction_pb.StreamBidsRequest()

        await self._assistant.listen_stream(
            call=self._stub.StreamBids,
            request=request,
            callback=callback,
            on_end_callback=on_end_callback,
            on_status_callback=on_status_callback,
        )
