import os

from django.conf import settings
from django.core.management.base import BaseCommand
from eqator.main import run_qa


class Command(BaseCommand):
    help = 'Checking the Django project for quality'

    def add_arguments(self, parser):
        parser.add_argument(
            '--verbose',
            action='store_true',
            help='Verbose mode',
        )

        parser.add_argument(
            '--lighthouse', '-lh',
            action='store_true',
            help='Run  Lighthouse CI check',
        )

        parser.add_argument(
            '--clear-reports',
            action='store_true',
            help='Remove report files generated by Lighthouse CI',
        )

        parser.add_argument(
            '--flake', '-f',
            action='store_true',
            help='Run checking style guide with flake8'
        )

        parser.add_argument(
            '--radon', '-r',
            action='store_true',
            help='Run checking cyclomatic complexity with radon'
        )

        parser.add_argument(
            '--linter', '-l',
            action='store_true',
            help='Run security lint with bandit'
        )

        parser.add_argument(
            '--migrations', '-m',
            action='store_true',
            help='Run django project migrations check'
        )

        parser.add_argument(
            '--tests', '-t',
            action='store_true',
            help='Run django unittest'
        )

        parser.add_argument(
            '--garpix_page', '-p',
            action='store_true',
            help='Run django unit tests for garpix_page'
        )

        parser.add_argument(
            '--test_coverage', '-c',
            action='store_true',
            help='Check test coverage of the project'
        )

    def handle(self, *args, **options):
        directory = os.path.abspath(os.path.join(settings.BASE_DIR))
        verbose = options['verbose']
        lighthouse = options['lighthouse']
        clear_reports = options['clear_reports']
        flake = options['flake']
        radon = options['radon']
        linter = options['linter']
        migrations = options['migrations']
        tests = options['tests']
        garpix_page = options['garpix_page']
        test_coverage = options['test_coverage']
        run_qa(directory, verbose, lighthouse, clear_reports, flake, radon, linter, migrations, tests, garpix_page,
               test_coverage)
