"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const alert_1 = __importDefault(require("antd/lib/alert"));
const collapse_1 = __importDefault(require("antd/lib/collapse"));
const markdown_1 = __importDefault(require("@boyuai/markdown"));
const select_1 = __importDefault(require("./select"));
const fill_1 = __importDefault(require("./fill"));
function Question({ question, value, onChange, showValidation, lock }) {
    return react_1.default.createElement("div", { className: "ui-quiz-question" },
        showValidation && !value && react_1.default.createElement(alert_1.default, { message: "\u6B64\u9898\u5FC5\u987B\u4F5C\u7B54", type: "warning", showIcon: true }),
        question.type === 'SELECT' && react_1.default.createElement(select_1.default, { question: question, value: value, onChange: onChange, lock: lock }),
        question.type === 'FILL' && react_1.default.createElement(fill_1.default, { question: question, value: value, onChange: onChange, lock: lock }),
        lock && question.hint && (react_1.default.createElement(collapse_1.default, null,
            react_1.default.createElement(collapse_1.default.Panel, { header: "\u7B54\u6848\u89E3\u91CA", key: "1" },
                react_1.default.createElement(markdown_1.default, { content: question.hint })))));
}
exports.default = Question;
//# sourceMappingURL=question.js.map