# AUTOGENERATED! DO NOT EDIT! File to edit: 03_utils.ipynb (unless otherwise specified).

__all__ = ['plot_anomalies']

# Cell
import matplotlib.pyplot as plt
import seaborn as sns;

# Cell
def plot_anomalies(ts, anomalies, figsize=(20, 5),
                   s=50, anomaly_color='red'):
    '''
    Input:
        ts: Series object  with DatetimeIndex
        anomalias: Series object with DatetimeIndex
    Output:
        fig, ax
    '''
    fig, ax = plt.subplots(1, 1, figsize=figsize)
    # plot ts
    ts.plot(ax=ax)
    # plot anomalies
    sns.scatterplot(x=anomalies.index, y=anomalies, s=s, color=anomaly_color)
    return fig, ax