"""initial

Revision ID: cdb3214131a9
Revises: 
Create Date: 2023-09-07 17:34:58.986945

"""
from alembic import op
import sqlalchemy as sa
from openmodule.database.custom_types import JSONEncodedDict
from openmodule.database.custom_types import TZDateTime

# revision identifiers, used by Alembic.
revision = 'cdb3214131a9'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.pre_upgrade()
    op.create_table('contracts',
    sa.Column('key', sa.String(), nullable=False),
    sa.Column('e_tag', sa.Integer(), nullable=False),
    sa.Column('contract_id', sa.String(), nullable=False),
    sa.Column('group_limit', sa.Integer(), nullable=True),
    sa.Column('access_infos', JSONEncodedDict(), nullable=True),
    sa.Column('barcode', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('e_tag')
    )
    with op.batch_alter_table('contracts', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_contracts_e_tag'), ['e_tag'], unique=False)
        batch_op.create_index(batch_op.f('ix_contracts_key'), ['key'], unique=True)

    op.create_table('reservations',
    sa.Column('key', sa.String(), nullable=False),
    sa.Column('e_tag', sa.Integer(), nullable=False),
    sa.Column('start', TZDateTime(), nullable=False),
    sa.Column('end', TZDateTime(), nullable=False),
    sa.Column('barcode', sa.String(), nullable=False),
    sa.PrimaryKeyConstraint('e_tag')
    )
    with op.batch_alter_table('reservations', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_reservations_e_tag'), ['e_tag'], unique=False)
        batch_op.create_index(batch_op.f('ix_reservations_key'), ['key'], unique=True)

    op.create_table('cars',
    sa.Column('id', sa.Integer(), autoincrement=True, nullable=False),
    sa.Column('lpr_id', sa.String(), nullable=False),
    sa.Column('lpr_search_id', sa.String(), nullable=False),
    sa.Column('lpr_country', sa.String(), nullable=False),
    sa.Column('customer_car_id', sa.String(), nullable=True),
    sa.Column('matching_scheme', sa.String(), nullable=True),
    sa.Column('matching_version', sa.Integer(), nullable=True),
    sa.Column('contract_id', sa.String(), nullable=True),
    sa.Column('reservation_id', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['contract_id'], ['contracts.key'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['reservation_id'], ['reservations.key'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('cars', schema=None) as batch_op:
        batch_op.create_index(batch_op.f('ix_cars_lpr_search_id'), ['lpr_search_id'], unique=False)

    op.post_upgrade()
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.pre_downgrade()
    with op.batch_alter_table('cars', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_cars_lpr_search_id'))

    op.drop_table('cars')
    with op.batch_alter_table('reservations', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_reservations_key'))
        batch_op.drop_index(batch_op.f('ix_reservations_e_tag'))

    op.drop_table('reservations')
    with op.batch_alter_table('contracts', schema=None) as batch_op:
        batch_op.drop_index(batch_op.f('ix_contracts_key'))
        batch_op.drop_index(batch_op.f('ix_contracts_e_tag'))

    op.drop_table('contracts')
    op.post_downgrade()
    # ### end Alembic commands ###
