from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from typing import ClassVar as _ClassVar, Mapping as _Mapping, Optional as _Optional, Union as _Union
DESCRIPTOR: _descriptor.FileDescriptor

class HealthCheckRequest(_message.Message):
    __slots__ = ('service',)
    SERVICE_FIELD_NUMBER: _ClassVar[int]
    service: str

    def __init__(self, service: _Optional[str]=...) -> None:
        ...

class HealthCheckResponse(_message.Message):
    __slots__ = ('status',)

    class ServingStatus(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        UNKNOWN: _ClassVar[HealthCheckResponse.ServingStatus]
        SERVING: _ClassVar[HealthCheckResponse.ServingStatus]
        NOT_SERVING: _ClassVar[HealthCheckResponse.ServingStatus]
        SERVICE_UNKNOWN: _ClassVar[HealthCheckResponse.ServingStatus]
    UNKNOWN: HealthCheckResponse.ServingStatus
    SERVING: HealthCheckResponse.ServingStatus
    NOT_SERVING: HealthCheckResponse.ServingStatus
    SERVICE_UNKNOWN: HealthCheckResponse.ServingStatus
    STATUS_FIELD_NUMBER: _ClassVar[int]
    status: HealthCheckResponse.ServingStatus

    def __init__(self, status: _Optional[_Union[HealthCheckResponse.ServingStatus, str]]=...) -> None:
        ...

class HealthListRequest(_message.Message):
    __slots__ = ()

    def __init__(self) -> None:
        ...

class HealthListResponse(_message.Message):
    __slots__ = ('statuses',)

    class StatusesEntry(_message.Message):
        __slots__ = ('key', 'value')
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: HealthCheckResponse

        def __init__(self, key: _Optional[str]=..., value: _Optional[_Union[HealthCheckResponse, _Mapping]]=...) -> None:
            ...
    STATUSES_FIELD_NUMBER: _ClassVar[int]
    statuses: _containers.MessageMap[str, HealthCheckResponse]

    def __init__(self, statuses: _Optional[_Mapping[str, HealthCheckResponse]]=...) -> None:
        ...