"""Error model
"""
from __future__ import absolute_import

from .deserialization import deserialize_model
from .base_model import Model


ErrorSchema = {
    "type": "object",
    "title": "The Error Schema",
    "properties": {
        "message": {
            "type": "string",
            "title": "Error message",
            "pattern": "^(.*)$"
        }
    }
}


class Error(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, message: str = None):  # noqa: E501
        """Document - a model defined in Swagger

        :param message: The message of this Error.  # noqa: E501
        :type type: str
        """
        self.swagger_types = {
            'message': str
        }

        self.attribute_map = {
            'message': 'message'
        }

        self._message = message

    @classmethod
    def from_dict(cls, dikt) -> 'Error':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Error object.  # noqa: E501
        :rtype: Error
        """
        return deserialize_model(dikt, cls)

    @property
    def message(self) -> str:
        """Gets the message of this Error.


        :return: The message of this Error.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message: str):
        """Sets the message of this Error.


        :param type: The message of this Error.
        :type message: str
        """
        self._message = message
