# -*- coding: utf-8 -*-


class FailoverCreateRunResponse(object):

    """Implementation of the 'FailoverCreateRunResponse' model.

    Specifies the response upon creating a special run during failover
    workflow.

    Attributes:
        failover_id (string): Specifies the unique failover Id which will be
            generated by orchestrator. This Id will be used to uniquely
            identify current failover operation.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "failover_id":'failoverId'
    }

    def __init__(self,
                 failover_id=None):
        """Constructor for the FailoverCreateRunResponse class"""

        # Initialize members of the class
        self.failover_id = failover_id


    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object as
            obtained from the deserialization of the server's response. The keys
            MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        failover_id = dictionary.get('failoverId')

        # Return an object of this model
        return cls(failover_id)


