# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['smile_id_core']

package_data = \
{'': ['*']}

install_requires = \
['pycryptodome==3.9.8', 'requests>=2.24.0']

setup_kwargs = {
    'name': 'smile-id-core',
    'version': '1.0.9',
    'description': 'The official Smile Identity package exposes four classes namely; the WebApi class, the IDApi class, the Signature class and the Utilities class.',
    'long_description': '# SmileIdentityCore\n\nThe official Smile Identity library exposes four classes namely; the WebApi class, the IDApi class, the Signature class, and the Utilities class.\n\nThe **WebApi Class** allows you as the Partner to validate a user’s identity against the relevant Identity Authorities/Third Party databases that Smile Identity has access to using ID information provided by your customer/user (including photo for compare). It has the following public method:\n- submit_job\n- get_web_token\n\nThe **IDApi Class** lets you perform basic KYC Services including verifying an ID number as well as retrieve a user\'s Personal Information. It has the following public methods:\n- submit_job\n\nThe **Signature Class** allows you as the Partner to generate a sec key to interact with our servers. It has the following public methods:\n- generate_sec_key\n\nThe **Utilities Class** allows you as the Partner to have access to our general Utility functions to gain access to your data. It has the following public methods:\n- get_job_status\n- validate_id_params\n- validate_partner_params\n- get_smile_id_services\n\n### Security\nWe accept 2 forms of security to communicate with our servers. The sec_key is the legacy means of communicating with our servers. This uses the v1 api key. The signature field is our new improved means of signing requests. To calculate a signature you need to generate a v2 api key. Generating a v2 api key does not invalidate existing v1 keys so you can safely upgrade. The library will default to calculating the legacy sec_key so your existing code will continue to behave as expected. To use the new signature form of security pass the boolean signature: true in the options object to any of our classes except Signature, where you would instead call the generate_signature function instead of the generate_sec_key function.\n\n## Documentation\n\nThis library requires specific input parameters, for more detail on these parameters please refer to our [documentation for Web API](https://docs.smileidentity.com/products/core-libraries/python).\n\nPlease note that you will have to be a Smile Identity Partner to be able to query our services. You can sign up on the [Portal](https://portal.smileidentity.com/signup).\n\n## Installation\n\nView the package on [Pypi](https://pypi.org/project/smile-id-core/).\n\nAdd the group, name and version to your application\'s build file, it will look similar based on your build tool:\n\n```shell\npip install smile-id-core\n```\n\nYou now may use the classes as follows:\n\n#### WebApi Class\n\nImport the necessary dependant classes for Web Api:\n\n```python\nfrom smile_id_core import WebApi\n```\n\n##### submit_job method\n\nYour call to the library will be similar to the below code snippet:\n```python\nfrom smile_id_core import WebApi, ServerError\n\nconnection = WebApi(\n    partner_id="125", \n    call_back_url="default_callback.com", \n    api_key="<the decoded-version of-your-api-key>", \n    sid_server=0\n)\npartner_params = {\n    "user_id": str("uuid4"),\n    "job_id": str("uuid4"),\n    "job_type": 1,\n}\nid_info_params = {\n    "first_name": "FirstName",\n    "middle_name": "LastName",\n    "last_name": "MiddleName",\n    "country": "NG",\n    "id_type": "PASSPORT",\n    "id_number": "A00000000",\n    "dob": "1989-09-20",\n    "phone_number": "",\n    "entered": True,\n}\nimage_params = [{"image_type_id": "2", "image": "base6image"}]\n\noptions_params = {\n    "return_job_status": True,\n    "return_history": True,\n    "return_images": True,\n    "signature": True,\n    "use_enrolled_image": True # Perform document verification (job_type 6) for a registered user i.e. use the user’s registered selfie\n}\n\ntry:\n    response = connection.submit_job(partner_params, image_params, id_info_params, options_params, use_validation_api=True)\nexcept ValueError:\n    # some of your params entered for a job are not valid or missing\n    print("handle ValueError")\nexcept ServerError:\n    # Server returned an error\n    print("handle ServerError")\nexcept FileNotFoundError:\n    # Sent a file which could not be found\n    print("handle FileNotFoundError")\n\n\n```\n\nIn the case of a Job Type 5 (_Validate an ID_) you can simply omit the the image_params and options_params keys. \nRemember that the response is immediate, so there is no need to query the job_status. There is also no enrollment so no images are required. \nThe response for a job type 5 can be found in the response section below.\n\n```python\nresponse = connection.submit_job(partner_params, None, id_info, None)\n```\n\n`use_validation_api` is optional and defaults to true. This will call the smile server and gets all required\ninput information for a job type and id type and checks if you  have provided required information, else it will throw an exception.\n\n**Response:**\n\nShould you choose to *set return_job_status to false*, the response will be a JSON String containing:\n```json\n{"success": true, "smile_job_id": smile_job_id}\n```\n\nHowever, if you have *set return_job_status to true (with image_links and history)* then you will receive JSON Object response like below:\n```json\n{\n    "job_success": true,\n    "result": {\n        "ConfidenceValue": "99",\n        "JSONVersion": "1.0.0",\n        "Actions": {\n            "Verify_ID_Number": "Verified",\n            "Return_Personal_Info": "Returned",\n            "Human_Review_Update_Selfie": "Not Applicable",\n            "Human_Review_Compare": "Not Applicable",\n            "Update_Registered_Selfie_On_File": "Not Applicable",\n            "Liveness_Check": "Not Applicable",\n            "Register_Selfie": "Approved",\n            "Human_Review_Liveness_Check": "Not Applicable",\n            "Selfie_To_ID_Authority_Compare": "Completed",\n            "Selfie_To_ID_Card_Compare": "Not Applicable",\n            "Selfie_To_Registered_Selfie_Compare": "Not Applicable"\n        },\n        "ResultText": "Enroll User",\n        "IsFinalResult": "true",\n        "IsMachineResult": "true",\n        "ResultType": "SAIA",\n        "PartnerParams": {\n            "job_type": "1",\n            "optional_info": "we are one",\n            "user_id": "HBBBBBBH57g",\n            "job_id": "HBBBBBBHg"\n        },\n        "Source": "WebAPI",\n        "ResultCode": "0810",\n        "SmileJobID": "0000001111"\n    },\n    "code": "2302",\n    "job_complete": true,\n    "signature": "HKBhxcv+1qaLy\\C7PjVtk257dE=|1577b051a4313ed5e3e4d29893a66f966e31af0a2d2f6bec2a7f2e00f2701259",\n    "history": [\n        {\n            "ConfidenceValue": "99",\n            "JSONVersion": "1.0.0",\n            "Actions": {\n                "Verify_ID_Number": "Verified",\n                "Return_Personal_Info": "Returned",\n                "Human_Review_Update_Selfie": "Not Applicable",\n                "Human_Review_Compare": "Not Applicable",\n                "Update_Registered_Selfie_On_File": "Not Applicable",\n                "Liveness_Check": "Not Applicable",\n                "Register_Selfie": "Approved",\n                "Human_Review_Liveness_Check": "Not Applicable",\n                "Selfie_To_ID_Authority_Compare": "Completed",\n                "Selfie_To_ID_Card_Compare": "Not Applicable",\n                "Selfie_To_Registered_Selfie_Compare": "Not Applicable"\n            },\n            "ResultText": "Enroll User",\n            "IsFinalResult": "true",\n            "IsMachineResult": "true",\n            "ResultType": "SAIA",\n            "PartnerParams": {\n                "job_type": "1",\n                "optional_info": "we are one",\n                "user_id": "HBBBBBBH57g",\n                "job_id": "HBBBBBBHg"\n            },\n            "Source": "WebAPI",\n            "ResultCode": "0810",\n            "SmileJobID": "0000001111"\n        }\n    ],\n    "image_links": {\n        "selfie_image": "image_link"\n    },\n    "timestamp": "2019-10-10T12:32:04.622Z",\n    "success": true,\n    "smile_job_id": "0000001111"\n}\n\n```\n\nYou can also *view your response asynchronously at the callback* that you have set, it will look as follows:\n```json\n{\n    "job_success": true,\n    "result": {\n        "ConfidenceValue": "99",\n        "JSONVersion": "1.0.0",\n        "Actions": {\n            "Verify_ID_Number": "Verified",\n            "Return_Personal_Info": "Returned",\n            "Human_Review_Update_Selfie": "Not Applicable",\n            "Human_Review_Compare": "Not Applicable",\n            "Update_Registered_Selfie_On_File": "Not Applicable",\n            "Liveness_Check": "Not Applicable",\n            "Register_Selfie": "Approved",\n            "Human_Review_Liveness_Check": "Not Applicable",\n            "Selfie_To_ID_Authority_Compare": "Completed",\n            "Selfie_To_ID_Card_Compare": "Not Applicable",\n            "Selfie_To_Registered_Selfie_Compare": "Not Applicable"\n        },\n        "ResultText": "Enroll User",\n        "IsFinalResult": "true",\n        "IsMachineResult": "true",\n        "ResultType": "SAIA",\n        "PartnerParams": {\n            "job_type": "1",\n            "optional_info": "we are one",\n            "user_id": "HBBBBBBH57g",\n            "job_id": "HBBBBBBHg"\n        },\n        "Source": "WebAPI",\n        "ResultCode": "0810",\n        "SmileJobID": "0000001111"\n    },\n    "code": "2302",\n    "job_complete": true,\n    "signature": "HKBhxcv+1qaLy\\C7PjVtk257dE=|1577b051a4313ed5e3e4d29893a66f966e31af0a2d2f6bec2a7f2e00f2701259",\n    "history": [\n        {\n            "ConfidenceValue": "99",\n            "JSONVersion": "1.0.0",\n            "Actions": {\n                "Verify_ID_Number": "Verified",\n                "Return_Personal_Info": "Returned",\n                "Human_Review_Update_Selfie": "Not Applicable",\n                "Human_Review_Compare": "Not Applicable",\n                "Update_Registered_Selfie_On_File": "Not Applicable",\n                "Liveness_Check": "Not Applicable",\n                "Register_Selfie": "Approved",\n                "Human_Review_Liveness_Check": "Not Applicable",\n                "Selfie_To_ID_Authority_Compare": "Completed",\n                "Selfie_To_ID_Card_Compare": "Not Applicable",\n                "Selfie_To_Registered_Selfie_Compare": "Not Applicable"\n            },\n            "ResultText": "Enroll User",\n            "IsFinalResult": "true",\n            "IsMachineResult": "true",\n            "ResultType": "SAIA",\n            "PartnerParams": {\n                "job_type": "1",\n                "optional_info": "we are one",\n                "user_id": "HBBBBBBH57g",\n                "job_id": "HBBBBBBHg"\n            },\n            "Source": "WebAPI",\n            "ResultCode": "0810",\n            "SmileJobID": "0000001111"\n        }\n    ],\n    "image_links": {\n        "selfie_image": "image_link"\n    },\n    "timestamp": "2019-10-10T12:32:04.622Z"\n}\n\n```\n\nIf you have queried a job type 5 (_Validate an ID_), your response be a JSON String that will contain the following:\n```json\n{\n   "JSONVersion":"1.0.0",\n   "SmileJobID":"0000001105",\n   "PartnerParams":{\n      "user_id":"T6yzdOezucdsPrY0QG9LYNDGOrC",\n      "job_id":"FS1kd1dd15JUpd87gTBDapvFxv0",\n      "job_type":5\n   },\n   "ResultType":"ID Verification",\n   "ResultText":"ID Number Validated",\n   "ResultCode":"1012",\n   "IsFinalResult":"true",\n   "Actions":{\n      "Verify_ID_Number":"Verified",\n      "Return_Personal_Info":"Returned"\n   },\n   "Country":"NG",\n   "IDType":"PASSPORT",\n   "IDNumber":"A12345",\n   "ExpirationDate":"2017-10-28",\n   "FullName":"John Doe",\n   "DOB":"1900-09-20",\n   "Photo":"SomeBase64Image",\n   "sec_key":"pjxsx...",\n   "timestamp":1570698930193\n}\n```\n\n##### get_job_status method\n\nSometimes, you may want to get a particular job status at a later time. You may use the get_job_status function to do this:\n\nYou will already have your Web Api or Utilities class initialised as follows:\n\n```python\nfrom smile_id_core import WebApi,Utilities,ServerError\ntry:\n    connection = WebApi("< String partner_id >", "< String default_callback_url >",\n                        "< String decoded_version_of_api_key >", "< Integer 0 | | 1 >")\n    # OR\n    connection = Utilities("< String partner_id >", "< String default_callback_url >",\n                           "< String decoded_version_of_api_key >", "< Integer 0 | | 1 >")\nexcept ValueError:\n    # some of your params entered for a job are not valid or missing\n    print("handle ValueError")\n# Thereafter, simply call get_job_status with the correct parameters using the classes we have provided:\n\n# create the stringified json for the partner params using our class (i.e. user_id, job_id, and job_type that you would are querying)\npartner_params = {\n    "user_id": str(uuid4()),\n    "job_id": str(uuid4()),\n    "job_type": 1,\n}\n# create the options - whether you would like to return_history and return_image_links in the job status response\noptions_params = {\n    "return_job_status": True,\n    "return_history": True,\n    "return_images": True,\n    "signature": True # optional param to use the new signature calculation for API Key V2\n}\ntry:\n    response = connection.get_job_status(partner_params, options_params)\nexcept ValueError:\n    # some of your params entered for a job are not valid or missing\n    print("handle ValueError")\nexcept ServerError:\n    # Server returned an error\n    print("handle ServerError")\n```\n\n##### get_web_token method\nYou may want to use our hosted web integration, and create a session. The `get_web_token` function enables this.\n\nYou have your Web Api class initialised as follows:\n```python\nfrom smile_id_core import WebApi\n\nconnection = WebApi(partner_id, default_callback, api_key, sid_server);\n```\n\nNext, you\'ll need to create your request object. This should take the following\nstructure:\n\n```json\n{\n\t"user_id": \'user-1\', // String: required\n\t"job_id": \'job-1\', // String: required\n\t"product": \'authentication\', // String: required one of \'authentication\', \'basic_kyc\', \'smartselfie\', \'biometric_kyc\', \'enhanced_kyc\', \'document_verification\'\n\t"callback_url": "https://smileidentity.com/callback" \t// String: required, optional if callback url was set during instantiation of the class\n}\n```\n\nThereafter, call `get_web_token` with the correct parameters:\n```python\n  response = connection.get_web_token(requestParams)\n```\n\n**Response**\n\nYour response will return a promise that contains a JSON Object below:\n```json\n{\n\t"token": "<token_string>"\n}\n```\n\n#### ID Api Class\n\nAn API that lets you performs basic KYC Services including verifying an ID number as well as retrieve a user\'s Personal Information\n\nImport the necessary dependant classes for ID Api:\n\n```python\nfrom smile_id_core import IdApi, ServerError\n```\n\n##### submit_job method\n\nYour call to the library will be similar to the below code snippet:\n```python\nfrom smile_id_core import IdApi, ServerError\n\npartner_params = {\n    "user_id": str(uuid4()),\n    "job_id": str(uuid4()),\n    "job_type": 5,\n}\n\nid_info_params = {\n    "first_name": "FirstName",\n    "middle_name": "LastName",\n    "last_name": "MiddleName",\n    "country": "NG",\n    "id_type": "PASSPORT",\n    "id_number": "A00000000",\n    "dob": "1989-09-20",\n    "phone_number": "",\n    "entered": True,\n}\n\noption_params = {\n    "signature": True # optional param to use the new signature calculation for API Key V2\n}\ntry:\n    connection = IdApi("< String partner_id >", "< String decoded_version_of_api_key >", "< Integer 0 | | 1 >")\n    response = connection.submit_job(partner_params, id_info_params,option_params)\nexcept ValueError:\n    # some of your params entered for a job are not valid or missing\n    print("handle ValueError")\nexcept ServerError:\n    # Server returned an error\n    print("handle ServerError")\n  \n```\nuse_validation_api is optional and defaults to true this will call the smile server and gets all required\ninput information for a job type and id type and checks if you  have provided required information else it will throw an exception\n\n**Response**\n\nYour response will return a JSON String containing the below:\n```json\n{\n   "JSONVersion":"1.0.0",\n   "SmileJobID":"0000001105",\n   "PartnerParams":{\n      "user_id":"T6yzdOezucdsPrY0QG9LYNDGOrC",\n      "job_id":"FS1kd1dd15JUpd87gTBDapvFxv0",\n      "job_type":5\n   },\n   "ResultType":"ID Verification",\n   "ResultText":"ID Number Validated",\n   "ResultCode":"1012",\n   "IsFinalResult":"true",\n   "Actions":{\n      "Verify_ID_Number":"Verified",\n      "Return_Personal_Info":"Returned"\n   },\n   "Country":"NG",\n   "IDType":"PASSPORT",\n   "IDNumber":"A12345",\n   "ExpirationDate":"2017-10-28",\n   "FullName":"John Doe",\n   "DOB":"1900-09-20",\n   "Photo":"SomeBase64Image",\n   "sec_key":"pjxsx...",\n   "timestamp":1570698930193\n}\n\n```\n\n#### Signature Class\n\n##### `generate_sec_key` method\n\nUse the Signature class as follows:\nFor API Key V1 (Legacy)\n```python\nfrom smile_id_core import Signature\n\n\nsignature = Signature("partner_id", "api_key")\nsignature_dict = signature.generate_sec_key(timestamp)  # where timestamp is optional\n```\n\nThe response will be a dict:\n```json\n{\n    "sec_key": "<the generated sec key>",\n    "timestamp": "<timestamp that you passed in or that was generated>"\n}\n```\nFor API Key V2\n```python\nfrom smile_id_core import Signature\n\n\nsignature = Signature("partner_id", "api_key")\nsignature_dict = signature.generate_signature(timestamp)  # where timestamp is optional\n```\n\nThe response will be a dict:\n```json\n{\n    "signature": "<the generated sec key>",\n    "timestamp": "<timestamp that you passed in or that was generated>"\n}\n```\n\n\n#### Utilities Class\n\nYou may want to receive more information about a job. This is built into Web Api if you choose to set return_job_status as true in the options class. However, you also have the option to build the functionality yourself by using the Utilities class. Please note that if you are querying a job immediately after submitting it, you will need to poll it for the duration of the job.\n\n```python\nfrom smile_id_core import Utilities, ServerError\n\ntry:\n    connection = Utilities("<partner_id>", "<the decoded-version of-your-api-key>", "<sid_server>")\n    job_status = connection.get_job_status("<partner_params>", "<option_params>", "<sec_key_params>")\n    print(job_status)\nexcept ValueError:\n    # some of your params entered for a job are not valid or missing\n    print("handle ValueError")\nexcept ServerError:\n    # Server returned an error\n    print("handle ServerError")\n\n```\n\nThis returns the job status as stringified json data.\n\n```python\nfrom smile_id_core import Utilities\n\ntry:\n    Utilities.validate_id_params("sid_server<0 for test or 1 for live or a string url>", "id_info_params", "partner_params", "use_validation_api=True")\nexcept ValueError:\n    # some of your params entered for a job are not valid or missing\n    print("handle ValueError")\n\n```\nThis will validate id parameters using the smile services endpoint which checks \nthe provided user id and partner params. If use_validation_api  is  False it will only do a local\nvalidation to check for country, id type and id number but by default this is  True and will check\nagainst the smile services endpoint and if any key is missing will throw an exception\n\n```python\nfrom smile_id_core import Utilities,ServerError\n\ntry:\n    Utilities.get_smile_id_services("sid_server<0 for test or 1 for live or a string url>")\nexcept ValueError:\n    # some of your params entered for a job are not valid or missing\n    print("handle ValueError")\nexcept ServerError:\n    # Server returned an error\n    print("handle ServerError")\n\n```\nThis will return the smile services endpoint as a json object and  can then be used  for validation as per requirement\n\n## Development\n\n1. Ensure you have `poetry` installed: https://python-poetry.org/docs#installation\n2. After checking out the repo, run `poetry install`  -- this sets up a virtualenvironment and install all required packages.\n   1. Run `poetry shell` to activate the virtual environment.\n   2. Run `poetry env info` to get details about the virtual environment\n\n## Deployment\n\nThis is the https://packaging.python.org/tutorials/packaging-projects/ that you can always reference for history.\n\n#### Testing\n\nTests are based on `pytest`.\n\nIf your virtual environment is active, run `poetry run pytest` from the root of the project to run the tests.\n\nIf you are outside the virtual environment, run `poetry run pytest` from the root of the project to run the tests.\n\n#### Deployment\n\nTo release a new version:\n\n- Bump the version number in `pyproject.toml` (the version in `smile_id_core/__init__.py` will pick this up)\n- Update `changelog.md` with the new version number and the changes made\n- Run `poetry build` to build package.\n- Ensure your PyPI credentials are propery configured\n- Run `poetry publish` to publish package.\n\n## Contributing\n\nBug reports and pull requests are welcome on GitHub at https://github.com/smileidentity/smile-identity-core-python-3\n\nPlease format the code with [black](https://github.com/psf/black) prior to submitting pull requests, by running:\n```\npoetry run black .\n```\nfrom the project\'s root. \n',
    'author': 'Smile Identity',
    'author_email': 'support@smileidentity.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/smileidentity/smile-identity-core-python-3',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.2,<4.0.0',
}


setup(**setup_kwargs)
