import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::DynamoDB::Table`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export interface CfnTableProps {
    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    readonly attributeDefinitions?: Array<CfnTable.AttributeDefinitionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     */
    readonly billingMode?: string;
    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    readonly globalSecondaryIndexes?: Array<CfnTable.GlobalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.KinesisStreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-kinesisstreamspecification
     */
    readonly kinesisStreamSpecification?: CfnTable.KinesisStreamSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    readonly localSecondaryIndexes?: Array<CfnTable.LocalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    readonly pointInTimeRecoverySpecification?: CfnTable.PointInTimeRecoverySpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    readonly provisionedThroughput?: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    readonly sseSpecification?: CfnTable.SSESpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    readonly streamSpecification?: CfnTable.StreamSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.TableName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    readonly tableName?: string;
    /**
     * `AWS::DynamoDB::Table.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    readonly timeToLiveSpecification?: CfnTable.TimeToLiveSpecificationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare class CfnTable extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DynamoDB::Table";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTable;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute StreamArn
     */
    readonly attrStreamArn: string;
    /**
     * `AWS::DynamoDB::Table.KeySchema`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-keyschema
     */
    keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DynamoDB::Table.AttributeDefinitions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-attributedef
     */
    attributeDefinitions: Array<CfnTable.AttributeDefinitionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.BillingMode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-billingmode
     */
    billingMode: string | undefined;
    /**
     * `AWS::DynamoDB::Table.GlobalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-gsi
     */
    globalSecondaryIndexes: Array<CfnTable.GlobalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.KinesisStreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-kinesisstreamspecification
     */
    kinesisStreamSpecification: CfnTable.KinesisStreamSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.LocalSecondaryIndexes`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-lsi
     */
    localSecondaryIndexes: Array<CfnTable.LocalSecondaryIndexProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.PointInTimeRecoverySpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-pointintimerecoveryspecification
     */
    pointInTimeRecoverySpecification: CfnTable.PointInTimeRecoverySpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.ProvisionedThroughput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-provisionedthroughput
     */
    provisionedThroughput: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.SSESpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-ssespecification
     */
    sseSpecification: CfnTable.SSESpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.StreamSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-streamspecification
     */
    streamSpecification: CfnTable.StreamSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::DynamoDB::Table.TableName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tablename
     */
    tableName: string | undefined;
    /**
     * `AWS::DynamoDB::Table.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DynamoDB::Table.TimeToLiveSpecification`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html#cfn-dynamodb-table-timetolivespecification
     */
    timeToLiveSpecification: CfnTable.TimeToLiveSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::DynamoDB::Table`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTableProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html
     */
    interface AttributeDefinitionProperty {
        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnTable.AttributeDefinitionProperty.AttributeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-attributedef.html#cfn-dynamodb-attributedef-attributename-attributetype
         */
        readonly attributeType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html
     */
    interface GlobalSecondaryIndexProperty {
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.IndexName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-indexname
         */
        readonly indexName: string;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.KeySchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-keyschema
         */
        readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.Projection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-projection
         */
        readonly projection: CfnTable.ProjectionProperty | cdk.IResolvable;
        /**
         * `CfnTable.GlobalSecondaryIndexProperty.ProvisionedThroughput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-gsi.html#cfn-dynamodb-gsi-provisionedthroughput
         */
        readonly provisionedThroughput?: CfnTable.ProvisionedThroughputProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html
     */
    interface KeySchemaProperty {
        /**
         * `CfnTable.KeySchemaProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnTable.KeySchemaProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-keyschema.html#aws-properties-dynamodb-keyschema-keytype
         */
        readonly keyType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-kinesisstreamspecification.html
     */
    interface KinesisStreamSpecificationProperty {
        /**
         * `CfnTable.KinesisStreamSpecificationProperty.StreamArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-kinesisstreamspecification.html#cfn-dynamodb-kinesisstreamspecification-streamarn
         */
        readonly streamArn: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html
     */
    interface LocalSecondaryIndexProperty {
        /**
         * `CfnTable.LocalSecondaryIndexProperty.IndexName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-indexname
         */
        readonly indexName: string;
        /**
         * `CfnTable.LocalSecondaryIndexProperty.KeySchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-keyschema
         */
        readonly keySchema: Array<CfnTable.KeySchemaProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnTable.LocalSecondaryIndexProperty.Projection`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-lsi.html#cfn-dynamodb-lsi-projection
         */
        readonly projection: CfnTable.ProjectionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html
     */
    interface PointInTimeRecoverySpecificationProperty {
        /**
         * `CfnTable.PointInTimeRecoverySpecificationProperty.PointInTimeRecoveryEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-pointintimerecoveryspecification.html#cfn-dynamodb-table-pointintimerecoveryspecification-pointintimerecoveryenabled
         */
        readonly pointInTimeRecoveryEnabled?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html
     */
    interface ProjectionProperty {
        /**
         * `CfnTable.ProjectionProperty.NonKeyAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-nonkeyatt
         */
        readonly nonKeyAttributes?: string[];
        /**
         * `CfnTable.ProjectionProperty.ProjectionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-projectionobject.html#cfn-dynamodb-projectionobj-projtype
         */
        readonly projectionType?: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html
     */
    interface ProvisionedThroughputProperty {
        /**
         * `CfnTable.ProvisionedThroughputProperty.ReadCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-readcapacityunits
         */
        readonly readCapacityUnits: number;
        /**
         * `CfnTable.ProvisionedThroughputProperty.WriteCapacityUnits`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-provisionedthroughput.html#cfn-dynamodb-provisionedthroughput-writecapacityunits
         */
        readonly writeCapacityUnits: number;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html
     */
    interface SSESpecificationProperty {
        /**
         * `CfnTable.SSESpecificationProperty.KMSMasterKeyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-kmsmasterkeyid
         */
        readonly kmsMasterKeyId?: string;
        /**
         * `CfnTable.SSESpecificationProperty.SSEEnabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-sseenabled
         */
        readonly sseEnabled: boolean | cdk.IResolvable;
        /**
         * `CfnTable.SSESpecificationProperty.SSEType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-table-ssespecification.html#cfn-dynamodb-table-ssespecification-ssetype
         */
        readonly sseType?: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html
     */
    interface StreamSpecificationProperty {
        /**
         * `CfnTable.StreamSpecificationProperty.StreamViewType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-streamspecification.html#cfn-dynamodb-streamspecification-streamviewtype
         */
        readonly streamViewType: string;
    }
}
/**
 * A CloudFormation `AWS::DynamoDB::Table`.
 *
 * @external
 * @cloudformationResource AWS::DynamoDB::Table
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-table.html
 */
export declare namespace CfnTable {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html
     */
    interface TimeToLiveSpecificationProperty {
        /**
         * `CfnTable.TimeToLiveSpecificationProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnTable.TimeToLiveSpecificationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-dynamodb-timetolivespecification.html#cfn-dynamodb-timetolivespecification-enabled
         */
        readonly enabled: boolean | cdk.IResolvable;
    }
}
