'''
MAVLink protocol implementation (auto-generated by mavgen.py)

Generated from: minimal.xml

Note: this file has been auto-generated. DO NOT EDIT
'''
from __future__ import print_function
from builtins import range
from builtins import object
import struct, array, time, json, os, sys, platform

from ...generator.mavcrc import x25crc
import hashlib

WIRE_PROTOCOL_VERSION = '1.0'
DIALECT = 'minimal'

PROTOCOL_MARKER_V1 = 0xFE
PROTOCOL_MARKER_V2 = 0xFD
HEADER_LEN_V1 = 6
HEADER_LEN_V2 = 10

MAVLINK_SIGNATURE_BLOCK_LEN = 13

MAVLINK_IFLAG_SIGNED = 0x01

native_supported = platform.system() != 'Windows' # Not yet supported on other dialects
native_force = 'MAVNATIVE_FORCE' in os.environ # Will force use of native code regardless of what client app wants
native_testing = 'MAVNATIVE_TESTING' in os.environ # Will force both native and legacy code to be used and their results compared

if native_supported and float(WIRE_PROTOCOL_VERSION) <= 1:
    try:
        import mavnative
    except ImportError:
        print('ERROR LOADING MAVNATIVE - falling back to python implementation')
        native_supported = False
else:
    # mavnative isn't supported for MAVLink2 yet
    native_supported = False

# some base types from mavlink_types.h
MAVLINK_TYPE_CHAR     = 0
MAVLINK_TYPE_UINT8_T  = 1
MAVLINK_TYPE_INT8_T   = 2
MAVLINK_TYPE_UINT16_T = 3
MAVLINK_TYPE_INT16_T  = 4
MAVLINK_TYPE_UINT32_T = 5
MAVLINK_TYPE_INT32_T  = 6
MAVLINK_TYPE_UINT64_T = 7
MAVLINK_TYPE_INT64_T  = 8
MAVLINK_TYPE_FLOAT    = 9
MAVLINK_TYPE_DOUBLE   = 10


class MAVLink_header(object):
    '''MAVLink message header'''
    def __init__(self, msgId, incompat_flags=0, compat_flags=0, mlen=0, seq=0, srcSystem=0, srcComponent=0):
        self.mlen = mlen
        self.seq = seq
        self.srcSystem = srcSystem
        self.srcComponent = srcComponent
        self.msgId = msgId
        self.incompat_flags = incompat_flags
        self.compat_flags = compat_flags

    def pack(self, force_mavlink1=False):
        if WIRE_PROTOCOL_VERSION == '2.0' and not force_mavlink1:
            return struct.pack('<BBBBBBBHB', 254, self.mlen,
                               self.incompat_flags, self.compat_flags,
                               self.seq, self.srcSystem, self.srcComponent,
                               self.msgId&0xFFFF, self.msgId>>16)
        return struct.pack('<BBBBBB', PROTOCOL_MARKER_V1, self.mlen, self.seq,
                           self.srcSystem, self.srcComponent, self.msgId)

class MAVLink_message(object):
    '''base MAVLink message class'''
    def __init__(self, msgId, name):
        self._header     = MAVLink_header(msgId)
        self._payload    = None
        self._msgbuf     = None
        self._crc        = None
        self._fieldnames = []
        self._type       = name
        self._signed     = False
        self._link_id    = None

    def format_attr(self, field):
        '''override field getter'''
        raw_attr = getattr(self,field)
        if isinstance(raw_attr, bytes):
            raw_attr = raw_attr.decode("utf-8").rstrip("\00")
        return raw_attr

    def get_msgbuf(self):
        if isinstance(self._msgbuf, bytearray):
            return self._msgbuf
        return bytearray(self._msgbuf)

    def get_header(self):
        return self._header

    def get_payload(self):
        return self._payload

    def get_crc(self):
        return self._crc

    def get_fieldnames(self):
        return self._fieldnames

    def get_type(self):
        return self._type

    def get_msgId(self):
        return self._header.msgId

    def get_srcSystem(self):
        return self._header.srcSystem

    def get_srcComponent(self):
        return self._header.srcComponent

    def get_seq(self):
        return self._header.seq

    def get_signed(self):
        return self._signed

    def get_link_id(self):
        return self._link_id

    def __str__(self):
        ret = '%s {' % self._type
        for a in self._fieldnames:
            v = self.format_attr(a)
            ret += '%s : %s, ' % (a, v)
        ret = ret[0:-2] + '}'
        return ret

    def __ne__(self, other):
        return not self.__eq__(other)

    def __eq__(self, other):
        if other is None:
            return False

        if self.get_type() != other.get_type():
            return False

        # We do not compare CRC because native code doesn't provide it
        #if self.get_crc() != other.get_crc():
        #    return False

        if self.get_seq() != other.get_seq():
            return False

        if self.get_srcSystem() != other.get_srcSystem():
            return False

        if self.get_srcComponent() != other.get_srcComponent():
            return False

        for a in self._fieldnames:
            if self.format_attr(a) != other.format_attr(a):
                return False

        return True

    def to_dict(self):
        d = dict({})
        d['mavpackettype'] = self._type
        for a in self._fieldnames:
          d[a] = self.format_attr(a)
        return d

    def to_json(self):
        return json.dumps(self.to_dict())

    def sign_packet(self, mav):
        h = hashlib.new('sha256')
        self._msgbuf += struct.pack('<BQ', mav.signing.link_id, mav.signing.timestamp)[:7]
        h.update(mav.signing.secret_key)
        h.update(self._msgbuf)
        sig = h.digest()[:6]
        self._msgbuf += sig
        mav.signing.timestamp += 1

    def pack(self, mav, crc_extra, payload, force_mavlink1=False):
        plen = len(payload)
        if WIRE_PROTOCOL_VERSION != '1.0' and not force_mavlink1:
            # in MAVLink2 we can strip trailing zeros off payloads. This allows for simple
            # variable length arrays and smaller packets
            nullbyte = chr(0)
            # in Python2, type("fred') is str but also type("fred")==bytes
            if str(type(payload)) == "<class 'bytes'>":
                nullbyte = 0
            while plen > 1 and payload[plen-1] == nullbyte:
                plen -= 1
        self._payload = payload[:plen]
        incompat_flags = 0
        if mav.signing.sign_outgoing:
            incompat_flags |= MAVLINK_IFLAG_SIGNED
        self._header  = MAVLink_header(self._header.msgId,
                                       incompat_flags=incompat_flags, compat_flags=0,
                                       mlen=len(self._payload), seq=mav.seq,
                                       srcSystem=mav.srcSystem, srcComponent=mav.srcComponent)
        self._msgbuf = self._header.pack(force_mavlink1=force_mavlink1) + self._payload
        crc = x25crc(self._msgbuf[1:])
        if True: # using CRC extra
            crc.accumulate_str(struct.pack('B', crc_extra))
        self._crc = crc.crc
        self._msgbuf += struct.pack('<H', self._crc)
        if mav.signing.sign_outgoing and not force_mavlink1:
            self.sign_packet(mav)
        return self._msgbuf


# enums

class EnumEntry(object):
    def __init__(self, name, description):
        self.name = name
        self.description = description
        self.param = {}

enums = {}

# MAV_AUTOPILOT
enums['MAV_AUTOPILOT'] = {}
MAV_AUTOPILOT_GENERIC = 0 # Generic autopilot, full support for everything
enums['MAV_AUTOPILOT'][0] = EnumEntry('MAV_AUTOPILOT_GENERIC', '''Generic autopilot, full support for everything''')
MAV_AUTOPILOT_RESERVED = 1 # Reserved for future use.
enums['MAV_AUTOPILOT'][1] = EnumEntry('MAV_AUTOPILOT_RESERVED', '''Reserved for future use.''')
MAV_AUTOPILOT_SLUGS = 2 # SLUGS autopilot, http://slugsuav.soe.ucsc.edu
enums['MAV_AUTOPILOT'][2] = EnumEntry('MAV_AUTOPILOT_SLUGS', '''SLUGS autopilot, http://slugsuav.soe.ucsc.edu''')
MAV_AUTOPILOT_ARDUPILOTMEGA = 3 # ArduPilot - Plane/Copter/Rover/Sub/Tracker, http://ardupilot.org
enums['MAV_AUTOPILOT'][3] = EnumEntry('MAV_AUTOPILOT_ARDUPILOTMEGA', '''ArduPilot - Plane/Copter/Rover/Sub/Tracker, http://ardupilot.org''')
MAV_AUTOPILOT_OPENPILOT = 4 # OpenPilot, http://openpilot.org
enums['MAV_AUTOPILOT'][4] = EnumEntry('MAV_AUTOPILOT_OPENPILOT', '''OpenPilot, http://openpilot.org''')
MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY = 5 # Generic autopilot only supporting simple waypoints
enums['MAV_AUTOPILOT'][5] = EnumEntry('MAV_AUTOPILOT_GENERIC_WAYPOINTS_ONLY', '''Generic autopilot only supporting simple waypoints''')
MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY = 6 # Generic autopilot supporting waypoints and other simple navigation
                        # commands
enums['MAV_AUTOPILOT'][6] = EnumEntry('MAV_AUTOPILOT_GENERIC_WAYPOINTS_AND_SIMPLE_NAVIGATION_ONLY', '''Generic autopilot supporting waypoints and other simple navigation commands''')
MAV_AUTOPILOT_GENERIC_MISSION_FULL = 7 # Generic autopilot supporting the full mission command set
enums['MAV_AUTOPILOT'][7] = EnumEntry('MAV_AUTOPILOT_GENERIC_MISSION_FULL', '''Generic autopilot supporting the full mission command set''')
MAV_AUTOPILOT_INVALID = 8 # No valid autopilot, e.g. a GCS or other MAVLink component
enums['MAV_AUTOPILOT'][8] = EnumEntry('MAV_AUTOPILOT_INVALID', '''No valid autopilot, e.g. a GCS or other MAVLink component''')
MAV_AUTOPILOT_PPZ = 9 # PPZ UAV - http://nongnu.org/paparazzi
enums['MAV_AUTOPILOT'][9] = EnumEntry('MAV_AUTOPILOT_PPZ', '''PPZ UAV - http://nongnu.org/paparazzi''')
MAV_AUTOPILOT_UDB = 10 # UAV Dev Board
enums['MAV_AUTOPILOT'][10] = EnumEntry('MAV_AUTOPILOT_UDB', '''UAV Dev Board''')
MAV_AUTOPILOT_FP = 11 # FlexiPilot
enums['MAV_AUTOPILOT'][11] = EnumEntry('MAV_AUTOPILOT_FP', '''FlexiPilot''')
MAV_AUTOPILOT_PX4 = 12 # PX4 Autopilot - http://px4.io/
enums['MAV_AUTOPILOT'][12] = EnumEntry('MAV_AUTOPILOT_PX4', '''PX4 Autopilot - http://px4.io/''')
MAV_AUTOPILOT_SMACCMPILOT = 13 # SMACCMPilot - http://smaccmpilot.org
enums['MAV_AUTOPILOT'][13] = EnumEntry('MAV_AUTOPILOT_SMACCMPILOT', '''SMACCMPilot - http://smaccmpilot.org''')
MAV_AUTOPILOT_AUTOQUAD = 14 # AutoQuad -- http://autoquad.org
enums['MAV_AUTOPILOT'][14] = EnumEntry('MAV_AUTOPILOT_AUTOQUAD', '''AutoQuad -- http://autoquad.org''')
MAV_AUTOPILOT_ARMAZILA = 15 # Armazila -- http://armazila.com
enums['MAV_AUTOPILOT'][15] = EnumEntry('MAV_AUTOPILOT_ARMAZILA', '''Armazila -- http://armazila.com''')
MAV_AUTOPILOT_AEROB = 16 # Aerob -- http://aerob.ru
enums['MAV_AUTOPILOT'][16] = EnumEntry('MAV_AUTOPILOT_AEROB', '''Aerob -- http://aerob.ru''')
MAV_AUTOPILOT_ASLUAV = 17 # ASLUAV autopilot -- http://www.asl.ethz.ch
enums['MAV_AUTOPILOT'][17] = EnumEntry('MAV_AUTOPILOT_ASLUAV', '''ASLUAV autopilot -- http://www.asl.ethz.ch''')
MAV_AUTOPILOT_SMARTAP = 18 # SmartAP Autopilot - http://sky-drones.com
enums['MAV_AUTOPILOT'][18] = EnumEntry('MAV_AUTOPILOT_SMARTAP', '''SmartAP Autopilot - http://sky-drones.com''')
MAV_AUTOPILOT_AIRRAILS = 19 # AirRails - http://uaventure.com
enums['MAV_AUTOPILOT'][19] = EnumEntry('MAV_AUTOPILOT_AIRRAILS', '''AirRails - http://uaventure.com''')
MAV_AUTOPILOT_ENUM_END = 20 # 
enums['MAV_AUTOPILOT'][20] = EnumEntry('MAV_AUTOPILOT_ENUM_END', '''''')

# MAV_TYPE
enums['MAV_TYPE'] = {}
MAV_TYPE_GENERIC = 0 # Generic micro air vehicle
enums['MAV_TYPE'][0] = EnumEntry('MAV_TYPE_GENERIC', '''Generic micro air vehicle''')
MAV_TYPE_FIXED_WING = 1 # Fixed wing aircraft.
enums['MAV_TYPE'][1] = EnumEntry('MAV_TYPE_FIXED_WING', '''Fixed wing aircraft.''')
MAV_TYPE_QUADROTOR = 2 # Quadrotor
enums['MAV_TYPE'][2] = EnumEntry('MAV_TYPE_QUADROTOR', '''Quadrotor''')
MAV_TYPE_COAXIAL = 3 # Coaxial helicopter
enums['MAV_TYPE'][3] = EnumEntry('MAV_TYPE_COAXIAL', '''Coaxial helicopter''')
MAV_TYPE_HELICOPTER = 4 # Normal helicopter with tail rotor.
enums['MAV_TYPE'][4] = EnumEntry('MAV_TYPE_HELICOPTER', '''Normal helicopter with tail rotor.''')
MAV_TYPE_ANTENNA_TRACKER = 5 # Ground installation
enums['MAV_TYPE'][5] = EnumEntry('MAV_TYPE_ANTENNA_TRACKER', '''Ground installation''')
MAV_TYPE_GCS = 6 # Operator control unit / ground control station
enums['MAV_TYPE'][6] = EnumEntry('MAV_TYPE_GCS', '''Operator control unit / ground control station''')
MAV_TYPE_AIRSHIP = 7 # Airship, controlled
enums['MAV_TYPE'][7] = EnumEntry('MAV_TYPE_AIRSHIP', '''Airship, controlled''')
MAV_TYPE_FREE_BALLOON = 8 # Free balloon, uncontrolled
enums['MAV_TYPE'][8] = EnumEntry('MAV_TYPE_FREE_BALLOON', '''Free balloon, uncontrolled''')
MAV_TYPE_ROCKET = 9 # Rocket
enums['MAV_TYPE'][9] = EnumEntry('MAV_TYPE_ROCKET', '''Rocket''')
MAV_TYPE_GROUND_ROVER = 10 # Ground rover
enums['MAV_TYPE'][10] = EnumEntry('MAV_TYPE_GROUND_ROVER', '''Ground rover''')
MAV_TYPE_SURFACE_BOAT = 11 # Surface vessel, boat, ship
enums['MAV_TYPE'][11] = EnumEntry('MAV_TYPE_SURFACE_BOAT', '''Surface vessel, boat, ship''')
MAV_TYPE_SUBMARINE = 12 # Submarine
enums['MAV_TYPE'][12] = EnumEntry('MAV_TYPE_SUBMARINE', '''Submarine''')
MAV_TYPE_HEXAROTOR = 13 # Hexarotor
enums['MAV_TYPE'][13] = EnumEntry('MAV_TYPE_HEXAROTOR', '''Hexarotor''')
MAV_TYPE_OCTOROTOR = 14 # Octorotor
enums['MAV_TYPE'][14] = EnumEntry('MAV_TYPE_OCTOROTOR', '''Octorotor''')
MAV_TYPE_TRICOPTER = 15 # Tricopter
enums['MAV_TYPE'][15] = EnumEntry('MAV_TYPE_TRICOPTER', '''Tricopter''')
MAV_TYPE_FLAPPING_WING = 16 # Flapping wing
enums['MAV_TYPE'][16] = EnumEntry('MAV_TYPE_FLAPPING_WING', '''Flapping wing''')
MAV_TYPE_KITE = 17 # Kite
enums['MAV_TYPE'][17] = EnumEntry('MAV_TYPE_KITE', '''Kite''')
MAV_TYPE_ONBOARD_CONTROLLER = 18 # Onboard companion controller
enums['MAV_TYPE'][18] = EnumEntry('MAV_TYPE_ONBOARD_CONTROLLER', '''Onboard companion controller''')
MAV_TYPE_VTOL_DUOROTOR = 19 # Two-rotor VTOL using control surfaces in vertical operation in
                        # addition. Tailsitter.
enums['MAV_TYPE'][19] = EnumEntry('MAV_TYPE_VTOL_DUOROTOR', '''Two-rotor VTOL using control surfaces in vertical operation in addition. Tailsitter.''')
MAV_TYPE_VTOL_QUADROTOR = 20 # Quad-rotor VTOL using a V-shaped quad config in vertical operation.
                        # Tailsitter.
enums['MAV_TYPE'][20] = EnumEntry('MAV_TYPE_VTOL_QUADROTOR', '''Quad-rotor VTOL using a V-shaped quad config in vertical operation. Tailsitter.''')
MAV_TYPE_VTOL_TILTROTOR = 21 # Tiltrotor VTOL
enums['MAV_TYPE'][21] = EnumEntry('MAV_TYPE_VTOL_TILTROTOR', '''Tiltrotor VTOL''')
MAV_TYPE_VTOL_RESERVED2 = 22 # VTOL reserved 2
enums['MAV_TYPE'][22] = EnumEntry('MAV_TYPE_VTOL_RESERVED2', '''VTOL reserved 2''')
MAV_TYPE_VTOL_RESERVED3 = 23 # VTOL reserved 3
enums['MAV_TYPE'][23] = EnumEntry('MAV_TYPE_VTOL_RESERVED3', '''VTOL reserved 3''')
MAV_TYPE_VTOL_RESERVED4 = 24 # VTOL reserved 4
enums['MAV_TYPE'][24] = EnumEntry('MAV_TYPE_VTOL_RESERVED4', '''VTOL reserved 4''')
MAV_TYPE_VTOL_RESERVED5 = 25 # VTOL reserved 5
enums['MAV_TYPE'][25] = EnumEntry('MAV_TYPE_VTOL_RESERVED5', '''VTOL reserved 5''')
MAV_TYPE_GIMBAL = 26 # Gimbal
enums['MAV_TYPE'][26] = EnumEntry('MAV_TYPE_GIMBAL', '''Gimbal''')
MAV_TYPE_ADSB = 27 # ADSB system
enums['MAV_TYPE'][27] = EnumEntry('MAV_TYPE_ADSB', '''ADSB system''')
MAV_TYPE_PARAFOIL = 28 # Steerable, nonrigid airfoil
enums['MAV_TYPE'][28] = EnumEntry('MAV_TYPE_PARAFOIL', '''Steerable, nonrigid airfoil''')
MAV_TYPE_DODECAROTOR = 29 # Dodecarotor
enums['MAV_TYPE'][29] = EnumEntry('MAV_TYPE_DODECAROTOR', '''Dodecarotor''')
MAV_TYPE_CAMERA = 30 # Camera
enums['MAV_TYPE'][30] = EnumEntry('MAV_TYPE_CAMERA', '''Camera''')
MAV_TYPE_CHARGING_STATION = 31 # Charging station
enums['MAV_TYPE'][31] = EnumEntry('MAV_TYPE_CHARGING_STATION', '''Charging station''')
MAV_TYPE_FLARM = 32 # FLARM collision avoidance system
enums['MAV_TYPE'][32] = EnumEntry('MAV_TYPE_FLARM', '''FLARM collision avoidance system''')
MAV_TYPE_SERVO = 33 # Servo
enums['MAV_TYPE'][33] = EnumEntry('MAV_TYPE_SERVO', '''Servo''')
MAV_TYPE_ENUM_END = 34 # 
enums['MAV_TYPE'][34] = EnumEntry('MAV_TYPE_ENUM_END', '''''')

# MAV_MODE_FLAG
enums['MAV_MODE_FLAG'] = {}
MAV_MODE_FLAG_CUSTOM_MODE_ENABLED = 1 # 0b00000001 Reserved for future use.
enums['MAV_MODE_FLAG'][1] = EnumEntry('MAV_MODE_FLAG_CUSTOM_MODE_ENABLED', '''0b00000001 Reserved for future use.''')
MAV_MODE_FLAG_TEST_ENABLED = 2 # 0b00000010 system has a test mode enabled. This flag is intended for
                        # temporary system tests and should not be
                        # used for stable implementations.
enums['MAV_MODE_FLAG'][2] = EnumEntry('MAV_MODE_FLAG_TEST_ENABLED', '''0b00000010 system has a test mode enabled. This flag is intended for temporary system tests and should not be used for stable implementations.''')
MAV_MODE_FLAG_AUTO_ENABLED = 4 # 0b00000100 autonomous mode enabled, system finds its own goal
                        # positions. Guided flag can be set or not,
                        # depends on the actual implementation.
enums['MAV_MODE_FLAG'][4] = EnumEntry('MAV_MODE_FLAG_AUTO_ENABLED', '''0b00000100 autonomous mode enabled, system finds its own goal positions. Guided flag can be set or not, depends on the actual implementation.''')
MAV_MODE_FLAG_GUIDED_ENABLED = 8 # 0b00001000 guided mode enabled, system flies waypoints / mission
                        # items.
enums['MAV_MODE_FLAG'][8] = EnumEntry('MAV_MODE_FLAG_GUIDED_ENABLED', '''0b00001000 guided mode enabled, system flies waypoints / mission items.''')
MAV_MODE_FLAG_STABILIZE_ENABLED = 16 # 0b00010000 system stabilizes electronically its attitude (and
                        # optionally position). It needs however
                        # further control inputs to move around.
enums['MAV_MODE_FLAG'][16] = EnumEntry('MAV_MODE_FLAG_STABILIZE_ENABLED', '''0b00010000 system stabilizes electronically its attitude (and optionally position). It needs however further control inputs to move around.''')
MAV_MODE_FLAG_HIL_ENABLED = 32 # 0b00100000 hardware in the loop simulation. All motors / actuators are
                        # blocked, but internal software is full
                        # operational.
enums['MAV_MODE_FLAG'][32] = EnumEntry('MAV_MODE_FLAG_HIL_ENABLED', '''0b00100000 hardware in the loop simulation. All motors / actuators are blocked, but internal software is full operational.''')
MAV_MODE_FLAG_MANUAL_INPUT_ENABLED = 64 # 0b01000000 remote control input is enabled.
enums['MAV_MODE_FLAG'][64] = EnumEntry('MAV_MODE_FLAG_MANUAL_INPUT_ENABLED', '''0b01000000 remote control input is enabled.''')
MAV_MODE_FLAG_SAFETY_ARMED = 128 # 0b10000000 MAV safety set to armed. Motors are enabled / running / can
                        # start. Ready to fly. Additional note: this
                        # flag is to be ignore when sent in the
                        # command MAV_CMD_DO_SET_MODE and
                        # MAV_CMD_COMPONENT_ARM_DISARM shall be used
                        # instead. The flag can still be used to
                        # report the armed state.
enums['MAV_MODE_FLAG'][128] = EnumEntry('MAV_MODE_FLAG_SAFETY_ARMED', '''0b10000000 MAV safety set to armed. Motors are enabled / running / can start. Ready to fly. Additional note: this flag is to be ignore when sent in the command MAV_CMD_DO_SET_MODE and MAV_CMD_COMPONENT_ARM_DISARM shall be used instead. The flag can still be used to report the armed state.''')
MAV_MODE_FLAG_ENUM_END = 129 # 
enums['MAV_MODE_FLAG'][129] = EnumEntry('MAV_MODE_FLAG_ENUM_END', '''''')

# MAV_MODE_FLAG_DECODE_POSITION
enums['MAV_MODE_FLAG_DECODE_POSITION'] = {}
MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE = 1 # Eighth bit: 00000001
enums['MAV_MODE_FLAG_DECODE_POSITION'][1] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_CUSTOM_MODE', '''Eighth bit: 00000001''')
MAV_MODE_FLAG_DECODE_POSITION_TEST = 2 # Seventh bit: 00000010
enums['MAV_MODE_FLAG_DECODE_POSITION'][2] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_TEST', '''Seventh bit: 00000010''')
MAV_MODE_FLAG_DECODE_POSITION_AUTO = 4 # Sixth bit:   00000100
enums['MAV_MODE_FLAG_DECODE_POSITION'][4] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_AUTO', '''Sixth bit:   00000100''')
MAV_MODE_FLAG_DECODE_POSITION_GUIDED = 8 # Fifth bit:  00001000
enums['MAV_MODE_FLAG_DECODE_POSITION'][8] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_GUIDED', '''Fifth bit:  00001000''')
MAV_MODE_FLAG_DECODE_POSITION_STABILIZE = 16 # Fourth bit: 00010000
enums['MAV_MODE_FLAG_DECODE_POSITION'][16] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_STABILIZE', '''Fourth bit: 00010000''')
MAV_MODE_FLAG_DECODE_POSITION_HIL = 32 # Third bit:  00100000
enums['MAV_MODE_FLAG_DECODE_POSITION'][32] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_HIL', '''Third bit:  00100000''')
MAV_MODE_FLAG_DECODE_POSITION_MANUAL = 64 # Second bit: 01000000
enums['MAV_MODE_FLAG_DECODE_POSITION'][64] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_MANUAL', '''Second bit: 01000000''')
MAV_MODE_FLAG_DECODE_POSITION_SAFETY = 128 # First bit:  10000000
enums['MAV_MODE_FLAG_DECODE_POSITION'][128] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_SAFETY', '''First bit:  10000000''')
MAV_MODE_FLAG_DECODE_POSITION_ENUM_END = 129 # 
enums['MAV_MODE_FLAG_DECODE_POSITION'][129] = EnumEntry('MAV_MODE_FLAG_DECODE_POSITION_ENUM_END', '''''')

# MAV_STATE
enums['MAV_STATE'] = {}
MAV_STATE_UNINIT = 0 # Uninitialized system, state is unknown.
enums['MAV_STATE'][0] = EnumEntry('MAV_STATE_UNINIT', '''Uninitialized system, state is unknown.''')
MAV_STATE_BOOT = 1 # System is booting up.
enums['MAV_STATE'][1] = EnumEntry('MAV_STATE_BOOT', '''System is booting up.''')
MAV_STATE_CALIBRATING = 2 # System is calibrating and not flight-ready.
enums['MAV_STATE'][2] = EnumEntry('MAV_STATE_CALIBRATING', '''System is calibrating and not flight-ready.''')
MAV_STATE_STANDBY = 3 # System is grounded and on standby. It can be launched any time.
enums['MAV_STATE'][3] = EnumEntry('MAV_STATE_STANDBY', '''System is grounded and on standby. It can be launched any time.''')
MAV_STATE_ACTIVE = 4 # System is active and might be already airborne. Motors are engaged.
enums['MAV_STATE'][4] = EnumEntry('MAV_STATE_ACTIVE', '''System is active and might be already airborne. Motors are engaged.''')
MAV_STATE_CRITICAL = 5 # System is in a non-normal flight mode. It can however still navigate.
enums['MAV_STATE'][5] = EnumEntry('MAV_STATE_CRITICAL', '''System is in a non-normal flight mode. It can however still navigate.''')
MAV_STATE_EMERGENCY = 6 # System is in a non-normal flight mode. It lost control over parts or
                        # over the whole airframe. It is in mayday and
                        # going down.
enums['MAV_STATE'][6] = EnumEntry('MAV_STATE_EMERGENCY', '''System is in a non-normal flight mode. It lost control over parts or over the whole airframe. It is in mayday and going down.''')
MAV_STATE_POWEROFF = 7 # System just initialized its power-down sequence, will shut down now.
enums['MAV_STATE'][7] = EnumEntry('MAV_STATE_POWEROFF', '''System just initialized its power-down sequence, will shut down now.''')
MAV_STATE_FLIGHT_TERMINATION = 8 # System is terminating itself.
enums['MAV_STATE'][8] = EnumEntry('MAV_STATE_FLIGHT_TERMINATION', '''System is terminating itself.''')
MAV_STATE_ENUM_END = 9 # 
enums['MAV_STATE'][9] = EnumEntry('MAV_STATE_ENUM_END', '''''')

# MAV_COMPONENT
enums['MAV_COMPONENT'] = {}
MAV_COMP_ID_ALL = 0 # Used to broadcast messages to all components of the receiving system.
                        # Components should attempt to process
                        # messages with this component ID and forward
                        # to components on any other interfaces.
enums['MAV_COMPONENT'][0] = EnumEntry('MAV_COMP_ID_ALL', '''Used to broadcast messages to all components of the receiving system. Components should attempt to process messages with this component ID and forward to components on any other interfaces.''')
MAV_COMP_ID_AUTOPILOT1 = 1 # System flight controller component ("autopilot"). Only one autopilot
                        # is expected in a particular system.
enums['MAV_COMPONENT'][1] = EnumEntry('MAV_COMP_ID_AUTOPILOT1', '''System flight controller component ("autopilot"). Only one autopilot is expected in a particular system.''')
MAV_COMP_ID_USER1 = 25 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][25] = EnumEntry('MAV_COMP_ID_USER1', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER2 = 26 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][26] = EnumEntry('MAV_COMP_ID_USER2', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER3 = 27 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][27] = EnumEntry('MAV_COMP_ID_USER3', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER4 = 28 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][28] = EnumEntry('MAV_COMP_ID_USER4', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER5 = 29 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][29] = EnumEntry('MAV_COMP_ID_USER5', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER6 = 30 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][30] = EnumEntry('MAV_COMP_ID_USER6', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER7 = 31 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][31] = EnumEntry('MAV_COMP_ID_USER7', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER8 = 32 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][32] = EnumEntry('MAV_COMP_ID_USER8', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER9 = 33 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][33] = EnumEntry('MAV_COMP_ID_USER9', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER10 = 34 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][34] = EnumEntry('MAV_COMP_ID_USER10', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER11 = 35 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][35] = EnumEntry('MAV_COMP_ID_USER11', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER12 = 36 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][36] = EnumEntry('MAV_COMP_ID_USER12', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER13 = 37 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][37] = EnumEntry('MAV_COMP_ID_USER13', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER14 = 38 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][38] = EnumEntry('MAV_COMP_ID_USER14', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER15 = 39 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][39] = EnumEntry('MAV_COMP_ID_USER15', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USE16 = 40 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][40] = EnumEntry('MAV_COMP_ID_USE16', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER17 = 41 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][41] = EnumEntry('MAV_COMP_ID_USER17', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER18 = 42 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][42] = EnumEntry('MAV_COMP_ID_USER18', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER19 = 43 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][43] = EnumEntry('MAV_COMP_ID_USER19', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER20 = 44 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][44] = EnumEntry('MAV_COMP_ID_USER20', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER21 = 45 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][45] = EnumEntry('MAV_COMP_ID_USER21', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER22 = 46 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][46] = EnumEntry('MAV_COMP_ID_USER22', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER23 = 47 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][47] = EnumEntry('MAV_COMP_ID_USER23', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER24 = 48 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][48] = EnumEntry('MAV_COMP_ID_USER24', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER25 = 49 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][49] = EnumEntry('MAV_COMP_ID_USER25', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER26 = 50 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][50] = EnumEntry('MAV_COMP_ID_USER26', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER27 = 51 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][51] = EnumEntry('MAV_COMP_ID_USER27', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER28 = 52 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][52] = EnumEntry('MAV_COMP_ID_USER28', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER29 = 53 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][53] = EnumEntry('MAV_COMP_ID_USER29', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER30 = 54 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][54] = EnumEntry('MAV_COMP_ID_USER30', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER31 = 55 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][55] = EnumEntry('MAV_COMP_ID_USER31', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER32 = 56 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][56] = EnumEntry('MAV_COMP_ID_USER32', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER33 = 57 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][57] = EnumEntry('MAV_COMP_ID_USER33', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER34 = 58 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][58] = EnumEntry('MAV_COMP_ID_USER34', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER35 = 59 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][59] = EnumEntry('MAV_COMP_ID_USER35', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER36 = 60 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][60] = EnumEntry('MAV_COMP_ID_USER36', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER37 = 61 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][61] = EnumEntry('MAV_COMP_ID_USER37', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER38 = 62 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][62] = EnumEntry('MAV_COMP_ID_USER38', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER39 = 63 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][63] = EnumEntry('MAV_COMP_ID_USER39', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER40 = 64 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][64] = EnumEntry('MAV_COMP_ID_USER40', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER41 = 65 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][65] = EnumEntry('MAV_COMP_ID_USER41', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER42 = 66 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][66] = EnumEntry('MAV_COMP_ID_USER42', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER43 = 67 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][67] = EnumEntry('MAV_COMP_ID_USER43', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER44 = 68 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][68] = EnumEntry('MAV_COMP_ID_USER44', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER45 = 69 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][69] = EnumEntry('MAV_COMP_ID_USER45', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER46 = 70 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][70] = EnumEntry('MAV_COMP_ID_USER46', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER47 = 71 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][71] = EnumEntry('MAV_COMP_ID_USER47', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER48 = 72 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][72] = EnumEntry('MAV_COMP_ID_USER48', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER49 = 73 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][73] = EnumEntry('MAV_COMP_ID_USER49', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER50 = 74 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][74] = EnumEntry('MAV_COMP_ID_USER50', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER51 = 75 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][75] = EnumEntry('MAV_COMP_ID_USER51', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER52 = 76 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][76] = EnumEntry('MAV_COMP_ID_USER52', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER53 = 77 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][77] = EnumEntry('MAV_COMP_ID_USER53', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER54 = 78 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][78] = EnumEntry('MAV_COMP_ID_USER54', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER55 = 79 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][79] = EnumEntry('MAV_COMP_ID_USER55', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER56 = 80 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][80] = EnumEntry('MAV_COMP_ID_USER56', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER57 = 81 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][81] = EnumEntry('MAV_COMP_ID_USER57', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER58 = 82 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][82] = EnumEntry('MAV_COMP_ID_USER58', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER59 = 83 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][83] = EnumEntry('MAV_COMP_ID_USER59', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER60 = 84 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][84] = EnumEntry('MAV_COMP_ID_USER60', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER61 = 85 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][85] = EnumEntry('MAV_COMP_ID_USER61', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER62 = 86 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][86] = EnumEntry('MAV_COMP_ID_USER62', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER63 = 87 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][87] = EnumEntry('MAV_COMP_ID_USER63', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER64 = 88 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][88] = EnumEntry('MAV_COMP_ID_USER64', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER65 = 89 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][89] = EnumEntry('MAV_COMP_ID_USER65', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER66 = 90 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][90] = EnumEntry('MAV_COMP_ID_USER66', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER67 = 91 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][91] = EnumEntry('MAV_COMP_ID_USER67', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER68 = 92 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][92] = EnumEntry('MAV_COMP_ID_USER68', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER69 = 93 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][93] = EnumEntry('MAV_COMP_ID_USER69', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER70 = 94 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][94] = EnumEntry('MAV_COMP_ID_USER70', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER71 = 95 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][95] = EnumEntry('MAV_COMP_ID_USER71', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER72 = 96 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][96] = EnumEntry('MAV_COMP_ID_USER72', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER73 = 97 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][97] = EnumEntry('MAV_COMP_ID_USER73', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER74 = 98 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][98] = EnumEntry('MAV_COMP_ID_USER74', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_USER75 = 99 # Id for a component on privately managed MAVLink network. Can be used
                        # for any purpose but may not be published by
                        # components outside of the private network.
enums['MAV_COMPONENT'][99] = EnumEntry('MAV_COMP_ID_USER75', '''Id for a component on privately managed MAVLink network. Can be used for any purpose but may not be published by components outside of the private network.''')
MAV_COMP_ID_CAMERA = 100 # Camera #1.
enums['MAV_COMPONENT'][100] = EnumEntry('MAV_COMP_ID_CAMERA', '''Camera #1.''')
MAV_COMP_ID_CAMERA2 = 101 # Camera #2.
enums['MAV_COMPONENT'][101] = EnumEntry('MAV_COMP_ID_CAMERA2', '''Camera #2.''')
MAV_COMP_ID_CAMERA3 = 102 # Camera #3.
enums['MAV_COMPONENT'][102] = EnumEntry('MAV_COMP_ID_CAMERA3', '''Camera #3.''')
MAV_COMP_ID_CAMERA4 = 103 # Camera #4.
enums['MAV_COMPONENT'][103] = EnumEntry('MAV_COMP_ID_CAMERA4', '''Camera #4.''')
MAV_COMP_ID_CAMERA5 = 104 # Camera #5.
enums['MAV_COMPONENT'][104] = EnumEntry('MAV_COMP_ID_CAMERA5', '''Camera #5.''')
MAV_COMP_ID_CAMERA6 = 105 # Camera #6.
enums['MAV_COMPONENT'][105] = EnumEntry('MAV_COMP_ID_CAMERA6', '''Camera #6.''')
MAV_COMP_ID_SERVO1 = 140 # Servo #1.
enums['MAV_COMPONENT'][140] = EnumEntry('MAV_COMP_ID_SERVO1', '''Servo #1.''')
MAV_COMP_ID_SERVO2 = 141 # Servo #2.
enums['MAV_COMPONENT'][141] = EnumEntry('MAV_COMP_ID_SERVO2', '''Servo #2.''')
MAV_COMP_ID_SERVO3 = 142 # Servo #3.
enums['MAV_COMPONENT'][142] = EnumEntry('MAV_COMP_ID_SERVO3', '''Servo #3.''')
MAV_COMP_ID_SERVO4 = 143 # Servo #4.
enums['MAV_COMPONENT'][143] = EnumEntry('MAV_COMP_ID_SERVO4', '''Servo #4.''')
MAV_COMP_ID_SERVO5 = 144 # Servo #5.
enums['MAV_COMPONENT'][144] = EnumEntry('MAV_COMP_ID_SERVO5', '''Servo #5.''')
MAV_COMP_ID_SERVO6 = 145 # Servo #6.
enums['MAV_COMPONENT'][145] = EnumEntry('MAV_COMP_ID_SERVO6', '''Servo #6.''')
MAV_COMP_ID_SERVO7 = 146 # Servo #7.
enums['MAV_COMPONENT'][146] = EnumEntry('MAV_COMP_ID_SERVO7', '''Servo #7.''')
MAV_COMP_ID_SERVO8 = 147 # Servo #8.
enums['MAV_COMPONENT'][147] = EnumEntry('MAV_COMP_ID_SERVO8', '''Servo #8.''')
MAV_COMP_ID_SERVO9 = 148 # Servo #9.
enums['MAV_COMPONENT'][148] = EnumEntry('MAV_COMP_ID_SERVO9', '''Servo #9.''')
MAV_COMP_ID_SERVO10 = 149 # Servo #10.
enums['MAV_COMPONENT'][149] = EnumEntry('MAV_COMP_ID_SERVO10', '''Servo #10.''')
MAV_COMP_ID_SERVO11 = 150 # Servo #11.
enums['MAV_COMPONENT'][150] = EnumEntry('MAV_COMP_ID_SERVO11', '''Servo #11.''')
MAV_COMP_ID_SERVO12 = 151 # Servo #12.
enums['MAV_COMPONENT'][151] = EnumEntry('MAV_COMP_ID_SERVO12', '''Servo #12.''')
MAV_COMP_ID_SERVO13 = 152 # Servo #13.
enums['MAV_COMPONENT'][152] = EnumEntry('MAV_COMP_ID_SERVO13', '''Servo #13.''')
MAV_COMP_ID_SERVO14 = 153 # Servo #14.
enums['MAV_COMPONENT'][153] = EnumEntry('MAV_COMP_ID_SERVO14', '''Servo #14.''')
MAV_COMP_ID_GIMBAL = 154 # Gimbal component.
enums['MAV_COMPONENT'][154] = EnumEntry('MAV_COMP_ID_GIMBAL', '''Gimbal component.''')
MAV_COMP_ID_LOG = 155 # Logging component.
enums['MAV_COMPONENT'][155] = EnumEntry('MAV_COMP_ID_LOG', '''Logging component.''')
MAV_COMP_ID_ADSB = 156 # Automatic Dependent Surveillance-Broadcast (ADS-B) component.
enums['MAV_COMPONENT'][156] = EnumEntry('MAV_COMP_ID_ADSB', '''Automatic Dependent Surveillance-Broadcast (ADS-B) component.''')
MAV_COMP_ID_OSD = 157 # On Screen Display (OSD) devices for video links.
enums['MAV_COMPONENT'][157] = EnumEntry('MAV_COMP_ID_OSD', '''On Screen Display (OSD) devices for video links.''')
MAV_COMP_ID_PERIPHERAL = 158 # Generic autopilot peripheral component ID. Meant for devices that do
                        # not implement the parameter microservice.
enums['MAV_COMPONENT'][158] = EnumEntry('MAV_COMP_ID_PERIPHERAL', '''Generic autopilot peripheral component ID. Meant for devices that do not implement the parameter microservice.''')
MAV_COMP_ID_QX1_GIMBAL = 159 # Gimbal ID for QX1.
enums['MAV_COMPONENT'][159] = EnumEntry('MAV_COMP_ID_QX1_GIMBAL', '''Gimbal ID for QX1.''')
MAV_COMP_ID_FLARM = 160 # FLARM collision alert component.
enums['MAV_COMPONENT'][160] = EnumEntry('MAV_COMP_ID_FLARM', '''FLARM collision alert component.''')
MAV_COMP_ID_MISSIONPLANNER = 190 # Component that can generate/supply a mission flight plan (e.g. GCS or
                        # developer API).
enums['MAV_COMPONENT'][190] = EnumEntry('MAV_COMP_ID_MISSIONPLANNER', '''Component that can generate/supply a mission flight plan (e.g. GCS or developer API).''')
MAV_COMP_ID_PATHPLANNER = 195 # Component that finds an optimal path between points based on a certain
                        # constraint (e.g. minimum snap, shortest
                        # path, cost, etc.).
enums['MAV_COMPONENT'][195] = EnumEntry('MAV_COMP_ID_PATHPLANNER', '''Component that finds an optimal path between points based on a certain constraint (e.g. minimum snap, shortest path, cost, etc.).''')
MAV_COMP_ID_OBSTACLE_AVOIDANCE = 196 # Component that plans a collision free path between two points.
enums['MAV_COMPONENT'][196] = EnumEntry('MAV_COMP_ID_OBSTACLE_AVOIDANCE', '''Component that plans a collision free path between two points.''')
MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY = 197 # Component that provides position estimates using VIO techniques.
enums['MAV_COMPONENT'][197] = EnumEntry('MAV_COMP_ID_VISUAL_INERTIAL_ODOMETRY', '''Component that provides position estimates using VIO techniques.''')
MAV_COMP_ID_IMU = 200 # Inertial Measurement Unit (IMU) #1.
enums['MAV_COMPONENT'][200] = EnumEntry('MAV_COMP_ID_IMU', '''Inertial Measurement Unit (IMU) #1.''')
MAV_COMP_ID_IMU_2 = 201 # Inertial Measurement Unit (IMU) #2.
enums['MAV_COMPONENT'][201] = EnumEntry('MAV_COMP_ID_IMU_2', '''Inertial Measurement Unit (IMU) #2.''')
MAV_COMP_ID_IMU_3 = 202 # Inertial Measurement Unit (IMU) #3.
enums['MAV_COMPONENT'][202] = EnumEntry('MAV_COMP_ID_IMU_3', '''Inertial Measurement Unit (IMU) #3.''')
MAV_COMP_ID_GPS = 220 # GPS #1.
enums['MAV_COMPONENT'][220] = EnumEntry('MAV_COMP_ID_GPS', '''GPS #1.''')
MAV_COMP_ID_GPS2 = 221 # GPS #2.
enums['MAV_COMPONENT'][221] = EnumEntry('MAV_COMP_ID_GPS2', '''GPS #2.''')
MAV_COMP_ID_UDP_BRIDGE = 240 # Component to bridge MAVLink to UDP (i.e. from a UART).
enums['MAV_COMPONENT'][240] = EnumEntry('MAV_COMP_ID_UDP_BRIDGE', '''Component to bridge MAVLink to UDP (i.e. from a UART).''')
MAV_COMP_ID_UART_BRIDGE = 241 # Component to bridge to UART (i.e. from UDP).
enums['MAV_COMPONENT'][241] = EnumEntry('MAV_COMP_ID_UART_BRIDGE', '''Component to bridge to UART (i.e. from UDP).''')
MAV_COMP_ID_SYSTEM_CONTROL = 250 # Component for handling system messages (e.g. to ARM, takeoff, etc.).
enums['MAV_COMPONENT'][250] = EnumEntry('MAV_COMP_ID_SYSTEM_CONTROL', '''Component for handling system messages (e.g. to ARM, takeoff, etc.).''')
MAV_COMPONENT_ENUM_END = 251 # 
enums['MAV_COMPONENT'][251] = EnumEntry('MAV_COMPONENT_ENUM_END', '''''')

# MAV_CMD
enums['MAV_CMD'] = {}
MAV_CMD_REQUEST_PROTOCOL_VERSION = 519 # Request MAVLink protocol version compatibility
enums['MAV_CMD'][519] = EnumEntry('MAV_CMD_REQUEST_PROTOCOL_VERSION', '''Request MAVLink protocol version compatibility''')
enums['MAV_CMD'][519].param[1] = '''1: Request supported protocol versions by all nodes on the network'''
enums['MAV_CMD'][519].param[2] = '''Reserved (all remaining params)'''
enums['MAV_CMD'][519].param[3] = '''Reserved (default:0)'''
enums['MAV_CMD'][519].param[4] = '''Reserved (default:0)'''
enums['MAV_CMD'][519].param[5] = '''Reserved (default:0)'''
enums['MAV_CMD'][519].param[6] = '''Reserved (default:0)'''
enums['MAV_CMD'][519].param[7] = '''Reserved (default:0)'''
MAV_CMD_ENUM_END = 520 # 
enums['MAV_CMD'][520] = EnumEntry('MAV_CMD_ENUM_END', '''''')

# message IDs
MAVLINK_MSG_ID_BAD_DATA = -1
MAVLINK_MSG_ID_HEARTBEAT = 0

class MAVLink_heartbeat_message(MAVLink_message):
        '''
        The heartbeat message shows that a system or component is
        present and responding. The type and autopilot fields (along
        with the message component id), allow the receiving system to
        treat further messages from this system appropriately (e.g. by
        laying out the user interface based on the autopilot). This
        microservice is documented at
        https://mavlink.io/en/services/heartbeat.html
        '''
        id = MAVLINK_MSG_ID_HEARTBEAT
        name = 'HEARTBEAT'
        fieldnames = ['type', 'autopilot', 'base_mode', 'custom_mode', 'system_status', 'mavlink_version']
        ordered_fieldnames = ['custom_mode', 'type', 'autopilot', 'base_mode', 'system_status', 'mavlink_version']
        fieldtypes = ['uint8_t', 'uint8_t', 'uint8_t', 'uint32_t', 'uint8_t', 'uint8_t']
        fielddisplays_by_name = {"base_mode": "bitmask"}
        fieldenums_by_name = {"type": "MAV_TYPE", "autopilot": "MAV_AUTOPILOT", "base_mode": "MAV_MODE_FLAG", "system_status": "MAV_STATE"}
        fieldunits_by_name = {}
        format = '<IBBBBB'
        native_format = bytearray('<IBBBBB', 'ascii')
        orders = [1, 2, 3, 0, 4, 5]
        lengths = [1, 1, 1, 1, 1, 1]
        array_lengths = [0, 0, 0, 0, 0, 0]
        crc_extra = 50
        unpacker = struct.Struct('<IBBBBB')

        def __init__(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version):
                MAVLink_message.__init__(self, MAVLink_heartbeat_message.id, MAVLink_heartbeat_message.name)
                self._fieldnames = MAVLink_heartbeat_message.fieldnames
                self.type = type
                self.autopilot = autopilot
                self.base_mode = base_mode
                self.custom_mode = custom_mode
                self.system_status = system_status
                self.mavlink_version = mavlink_version

        def pack(self, mav, force_mavlink1=False):
                return MAVLink_message.pack(self, mav, 50, struct.pack('<IBBBBB', self.custom_mode, self.type, self.autopilot, self.base_mode, self.system_status, self.mavlink_version), force_mavlink1=force_mavlink1)


mavlink_map = {
        MAVLINK_MSG_ID_HEARTBEAT : MAVLink_heartbeat_message,
}

class MAVError(Exception):
        '''MAVLink error class'''
        def __init__(self, msg):
            Exception.__init__(self, msg)
            self.message = msg

class MAVString(str):
        '''NUL terminated string'''
        def __init__(self, s):
                str.__init__(self)
        def __str__(self):
            i = self.find(chr(0))
            if i == -1:
                return self[:]
            return self[0:i]

class MAVLink_bad_data(MAVLink_message):
        '''
        a piece of bad data in a mavlink stream
        '''
        def __init__(self, data, reason):
                MAVLink_message.__init__(self, MAVLINK_MSG_ID_BAD_DATA, 'BAD_DATA')
                self._fieldnames = ['data', 'reason']
                self.data = data
                self.reason = reason
                self._msgbuf = data

        def __str__(self):
            '''Override the __str__ function from MAVLink_messages because non-printable characters are common in to be the reason for this message to exist.'''
            return '%s {%s, data:%s}' % (self._type, self.reason, [('%x' % ord(i) if isinstance(i, str) else '%x' % i) for i in self.data])

class MAVLinkSigning(object):
    '''MAVLink signing state class'''
    def __init__(self):
        self.secret_key = None
        self.timestamp = 0
        self.link_id = 0
        self.sign_outgoing = False
        self.allow_unsigned_callback = None
        self.stream_timestamps = {}
        self.sig_count = 0
        self.badsig_count = 0
        self.goodsig_count = 0
        self.unsigned_count = 0
        self.reject_count = 0

class MAVLink(object):
        '''MAVLink protocol handling class'''
        def __init__(self, file, srcSystem=0, srcComponent=0, use_native=False):
                self.seq = 0
                self.file = file
                self.srcSystem = srcSystem
                self.srcComponent = srcComponent
                self.callback = None
                self.callback_args = None
                self.callback_kwargs = None
                self.send_callback = None
                self.send_callback_args = None
                self.send_callback_kwargs = None
                self.buf = bytearray()
                self.buf_index = 0
                self.expected_length = HEADER_LEN_V1+2
                self.have_prefix_error = False
                self.robust_parsing = False
                self.protocol_marker = 254
                self.little_endian = True
                self.crc_extra = True
                self.sort_fields = True
                self.total_packets_sent = 0
                self.total_bytes_sent = 0
                self.total_packets_received = 0
                self.total_bytes_received = 0
                self.total_receive_errors = 0
                self.startup_time = time.time()
                self.signing = MAVLinkSigning()
                if native_supported and (use_native or native_testing or native_force):
                    print("NOTE: mavnative is currently beta-test code")
                    self.native = mavnative.NativeConnection(MAVLink_message, mavlink_map)
                else:
                    self.native = None
                if native_testing:
                    self.test_buf = bytearray()
                self.mav20_unpacker = struct.Struct('<cBBBBBBHB')
                self.mav10_unpacker = struct.Struct('<cBBBBB')
                self.mav20_h3_unpacker = struct.Struct('BBB')
                self.mav_csum_unpacker = struct.Struct('<H')
                self.mav_sign_unpacker = struct.Struct('<IH')

        def set_callback(self, callback, *args, **kwargs):
            self.callback = callback
            self.callback_args = args
            self.callback_kwargs = kwargs

        def set_send_callback(self, callback, *args, **kwargs):
            self.send_callback = callback
            self.send_callback_args = args
            self.send_callback_kwargs = kwargs

        def send(self, mavmsg, force_mavlink1=False):
                '''send a MAVLink message'''
                buf = mavmsg.pack(self, force_mavlink1=force_mavlink1)
                self.file.write(buf)
                self.seq = (self.seq + 1) % 256
                self.total_packets_sent += 1
                self.total_bytes_sent += len(buf)
                if self.send_callback:
                    self.send_callback(mavmsg, *self.send_callback_args, **self.send_callback_kwargs)

        def buf_len(self):
            return len(self.buf) - self.buf_index

        def bytes_needed(self):
            '''return number of bytes needed for next parsing stage'''
            if self.native:
                ret = self.native.expected_length - self.buf_len()
            else:
                ret = self.expected_length - self.buf_len()

            if ret <= 0:
                return 1
            return ret

        def __parse_char_native(self, c):
            '''this method exists only to see in profiling results'''
            m = self.native.parse_chars(c)
            return m

        def __callbacks(self, msg):
            '''this method exists only to make profiling results easier to read'''
            if self.callback:
                self.callback(msg, *self.callback_args, **self.callback_kwargs)

        def parse_char(self, c):
            '''input some data bytes, possibly returning a new message'''
            self.buf.extend(c)

            self.total_bytes_received += len(c)

            if self.native:
                if native_testing:
                    self.test_buf.extend(c)
                    m = self.__parse_char_native(self.test_buf)
                    m2 = self.__parse_char_legacy()
                    if m2 != m:
                        print("Native: %s\nLegacy: %s\n" % (m, m2))
                        raise Exception('Native vs. Legacy mismatch')
                else:
                    m = self.__parse_char_native(self.buf)
            else:
                m = self.__parse_char_legacy()

            if m is not None:
                self.total_packets_received += 1
                self.__callbacks(m)
            else:
                # XXX The idea here is if we've read something and there's nothing left in
                # the buffer, reset it to 0 which frees the memory
                if self.buf_len() == 0 and self.buf_index != 0:
                    self.buf = bytearray()
                    self.buf_index = 0

            return m

        def __parse_char_legacy(self):
            '''input some data bytes, possibly returning a new message (uses no native code)'''
            header_len = HEADER_LEN_V1
            if self.buf_len() >= 1 and self.buf[self.buf_index] == PROTOCOL_MARKER_V2:
                header_len = HEADER_LEN_V2

            if self.buf_len() >= 1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V1 and self.buf[self.buf_index] != PROTOCOL_MARKER_V2:
                magic = self.buf[self.buf_index]
                self.buf_index += 1
                if self.robust_parsing:
                    m = MAVLink_bad_data(bytearray([magic]), 'Bad prefix')
                    self.expected_length = header_len+2
                    self.total_receive_errors += 1
                    return m
                if self.have_prefix_error:
                    return None
                self.have_prefix_error = True
                self.total_receive_errors += 1
                raise MAVError("invalid MAVLink prefix '%s'" % magic)
            self.have_prefix_error = False
            if self.buf_len() >= 3:
                sbuf = self.buf[self.buf_index:3+self.buf_index]
                if sys.version_info.major < 3:
                    sbuf = str(sbuf)
                (magic, self.expected_length, incompat_flags) = self.mav20_h3_unpacker.unpack(sbuf)
                if magic == PROTOCOL_MARKER_V2 and (incompat_flags & MAVLINK_IFLAG_SIGNED):
                        self.expected_length += MAVLINK_SIGNATURE_BLOCK_LEN
                self.expected_length += header_len + 2
            if self.expected_length >= (header_len+2) and self.buf_len() >= self.expected_length:
                mbuf = array.array('B', self.buf[self.buf_index:self.buf_index+self.expected_length])
                self.buf_index += self.expected_length
                self.expected_length = header_len+2
                if self.robust_parsing:
                    try:
                        if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                            raise MAVError('invalid incompat_flags 0x%x 0x%x %u' % (incompat_flags, magic, self.expected_length))
                        m = self.decode(mbuf)
                    except MAVError as reason:
                        m = MAVLink_bad_data(mbuf, reason.message)
                        self.total_receive_errors += 1
                else:
                    if magic == PROTOCOL_MARKER_V2 and (incompat_flags & ~MAVLINK_IFLAG_SIGNED) != 0:
                        raise MAVError('invalid incompat_flags 0x%x 0x%x %u' % (incompat_flags, magic, self.expected_length))
                    m = self.decode(mbuf)
                return m
            return None

        def parse_buffer(self, s):
            '''input some data bytes, possibly returning a list of new messages'''
            m = self.parse_char(s)
            if m is None:
                return None
            ret = [m]
            while True:
                m = self.parse_char("")
                if m is None:
                    return ret
                ret.append(m)
            return ret

        def check_signature(self, msgbuf, srcSystem, srcComponent):
            '''check signature on incoming message'''
            if isinstance(msgbuf, array.array):
                msgbuf = msgbuf.tostring()
            timestamp_buf = msgbuf[-12:-6]
            link_id = msgbuf[-13]
            (tlow, thigh) = self.mav_sign_unpacker.unpack(timestamp_buf)
            timestamp = tlow + (thigh<<32)

            # see if the timestamp is acceptable
            stream_key = (link_id,srcSystem,srcComponent)
            if stream_key in self.signing.stream_timestamps:
                if timestamp <= self.signing.stream_timestamps[stream_key]:
                    # reject old timestamp
                    # print('old timestamp')
                    return False
            else:
                # a new stream has appeared. Accept the timestamp if it is at most
                # one minute behind our current timestamp
                if timestamp + 6000*1000 < self.signing.timestamp:
                    # print('bad new stream ', timestamp/(100.0*1000*60*60*24*365), self.signing.timestamp/(100.0*1000*60*60*24*365))
                    return False
                self.signing.stream_timestamps[stream_key] = timestamp
                # print('new stream')

            h = hashlib.new('sha256')
            h.update(self.signing.secret_key)
            h.update(msgbuf[:-6])
            if str(type(msgbuf)) == "<class 'bytes'>":
                # Python 3
                sig1 = h.digest()[:6]
                sig2 = msgbuf[-6:]
            else:
                sig1 = str(h.digest())[:6]
                sig2 = str(msgbuf)[-6:]
            if sig1 != sig2:
                # print('sig mismatch')
                return False

            # the timestamp we next send with is the max of the received timestamp and
            # our current timestamp
            self.signing.timestamp = max(self.signing.timestamp, timestamp)
            return True

        def decode(self, msgbuf):
                '''decode a buffer as a MAVLink message'''
                # decode the header
                if msgbuf[0] != PROTOCOL_MARKER_V1:
                    headerlen = 10
                    try:
                        magic, mlen, incompat_flags, compat_flags, seq, srcSystem, srcComponent, msgIdlow, msgIdhigh = self.mav20_unpacker.unpack(msgbuf[:headerlen])
                    except struct.error as emsg:
                        raise MAVError('Unable to unpack MAVLink header: %s' % emsg)
                    msgId = msgIdlow | (msgIdhigh<<16)
                    mapkey = msgId
                else:
                    headerlen = 6
                    try:
                        magic, mlen, seq, srcSystem, srcComponent, msgId = self.mav10_unpacker.unpack(msgbuf[:headerlen])
                        incompat_flags = 0
                        compat_flags = 0
                    except struct.error as emsg:
                        raise MAVError('Unable to unpack MAVLink header: %s' % emsg)
                    mapkey = msgId
                if (incompat_flags & MAVLINK_IFLAG_SIGNED) != 0:
                    signature_len = MAVLINK_SIGNATURE_BLOCK_LEN
                else:
                    signature_len = 0

                if ord(magic) != PROTOCOL_MARKER_V1 and ord(magic) != PROTOCOL_MARKER_V2:
                    raise MAVError("invalid MAVLink prefix '%s'" % magic)
                if mlen != len(msgbuf)-(headerlen+2+signature_len):
                    raise MAVError('invalid MAVLink message length. Got %u expected %u, msgId=%u headerlen=%u' % (len(msgbuf)-(headerlen+2+signature_len), mlen, msgId, headerlen))

                if not mapkey in mavlink_map:
                    raise MAVError('unknown MAVLink message ID %s' % str(mapkey))

                # decode the payload
                type = mavlink_map[mapkey]
                fmt = type.format
                order_map = type.orders
                len_map = type.lengths
                crc_extra = type.crc_extra

                # decode the checksum
                try:
                    crc, = self.mav_csum_unpacker.unpack(msgbuf[-(2+signature_len):][:2])
                except struct.error as emsg:
                    raise MAVError('Unable to unpack MAVLink CRC: %s' % emsg)
                crcbuf = msgbuf[1:-(2+signature_len)]
                if True: # using CRC extra
                    crcbuf.append(crc_extra)
                crc2 = x25crc(crcbuf)
                if crc != crc2.crc:
                    raise MAVError('invalid MAVLink CRC in msgID %u 0x%04x should be 0x%04x' % (msgId, crc, crc2.crc))

                sig_ok = False
                if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
                    self.signing.sig_count += 1
                if self.signing.secret_key is not None:
                    accept_signature = False
                    if signature_len == MAVLINK_SIGNATURE_BLOCK_LEN:
                        sig_ok = self.check_signature(msgbuf, srcSystem, srcComponent)
                        accept_signature = sig_ok
                        if sig_ok:
                            self.signing.goodsig_count += 1
                        else:
                            self.signing.badsig_count += 1
                        if not accept_signature and self.signing.allow_unsigned_callback is not None:
                            accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                            if accept_signature:
                                self.signing.unsigned_count += 1
                            else:
                                self.signing.reject_count += 1
                    elif self.signing.allow_unsigned_callback is not None:
                        accept_signature = self.signing.allow_unsigned_callback(self, msgId)
                        if accept_signature:
                            self.signing.unsigned_count += 1
                        else:
                            self.signing.reject_count += 1
                    if not accept_signature:
                        raise MAVError('Invalid signature')

                csize = type.unpacker.size
                mbuf = msgbuf[headerlen:-(2+signature_len)]
                if len(mbuf) < csize:
                    # zero pad to give right size
                    mbuf.extend([0]*(csize - len(mbuf)))
                if len(mbuf) < csize:
                    raise MAVError('Bad message of type %s length %u needs %s' % (
                        type, len(mbuf), csize))
                mbuf = mbuf[:csize]
                try:
                    t = type.unpacker.unpack(mbuf)
                except struct.error as emsg:
                    raise MAVError('Unable to unpack MAVLink payload type=%s fmt=%s payloadLength=%u: %s' % (
                        type, fmt, len(mbuf), emsg))

                tlist = list(t)
                # handle sorted fields
                if True:
                    t = tlist[:]
                    if sum(len_map) == len(len_map):
                        # message has no arrays in it
                        for i in range(0, len(tlist)):
                            tlist[i] = t[order_map[i]]
                    else:
                        # message has some arrays
                        tlist = []
                        for i in range(0, len(order_map)):
                            order = order_map[i]
                            L = len_map[order]
                            tip = sum(len_map[:order])
                            field = t[tip]
                            if L == 1 or isinstance(field, str):
                                tlist.append(field)
                            else:
                                tlist.append(t[tip:(tip + L)])

                # terminate any strings
                for i in range(0, len(tlist)):
                    if type.fieldtypes[i] == 'char':
                        if sys.version_info.major >= 3:
                            tlist[i] = tlist[i].decode('utf-8')
                        tlist[i] = str(MAVString(tlist[i]))
                t = tuple(tlist)
                # construct the message object
                try:
                    m = type(*t)
                except Exception as emsg:
                    raise MAVError('Unable to instantiate MAVLink message of type %s : %s' % (type, emsg))
                m._signed = sig_ok
                if m._signed:
                    m._link_id = msgbuf[-13]
                m._msgbuf = msgbuf
                m._payload = msgbuf[6:-(2+signature_len)]
                m._crc = crc
                m._header = MAVLink_header(msgId, incompat_flags, compat_flags, mlen, seq, srcSystem, srcComponent)
                return m
        def heartbeat_encode(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version=3):
                '''
                The heartbeat message shows that a system or component is present and
                responding. The type and autopilot fields (along with
                the message component id), allow the receiving system
                to treat further messages from this system
                appropriately (e.g. by laying out the user interface
                based on the autopilot). This microservice is
                documented at
                https://mavlink.io/en/services/heartbeat.html

                type                      : Type of the system (quadrotor, helicopter, etc.). Components use the same type as their associated system. (type:uint8_t, values:MAV_TYPE)
                autopilot                 : Autopilot type / class. (type:uint8_t, values:MAV_AUTOPILOT)
                base_mode                 : System mode bitmap. (type:uint8_t, values:MAV_MODE_FLAG)
                custom_mode               : A bitfield for use for autopilot-specific flags (type:uint32_t)
                system_status             : System status flag. (type:uint8_t, values:MAV_STATE)
                mavlink_version           : MAVLink version, not writable by user, gets added by protocol because of magic data type: uint8_t_mavlink_version (type:uint8_t)

                '''
                return MAVLink_heartbeat_message(type, autopilot, base_mode, custom_mode, system_status, mavlink_version)

        def heartbeat_send(self, type, autopilot, base_mode, custom_mode, system_status, mavlink_version=3, force_mavlink1=False):
                '''
                The heartbeat message shows that a system or component is present and
                responding. The type and autopilot fields (along with
                the message component id), allow the receiving system
                to treat further messages from this system
                appropriately (e.g. by laying out the user interface
                based on the autopilot). This microservice is
                documented at
                https://mavlink.io/en/services/heartbeat.html

                type                      : Type of the system (quadrotor, helicopter, etc.). Components use the same type as their associated system. (type:uint8_t, values:MAV_TYPE)
                autopilot                 : Autopilot type / class. (type:uint8_t, values:MAV_AUTOPILOT)
                base_mode                 : System mode bitmap. (type:uint8_t, values:MAV_MODE_FLAG)
                custom_mode               : A bitfield for use for autopilot-specific flags (type:uint32_t)
                system_status             : System status flag. (type:uint8_t, values:MAV_STATE)
                mavlink_version           : MAVLink version, not writable by user, gets added by protocol because of magic data type: uint8_t_mavlink_version (type:uint8_t)

                '''
                return self.send(self.heartbeat_encode(type, autopilot, base_mode, custom_mode, system_status, mavlink_version), force_mavlink1=force_mavlink1)

