"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UisNode = exports.UisNodeProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const uis_generated_1 = require("./uis.generated");
Object.defineProperty(exports, "UisNodeProperty", { enumerable: true, get: function () { return uis_generated_1.RosUisNode; } });
/**
 * A ROS resource type:  `ALIYUN::UIS::UisNode`
 */
class UisNode extends ros.Resource {
    /**
     * Create a new `ALIYUN::UIS::UisNode`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosUisNode = new uis_generated_1.RosUisNode(this, id, {
            description: props.description,
            uisId: props.uisId,
            ipAddrsNum: props.ipAddrsNum === undefined || props.ipAddrsNum === null ? 2 : props.ipAddrsNum,
            uisNodeBandwidth: props.uisNodeBandwidth === undefined || props.uisNodeBandwidth === null ? 20 : props.uisNodeBandwidth,
            uisNodeAreaId: props.uisNodeAreaId,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUisNode;
        this.attrUisNodeActiveIps = rosUisNode.attrUisNodeActiveIps;
        this.attrUisNodeId = rosUisNode.attrUisNodeId;
        this.attrUisNodeIps = rosUisNode.attrUisNodeIps;
    }
}
exports.UisNode = UisNode;
//# sourceMappingURL=data:application/json;base64,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