"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UisConnection = exports.UisConnectionProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const uis_generated_1 = require("./uis.generated");
Object.defineProperty(exports, "UisConnectionProperty", { enumerable: true, get: function () { return uis_generated_1.RosUisConnection; } });
/**
 * A ROS resource type:  `ALIYUN::UIS::UisConnection`
 */
class UisConnection extends ros.Resource {
    /**
     * Create a new `ALIYUN::UIS::UisConnection`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosUisConnection = new uis_generated_1.RosUisConnection(this, id, {
            sslConfig: props.sslConfig,
            description: props.description,
            greConfig: props.greConfig,
            uisProtocol: props.uisProtocol === undefined || props.uisProtocol === null ? 'SSLVPN' : props.uisProtocol,
            uisNodeId: props.uisNodeId,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosUisConnection;
        this.attrUisConnectionId = rosUisConnection.attrUisConnectionId;
    }
}
exports.UisConnection = UisConnection;
//# sourceMappingURL=data:application/json;base64,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