# autogenerated module
from typing import ClassVar

from ..core import resource as res
from ..models import apps_v1beta1 as m_apps_v1beta1
from ..models import meta_v1 as m_meta_v1


class ControllerRevision(res.NamespacedResourceG, m_apps_v1beta1.ControllerRevision):
    """* **Extends**: ``models.apps_v1beta1.ControllerRevision``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('apps', 'v1beta1', 'ControllerRevision'),
        plural='controllerrevisions',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )


class DeploymentRollback(res.NamespacedSubResource, m_meta_v1.Status):
    """* **Extends**: ``models.meta_v1.Status``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `create`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('apps', 'v1beta1', 'DeploymentRollback'),
        parent=res.ResourceDef('apps', 'v1beta1', 'Deployment'),
        plural='deployments',
        verbs=['post'],
        action='rollback',
    )


class DeploymentScale(res.NamespacedSubResource, m_apps_v1beta1.Scale):
    """* **Extends**: ``models.apps_v1beta1.Scale``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('apps', 'v1beta1', 'Scale'),
        parent=res.ResourceDef('apps', 'v1beta1', 'Deployment'),
        plural='deployments',
        verbs=['get', 'patch', 'put'],
        action='scale',
    )


class DeploymentStatus(res.NamespacedSubResource, m_apps_v1beta1.Deployment):
    """* **Extends**: ``models.apps_v1beta1.Deployment``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('apps', 'v1beta1', 'Deployment'),
        parent=res.ResourceDef('apps', 'v1beta1', 'Deployment'),
        plural='deployments',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class Deployment(res.NamespacedResourceG, m_apps_v1beta1.Deployment):
    """* **Extends**: ``models.apps_v1beta1.Deployment``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Rollback**: ``DeploymentRollback``
       * **Scale**: ``DeploymentScale``
       * **Status**: ``DeploymentStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('apps', 'v1beta1', 'Deployment'),
        plural='deployments',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Rollback: ClassVar = DeploymentRollback
    Scale: ClassVar = DeploymentScale
    Status: ClassVar = DeploymentStatus


class StatefulSetScale(res.NamespacedSubResource, m_apps_v1beta1.Scale):
    """* **Extends**: ``models.apps_v1beta1.Scale``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('apps', 'v1beta1', 'Scale'),
        parent=res.ResourceDef('apps', 'v1beta1', 'StatefulSet'),
        plural='statefulsets',
        verbs=['get', 'patch', 'put'],
        action='scale',
    )


class StatefulSetStatus(res.NamespacedSubResource, m_apps_v1beta1.StatefulSet):
    """* **Extends**: ``models.apps_v1beta1.StatefulSet``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `get`, `patch`, `replace`
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('apps', 'v1beta1', 'StatefulSet'),
        parent=res.ResourceDef('apps', 'v1beta1', 'StatefulSet'),
        plural='statefulsets',
        verbs=['get', 'patch', 'put'],
        action='status',
    )


class StatefulSet(res.NamespacedResourceG, m_apps_v1beta1.StatefulSet):
    """* **Extends**: ``models.apps_v1beta1.StatefulSet``
       * **Type**: Namespaced Resource
       * **Accepted client methods**: `delete`, `deletecollection`, `get`, `list` all, `watch` all, `list`, `patch`, `create`, `replace`, `watch`

       **Subresources**:

       * **Scale**: ``StatefulSetScale``
       * **Status**: ``StatefulSetStatus``
    """
    _api_info = res.ApiInfo(
        resource=res.ResourceDef('apps', 'v1beta1', 'StatefulSet'),
        plural='statefulsets',
        verbs=['delete', 'deletecollection', 'get', 'global_list', 'global_watch', 'list', 'patch', 'post', 'put', 'watch'],
    )

    Scale: ClassVar = StatefulSetScale
    Status: ClassVar = StatefulSetStatus

