# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import runtime
from datetime import datetime
from typing import Dict


@dataclass
class APIGroup(DataclassDictMixIn):
    """APIGroup contains the name, the supported versions, and the preferred version
      of a group.

      **parameters**

      * **name** ``str`` - name is the name of the group.
      * **versions** ``List[GroupVersionForDiscovery]`` - versions are the versions supported in this group.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **preferredVersion** ``GroupVersionForDiscovery`` - *(optional)* preferredVersion is the version preferred by the API server, which probably is
        the storage version.
      * **serverAddressByClientCIDRs** ``List[ServerAddressByClientCIDR]`` - *(optional)* a map of client CIDR to server address that is serving this group. This is to
        help clients reach servers in the most network-efficient way possible. Clients
        can use the appropriate server address as per the CIDR that they match. In
        case of multiple matches, clients should use the longest matching CIDR. The
        server returns only those CIDRs that it thinks that the client can match. For
        example: the master will return an internal IP CIDR only, if the client
        reaches the server using an internal IP. Server looks at X-Forwarded-For
        header or X-Real-Ip header or request.RemoteAddr (in that order) to get the
        client IP.
    """
    name: 'str'
    versions: 'List[GroupVersionForDiscovery]'
    apiVersion: 'str' = None
    kind: 'str' = None
    preferredVersion: 'GroupVersionForDiscovery' = None
    serverAddressByClientCIDRs: 'List[ServerAddressByClientCIDR]' = None


@dataclass
class APIGroupList(DataclassDictMixIn):
    """APIGroupList is a list of APIGroup, to allow clients to discover the API at
      /apis.

      **parameters**

      * **groups** ``List[APIGroup]`` - groups is a list of APIGroup.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    groups: 'List[APIGroup]'
    apiVersion: 'str' = None
    kind: 'str' = None


@dataclass
class APIResource(DataclassDictMixIn):
    """APIResource specifies the name of a resource and whether it is namespaced.

      **parameters**

      * **kind** ``str`` - kind is the kind for the resource (e.g. 'Foo' is the kind for a resource
        'foo')
      * **name** ``str`` - name is the plural name of the resource.
      * **namespaced** ``bool`` - namespaced indicates if a resource is namespaced or not.
      * **singularName** ``str`` - singularName is the singular name of the resource.  This allows clients to
        handle plural and singular opaquely. The singularName is more correct for
        reporting status on a single item and both singular and plural are allowed
        from the kubectl CLI interface.
      * **verbs** ``List[str]`` - verbs is a list of supported kube verbs (this includes get, list, watch,
        create, update, patch, delete, deletecollection, and proxy)
      * **categories** ``List[str]`` - *(optional)* categories is a list of the grouped resources this resource belongs to (e.g.
        'all')
      * **group** ``str`` - *(optional)* group is the preferred group of the resource.  Empty implies the group of the
        containing resource list. For subresources, this may have a different value,
        for example: Scale".
      * **shortNames** ``List[str]`` - *(optional)* shortNames is a list of suggested short names of the resource.
      * **storageVersionHash** ``str`` - *(optional)* The hash value of the storage version, the version this resource is converted
        to when written to the data store. Value must be treated as opaque by clients.
        Only equality comparison on the value is valid. This is an alpha feature and
        may change or be removed in the future. The field is populated by the
        apiserver only if the StorageVersionHash feature gate is enabled. This field
        will remain optional even if it graduates.
      * **version** ``str`` - *(optional)* version is the preferred version of the resource.  Empty implies the version
        of the containing resource list For subresources, this may have a different
        value, for example: v1 (while inside a v1beta1 version of the core resource's
        group)".
    """
    kind: 'str'
    name: 'str'
    namespaced: 'bool'
    singularName: 'str'
    verbs: 'List[str]'
    categories: 'List[str]' = None
    group: 'str' = None
    shortNames: 'List[str]' = None
    storageVersionHash: 'str' = None
    version: 'str' = None


@dataclass
class APIResourceList(DataclassDictMixIn):
    """APIResourceList is a list of APIResource, it is used to expose the name of the
      resources supported in a specific group and version, and if the resource is
      namespaced.

      **parameters**

      * **groupVersion** ``str`` - groupVersion is the group and version this APIResourceList is for.
      * **resources** ``List[APIResource]`` - resources contains the name of the resources and if they are namespaced.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    groupVersion: 'str'
    resources: 'List[APIResource]'
    apiVersion: 'str' = None
    kind: 'str' = None


@dataclass
class APIVersions(DataclassDictMixIn):
    """APIVersions lists the versions that are available, to allow clients to
      discover the API at /api, which is the root path of the legacy v1 API.

      **parameters**

      * **serverAddressByClientCIDRs** ``List[ServerAddressByClientCIDR]`` - a map of client CIDR to server address that is serving this group. This is to
        help clients reach servers in the most network-efficient way possible. Clients
        can use the appropriate server address as per the CIDR that they match. In
        case of multiple matches, clients should use the longest matching CIDR. The
        server returns only those CIDRs that it thinks that the client can match. For
        example: the master will return an internal IP CIDR only, if the client
        reaches the server using an internal IP. Server looks at X-Forwarded-For
        header or X-Real-Ip header or request.RemoteAddr (in that order) to get the
        client IP.
      * **versions** ``List[str]`` - versions are the api versions that are available.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    serverAddressByClientCIDRs: 'List[ServerAddressByClientCIDR]'
    versions: 'List[str]'
    apiVersion: 'str' = None
    kind: 'str' = None


@dataclass
class DeleteOptions(DataclassDictMixIn):
    """DeleteOptions may be provided when deleting an API object.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **dryRun** ``List[str]`` - *(optional)* When present, indicates that modifications should not be persisted. An invalid
        or unrecognized dryRun directive will result in an error response and no
        further processing of the request. Valid values are: - All: all dry run stages
        will be processed
      * **gracePeriodSeconds** ``int`` - *(optional)* The duration in seconds before the object should be deleted. Value must be
        non-negative integer. The value zero indicates delete immediately. If this
        value is nil, the default grace period for the specified type will be used.
        Defaults to a per object value if not specified. zero means delete
        immediately.
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **orphanDependents** ``bool`` - *(optional)* Deprecated: please use the PropagationPolicy, this field will be deprecated in
        1.7. Should the dependent objects be orphaned. If true/false, the "orphan"
        finalizer will be added to/removed from the object's finalizers list. Either
        this field or PropagationPolicy may be set, but not both.
      * **preconditions** ``Preconditions`` - *(optional)* Must be fulfilled before a deletion is carried out. If not possible, a 409
        Conflict status will be returned.
      * **propagationPolicy** ``str`` - *(optional)* Whether and how garbage collection will be performed. Either this field or
        OrphanDependents may be set, but not both. The default policy is decided by
        the existing finalizer set in the metadata.finalizers and the
        resource-specific default policy. Acceptable values are: 'Orphan' - orphan the
        dependents; 'Background' - allow the garbage collector to delete the
        dependents in the background; 'Foreground' - a cascading policy that deletes
        all dependents in the foreground.
    """
    apiVersion: 'str' = None
    dryRun: 'List[str]' = None
    gracePeriodSeconds: 'int' = None
    kind: 'str' = None
    orphanDependents: 'bool' = None
    preconditions: 'Preconditions' = None
    propagationPolicy: 'str' = None


FieldsV1 = Dict


@dataclass
class GroupVersionForDiscovery(DataclassDictMixIn):
    """GroupVersion contains the "group/version" and "version" string of a version.
      It is made a struct to keep extensibility.

      **parameters**

      * **groupVersion** ``str`` - groupVersion specifies the API group and version in the form "group/version"
      * **version** ``str`` - version specifies the version in the form of "version". This is to save the
        clients the trouble of splitting the GroupVersion.
    """
    groupVersion: 'str'
    version: 'str'


@dataclass
class LabelSelector(DataclassDictMixIn):
    """A label selector is a label query over a set of resources. The result of
      matchLabels and matchExpressions are ANDed. An empty label selector matches
      all objects. A null label selector matches no objects.

      **parameters**

      * **matchExpressions** ``List[LabelSelectorRequirement]`` - *(optional)* matchExpressions is a list of label selector requirements. The requirements
        are ANDed.
      * **matchLabels** ``dict`` - *(optional)* matchLabels is a map of {key,value} pairs. A single {key,value} in the
        matchLabels map is equivalent to an element of matchExpressions, whose key
        field is "key", the operator is "In", and the values array contains only
        "value". The requirements are ANDed.
    """
    matchExpressions: 'List[LabelSelectorRequirement]' = None
    matchLabels: 'dict' = None


@dataclass
class LabelSelectorRequirement(DataclassDictMixIn):
    """A label selector requirement is a selector that contains values, a key, and an
      operator that relates the key and values.

      **parameters**

      * **key** ``str`` - key is the label key that the selector applies to.
      * **operator** ``str`` - operator represents a key's relationship to a set of values. Valid operators
        are In, NotIn, Exists and DoesNotExist.
      * **values** ``List[str]`` - *(optional)* values is an array of string values. If the operator is In or NotIn, the
        values array must be non-empty. If the operator is Exists or DoesNotExist, the
        values array must be empty. This array is replaced during a strategic merge
        patch.
    """
    key: 'str'
    operator: 'str'
    values: 'List[str]' = None


@dataclass
class ListMeta(DataclassDictMixIn):
    """ListMeta describes metadata that synthetic resources must have, including
      lists and various status objects. A resource may have only one of {ObjectMeta,
      ListMeta}.

      **parameters**

      * **continue_** ``str`` - *(optional)* continue may be set if the user set a limit on the number of items returned,
        and indicates that the server has more data available. The value is opaque and
        may be used to issue another request to the endpoint that served this list to
        retrieve the next set of available objects. Continuing a consistent list may
        not be possible if the server configuration has changed or more than a few
        minutes have passed. The resourceVersion field returned when using this
        continue value will be identical to the value in the first response, unless
        you have received this token from an error message.
      * **remainingItemCount** ``int`` - *(optional)* remainingItemCount is the number of subsequent items in the list which are not
        included in this list response. If the list request contained label or field
        selectors, then the number of remaining items is unknown and the field will be
        left unset and omitted during serialization. If the list is complete (either
        because it is not chunking or because this is the last chunk), then there are
        no more remaining items and this field will be left unset and omitted during
        serialization. Servers older than v1.15 do not set this field. The intended
        use of the remainingItemCount is *estimating* the size of a collection.
        Clients should not rely on the remainingItemCount to be set or to be exact.
      * **resourceVersion** ``str`` - *(optional)* String that identifies the server's internal version of this object that can
        be used by clients to determine when objects have changed. Value must be
        treated as opaque by clients and passed unmodified back to the server.
        Populated by the system. Read-only. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
      * **selfLink** ``str`` - *(optional)* selfLink is a URL representing this object. Populated by the system.
        Read-only.
        DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the
        field is planned to be removed in 1.21 release.
    """
    continue_: 'str' = field(metadata={"json": "continue"}, default=None)
    remainingItemCount: 'int' = None
    resourceVersion: 'str' = None
    selfLink: 'str' = None


@dataclass
class ManagedFieldsEntry(DataclassDictMixIn):
    """ManagedFieldsEntry is a workflow-id, a FieldSet and the group version of the
      resource that the fieldset applies to.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the version of this resource that this field set applies
        to. The format is "group/version" just like the top-level APIVersion field. It
        is necessary to track the version of a field set because it cannot be
        automatically converted.
      * **fieldsType** ``str`` - *(optional)* FieldsType is the discriminator for the different fields format and version.
        There is currently only one possible value: "FieldsV1"
      * **fieldsV1** ``FieldsV1`` - *(optional)* FieldsV1 holds the first JSON version format as described in the "FieldsV1"
        type.
      * **manager** ``str`` - *(optional)* Manager is an identifier of the workflow managing these fields.
      * **operation** ``str`` - *(optional)* Operation is the type of operation which lead to this ManagedFieldsEntry being
        created. The only valid values for this field are 'Apply' and 'Update'.
      * **time** ``Time`` - *(optional)* Time is timestamp of when these fields were set. It should always be empty if
        Operation is 'Apply'
    """
    apiVersion: 'str' = None
    fieldsType: 'str' = None
    fieldsV1: 'FieldsV1' = None
    manager: 'str' = None
    operation: 'str' = None
    time: 'Time' = None


MicroTime = datetime


@dataclass
class ObjectMeta(DataclassDictMixIn):
    """ObjectMeta is metadata that all persisted resources must have, which includes
      all objects users must create.

      **parameters**

      * **annotations** ``dict`` - *(optional)* Annotations is an unstructured key value map stored with a resource that may
        be set by external tools to store and retrieve arbitrary metadata. They are
        not queryable and should be preserved when modifying objects. More info:
        http://kubernetes.io/docs/user-guide/annotations
      * **clusterName** ``str`` - *(optional)* The name of the cluster which the object belongs to. This is used to
        distinguish resources with same name and namespace in different clusters. This
        field is not set anywhere right now and apiserver is going to ignore it if set
        in create or update request.
      * **creationTimestamp** ``Time`` - *(optional)* CreationTimestamp is a timestamp representing the server time when this object
        was created. It is not guaranteed to be set in happens-before order across
        separate operations. Clients may not set this value. It is represented in
        RFC3339 form and is in UTC.
        Populated by the system. Read-only. Null for lists. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **deletionGracePeriodSeconds** ``int`` - *(optional)* Number of seconds allowed for this object to gracefully terminate before it
        will be removed from the system. Only set when deletionTimestamp is also set.
        May only be shortened. Read-only.
      * **deletionTimestamp** ``Time`` - *(optional)* DeletionTimestamp is RFC 3339 date and time at which this resource will be
        deleted. This field is set by the server when a graceful deletion is requested
        by the user, and is not directly settable by a client. The resource is
        expected to be deleted (no longer visible from resource lists, and not
        reachable by name) after the time in this field, once the finalizers list is
        empty. As long as the finalizers list contains items, deletion is blocked.
        Once the deletionTimestamp is set, this value may not be unset or be set
        further into the future, although it may be shortened or the resource may be
        deleted prior to this time. For example, a user may request that a pod is
        deleted in 30 seconds. The Kubelet will react by sending a graceful
        termination signal to the containers in the pod. After that 30 seconds, the
        Kubelet will send a hard termination signal (SIGKILL) to the container and
        after cleanup, remove the pod from the API. In the presence of network
        partitions, this object may still exist after this timestamp, until an
        administrator or automated process can determine the resource is fully
        terminated. If not set, graceful deletion of the object has not been
        requested.
        Populated by the system when a graceful deletion is requested. Read-only. More
        info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **finalizers** ``List[str]`` - *(optional)* Must be empty before the object is deleted from the registry. Each entry is an
        identifier for the responsible component that will remove the entry from the
        list. If the deletionTimestamp of the object is non-nil, entries in this list
        can only be removed. Finalizers may be processed and removed in any order.
        Order is NOT enforced because it introduces significant risk of stuck
        finalizers. finalizers is a shared field, any actor with permission can
        reorder it. If the finalizer list is processed in order, then this can lead to
        a situation in which the component responsible for the first finalizer in the
        list is waiting for a signal (field value, external system, or other) produced
        by a component responsible for a finalizer later in the list, resulting in a
        deadlock. Without enforced ordering finalizers are free to order amongst
        themselves and are not vulnerable to ordering changes in the list.
      * **generateName** ``str`` - *(optional)* GenerateName is an optional prefix, used by the server, to generate a unique
        name ONLY IF the Name field has not been provided. If this field is used, the
        name returned to the client will be different than the name passed. This value
        will also be combined with a unique suffix. The provided value has the same
        validation rules as the Name field, and may be truncated by the length of the
        suffix required to make the value unique on the server.
        If this field is specified and the generated name exists, the server will NOT
        return a 409 - instead, it will either return 201 Created or 500 with Reason
        ServerTimeout indicating a unique name could not be found in the time
        allotted, and the client should retry (optionally after the time indicated in
        the Retry-After header).
        Applied only if Name is not specified. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#idempotency
      * **generation** ``int`` - *(optional)* A sequence number representing a specific generation of the desired state.
        Populated by the system. Read-only.
      * **labels** ``dict`` - *(optional)* Map of string keys and values that can be used to organize and categorize
        (scope and select) objects. May match selectors of replication controllers and
        services. More info: http://kubernetes.io/docs/user-guide/labels
      * **managedFields** ``List[ManagedFieldsEntry]`` - *(optional)* ManagedFields maps workflow-id and version to the set of fields that are
        managed by that workflow. This is mostly for internal housekeeping, and users
        typically shouldn't need to set or understand this field. A workflow can be
        the user's name, a controller's name, or the name of a specific apply path
        like "ci-cd". The set of fields is always in the version that the workflow
        used when modifying the object.
      * **name** ``str`` - *(optional)* Name must be unique within a namespace. Is required when creating resources,
        although some resources may allow a client to request the generation of an
        appropriate name automatically. Name is primarily intended for creation
        idempotence and configuration definition. Cannot be updated. More info:
        http://kubernetes.io/docs/user-guide/identifiers#names
      * **namespace** ``str`` - *(optional)* Namespace defines the space within each name must be unique. An empty
        namespace is equivalent to the "default" namespace, but "default" is the
        canonical representation. Not all objects are required to be scoped to a
        namespace - the value of this field for those objects will be empty.
        Must be a DNS_LABEL. Cannot be updated. More info:
        http://kubernetes.io/docs/user-guide/namespaces
      * **ownerReferences** ``List[OwnerReference]`` - *(optional)* List of objects depended by this object. If ALL objects in the list have been
        deleted, this object will be garbage collected. If this object is managed by a
        controller, then an entry in this list will point to this controller, with the
        controller field set to true. There cannot be more than one managing
        controller.
      * **resourceVersion** ``str`` - *(optional)* An opaque value that represents the internal version of this object that can
        be used by clients to determine when objects have changed. May be used for
        optimistic concurrency, change detection, and the watch operation on a
        resource or set of resources. Clients must treat these values as opaque and
        passed unmodified back to the server. They may only be valid for a particular
        resource or set of resources.
        Populated by the system. Read-only. Value must be treated as opaque by clients
        and . More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
      * **selfLink** ``str`` - *(optional)* SelfLink is a URL representing this object. Populated by the system.
        Read-only.
        DEPRECATED Kubernetes will stop propagating this field in 1.20 release and the
        field is planned to be removed in 1.21 release.
      * **uid** ``str`` - *(optional)* UID is the unique in time and space value for this object. It is typically
        generated by the server on successful creation of a resource and is not
        allowed to change on PUT operations.
        Populated by the system. Read-only. More info:
        http://kubernetes.io/docs/user-guide/identifiers#uids
    """
    annotations: 'dict' = None
    clusterName: 'str' = None
    creationTimestamp: 'Time' = None
    deletionGracePeriodSeconds: 'int' = None
    deletionTimestamp: 'Time' = None
    finalizers: 'List[str]' = None
    generateName: 'str' = None
    generation: 'int' = None
    labels: 'dict' = None
    managedFields: 'List[ManagedFieldsEntry]' = None
    name: 'str' = None
    namespace: 'str' = None
    ownerReferences: 'List[OwnerReference]' = None
    resourceVersion: 'str' = None
    selfLink: 'str' = None
    uid: 'str' = None


@dataclass
class OwnerReference(DataclassDictMixIn):
    """OwnerReference contains enough information to let you identify an owning
      object. An owning object must be in the same namespace as the dependent, or be
      cluster-scoped, so there is no namespace field.

      **parameters**

      * **apiVersion** ``str`` - API version of the referent.
      * **kind** ``str`` - Kind of the referent. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **name** ``str`` - Name of the referent. More info:
        http://kubernetes.io/docs/user-guide/identifiers#names
      * **uid** ``str`` - UID of the referent. More info:
        http://kubernetes.io/docs/user-guide/identifiers#uids
      * **blockOwnerDeletion** ``bool`` - *(optional)* If true, AND if the owner has the "foregroundDeletion" finalizer, then the
        owner cannot be deleted from the key-value store until this reference is
        removed. Defaults to false. To set this field, a user needs "delete"
        permission of the owner, otherwise 422 (Unprocessable Entity) will be
        returned.
      * **controller** ``bool`` - *(optional)* If true, this reference points to the managing controller.
    """
    apiVersion: 'str'
    kind: 'str'
    name: 'str'
    uid: 'str'
    blockOwnerDeletion: 'bool' = None
    controller: 'bool' = None


Patch = Dict


@dataclass
class Preconditions(DataclassDictMixIn):
    """Preconditions must be fulfilled before an operation (update, delete, etc.) is
      carried out.

      **parameters**

      * **resourceVersion** ``str`` - *(optional)* Specifies the target ResourceVersion
      * **uid** ``str`` - *(optional)* Specifies the target UID.
    """
    resourceVersion: 'str' = None
    uid: 'str' = None


@dataclass
class ServerAddressByClientCIDR(DataclassDictMixIn):
    """ServerAddressByClientCIDR helps the client to determine the server address
      that they should use, depending on the clientCIDR that they match.

      **parameters**

      * **clientCIDR** ``str`` - The CIDR with which clients can match their IP to figure out the server
        address that they should use.
      * **serverAddress** ``str`` - Address of this server, suitable for a client that matches the above CIDR.
        This can be a hostname, hostname:port, IP or IP:port.
    """
    clientCIDR: 'str'
    serverAddress: 'str'


@dataclass
class Status(DataclassDictMixIn):
    """Status is a return value for calls that don't return other objects.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **code** ``int`` - *(optional)* Suggested HTTP return code for this status, 0 if not set.
      * **details** ``StatusDetails`` - *(optional)* Extended data associated with the reason.  Each reason may define its own
        extended details. This field is optional and the data returned is not
        guaranteed to conform to any schema except that defined by the reason type.
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **message** ``str`` - *(optional)* A human-readable description of the status of this operation.
      * **metadata** ``ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **reason** ``str`` - *(optional)* A machine-readable description of why this operation is in the "Failure"
        status. If this value is empty there is no information available. A Reason
        clarifies an HTTP status code but does not override it.
      * **status** ``str`` - *(optional)* Status of the operation. One of: "Success" or "Failure". More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    code: 'int' = None
    details: 'StatusDetails' = None
    kind: 'str' = None
    message: 'str' = None
    metadata: 'ListMeta' = None
    reason: 'str' = None
    status: 'str' = None


@dataclass
class StatusCause(DataclassDictMixIn):
    """StatusCause provides more information about an api.Status failure, including
      cases when multiple errors are encountered.

      **parameters**

      * **field** ``str`` - *(optional)* The field of the resource that has caused this error, as named by its JSON
        serialization. May include dot and postfix notation for nested attributes.
        Arrays are zero-indexed.  Fields may appear more than once in an array of
        causes due to fields having multiple errors. Optional.
        Examples:
          "name" - the field "name" on the current resource
          "items[0].name" - the field "name" on the first array entry in "items"
      * **message** ``str`` - *(optional)* A human-readable description of the cause of the error.  This field may be
        presented as-is to a reader.
      * **reason** ``str`` - *(optional)* A machine-readable description of the cause of the error. If this value is
        empty there is no information available.
    """
    field: 'str' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class StatusDetails(DataclassDictMixIn):
    """StatusDetails is a set of additional properties that MAY be set by the server
      to provide additional information about a response. The Reason field of a
      Status object defines what attributes will be set. Clients must ignore fields
      that do not match the defined type of each attribute, and should assume that
      any attribute may be empty, invalid, or under defined.

      **parameters**

      * **causes** ``List[StatusCause]`` - *(optional)* The Causes array includes more details associated with the StatusReason
        failure. Not all StatusReasons may provide detailed causes.
      * **group** ``str`` - *(optional)* The group attribute of the resource associated with the status StatusReason.
      * **kind** ``str`` - *(optional)* The kind attribute of the resource associated with the status StatusReason. On
        some operations may differ from the requested resource Kind. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **name** ``str`` - *(optional)* The name attribute of the resource associated with the status StatusReason
        (when there is a single name which can be described).
      * **retryAfterSeconds** ``int`` - *(optional)* If specified, the time in seconds before the operation should be retried. Some
        errors may indicate the client must take an alternate action - for those
        errors this field may indicate how long to wait before taking the alternate
        action.
      * **uid** ``str`` - *(optional)* UID of the resource. (when there is a single resource which can be described).
        More info: http://kubernetes.io/docs/user-guide/identifiers#uids
    """
    causes: 'List[StatusCause]' = None
    group: 'str' = None
    kind: 'str' = None
    name: 'str' = None
    retryAfterSeconds: 'int' = None
    uid: 'str' = None


Time = datetime


@dataclass
class WatchEvent(DataclassDictMixIn):
    """Event represents a single event to a watched resource.

      **parameters**

      * **object** ``runtime.RawExtension`` - Object is:
         * If Type is Added or Modified: the new state of the object.
         * If Type is Deleted: the state of the object immediately before deletion.
         * If Type is Error: *Status is recommended; other types may make sense
           depending on context.
      * **type** ``str`` - 
    """
    object: 'runtime.RawExtension'
    type: 'str'


