# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1
from . import util_intstr
from . import resource


@dataclass
class AWSElasticBlockStoreVolumeSource(DataclassDictMixIn):
    """Represents a Persistent Disk resource in AWS.
      
      An AWS EBS disk must exist before mounting to a container. The disk must also
      be in the same AWS zone as the kubelet. An AWS EBS disk can only be mounted as
      read/write once. AWS EBS volumes support ownership management and SELinux
      relabeling.

      **parameters**

      * **volumeID** ``str`` - Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More
        info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
      * **fsType** ``str`` - *(optional)* Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
      * **partition** ``int`` - *(optional)* The partition in the volume that you want to mount. If omitted, the default is
        to mount by volume name. Examples: For volume /dev/sda1, you specify the
        partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you
        can leave the property empty).
      * **readOnly** ``bool`` - *(optional)* Specify "true" to force and set the ReadOnly property in VolumeMounts to
        "true". If omitted, the default is "false". More info:
        https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
    """
    volumeID: 'str'
    fsType: 'str' = None
    partition: 'int' = None
    readOnly: 'bool' = None


@dataclass
class Affinity(DataclassDictMixIn):
    """Affinity is a group of affinity scheduling rules.

      **parameters**

      * **nodeAffinity** ``NodeAffinity`` - *(optional)* Describes node affinity scheduling rules for the pod.
      * **podAffinity** ``PodAffinity`` - *(optional)* Describes pod affinity scheduling rules (e.g. co-locate this pod in the same
        node, zone, etc. as some other pod(s)).
      * **podAntiAffinity** ``PodAntiAffinity`` - *(optional)* Describes pod anti-affinity scheduling rules (e.g. avoid putting this pod in
        the same node, zone, etc. as some other pod(s)).
    """
    nodeAffinity: 'NodeAffinity' = None
    podAffinity: 'PodAffinity' = None
    podAntiAffinity: 'PodAntiAffinity' = None


@dataclass
class AttachedVolume(DataclassDictMixIn):
    """AttachedVolume describes a volume attached to a node

      **parameters**

      * **devicePath** ``str`` - DevicePath represents the device path where the volume should be available
      * **name** ``str`` - Name of the attached volume
    """
    devicePath: 'str'
    name: 'str'


@dataclass
class AzureDiskVolumeSource(DataclassDictMixIn):
    """AzureDisk represents an Azure Data Disk mount on the host and bind mount to
      the pod.

      **parameters**

      * **diskName** ``str`` - The Name of the data disk in the blob storage
      * **diskURI** ``str`` - The URI the data disk in the blob storage
      * **cachingMode** ``str`` - *(optional)* Host Caching mode: None, Read Only, Read Write.
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **kind** ``str`` - *(optional)* Expected values Shared: multiple blob disks per storage account  Dedicated:
        single blob disk per storage account  Managed: azure managed data disk (only
        in managed availability set). defaults to shared
      * **readOnly** ``bool`` - *(optional)* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
    """
    diskName: 'str'
    diskURI: 'str'
    cachingMode: 'str' = None
    fsType: 'str' = None
    kind: 'str' = None
    readOnly: 'bool' = None


@dataclass
class AzureFilePersistentVolumeSource(DataclassDictMixIn):
    """AzureFile represents an Azure File Service mount on the host and bind mount to
      the pod.

      **parameters**

      * **secretName** ``str`` - the name of secret that contains Azure Storage Account Name and Key
      * **shareName** ``str`` - Share Name
      * **readOnly** ``bool`` - *(optional)* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **secretNamespace** ``str`` - *(optional)* the namespace of the secret that contains Azure Storage Account Name and Key
        default is the same as the Pod
    """
    secretName: 'str'
    shareName: 'str'
    readOnly: 'bool' = None
    secretNamespace: 'str' = None


@dataclass
class AzureFileVolumeSource(DataclassDictMixIn):
    """AzureFile represents an Azure File Service mount on the host and bind mount to
      the pod.

      **parameters**

      * **secretName** ``str`` - the name of secret that contains Azure Storage Account Name and Key
      * **shareName** ``str`` - Share Name
      * **readOnly** ``bool`` - *(optional)* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
    """
    secretName: 'str'
    shareName: 'str'
    readOnly: 'bool' = None


@dataclass
class Binding(DataclassDictMixIn):
    """Binding ties one object to another; for example, a pod is bound to a node by a
      scheduler. Deprecated in 1.7, please use the bindings subresource of pods
      instead.

      **parameters**

      * **target** ``ObjectReference`` - The target object that you want to bind to the standard object.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    target: 'ObjectReference'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None


@dataclass
class CSIPersistentVolumeSource(DataclassDictMixIn):
    """Represents storage that is managed by an external CSI volume driver (Beta
      feature)

      **parameters**

      * **driver** ``str`` - Driver is the name of the driver to use for this volume. Required.
      * **volumeHandle** ``str`` - VolumeHandle is the unique volume name returned by the CSI volume plugin’s
        CreateVolume to refer to the volume on all subsequent calls. Required.
      * **controllerExpandSecretRef** ``SecretReference`` - *(optional)* ControllerExpandSecretRef is a reference to the secret object containing
        sensitive information to pass to the CSI driver to complete the CSI
        ControllerExpandVolume call. This is an alpha field and requires enabling
        ExpandCSIVolumes feature gate. This field is optional, and may be empty if no
        secret is required. If the secret object contains more than one secret, all
        secrets are passed.
      * **controllerPublishSecretRef** ``SecretReference`` - *(optional)* ControllerPublishSecretRef is a reference to the secret object containing
        sensitive information to pass to the CSI driver to complete the CSI
        ControllerPublishVolume and ControllerUnpublishVolume calls. This field is
        optional, and may be empty if no secret is required. If the secret object
        contains more than one secret, all secrets are passed.
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs".
      * **nodePublishSecretRef** ``SecretReference`` - *(optional)* NodePublishSecretRef is a reference to the secret object containing sensitive
        information to pass to the CSI driver to complete the CSI NodePublishVolume
        and NodeUnpublishVolume calls. This field is optional, and may be empty if no
        secret is required. If the secret object contains more than one secret, all
        secrets are passed.
      * **nodeStageSecretRef** ``SecretReference`` - *(optional)* NodeStageSecretRef is a reference to the secret object containing sensitive
        information to pass to the CSI driver to complete the CSI NodeStageVolume and
        NodeStageVolume and NodeUnstageVolume calls. This field is optional, and may
        be empty if no secret is required. If the secret object contains more than one
        secret, all secrets are passed.
      * **readOnly** ``bool`` - *(optional)* Optional: The value to pass to ControllerPublishVolumeRequest. Defaults to
        false (read/write).
      * **volumeAttributes** ``dict`` - *(optional)* Attributes of the volume to publish.
    """
    driver: 'str'
    volumeHandle: 'str'
    controllerExpandSecretRef: 'SecretReference' = None
    controllerPublishSecretRef: 'SecretReference' = None
    fsType: 'str' = None
    nodePublishSecretRef: 'SecretReference' = None
    nodeStageSecretRef: 'SecretReference' = None
    readOnly: 'bool' = None
    volumeAttributes: 'dict' = None


@dataclass
class CSIVolumeSource(DataclassDictMixIn):
    """Represents a source location of a volume to mount, managed by an external CSI
      driver

      **parameters**

      * **driver** ``str`` - Driver is the name of the CSI driver that handles this volume. Consult with
        your admin for the correct name as registered in the cluster.
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the
        empty value is passed to the associated CSI driver which will determine the
        default filesystem to apply.
      * **nodePublishSecretRef** ``LocalObjectReference`` - *(optional)* NodePublishSecretRef is a reference to the secret object containing sensitive
        information to pass to the CSI driver to complete the CSI NodePublishVolume
        and NodeUnpublishVolume calls. This field is optional, and  may be empty if no
        secret is required. If the secret object contains more than one secret, all
        secret references are passed.
      * **readOnly** ``bool`` - *(optional)* Specifies a read-only configuration for the volume. Defaults to false
        (read/write).
      * **volumeAttributes** ``dict`` - *(optional)* VolumeAttributes stores driver-specific properties that are passed to the CSI
        driver. Consult your driver's documentation for supported values.
    """
    driver: 'str'
    fsType: 'str' = None
    nodePublishSecretRef: 'LocalObjectReference' = None
    readOnly: 'bool' = None
    volumeAttributes: 'dict' = None


@dataclass
class Capabilities(DataclassDictMixIn):
    """Adds and removes POSIX capabilities from running containers.

      **parameters**

      * **add** ``List[str]`` - *(optional)* Added capabilities
      * **drop** ``List[str]`` - *(optional)* Removed capabilities
    """
    add: 'List[str]' = None
    drop: 'List[str]' = None


@dataclass
class CephFSPersistentVolumeSource(DataclassDictMixIn):
    """Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs
      volumes do not support ownership management or SELinux relabeling.

      **parameters**

      * **monitors** ``List[str]`` - Required: Monitors is a collection of Ceph monitors More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **path** ``str`` - *(optional)* Optional: Used as the mounted root, rather than the full Ceph tree, default is
        /
      * **readOnly** ``bool`` - *(optional)* Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts. More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **secretFile** ``str`` - *(optional)* Optional: SecretFile is the path to key ring for User, default is
        /etc/ceph/user.secret More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **secretRef** ``SecretReference`` - *(optional)* Optional: SecretRef is reference to the authentication secret for User,
        default is empty. More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **user** ``str`` - *(optional)* Optional: User is the rados user name, default is admin More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    monitors: 'List[str]'
    path: 'str' = None
    readOnly: 'bool' = None
    secretFile: 'str' = None
    secretRef: 'SecretReference' = None
    user: 'str' = None


@dataclass
class CephFSVolumeSource(DataclassDictMixIn):
    """Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs
      volumes do not support ownership management or SELinux relabeling.

      **parameters**

      * **monitors** ``List[str]`` - Required: Monitors is a collection of Ceph monitors More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **path** ``str`` - *(optional)* Optional: Used as the mounted root, rather than the full Ceph tree, default is
        /
      * **readOnly** ``bool`` - *(optional)* Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts. More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **secretFile** ``str`` - *(optional)* Optional: SecretFile is the path to key ring for User, default is
        /etc/ceph/user.secret More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **secretRef** ``LocalObjectReference`` - *(optional)* Optional: SecretRef is reference to the authentication secret for User,
        default is empty. More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
      * **user** ``str`` - *(optional)* Optional: User is the rados user name, default is admin More info:
        https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
    """
    monitors: 'List[str]'
    path: 'str' = None
    readOnly: 'bool' = None
    secretFile: 'str' = None
    secretRef: 'LocalObjectReference' = None
    user: 'str' = None


@dataclass
class CinderPersistentVolumeSource(DataclassDictMixIn):
    """Represents a cinder volume resource in Openstack. A Cinder volume must exist
      before mounting to a container. The volume must also be in the same region as
      the kubelet. Cinder volumes support ownership management and SELinux
      relabeling.

      **parameters**

      * **volumeID** ``str`` - volume id used to identify the volume in cinder. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be
        "ext4" if unspecified. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **readOnly** ``bool`` - *(optional)* Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **secretRef** ``SecretReference`` - *(optional)* Optional: points to a secret object containing parameters used to connect to
        OpenStack.
    """
    volumeID: 'str'
    fsType: 'str' = None
    readOnly: 'bool' = None
    secretRef: 'SecretReference' = None


@dataclass
class CinderVolumeSource(DataclassDictMixIn):
    """Represents a cinder volume resource in Openstack. A Cinder volume must exist
      before mounting to a container. The volume must also be in the same region as
      the kubelet. Cinder volumes support ownership management and SELinux
      relabeling.

      **parameters**

      * **volumeID** ``str`` - volume id used to identify the volume in cinder. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be
        "ext4" if unspecified. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **readOnly** ``bool`` - *(optional)* Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts. More info:
        https://examples.k8s.io/mysql-cinder-pd/README.md
      * **secretRef** ``LocalObjectReference`` - *(optional)* Optional: points to a secret object containing parameters used to connect to
        OpenStack.
    """
    volumeID: 'str'
    fsType: 'str' = None
    readOnly: 'bool' = None
    secretRef: 'LocalObjectReference' = None


@dataclass
class ClientIPConfig(DataclassDictMixIn):
    """ClientIPConfig represents the configurations of Client IP based session
      affinity.

      **parameters**

      * **timeoutSeconds** ``int`` - *(optional)* timeoutSeconds specifies the seconds of ClientIP type session sticky time. The
        value must be >0 && <=86400(for 1 day) if ServiceAffinity == "ClientIP".
        Default value is 10800(for 3 hours).
    """
    timeoutSeconds: 'int' = None


@dataclass
class ComponentCondition(DataclassDictMixIn):
    """Information about the condition of a component.

      **parameters**

      * **status** ``str`` - Status of the condition for a component. Valid values for "Healthy": "True",
        "False", or "Unknown".
      * **type** ``str`` - Type of condition for a component. Valid value: "Healthy"
      * **error** ``str`` - *(optional)* Condition error code for a component. For example, a health check error code.
      * **message** ``str`` - *(optional)* Message about the condition for a component. For example, information about a
        health check.
    """
    status: 'str'
    type: 'str'
    error: 'str' = None
    message: 'str' = None


@dataclass
class ComponentStatus(DataclassDictMixIn):
    """ComponentStatus (and ComponentStatusList) holds the cluster validation info.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **conditions** ``List[ComponentCondition]`` - *(optional)* List of component conditions observed
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    apiVersion: 'str' = None
    conditions: 'List[ComponentCondition]' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None


@dataclass
class ComponentStatusList(DataclassDictMixIn):
    """Status of all the conditions for the component as a list of ComponentStatus
      objects.

      **parameters**

      * **items** ``List[ComponentStatus]`` - List of ComponentStatus objects.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ComponentStatus]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ConfigMap(DataclassDictMixIn):
    """ConfigMap holds configuration data for pods to consume.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **binaryData** ``dict`` - *(optional)* BinaryData contains the binary data. Each key must consist of alphanumeric
        characters, '-', '_' or '.'. BinaryData can contain byte sequences that are
        not in the UTF-8 range. The keys stored in BinaryData must not overlap with
        the ones in the Data field, this is enforced during validation process. Using
        this field will require 1.10+ apiserver and kubelet.
      * **data** ``dict`` - *(optional)* Data contains the configuration data. Each key must consist of alphanumeric
        characters, '-', '_' or '.'. Values with non-UTF-8 byte sequences must use the
        BinaryData field. The keys stored in Data must not overlap with the keys in
        the BinaryData field, this is enforced during validation process.
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    apiVersion: 'str' = None
    binaryData: 'dict' = None
    data: 'dict' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None


@dataclass
class ConfigMapEnvSource(DataclassDictMixIn):
    """ConfigMapEnvSource selects a ConfigMap to populate the environment variables
      with.
      
      The contents of the target ConfigMap's Data field will represent the key-value
      pairs as environment variables.

      **parameters**

      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``bool`` - *(optional)* Specify whether the ConfigMap must be defined
    """
    name: 'str' = None
    optional: 'bool' = None


@dataclass
class ConfigMapKeySelector(DataclassDictMixIn):
    """Selects a key from a ConfigMap.

      **parameters**

      * **key** ``str`` - The key to select.
      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``bool`` - *(optional)* Specify whether the ConfigMap or its key must be defined
    """
    key: 'str'
    name: 'str' = None
    optional: 'bool' = None


@dataclass
class ConfigMapList(DataclassDictMixIn):
    """ConfigMapList is a resource containing a list of ConfigMap objects.

      **parameters**

      * **items** ``List[ConfigMap]`` - Items is the list of ConfigMaps.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[ConfigMap]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ConfigMapNodeConfigSource(DataclassDictMixIn):
    """ConfigMapNodeConfigSource contains the information to reference a ConfigMap as
      a config source for the Node.

      **parameters**

      * **kubeletConfigKey** ``str`` - KubeletConfigKey declares which key of the referenced ConfigMap corresponds to
        the KubeletConfiguration structure This field is required in all cases.
      * **name** ``str`` - Name is the metadata.name of the referenced ConfigMap. This field is required
        in all cases.
      * **namespace** ``str`` - Namespace is the metadata.namespace of the referenced ConfigMap. This field is
        required in all cases.
      * **resourceVersion** ``str`` - *(optional)* ResourceVersion is the metadata.ResourceVersion of the referenced ConfigMap.
        This field is forbidden in Node.Spec, and required in Node.Status.
      * **uid** ``str`` - *(optional)* UID is the metadata.UID of the referenced ConfigMap. This field is forbidden
        in Node.Spec, and required in Node.Status.
    """
    kubeletConfigKey: 'str'
    name: 'str'
    namespace: 'str'
    resourceVersion: 'str' = None
    uid: 'str' = None


@dataclass
class ConfigMapProjection(DataclassDictMixIn):
    """Adapts a ConfigMap into a projected volume.
      
      The contents of the target ConfigMap's Data field will be presented in a
      projected volume as files using the keys in the Data field as the file names,
      unless the items element is populated with specific mappings of keys to paths.
      Note that this is identical to a configmap volume source without the default
      mode.

      **parameters**

      * **items** ``List[KeyToPath]`` - *(optional)* If unspecified, each key-value pair in the Data field of the referenced
        ConfigMap will be projected into the volume as a file whose name is the key
        and content is the value. If specified, the listed keys will be projected into
        the specified paths, and unlisted keys will not be present. If a key is
        specified which is not present in the ConfigMap, the volume setup will error
        unless it is marked optional. Paths must be relative and may not contain the
        '..' path or start with '..'.
      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``bool`` - *(optional)* Specify whether the ConfigMap or its keys must be defined
    """
    items: 'List[KeyToPath]' = None
    name: 'str' = None
    optional: 'bool' = None


@dataclass
class ConfigMapVolumeSource(DataclassDictMixIn):
    """Adapts a ConfigMap into a volume.
      
      The contents of the target ConfigMap's Data field will be presented in a
      volume as files using the keys in the Data field as the file names, unless the
      items element is populated with specific mappings of keys to paths. ConfigMap
      volumes support ownership management and SELinux relabeling.

      **parameters**

      * **defaultMode** ``int`` - *(optional)* Optional: mode bits to use on created files by default. Must be a value
        between 0 and 0777. Defaults to 0644. Directories within the path are not
        affected by this setting. This might be in conflict with other options that
        affect the file mode, like fsGroup, and the result can be other mode bits set.
      * **items** ``List[KeyToPath]`` - *(optional)* If unspecified, each key-value pair in the Data field of the referenced
        ConfigMap will be projected into the volume as a file whose name is the key
        and content is the value. If specified, the listed keys will be projected into
        the specified paths, and unlisted keys will not be present. If a key is
        specified which is not present in the ConfigMap, the volume setup will error
        unless it is marked optional. Paths must be relative and may not contain the
        '..' path or start with '..'.
      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``bool`` - *(optional)* Specify whether the ConfigMap or its keys must be defined
    """
    defaultMode: 'int' = None
    items: 'List[KeyToPath]' = None
    name: 'str' = None
    optional: 'bool' = None


@dataclass
class Container(DataclassDictMixIn):
    """A single application container that you want to run within a pod.

      **parameters**

      * **name** ``str`` - Name of the container specified as a DNS_LABEL. Each container in a pod must
        have a unique name (DNS_LABEL). Cannot be updated.
      * **args** ``List[str]`` - *(optional)* Arguments to the entrypoint. The docker image's CMD is used if this is not
        provided. Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double
        $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of
        whether the variable exists or not. Cannot be updated. More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
      * **command** ``List[str]`` - *(optional)* Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT
        is used if this is not provided. Variable references $(VAR_NAME) are expanded
        using the container's environment. If a variable cannot be resolved, the
        reference in the input string will be unchanged. The $(VAR_NAME) syntax can be
        escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be
        expanded, regardless of whether the variable exists or not. Cannot be updated.
        More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
      * **env** ``List[EnvVar]`` - *(optional)* List of environment variables to set in the container. Cannot be updated.
      * **envFrom** ``List[EnvFromSource]`` - *(optional)* List of sources to populate environment variables in the container. The keys
        defined within a source must be a C_IDENTIFIER. All invalid keys will be
        reported as an event when the container is starting. When a key exists in
        multiple sources, the value associated with the last source will take
        precedence. Values defined by an Env with a duplicate key will take
        precedence. Cannot be updated.
      * **image** ``str`` - *(optional)* Docker image name. More info:
        https://kubernetes.io/docs/concepts/containers/images This field is optional
        to allow higher level config management to default or override container
        images in workload controllers like Deployments and StatefulSets.
      * **imagePullPolicy** ``str`` - *(optional)* Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if
        :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More
        info: https://kubernetes.io/docs/concepts/containers/images#updating-images
      * **lifecycle** ``Lifecycle`` - *(optional)* Actions that the management system should take in response to container
        lifecycle events. Cannot be updated.
      * **livenessProbe** ``Probe`` - *(optional)* Periodic probe of container liveness. Container will be restarted if the probe
        fails. Cannot be updated. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
      * **ports** ``List[ContainerPort]`` - *(optional)* List of ports to expose from the container. Exposing a port here gives the
        system additional information about the network connections a container uses,
        but is primarily informational. Not specifying a port here DOES NOT prevent
        that port from being exposed. Any port which is listening on the default
        "0.0.0.0" address inside a container will be accessible from the network.
        Cannot be updated.
      * **readinessProbe** ``Probe`` - *(optional)* Periodic probe of container service readiness. Container will be removed from
        service endpoints if the probe fails. Cannot be updated. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
      * **resources** ``ResourceRequirements`` - *(optional)* Compute Resources required by this container. Cannot be updated. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
      * **securityContext** ``SecurityContext`` - *(optional)* Security options the pod should run with. More info:
        https://kubernetes.io/docs/concepts/policy/security-context/ More info:
        https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
      * **startupProbe** ``Probe`` - *(optional)* StartupProbe indicates that the Pod has successfully initialized. If
        specified, no other probes are executed until this completes successfully. If
        this probe fails, the Pod will be restarted, just as if the livenessProbe
        failed. This can be used to provide different probe parameters at the
        beginning of a Pod's lifecycle, when it might take a long time to load data or
        warm a cache, than during steady-state operation. This cannot be updated. This
        is an alpha feature enabled by the StartupProbe feature flag. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
      * **stdin** ``bool`` - *(optional)* Whether this container should allocate a buffer for stdin in the container
        runtime. If this is not set, reads from stdin in the container will always
        result in EOF. Default is false.
      * **stdinOnce** ``bool`` - *(optional)* Whether the container runtime should close the stdin channel after it has been
        opened by a single attach. When stdin is true the stdin stream will remain
        open across multiple attach sessions. If stdinOnce is set to true, stdin is
        opened on container start, is empty until the first client attaches to stdin,
        and then remains open and accepts data until the client disconnects, at which
        time stdin is closed and remains closed until the container is restarted. If
        this flag is false, a container processes that reads from stdin will never
        receive an EOF. Default is false
      * **terminationMessagePath** ``str`` - *(optional)* Optional: Path at which the file to which the container's termination message
        will be written is mounted into the container's filesystem. Message written is
        intended to be brief final status, such as an assertion failure message. Will
        be truncated by the node if greater than 4096 bytes. The total message length
        across all containers will be limited to 12kb. Defaults to
        /dev/termination-log. Cannot be updated.
      * **terminationMessagePolicy** ``str`` - *(optional)* Indicate how the termination message should be populated. File will use the
        contents of terminationMessagePath to populate the container status message on
        both success and failure. FallbackToLogsOnError will use the last chunk of
        container log output if the termination message file is empty and the
        container exited with an error. The log output is limited to 2048 bytes or 80
        lines, whichever is smaller. Defaults to File. Cannot be updated.
      * **tty** ``bool`` - *(optional)* Whether this container should allocate a TTY for itself, also requires 'stdin'
        to be true. Default is false.
      * **volumeDevices** ``List[VolumeDevice]`` - *(optional)* volumeDevices is the list of block devices to be used by the container. This
        is a beta feature.
      * **volumeMounts** ``List[VolumeMount]`` - *(optional)* Pod volumes to mount into the container's filesystem. Cannot be updated.
      * **workingDir** ``str`` - *(optional)* Container's working directory. If not specified, the container runtime's
        default will be used, which might be configured in the container image. Cannot
        be updated.
    """
    name: 'str'
    args: 'List[str]' = None
    command: 'List[str]' = None
    env: 'List[EnvVar]' = None
    envFrom: 'List[EnvFromSource]' = None
    image: 'str' = None
    imagePullPolicy: 'str' = None
    lifecycle: 'Lifecycle' = None
    livenessProbe: 'Probe' = None
    ports: 'List[ContainerPort]' = None
    readinessProbe: 'Probe' = None
    resources: 'ResourceRequirements' = None
    securityContext: 'SecurityContext' = None
    startupProbe: 'Probe' = None
    stdin: 'bool' = None
    stdinOnce: 'bool' = None
    terminationMessagePath: 'str' = None
    terminationMessagePolicy: 'str' = None
    tty: 'bool' = None
    volumeDevices: 'List[VolumeDevice]' = None
    volumeMounts: 'List[VolumeMount]' = None
    workingDir: 'str' = None


@dataclass
class ContainerImage(DataclassDictMixIn):
    """Describe a container image

      **parameters**

      * **names** ``List[str]`` - Names by which this image is known. e.g. ["k8s.gcr.io/hyperkube:v1.0.7",
        "dockerhub.io/google_containers/hyperkube:v1.0.7"]
      * **sizeBytes** ``int`` - *(optional)* The size of the image in bytes.
    """
    names: 'List[str]'
    sizeBytes: 'int' = None


@dataclass
class ContainerPort(DataclassDictMixIn):
    """ContainerPort represents a network port in a single container.

      **parameters**

      * **containerPort** ``int`` - Number of port to expose on the pod's IP address. This must be a valid port
        number, 0 < x < 65536.
      * **hostIP** ``str`` - *(optional)* What host IP to bind the external port to.
      * **hostPort** ``int`` - *(optional)* Number of port to expose on the host. If specified, this must be a valid port
        number, 0 < x < 65536. If HostNetwork is specified, this must match
        ContainerPort. Most containers do not need this.
      * **name** ``str`` - *(optional)* If specified, this must be an IANA_SVC_NAME and unique within the pod. Each
        named port in a pod must have a unique name. Name for the port that can be
        referred to by services.
      * **protocol** ``str`` - *(optional)* Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
    """
    containerPort: 'int'
    hostIP: 'str' = None
    hostPort: 'int' = None
    name: 'str' = None
    protocol: 'str' = None


@dataclass
class ContainerState(DataclassDictMixIn):
    """ContainerState holds a possible state of container. Only one of its members
      may be specified. If none of them is specified, the default one is
      ContainerStateWaiting.

      **parameters**

      * **running** ``ContainerStateRunning`` - *(optional)* Details about a running container
      * **terminated** ``ContainerStateTerminated`` - *(optional)* Details about a terminated container
      * **waiting** ``ContainerStateWaiting`` - *(optional)* Details about a waiting container
    """
    running: 'ContainerStateRunning' = None
    terminated: 'ContainerStateTerminated' = None
    waiting: 'ContainerStateWaiting' = None


@dataclass
class ContainerStateRunning(DataclassDictMixIn):
    """ContainerStateRunning is a running state of a container.

      **parameters**

      * **startedAt** ``meta_v1.Time`` - *(optional)* Time at which the container was last (re-)started
    """
    startedAt: 'meta_v1.Time' = None


@dataclass
class ContainerStateTerminated(DataclassDictMixIn):
    """ContainerStateTerminated is a terminated state of a container.

      **parameters**

      * **exitCode** ``int`` - Exit status from the last termination of the container
      * **containerID** ``str`` - *(optional)* Container's ID in the format 'docker://<container_id>'
      * **finishedAt** ``meta_v1.Time`` - *(optional)* Time at which the container last terminated
      * **message** ``str`` - *(optional)* Message regarding the last termination of the container
      * **reason** ``str`` - *(optional)* (brief) reason from the last termination of the container
      * **signal** ``int`` - *(optional)* Signal from the last termination of the container
      * **startedAt** ``meta_v1.Time`` - *(optional)* Time at which previous execution of the container started
    """
    exitCode: 'int'
    containerID: 'str' = None
    finishedAt: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None
    signal: 'int' = None
    startedAt: 'meta_v1.Time' = None


@dataclass
class ContainerStateWaiting(DataclassDictMixIn):
    """ContainerStateWaiting is a waiting state of a container.

      **parameters**

      * **message** ``str`` - *(optional)* Message regarding why the container is not yet running.
      * **reason** ``str`` - *(optional)* (brief) reason the container is not yet running.
    """
    message: 'str' = None
    reason: 'str' = None


@dataclass
class ContainerStatus(DataclassDictMixIn):
    """ContainerStatus contains details for the current status of this container.

      **parameters**

      * **image** ``str`` - The image the container is running. More info:
        https://kubernetes.io/docs/concepts/containers/images
      * **imageID** ``str`` - ImageID of the container's image.
      * **name** ``str`` - This must be a DNS_LABEL. Each container in a pod must have a unique name.
        Cannot be updated.
      * **ready** ``bool`` - Specifies whether the container has passed its readiness probe.
      * **restartCount** ``int`` - The number of times the container has been restarted, currently based on the
        number of dead containers that have not yet been removed. Note that this is
        calculated from dead containers. But those containers are subject to garbage
        collection. This value will get capped at 5 by GC.
      * **containerID** ``str`` - *(optional)* Container's ID in the format 'docker://<container_id>'.
      * **lastState** ``ContainerState`` - *(optional)* Details about the container's last termination condition.
      * **started** ``bool`` - *(optional)* Specifies whether the container has passed its startup probe. Initialized as
        false, becomes true after startupProbe is considered successful. Resets to
        false when the container is restarted, or if kubelet loses state temporarily.
        Is always true when no startupProbe is defined.
      * **state** ``ContainerState`` - *(optional)* Details about the container's current condition.
    """
    image: 'str'
    imageID: 'str'
    name: 'str'
    ready: 'bool'
    restartCount: 'int'
    containerID: 'str' = None
    lastState: 'ContainerState' = None
    started: 'bool' = None
    state: 'ContainerState' = None


@dataclass
class DaemonEndpoint(DataclassDictMixIn):
    """DaemonEndpoint contains information about a single Daemon endpoint.

      **parameters**

      * **Port** ``int`` - Port number of the given endpoint.
    """
    Port: 'int'


@dataclass
class DownwardAPIProjection(DataclassDictMixIn):
    """Represents downward API info for projecting into a projected volume. Note that
      this is identical to a downwardAPI volume source without the default mode.

      **parameters**

      * **items** ``List[DownwardAPIVolumeFile]`` - *(optional)* Items is a list of DownwardAPIVolume file
    """
    items: 'List[DownwardAPIVolumeFile]' = None


@dataclass
class DownwardAPIVolumeFile(DataclassDictMixIn):
    """DownwardAPIVolumeFile represents information to create the file containing the
      pod field

      **parameters**

      * **path** ``str`` - Required: Path is  the relative path name of the file to be created. Must not
        be absolute or contain the '..' path. Must be utf-8 encoded. The first item of
        the relative path must not start with '..'
      * **fieldRef** ``ObjectFieldSelector`` - *(optional)* Required: Selects a field of the pod: only annotations, labels, name and
        namespace are supported.
      * **mode** ``int`` - *(optional)* Optional: mode bits to use on this file, must be a value between 0 and 0777.
        If not specified, the volume defaultMode will be used. This might be in
        conflict with other options that affect the file mode, like fsGroup, and the
        result can be other mode bits set.
      * **resourceFieldRef** ``ResourceFieldSelector`` - *(optional)* Selects a resource of the container: only resources limits and requests
        (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently
        supported.
    """
    path: 'str'
    fieldRef: 'ObjectFieldSelector' = None
    mode: 'int' = None
    resourceFieldRef: 'ResourceFieldSelector' = None


@dataclass
class DownwardAPIVolumeSource(DataclassDictMixIn):
    """DownwardAPIVolumeSource represents a volume containing downward API info.
      Downward API volumes support ownership management and SELinux relabeling.

      **parameters**

      * **defaultMode** ``int`` - *(optional)* Optional: mode bits to use on created files by default. Must be a value
        between 0 and 0777. Defaults to 0644. Directories within the path are not
        affected by this setting. This might be in conflict with other options that
        affect the file mode, like fsGroup, and the result can be other mode bits set.
      * **items** ``List[DownwardAPIVolumeFile]`` - *(optional)* Items is a list of downward API volume file
    """
    defaultMode: 'int' = None
    items: 'List[DownwardAPIVolumeFile]' = None


@dataclass
class EmptyDirVolumeSource(DataclassDictMixIn):
    """Represents an empty directory for a pod. Empty directory volumes support
      ownership management and SELinux relabeling.

      **parameters**

      * **medium** ``str`` - *(optional)* What type of storage medium should back this directory. The default is ""
        which means to use the node's default medium. Must be an empty string
        (default) or Memory. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#emptydir
      * **sizeLimit** ``resource.Quantity`` - *(optional)* Total amount of local storage required for this EmptyDir volume. The size
        limit is also applicable for memory medium. The maximum usage on memory medium
        EmptyDir would be the minimum value between the SizeLimit specified here and
        the sum of memory limits of all containers in a pod. The default is nil which
        means that the limit is undefined. More info:
        http://kubernetes.io/docs/user-guide/volumes#emptydir
    """
    medium: 'str' = None
    sizeLimit: 'resource.Quantity' = None


@dataclass
class EndpointAddress(DataclassDictMixIn):
    """EndpointAddress is a tuple that describes single IP address.

      **parameters**

      * **ip** ``str`` - The IP of this endpoint. May not be loopback (127.0.0.0/8), link-local
        (169.254.0.0/16), or link-local multicast ((224.0.0.0/24). IPv6 is also
        accepted but not fully supported on all platforms. Also, certain kubernetes
        components, like kube-proxy, are not IPv6 ready.
      * **hostname** ``str`` - *(optional)* The Hostname of this endpoint
      * **nodeName** ``str`` - *(optional)* Optional: Node hosting this endpoint. This can be used to determine endpoints
        local to a node.
      * **targetRef** ``ObjectReference`` - *(optional)* Reference to object providing the endpoint.
    """
    ip: 'str'
    hostname: 'str' = None
    nodeName: 'str' = None
    targetRef: 'ObjectReference' = None


@dataclass
class EndpointPort(DataclassDictMixIn):
    """EndpointPort is a tuple that describes a single port.

      **parameters**

      * **port** ``int`` - The port number of the endpoint.
      * **name** ``str`` - *(optional)* The name of this port.  This must match the 'name' field in the corresponding
        ServicePort. Must be a DNS_LABEL. Optional only if one port is defined.
      * **protocol** ``str`` - *(optional)* The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.
    """
    port: 'int'
    name: 'str' = None
    protocol: 'str' = None


@dataclass
class EndpointSubset(DataclassDictMixIn):
    """EndpointSubset is a group of addresses with a common set of ports. The
      expanded set of endpoints is the Cartesian product of Addresses x Ports. For
      example, given:
        {
          Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
          Ports:     [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
        }
      The resulting set of endpoints can be viewed as:
          a: [ 10.10.1.1:8675, 10.10.2.2:8675 ],
          b: [ 10.10.1.1:309, 10.10.2.2:309 ]

      **parameters**

      * **addresses** ``List[EndpointAddress]`` - *(optional)* IP addresses which offer the related ports that are marked as ready. These
        endpoints should be considered safe for load balancers and clients to utilize.
      * **notReadyAddresses** ``List[EndpointAddress]`` - *(optional)* IP addresses which offer the related ports but are not currently marked as
        ready because they have not yet finished starting, have recently failed a
        readiness check, or have recently failed a liveness check.
      * **ports** ``List[EndpointPort]`` - *(optional)* Port numbers available on the related IP addresses.
    """
    addresses: 'List[EndpointAddress]' = None
    notReadyAddresses: 'List[EndpointAddress]' = None
    ports: 'List[EndpointPort]' = None


@dataclass
class Endpoints(DataclassDictMixIn):
    """Endpoints is a collection of endpoints that implement the actual service.
      Example:
        Name: "mysvc",
        Subsets: [
          {
            Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
            Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
          },
          {
            Addresses: [{"ip": "10.10.3.3"}],
            Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
          },
       ]

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **subsets** ``List[EndpointSubset]`` - *(optional)* The set of all endpoints is the union of all subsets. Addresses are placed
        into subsets according to the IPs they share. A single address with multiple
        ports, some of which are ready and some of which are not (because they come
        from different containers) will result in the address being displayed in
        different subsets for the different ports. No address will appear in both
        Addresses and NotReadyAddresses in the same subset. Sets of addresses and
        ports that comprise a service.
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    subsets: 'List[EndpointSubset]' = None


@dataclass
class EndpointsList(DataclassDictMixIn):
    """EndpointsList is a list of endpoints.

      **parameters**

      * **items** ``List[Endpoints]`` - List of endpoints.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Endpoints]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class EnvFromSource(DataclassDictMixIn):
    """EnvFromSource represents the source of a set of ConfigMaps

      **parameters**

      * **configMapRef** ``ConfigMapEnvSource`` - *(optional)* The ConfigMap to select from
      * **prefix** ``str`` - *(optional)* An optional identifier to prepend to each key in the ConfigMap. Must be a
        C_IDENTIFIER.
      * **secretRef** ``SecretEnvSource`` - *(optional)* The Secret to select from
    """
    configMapRef: 'ConfigMapEnvSource' = None
    prefix: 'str' = None
    secretRef: 'SecretEnvSource' = None


@dataclass
class EnvVar(DataclassDictMixIn):
    """EnvVar represents an environment variable present in a Container.

      **parameters**

      * **name** ``str`` - Name of the environment variable. Must be a C_IDENTIFIER.
      * **value** ``str`` - *(optional)* Variable references $(VAR_NAME) are expanded using the previous defined
        environment variables in the container and any service environment variables.
        If a variable cannot be resolved, the reference in the input string will be
        unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie:
        $$(VAR_NAME). Escaped references will never be expanded, regardless of whether
        the variable exists or not. Defaults to "".
      * **valueFrom** ``EnvVarSource`` - *(optional)* Source for the environment variable's value. Cannot be used if value is not
        empty.
    """
    name: 'str'
    value: 'str' = None
    valueFrom: 'EnvVarSource' = None


@dataclass
class EnvVarSource(DataclassDictMixIn):
    """EnvVarSource represents a source for the value of an EnvVar.

      **parameters**

      * **configMapKeyRef** ``ConfigMapKeySelector`` - *(optional)* Selects a key of a ConfigMap.
      * **fieldRef** ``ObjectFieldSelector`` - *(optional)* Selects a field of the pod: supports metadata.name, metadata.namespace,
        metadata.labels, metadata.annotations, spec.nodeName, spec.serviceAccountName,
        status.hostIP, status.podIP, status.podIPs.
      * **resourceFieldRef** ``ResourceFieldSelector`` - *(optional)* Selects a resource of the container: only resources limits and requests
        (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu,
        requests.memory and requests.ephemeral-storage) are currently supported.
      * **secretKeyRef** ``SecretKeySelector`` - *(optional)* Selects a key of a secret in the pod's namespace
    """
    configMapKeyRef: 'ConfigMapKeySelector' = None
    fieldRef: 'ObjectFieldSelector' = None
    resourceFieldRef: 'ResourceFieldSelector' = None
    secretKeyRef: 'SecretKeySelector' = None


@dataclass
class EphemeralContainer(DataclassDictMixIn):
    """An EphemeralContainer is a container that may be added temporarily to an
      existing pod for user-initiated activities such as debugging. Ephemeral
      containers have no resource or scheduling guarantees, and they will not be
      restarted when they exit or when a pod is removed or restarted. If an
      ephemeral container causes a pod to exceed its resource allocation, the pod
      may be evicted. Ephemeral containers may not be added by directly updating the
      pod spec. They must be added via the pod's ephemeralcontainers subresource,
      and they will appear in the pod spec once added. This is an alpha feature
      enabled by the EphemeralContainers feature flag.

      **parameters**

      * **name** ``str`` - Name of the ephemeral container specified as a DNS_LABEL. This name must be
        unique among all containers, init containers and ephemeral containers.
      * **args** ``List[str]`` - *(optional)* Arguments to the entrypoint. The docker image's CMD is used if this is not
        provided. Variable references $(VAR_NAME) are expanded using the container's
        environment. If a variable cannot be resolved, the reference in the input
        string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double
        $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of
        whether the variable exists or not. Cannot be updated. More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
      * **command** ``List[str]`` - *(optional)* Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT
        is used if this is not provided. Variable references $(VAR_NAME) are expanded
        using the container's environment. If a variable cannot be resolved, the
        reference in the input string will be unchanged. The $(VAR_NAME) syntax can be
        escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be
        expanded, regardless of whether the variable exists or not. Cannot be updated.
        More info:
        https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
      * **env** ``List[EnvVar]`` - *(optional)* List of environment variables to set in the container. Cannot be updated.
      * **envFrom** ``List[EnvFromSource]`` - *(optional)* List of sources to populate environment variables in the container. The keys
        defined within a source must be a C_IDENTIFIER. All invalid keys will be
        reported as an event when the container is starting. When a key exists in
        multiple sources, the value associated with the last source will take
        precedence. Values defined by an Env with a duplicate key will take
        precedence. Cannot be updated.
      * **image** ``str`` - *(optional)* Docker image name. More info:
        https://kubernetes.io/docs/concepts/containers/images
      * **imagePullPolicy** ``str`` - *(optional)* Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if
        :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More
        info: https://kubernetes.io/docs/concepts/containers/images#updating-images
      * **lifecycle** ``Lifecycle`` - *(optional)* Lifecycle is not allowed for ephemeral containers.
      * **livenessProbe** ``Probe`` - *(optional)* Probes are not allowed for ephemeral containers.
      * **ports** ``List[ContainerPort]`` - *(optional)* Ports are not allowed for ephemeral containers.
      * **readinessProbe** ``Probe`` - *(optional)* Probes are not allowed for ephemeral containers.
      * **resources** ``ResourceRequirements`` - *(optional)* Resources are not allowed for ephemeral containers. Ephemeral containers use
        spare resources already allocated to the pod.
      * **securityContext** ``SecurityContext`` - *(optional)* SecurityContext is not allowed for ephemeral containers.
      * **startupProbe** ``Probe`` - *(optional)* Probes are not allowed for ephemeral containers.
      * **stdin** ``bool`` - *(optional)* Whether this container should allocate a buffer for stdin in the container
        runtime. If this is not set, reads from stdin in the container will always
        result in EOF. Default is false.
      * **stdinOnce** ``bool`` - *(optional)* Whether the container runtime should close the stdin channel after it has been
        opened by a single attach. When stdin is true the stdin stream will remain
        open across multiple attach sessions. If stdinOnce is set to true, stdin is
        opened on container start, is empty until the first client attaches to stdin,
        and then remains open and accepts data until the client disconnects, at which
        time stdin is closed and remains closed until the container is restarted. If
        this flag is false, a container processes that reads from stdin will never
        receive an EOF. Default is false
      * **targetContainerName** ``str`` - *(optional)* If set, the name of the container from PodSpec that this ephemeral container
        targets. The ephemeral container will be run in the namespaces (IPC, PID, etc)
        of this container. If not set then the ephemeral container is run in whatever
        namespaces are shared for the pod. Note that the container runtime must
        support this feature.
      * **terminationMessagePath** ``str`` - *(optional)* Optional: Path at which the file to which the container's termination message
        will be written is mounted into the container's filesystem. Message written is
        intended to be brief final status, such as an assertion failure message. Will
        be truncated by the node if greater than 4096 bytes. The total message length
        across all containers will be limited to 12kb. Defaults to
        /dev/termination-log. Cannot be updated.
      * **terminationMessagePolicy** ``str`` - *(optional)* Indicate how the termination message should be populated. File will use the
        contents of terminationMessagePath to populate the container status message on
        both success and failure. FallbackToLogsOnError will use the last chunk of
        container log output if the termination message file is empty and the
        container exited with an error. The log output is limited to 2048 bytes or 80
        lines, whichever is smaller. Defaults to File. Cannot be updated.
      * **tty** ``bool`` - *(optional)* Whether this container should allocate a TTY for itself, also requires 'stdin'
        to be true. Default is false.
      * **volumeDevices** ``List[VolumeDevice]`` - *(optional)* volumeDevices is the list of block devices to be used by the container. This
        is a beta feature.
      * **volumeMounts** ``List[VolumeMount]`` - *(optional)* Pod volumes to mount into the container's filesystem. Cannot be updated.
      * **workingDir** ``str`` - *(optional)* Container's working directory. If not specified, the container runtime's
        default will be used, which might be configured in the container image. Cannot
        be updated.
    """
    name: 'str'
    args: 'List[str]' = None
    command: 'List[str]' = None
    env: 'List[EnvVar]' = None
    envFrom: 'List[EnvFromSource]' = None
    image: 'str' = None
    imagePullPolicy: 'str' = None
    lifecycle: 'Lifecycle' = None
    livenessProbe: 'Probe' = None
    ports: 'List[ContainerPort]' = None
    readinessProbe: 'Probe' = None
    resources: 'ResourceRequirements' = None
    securityContext: 'SecurityContext' = None
    startupProbe: 'Probe' = None
    stdin: 'bool' = None
    stdinOnce: 'bool' = None
    targetContainerName: 'str' = None
    terminationMessagePath: 'str' = None
    terminationMessagePolicy: 'str' = None
    tty: 'bool' = None
    volumeDevices: 'List[VolumeDevice]' = None
    volumeMounts: 'List[VolumeMount]' = None
    workingDir: 'str' = None


@dataclass
class Event(DataclassDictMixIn):
    """Event is a report of an event somewhere in the cluster.

      **parameters**

      * **involvedObject** ``ObjectReference`` - The object that this event is about.
      * **metadata** ``meta_v1.ObjectMeta`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **action** ``str`` - *(optional)* What action was taken/failed regarding to the Regarding object.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **count** ``int`` - *(optional)* The number of times this event has occurred.
      * **eventTime** ``meta_v1.MicroTime`` - *(optional)* Time when this Event was first observed.
      * **firstTimestamp** ``meta_v1.Time`` - *(optional)* The time at which the event was first recorded. (Time of server receipt is in
        TypeMeta.)
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **lastTimestamp** ``meta_v1.Time`` - *(optional)* The time at which the most recent occurrence of this event was recorded.
      * **message** ``str`` - *(optional)* A human-readable description of the status of this operation.
      * **reason** ``str`` - *(optional)* This should be a short, machine understandable string that gives the reason
        for the transition into the object's current status.
      * **related** ``ObjectReference`` - *(optional)* Optional secondary object for more complex actions.
      * **reportingComponent** ``str`` - *(optional)* Name of the controller that emitted this Event, e.g. `kubernetes.io/kubelet`.
      * **reportingInstance** ``str`` - *(optional)* ID of the controller instance, e.g. `kubelet-xyzf`.
      * **series** ``EventSeries`` - *(optional)* Data about the Event series this event represents or nil if it's a singleton
        Event.
      * **source** ``EventSource`` - *(optional)* The component reporting this event. Should be a short machine understandable
        string.
      * **type** ``str`` - *(optional)* Type of this event (Normal, Warning), new types could be added in the future
    """
    involvedObject: 'ObjectReference'
    metadata: 'meta_v1.ObjectMeta'
    action: 'str' = None
    apiVersion: 'str' = None
    count: 'int' = None
    eventTime: 'meta_v1.MicroTime' = None
    firstTimestamp: 'meta_v1.Time' = None
    kind: 'str' = None
    lastTimestamp: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None
    related: 'ObjectReference' = None
    reportingComponent: 'str' = None
    reportingInstance: 'str' = None
    series: 'EventSeries' = None
    source: 'EventSource' = None
    type: 'str' = None


@dataclass
class EventList(DataclassDictMixIn):
    """EventList is a list of events.

      **parameters**

      * **items** ``List[Event]`` - List of events
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Event]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class EventSeries(DataclassDictMixIn):
    """EventSeries contain information on series of events, i.e. thing that was/is
      happening continuously for some time.

      **parameters**

      * **count** ``int`` - *(optional)* Number of occurrences in this series up to the last heartbeat time
      * **lastObservedTime** ``meta_v1.MicroTime`` - *(optional)* Time of the last occurrence observed
      * **state** ``str`` - *(optional)* State of this Series: Ongoing or Finished Deprecated. Planned removal for 1.18
    """
    count: 'int' = None
    lastObservedTime: 'meta_v1.MicroTime' = None
    state: 'str' = None


@dataclass
class EventSource(DataclassDictMixIn):
    """EventSource contains information for an event.

      **parameters**

      * **component** ``str`` - *(optional)* Component from which the event is generated.
      * **host** ``str`` - *(optional)* Node name on which the event is generated.
    """
    component: 'str' = None
    host: 'str' = None


@dataclass
class ExecAction(DataclassDictMixIn):
    """ExecAction describes a "run in container" action.

      **parameters**

      * **command** ``List[str]`` - *(optional)* Command is the command line to execute inside the container, the working
        directory for the command  is root ('/') in the container's filesystem. The
        command is simply exec'd, it is not run inside a shell, so traditional shell
        instructions ('|', etc) won't work. To use a shell, you need to explicitly
        call out to that shell. Exit status of 0 is treated as live/healthy and
        non-zero is unhealthy.
    """
    command: 'List[str]' = None


@dataclass
class FCVolumeSource(DataclassDictMixIn):
    """Represents a Fibre Channel volume. Fibre Channel volumes can only be mounted
      as read/write once. Fibre Channel volumes support ownership management and
      SELinux relabeling.

      **parameters**

      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **lun** ``int`` - *(optional)* Optional: FC target lun number
      * **readOnly** ``bool`` - *(optional)* Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts.
      * **targetWWNs** ``List[str]`` - *(optional)* Optional: FC target worldwide names (WWNs)
      * **wwids** ``List[str]`` - *(optional)* Optional: FC volume world wide identifiers (wwids) Either wwids or combination
        of targetWWNs and lun must be set, but not both simultaneously.
    """
    fsType: 'str' = None
    lun: 'int' = None
    readOnly: 'bool' = None
    targetWWNs: 'List[str]' = None
    wwids: 'List[str]' = None


@dataclass
class FlexPersistentVolumeSource(DataclassDictMixIn):
    """FlexPersistentVolumeSource represents a generic persistent volume resource
      that is provisioned/attached using an exec based plugin.

      **parameters**

      * **driver** ``str`` - Driver is the name of the driver to use for this volume.
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on
        FlexVolume script.
      * **options** ``dict`` - *(optional)* Optional: Extra command options if any.
      * **readOnly** ``bool`` - *(optional)* Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts.
      * **secretRef** ``SecretReference`` - *(optional)* Optional: SecretRef is reference to the secret object containing sensitive
        information to pass to the plugin scripts. This may be empty if no secret
        object is specified. If the secret object contains more than one secret, all
        secrets are passed to the plugin scripts.
    """
    driver: 'str'
    fsType: 'str' = None
    options: 'dict' = None
    readOnly: 'bool' = None
    secretRef: 'SecretReference' = None


@dataclass
class FlexVolumeSource(DataclassDictMixIn):
    """FlexVolume represents a generic volume resource that is provisioned/attached
      using an exec based plugin.

      **parameters**

      * **driver** ``str`` - Driver is the name of the driver to use for this volume.
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on
        FlexVolume script.
      * **options** ``dict`` - *(optional)* Optional: Extra command options if any.
      * **readOnly** ``bool`` - *(optional)* Optional: Defaults to false (read/write). ReadOnly here will force the
        ReadOnly setting in VolumeMounts.
      * **secretRef** ``LocalObjectReference`` - *(optional)* Optional: SecretRef is reference to the secret object containing sensitive
        information to pass to the plugin scripts. This may be empty if no secret
        object is specified. If the secret object contains more than one secret, all
        secrets are passed to the plugin scripts.
    """
    driver: 'str'
    fsType: 'str' = None
    options: 'dict' = None
    readOnly: 'bool' = None
    secretRef: 'LocalObjectReference' = None


@dataclass
class FlockerVolumeSource(DataclassDictMixIn):
    """Represents a Flocker volume mounted by the Flocker agent. One and only one of
      datasetName and datasetUUID should be set. Flocker volumes do not support
      ownership management or SELinux relabeling.

      **parameters**

      * **datasetName** ``str`` - *(optional)* Name of the dataset stored as metadata -> name on the dataset for Flocker
        should be considered as deprecated
      * **datasetUUID** ``str`` - *(optional)* UUID of the dataset. This is unique identifier of a Flocker dataset
    """
    datasetName: 'str' = None
    datasetUUID: 'str' = None


@dataclass
class GCEPersistentDiskVolumeSource(DataclassDictMixIn):
    """Represents a Persistent Disk resource in Google Compute Engine.
      
      A GCE PD must exist before mounting to a container. The disk must also be in
      the same GCE project and zone as the kubelet. A GCE PD can only be mounted as
      read/write once or read-only many times. GCE PDs support ownership management
      and SELinux relabeling.

      **parameters**

      * **pdName** ``str`` - Unique name of the PD resource in GCE. Used to identify the disk in GCE. More
        info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **fsType** ``str`` - *(optional)* Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **partition** ``int`` - *(optional)* The partition in the volume that you want to mount. If omitted, the default is
        to mount by volume name. Examples: For volume /dev/sda1, you specify the
        partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you
        can leave the property empty). More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
    """
    pdName: 'str'
    fsType: 'str' = None
    partition: 'int' = None
    readOnly: 'bool' = None


@dataclass
class GitRepoVolumeSource(DataclassDictMixIn):
    """Represents a volume that is populated with the contents of a git repository.
      Git repo volumes do not support ownership management. Git repo volumes support
      SELinux relabeling.
      
      DEPRECATED: GitRepo is deprecated. To provision a container with a git repo,
      mount an EmptyDir into an InitContainer that clones the repo using git, then
      mount the EmptyDir into the Pod's container.

      **parameters**

      * **repository** ``str`` - Repository URL
      * **directory** ``str`` - *(optional)* Target directory name. Must not contain or start with '..'.  If '.' is
        supplied, the volume directory will be the git repository.  Otherwise, if
        specified, the volume will contain the git repository in the subdirectory with
        the given name.
      * **revision** ``str`` - *(optional)* Commit hash for the specified revision.
    """
    repository: 'str'
    directory: 'str' = None
    revision: 'str' = None


@dataclass
class GlusterfsPersistentVolumeSource(DataclassDictMixIn):
    """Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs
      volumes do not support ownership management or SELinux relabeling.

      **parameters**

      * **endpoints** ``str`` - EndpointsName is the endpoint name that details Glusterfs topology. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **path** ``str`` - Path is the Glusterfs volume path. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **endpointsNamespace** ``str`` - *(optional)* EndpointsNamespace is the namespace that contains Glusterfs endpoint. If this
        field is empty, the EndpointNamespace defaults to the same namespace as the
        bound PVC. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the Glusterfs volume to be mounted with read-only
        permissions. Defaults to false. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    endpoints: 'str'
    path: 'str'
    endpointsNamespace: 'str' = None
    readOnly: 'bool' = None


@dataclass
class GlusterfsVolumeSource(DataclassDictMixIn):
    """Represents a Glusterfs mount that lasts the lifetime of a pod. Glusterfs
      volumes do not support ownership management or SELinux relabeling.

      **parameters**

      * **endpoints** ``str`` - EndpointsName is the endpoint name that details Glusterfs topology. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **path** ``str`` - Path is the Glusterfs volume path. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the Glusterfs volume to be mounted with read-only
        permissions. Defaults to false. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
    """
    endpoints: 'str'
    path: 'str'
    readOnly: 'bool' = None


@dataclass
class HTTPGetAction(DataclassDictMixIn):
    """HTTPGetAction describes an action based on HTTP Get requests.

      **parameters**

      * **port** ``util_intstr.IntOrString`` - Name or number of the port to access on the container. Number must be in the
        range 1 to 65535. Name must be an IANA_SVC_NAME.
      * **host** ``str`` - *(optional)* Host name to connect to, defaults to the pod IP. You probably want to set
        "Host" in httpHeaders instead.
      * **httpHeaders** ``List[HTTPHeader]`` - *(optional)* Custom headers to set in the request. HTTP allows repeated headers.
      * **path** ``str`` - *(optional)* Path to access on the HTTP server.
      * **scheme** ``str`` - *(optional)* Scheme to use for connecting to the host. Defaults to HTTP.
    """
    port: 'util_intstr.IntOrString'
    host: 'str' = None
    httpHeaders: 'List[HTTPHeader]' = None
    path: 'str' = None
    scheme: 'str' = None


@dataclass
class HTTPHeader(DataclassDictMixIn):
    """HTTPHeader describes a custom header to be used in HTTP probes

      **parameters**

      * **name** ``str`` - The header field name
      * **value** ``str`` - The header field value
    """
    name: 'str'
    value: 'str'


@dataclass
class Handler(DataclassDictMixIn):
    """Handler defines a specific action that should be taken

      **parameters**

      * **exec** ``ExecAction`` - *(optional)* One and only one of the following should be specified. Exec specifies the
        action to take.
      * **httpGet** ``HTTPGetAction`` - *(optional)* HTTPGet specifies the http request to perform.
      * **tcpSocket** ``TCPSocketAction`` - *(optional)* TCPSocket specifies an action involving a TCP port. TCP hooks not yet
        supported
    """
    exec: 'ExecAction' = None
    httpGet: 'HTTPGetAction' = None
    tcpSocket: 'TCPSocketAction' = None


@dataclass
class HostAlias(DataclassDictMixIn):
    """HostAlias holds the mapping between IP and hostnames that will be injected as
      an entry in the pod's hosts file.

      **parameters**

      * **hostnames** ``List[str]`` - *(optional)* Hostnames for the above IP address.
      * **ip** ``str`` - *(optional)* IP address of the host file entry.
    """
    hostnames: 'List[str]' = None
    ip: 'str' = None


@dataclass
class HostPathVolumeSource(DataclassDictMixIn):
    """Represents a host path mapped into a pod. Host path volumes do not support
      ownership management or SELinux relabeling.

      **parameters**

      * **path** ``str`` - Path of the directory on the host. If the path is a symlink, it will follow
        the link to the real path. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#hostpath
      * **type** ``str`` - *(optional)* Type for HostPath Volume Defaults to "" More info:
        https://kubernetes.io/docs/concepts/storage/volumes#hostpath
    """
    path: 'str'
    type: 'str' = None


@dataclass
class ISCSIPersistentVolumeSource(DataclassDictMixIn):
    """ISCSIPersistentVolumeSource represents an ISCSI disk. ISCSI volumes can only
      be mounted as read/write once. ISCSI volumes support ownership management and
      SELinux relabeling.

      **parameters**

      * **iqn** ``str`` - Target iSCSI Qualified Name.
      * **lun** ``int`` - iSCSI Target Lun number.
      * **targetPortal** ``str`` - iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is
        other than default (typically TCP ports 860 and 3260).
      * **chapAuthDiscovery** ``bool`` - *(optional)* whether support iSCSI Discovery CHAP authentication
      * **chapAuthSession** ``bool`` - *(optional)* whether support iSCSI Session CHAP authentication
      * **fsType** ``str`` - *(optional)* Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#iscsi
      * **initiatorName** ``str`` - *(optional)* Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface
        simultaneously, new iSCSI interface <target portal>:<volume name> will be
        created for the connection.
      * **iscsiInterface** ``str`` - *(optional)* iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default'
        (tcp).
      * **portals** ``List[str]`` - *(optional)* iSCSI Target Portal List. The Portal is either an IP or ip_addr:port if the
        port is other than default (typically TCP ports 860 and 3260).
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false.
      * **secretRef** ``SecretReference`` - *(optional)* CHAP Secret for iSCSI target and initiator authentication
    """
    iqn: 'str'
    lun: 'int'
    targetPortal: 'str'
    chapAuthDiscovery: 'bool' = None
    chapAuthSession: 'bool' = None
    fsType: 'str' = None
    initiatorName: 'str' = None
    iscsiInterface: 'str' = None
    portals: 'List[str]' = None
    readOnly: 'bool' = None
    secretRef: 'SecretReference' = None


@dataclass
class ISCSIVolumeSource(DataclassDictMixIn):
    """Represents an ISCSI disk. ISCSI volumes can only be mounted as read/write
      once. ISCSI volumes support ownership management and SELinux relabeling.

      **parameters**

      * **iqn** ``str`` - Target iSCSI Qualified Name.
      * **lun** ``int`` - iSCSI Target Lun number.
      * **targetPortal** ``str`` - iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is
        other than default (typically TCP ports 860 and 3260).
      * **chapAuthDiscovery** ``bool`` - *(optional)* whether support iSCSI Discovery CHAP authentication
      * **chapAuthSession** ``bool`` - *(optional)* whether support iSCSI Session CHAP authentication
      * **fsType** ``str`` - *(optional)* Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#iscsi
      * **initiatorName** ``str`` - *(optional)* Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface
        simultaneously, new iSCSI interface <target portal>:<volume name> will be
        created for the connection.
      * **iscsiInterface** ``str`` - *(optional)* iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default'
        (tcp).
      * **portals** ``List[str]`` - *(optional)* iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the
        port is other than default (typically TCP ports 860 and 3260).
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false.
      * **secretRef** ``LocalObjectReference`` - *(optional)* CHAP Secret for iSCSI target and initiator authentication
    """
    iqn: 'str'
    lun: 'int'
    targetPortal: 'str'
    chapAuthDiscovery: 'bool' = None
    chapAuthSession: 'bool' = None
    fsType: 'str' = None
    initiatorName: 'str' = None
    iscsiInterface: 'str' = None
    portals: 'List[str]' = None
    readOnly: 'bool' = None
    secretRef: 'LocalObjectReference' = None


@dataclass
class KeyToPath(DataclassDictMixIn):
    """Maps a string key to a path within a volume.

      **parameters**

      * **key** ``str`` - The key to project.
      * **path** ``str`` - The relative path of the file to map the key to. May not be an absolute path.
        May not contain the path element '..'. May not start with the string '..'.
      * **mode** ``int`` - *(optional)* Optional: mode bits to use on this file, must be a value between 0 and 0777.
        If not specified, the volume defaultMode will be used. This might be in
        conflict with other options that affect the file mode, like fsGroup, and the
        result can be other mode bits set.
    """
    key: 'str'
    path: 'str'
    mode: 'int' = None


@dataclass
class Lifecycle(DataclassDictMixIn):
    """Lifecycle describes actions that the management system should take in response
      to container lifecycle events. For the PostStart and PreStop lifecycle
      handlers, management of the container blocks until the action is complete,
      unless the container process fails, in which case the handler is aborted.

      **parameters**

      * **postStart** ``Handler`` - *(optional)* PostStart is called immediately after a container is created. If the handler
        fails, the container is terminated and restarted according to its restart
        policy. Other management of the container blocks until the hook completes.
        More info:
        https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
      * **preStop** ``Handler`` - *(optional)* PreStop is called immediately before a container is terminated due to an API
        request or management event such as liveness/startup probe failure,
        preemption, resource contention, etc. The handler is not called if the
        container crashes or exits. The reason for termination is passed to the
        handler. The Pod's termination grace period countdown begins before the
        PreStop hooked is executed. Regardless of the outcome of the handler, the
        container will eventually terminate within the Pod's termination grace period.
        Other management of the container blocks until the hook completes or until the
        termination grace period is reached. More info:
        https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
    """
    postStart: 'Handler' = None
    preStop: 'Handler' = None


@dataclass
class LimitRange(DataclassDictMixIn):
    """LimitRange sets resource usage limits for each kind of resource in a
      Namespace.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``LimitRangeSpec`` - *(optional)* Spec defines the limits enforced. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'LimitRangeSpec' = None


@dataclass
class LimitRangeItem(DataclassDictMixIn):
    """LimitRangeItem defines a min/max usage limit for any resource that matches on
      kind.

      **parameters**

      * **default** ``dict`` - *(optional)* Default resource requirement limit value by resource name if resource limit is
        omitted.
      * **defaultRequest** ``dict`` - *(optional)* DefaultRequest is the default resource requirement request value by resource
        name if resource request is omitted.
      * **max** ``dict`` - *(optional)* Max usage constraints on this kind by resource name.
      * **maxLimitRequestRatio** ``dict`` - *(optional)* MaxLimitRequestRatio if specified, the named resource must have a request and
        limit that are both non-zero where limit divided by request is less than or
        equal to the enumerated value; this represents the max burst for the named
        resource.
      * **min** ``dict`` - *(optional)* Min usage constraints on this kind by resource name.
      * **type** ``str`` - *(optional)* Type of resource that this limit applies to.
    """
    default: 'dict' = None
    defaultRequest: 'dict' = None
    max: 'dict' = None
    maxLimitRequestRatio: 'dict' = None
    min: 'dict' = None
    type: 'str' = None


@dataclass
class LimitRangeList(DataclassDictMixIn):
    """LimitRangeList is a list of LimitRange items.

      **parameters**

      * **items** ``List[LimitRange]`` - Items is a list of LimitRange objects. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[LimitRange]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class LimitRangeSpec(DataclassDictMixIn):
    """LimitRangeSpec defines a min/max usage limit for resources that match on kind.

      **parameters**

      * **limits** ``List[LimitRangeItem]`` - Limits is the list of LimitRangeItem objects that are enforced.
    """
    limits: 'List[LimitRangeItem]'


@dataclass
class LoadBalancerIngress(DataclassDictMixIn):
    """LoadBalancerIngress represents the status of a load-balancer ingress point:
      traffic intended for the service should be sent to an ingress point.

      **parameters**

      * **hostname** ``str`` - *(optional)* Hostname is set for load-balancer ingress points that are DNS based (typically
        AWS load-balancers)
      * **ip** ``str`` - *(optional)* IP is set for load-balancer ingress points that are IP based (typically GCE or
        OpenStack load-balancers)
    """
    hostname: 'str' = None
    ip: 'str' = None


@dataclass
class LoadBalancerStatus(DataclassDictMixIn):
    """LoadBalancerStatus represents the status of a load-balancer.

      **parameters**

      * **ingress** ``List[LoadBalancerIngress]`` - *(optional)* Ingress is a list containing ingress points for the load-balancer. Traffic
        intended for the service should be sent to these ingress points.
    """
    ingress: 'List[LoadBalancerIngress]' = None


@dataclass
class LocalObjectReference(DataclassDictMixIn):
    """LocalObjectReference contains enough information to let you locate the
      referenced object inside the same namespace.

      **parameters**

      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
    """
    name: 'str' = None


@dataclass
class LocalVolumeSource(DataclassDictMixIn):
    """Local represents directly-attached storage with node affinity (Beta feature)

      **parameters**

      * **path** ``str`` - The full path to the volume on the node. It can be either a directory or block
        device (disk, partition, ...).
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. It applies only when the Path is a block device.
        Must be a filesystem type supported by the host operating system. Ex. "ext4",
        "xfs", "ntfs". The default value is to auto-select a fileystem if unspecified.
    """
    path: 'str'
    fsType: 'str' = None


@dataclass
class NFSVolumeSource(DataclassDictMixIn):
    """Represents an NFS mount that lasts the lifetime of a pod. NFS volumes do not
      support ownership management or SELinux relabeling.

      **parameters**

      * **path** ``str`` - Path that is exported by the NFS server. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#nfs
      * **server** ``str`` - Server is the hostname or IP address of the NFS server. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#nfs
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the NFS export to be mounted with read-only
        permissions. Defaults to false. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#nfs
    """
    path: 'str'
    server: 'str'
    readOnly: 'bool' = None


@dataclass
class Namespace(DataclassDictMixIn):
    """Namespace provides a scope for Names. Use of multiple namespaces is optional.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``NamespaceSpec`` - *(optional)* Spec defines the behavior of the Namespace. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``NamespaceStatus`` - *(optional)* Status describes the current status of a Namespace. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'NamespaceSpec' = None
    status: 'NamespaceStatus' = None


@dataclass
class NamespaceCondition(DataclassDictMixIn):
    """NamespaceCondition contains details about state of namespace.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of namespace controller condition.
      * **lastTransitionTime** ``meta_v1.Time`` - *(optional)* 
      * **message** ``str`` - *(optional)* 
      * **reason** ``str`` - *(optional)* 
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class NamespaceList(DataclassDictMixIn):
    """NamespaceList is a list of Namespaces.

      **parameters**

      * **items** ``List[Namespace]`` - Items is the list of Namespace objects in the list. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Namespace]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class NamespaceSpec(DataclassDictMixIn):
    """NamespaceSpec describes the attributes on a Namespace.

      **parameters**

      * **finalizers** ``List[str]`` - *(optional)* Finalizers is an opaque list of values that must be empty to permanently
        remove object from storage. More info:
        https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
    """
    finalizers: 'List[str]' = None


@dataclass
class NamespaceStatus(DataclassDictMixIn):
    """NamespaceStatus is information about the current status of a Namespace.

      **parameters**

      * **conditions** ``List[NamespaceCondition]`` - *(optional)* Represents the latest available observations of a namespace's current state.
      * **phase** ``str`` - *(optional)* Phase is the current lifecycle phase of the namespace. More info:
        https://kubernetes.io/docs/tasks/administer-cluster/namespaces/
    """
    conditions: 'List[NamespaceCondition]' = None
    phase: 'str' = None


@dataclass
class Node(DataclassDictMixIn):
    """Node is a worker node in Kubernetes. Each node will have a unique identifier
      in the cache (i.e. in etcd).

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``NodeSpec`` - *(optional)* Spec defines the behavior of a node.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``NodeStatus`` - *(optional)* Most recently observed status of the node. Populated by the system. Read-only.
        More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'NodeSpec' = None
    status: 'NodeStatus' = None


@dataclass
class NodeAddress(DataclassDictMixIn):
    """NodeAddress contains information for the node's address.

      **parameters**

      * **address** ``str`` - The node address.
      * **type** ``str`` - Node address type, one of Hostname, ExternalIP or InternalIP.
    """
    address: 'str'
    type: 'str'


@dataclass
class NodeAffinity(DataclassDictMixIn):
    """Node affinity is a group of node affinity scheduling rules.

      **parameters**

      * **preferredDuringSchedulingIgnoredDuringExecution** ``List[PreferredSchedulingTerm]`` - *(optional)* The scheduler will prefer to schedule pods to nodes that satisfy the affinity
        expressions specified by this field, but it may choose a node that violates
        one or more of the expressions. The node that is most preferred is the one
        with the greatest sum of weights, i.e. for each node that meets all of the
        scheduling requirements (resource request, requiredDuringScheduling affinity
        expressions, etc.), compute a sum by iterating through the elements of this
        field and adding "weight" to the sum if the node matches the corresponding
        matchExpressions; the node(s) with the highest sum are the most preferred.
      * **requiredDuringSchedulingIgnoredDuringExecution** ``NodeSelector`` - *(optional)* If the affinity requirements specified by this field are not met at scheduling
        time, the pod will not be scheduled onto the node. If the affinity
        requirements specified by this field cease to be met at some point during pod
        execution (e.g. due to an update), the system may or may not try to eventually
        evict the pod from its node.
    """
    preferredDuringSchedulingIgnoredDuringExecution: 'List[PreferredSchedulingTerm]' = None
    requiredDuringSchedulingIgnoredDuringExecution: 'NodeSelector' = None


@dataclass
class NodeCondition(DataclassDictMixIn):
    """NodeCondition contains condition information for a node.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of node condition.
      * **lastHeartbeatTime** ``meta_v1.Time`` - *(optional)* Last time we got an update on a given condition.
      * **lastTransitionTime** ``meta_v1.Time`` - *(optional)* Last time the condition transit from one status to another.
      * **message** ``str`` - *(optional)* Human readable message indicating details about last transition.
      * **reason** ``str`` - *(optional)* (brief) reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastHeartbeatTime: 'meta_v1.Time' = None
    lastTransitionTime: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class NodeConfigSource(DataclassDictMixIn):
    """NodeConfigSource specifies a source of node configuration. Exactly one
      subfield (excluding metadata) must be non-nil.

      **parameters**

      * **configMap** ``ConfigMapNodeConfigSource`` - *(optional)* ConfigMap is a reference to a Node's ConfigMap
    """
    configMap: 'ConfigMapNodeConfigSource' = None


@dataclass
class NodeConfigStatus(DataclassDictMixIn):
    """NodeConfigStatus describes the status of the config assigned by
      Node.Spec.ConfigSource.

      **parameters**

      * **active** ``NodeConfigSource`` - *(optional)* Active reports the checkpointed config the node is actively using. Active will
        represent either the current version of the Assigned config, or the current
        LastKnownGood config, depending on whether attempting to use the Assigned
        config results in an error.
      * **assigned** ``NodeConfigSource`` - *(optional)* Assigned reports the checkpointed config the node will try to use. When
        Node.Spec.ConfigSource is updated, the node checkpoints the associated config
        payload to local disk, along with a record indicating intended config. The
        node refers to this record to choose its config checkpoint, and reports this
        record in Assigned. Assigned only updates in the status after the record has
        been checkpointed to disk. When the Kubelet is restarted, it tries to make the
        Assigned config the Active config by loading and validating the checkpointed
        payload identified by Assigned.
      * **error** ``str`` - *(optional)* Error describes any problems reconciling the Spec.ConfigSource to the Active
        config. Errors may occur, for example, attempting to checkpoint
        Spec.ConfigSource to the local Assigned record, attempting to checkpoint the
        payload associated with Spec.ConfigSource, attempting to load or validate the
        Assigned config, etc. Errors may occur at different points while syncing
        config. Earlier errors (e.g. download or checkpointing errors) will not result
        in a rollback to LastKnownGood, and may resolve across Kubelet retries. Later
        errors (e.g. loading or validating a checkpointed config) will result in a
        rollback to LastKnownGood. In the latter case, it is usually possible to
        resolve the error by fixing the config assigned in Spec.ConfigSource. You can
        find additional information for debugging by searching the error message in
        the Kubelet log. Error is a human-readable description of the error state;
        machines can check whether or not Error is empty, but should not rely on the
        stability of the Error text across Kubelet versions.
      * **lastKnownGood** ``NodeConfigSource`` - *(optional)* LastKnownGood reports the checkpointed config the node will fall back to when
        it encounters an error attempting to use the Assigned config. The Assigned
        config becomes the LastKnownGood config when the node determines that the
        Assigned config is stable and correct. This is currently implemented as a
        10-minute soak period starting when the local record of Assigned config is
        updated. If the Assigned config is Active at the end of this period, it
        becomes the LastKnownGood. Note that if Spec.ConfigSource is reset to nil (use
        local defaults), the LastKnownGood is also immediately reset to nil, because
        the local default config is always assumed good. You should not make
        assumptions about the node's method of determining config stability and
        correctness, as this may change or become configurable in the future.
    """
    active: 'NodeConfigSource' = None
    assigned: 'NodeConfigSource' = None
    error: 'str' = None
    lastKnownGood: 'NodeConfigSource' = None


@dataclass
class NodeDaemonEndpoints(DataclassDictMixIn):
    """NodeDaemonEndpoints lists ports opened by daemons running on the Node.

      **parameters**

      * **kubeletEndpoint** ``DaemonEndpoint`` - *(optional)* Endpoint on which Kubelet is listening.
    """
    kubeletEndpoint: 'DaemonEndpoint' = None


@dataclass
class NodeList(DataclassDictMixIn):
    """NodeList is the whole list of all Nodes which have been registered with
      master.

      **parameters**

      * **items** ``List[Node]`` - List of nodes
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Node]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class NodeSelector(DataclassDictMixIn):
    """A node selector represents the union of the results of one or more label
      queries over a set of nodes; that is, it represents the OR of the selectors
      represented by the node selector terms.

      **parameters**

      * **nodeSelectorTerms** ``List[NodeSelectorTerm]`` - Required. A list of node selector terms. The terms are ORed.
    """
    nodeSelectorTerms: 'List[NodeSelectorTerm]'


@dataclass
class NodeSelectorRequirement(DataclassDictMixIn):
    """A node selector requirement is a selector that contains values, a key, and an
      operator that relates the key and values.

      **parameters**

      * **key** ``str`` - The label key that the selector applies to.
      * **operator** ``str`` - Represents a key's relationship to a set of values. Valid operators are In,
        NotIn, Exists, DoesNotExist. Gt, and Lt.
      * **values** ``List[str]`` - *(optional)* An array of string values. If the operator is In or NotIn, the values array
        must be non-empty. If the operator is Exists or DoesNotExist, the values array
        must be empty. If the operator is Gt or Lt, the values array must have a
        single element, which will be interpreted as an integer. This array is
        replaced during a strategic merge patch.
    """
    key: 'str'
    operator: 'str'
    values: 'List[str]' = None


@dataclass
class NodeSelectorTerm(DataclassDictMixIn):
    """A null or empty node selector term matches no objects. The requirements of
      them are ANDed. The TopologySelectorTerm type implements a subset of the
      NodeSelectorTerm.

      **parameters**

      * **matchExpressions** ``List[NodeSelectorRequirement]`` - *(optional)* A list of node selector requirements by node's labels.
      * **matchFields** ``List[NodeSelectorRequirement]`` - *(optional)* A list of node selector requirements by node's fields.
    """
    matchExpressions: 'List[NodeSelectorRequirement]' = None
    matchFields: 'List[NodeSelectorRequirement]' = None


@dataclass
class NodeSpec(DataclassDictMixIn):
    """NodeSpec describes the attributes that a node is created with.

      **parameters**

      * **configSource** ``NodeConfigSource`` - *(optional)* If specified, the source to get node configuration from The
        DynamicKubeletConfig feature gate must be enabled for the Kubelet to use this
        field
      * **externalID** ``str`` - *(optional)* Deprecated. Not all kubelets will set this field. Remove field after 1.13.
        see: https://issues.k8s.io/61966
      * **podCIDR** ``str`` - *(optional)* PodCIDR represents the pod IP range assigned to the node.
      * **podCIDRs** ``List[str]`` - *(optional)* podCIDRs represents the IP ranges assigned to the node for usage by Pods on
        that node. If this field is specified, the 0th entry must match the podCIDR
        field. It may contain at most 1 value for each of IPv4 and IPv6.
      * **providerID** ``str`` - *(optional)* ID of the node assigned by the cloud provider in the format:
        <ProviderName>://<ProviderSpecificNodeID>
      * **taints** ``List[Taint]`` - *(optional)* If specified, the node's taints.
      * **unschedulable** ``bool`` - *(optional)* Unschedulable controls node schedulability of new pods. By default, node is
        schedulable. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#manual-node-administration
    """
    configSource: 'NodeConfigSource' = None
    externalID: 'str' = None
    podCIDR: 'str' = None
    podCIDRs: 'List[str]' = None
    providerID: 'str' = None
    taints: 'List[Taint]' = None
    unschedulable: 'bool' = None


@dataclass
class NodeStatus(DataclassDictMixIn):
    """NodeStatus is information about the current status of a node.

      **parameters**

      * **addresses** ``List[NodeAddress]`` - *(optional)* List of addresses reachable to the node. Queried from cloud provider, if
        available. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#addresses Note: This field is
        declared as mergeable, but the merge key is not sufficiently unique, which can
        cause data corruption when it is merged. Callers should instead use a
        full-replacement patch. See http://pr.k8s.io/79391 for an example.
      * **allocatable** ``dict`` - *(optional)* Allocatable represents the resources of a node that are available for
        scheduling. Defaults to Capacity.
      * **capacity** ``dict`` - *(optional)* Capacity represents the total resources of a node. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
      * **conditions** ``List[NodeCondition]`` - *(optional)* Conditions is an array of current observed node conditions. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#condition
      * **config** ``NodeConfigStatus`` - *(optional)* Status of the config assigned to the node via the dynamic Kubelet config
        feature.
      * **daemonEndpoints** ``NodeDaemonEndpoints`` - *(optional)* Endpoints of daemons running on the Node.
      * **images** ``List[ContainerImage]`` - *(optional)* List of container images on this node
      * **nodeInfo** ``NodeSystemInfo`` - *(optional)* Set of ids/uuids to uniquely identify the node. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#info
      * **phase** ``str`` - *(optional)* NodePhase is the recently observed lifecycle phase of the node. More info:
        https://kubernetes.io/docs/concepts/nodes/node/#phase The field is never
        populated, and now is deprecated.
      * **volumesAttached** ``List[AttachedVolume]`` - *(optional)* List of volumes that are attached to the node.
      * **volumesInUse** ``List[str]`` - *(optional)* List of attachable volumes in use (mounted) by the node.
    """
    addresses: 'List[NodeAddress]' = None
    allocatable: 'dict' = None
    capacity: 'dict' = None
    conditions: 'List[NodeCondition]' = None
    config: 'NodeConfigStatus' = None
    daemonEndpoints: 'NodeDaemonEndpoints' = None
    images: 'List[ContainerImage]' = None
    nodeInfo: 'NodeSystemInfo' = None
    phase: 'str' = None
    volumesAttached: 'List[AttachedVolume]' = None
    volumesInUse: 'List[str]' = None


@dataclass
class NodeSystemInfo(DataclassDictMixIn):
    """NodeSystemInfo is a set of ids/uuids to uniquely identify the node.

      **parameters**

      * **architecture** ``str`` - The Architecture reported by the node
      * **bootID** ``str`` - Boot ID reported by the node.
      * **containerRuntimeVersion** ``str`` - ContainerRuntime Version reported by the node through runtime remote API (e.g.
        docker://1.5.0).
      * **kernelVersion** ``str`` - Kernel Version reported by the node from 'uname -r' (e.g.
        3.16.0-0.bpo.4-amd64).
      * **kubeProxyVersion** ``str`` - KubeProxy Version reported by the node.
      * **kubeletVersion** ``str`` - Kubelet Version reported by the node.
      * **machineID** ``str`` - MachineID reported by the node. For unique machine identification in the
        cluster this field is preferred. Learn more from man(5) machine-id:
        http://man7.org/linux/man-pages/man5/machine-id.5.html
      * **operatingSystem** ``str`` - The Operating System reported by the node
      * **osImage** ``str`` - OS Image reported by the node from /etc/os-release (e.g. Debian GNU/Linux 7
        (wheezy)).
      * **systemUUID** ``str`` - SystemUUID reported by the node. For unique machine identification MachineID
        is preferred. This field is specific to Red Hat hosts
        https://access.redhat.com/documentation/en-US/Red_Hat_Subscription_Management/1/html/RHSM/getting-system-uuid.html
    """
    architecture: 'str'
    bootID: 'str'
    containerRuntimeVersion: 'str'
    kernelVersion: 'str'
    kubeProxyVersion: 'str'
    kubeletVersion: 'str'
    machineID: 'str'
    operatingSystem: 'str'
    osImage: 'str'
    systemUUID: 'str'


@dataclass
class ObjectFieldSelector(DataclassDictMixIn):
    """ObjectFieldSelector selects an APIVersioned field of an object.

      **parameters**

      * **fieldPath** ``str`` - Path of the field to select in the specified API version.
      * **apiVersion** ``str`` - *(optional)* Version of the schema the FieldPath is written in terms of, defaults to "v1".
    """
    fieldPath: 'str'
    apiVersion: 'str' = None


@dataclass
class ObjectReference(DataclassDictMixIn):
    """ObjectReference contains enough information to let you inspect or modify the
      referred object.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* API version of the referent.
      * **fieldPath** ``str`` - *(optional)* If referring to a piece of an object instead of an entire object, this string
        should contain a valid JSON/Go field access statement, such as
        desiredState.manifest.containers[2]. For example, if the object reference is
        to a container within a pod, this would take on a value like:
        "spec.containers{name}" (where "name" refers to the name of the container that
        triggered the event) or if no container name is specified "spec.containers[2]"
        (container with index 2 in this pod). This syntax is chosen only to have some
        well-defined way of referencing a part of an object.
      * **kind** ``str`` - *(optional)* Kind of the referent. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **namespace** ``str`` - *(optional)* Namespace of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/
      * **resourceVersion** ``str`` - *(optional)* Specific resourceVersion to which this reference is made, if any. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#concurrency-control-and-consistency
      * **uid** ``str`` - *(optional)* UID of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#uids
    """
    apiVersion: 'str' = None
    fieldPath: 'str' = None
    kind: 'str' = None
    name: 'str' = None
    namespace: 'str' = None
    resourceVersion: 'str' = None
    uid: 'str' = None


@dataclass
class PersistentVolume(DataclassDictMixIn):
    """PersistentVolume (PV) is a storage resource provisioned by an administrator.
      It is analogous to a node. More info:
      https://kubernetes.io/docs/concepts/storage/persistent-volumes

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``PersistentVolumeSpec`` - *(optional)* Spec defines a specification of a persistent volume owned by the cluster.
        Provisioned by an administrator. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
      * **status** ``PersistentVolumeStatus`` - *(optional)* Status represents the current information/status for the persistent volume.
        Populated by the system. Read-only. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistent-volumes
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'PersistentVolumeSpec' = None
    status: 'PersistentVolumeStatus' = None


@dataclass
class PersistentVolumeClaim(DataclassDictMixIn):
    """PersistentVolumeClaim is a user's request for and claim to a persistent volume

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``PersistentVolumeClaimSpec`` - *(optional)* Spec defines the desired characteristics of a volume requested by a pod
        author. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
      * **status** ``PersistentVolumeClaimStatus`` - *(optional)* Status represents the current information/status of a persistent volume claim.
        Read-only. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'PersistentVolumeClaimSpec' = None
    status: 'PersistentVolumeClaimStatus' = None


@dataclass
class PersistentVolumeClaimCondition(DataclassDictMixIn):
    """PersistentVolumeClaimCondition contails details about state of pvc

      **parameters**

      * **status** ``str`` - 
      * **type** ``str`` - 
      * **lastProbeTime** ``meta_v1.Time`` - *(optional)* Last time we probed the condition.
      * **lastTransitionTime** ``meta_v1.Time`` - *(optional)* Last time the condition transitioned from one status to another.
      * **message** ``str`` - *(optional)* Human-readable message indicating details about last transition.
      * **reason** ``str`` - *(optional)* Unique, this should be a short, machine understandable string that gives the
        reason for condition's last transition. If it reports "ResizeStarted" that
        means the underlying persistent volume is being resized.
    """
    status: 'str'
    type: 'str'
    lastProbeTime: 'meta_v1.Time' = None
    lastTransitionTime: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class PersistentVolumeClaimList(DataclassDictMixIn):
    """PersistentVolumeClaimList is a list of PersistentVolumeClaim items.

      **parameters**

      * **items** ``List[PersistentVolumeClaim]`` - A list of persistent volume claims. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[PersistentVolumeClaim]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class PersistentVolumeClaimSpec(DataclassDictMixIn):
    """PersistentVolumeClaimSpec describes the common attributes of storage devices
      and allows a Source for provider-specific attributes

      **parameters**

      * **accessModes** ``List[str]`` - *(optional)* AccessModes contains the desired access modes the volume should have. More
        info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
      * **dataSource** ``TypedLocalObjectReference`` - *(optional)* This field requires the VolumeSnapshotDataSource alpha feature gate to be
        enabled and currently VolumeSnapshot is the only supported data source. If the
        provisioner can support VolumeSnapshot data source, it will create a new
        volume and data will be restored to the volume at the same time. If the
        provisioner does not support VolumeSnapshot data source, volume will not be
        created and the failure will be reported as an event. In the future, we plan
        to support more data source types and the behavior of the provisioner may
        change.
      * **resources** ``ResourceRequirements`` - *(optional)* Resources represents the minimum resources the volume should have. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
      * **selector** ``meta_v1.LabelSelector`` - *(optional)* A label query over volumes to consider for binding.
      * **storageClassName** ``str`` - *(optional)* Name of the StorageClass required by the claim. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
      * **volumeMode** ``str`` - *(optional)* volumeMode defines what type of volume is required by the claim. Value of
        Filesystem is implied when not included in claim spec. This is a beta feature.
      * **volumeName** ``str`` - *(optional)* VolumeName is the binding reference to the PersistentVolume backing this
        claim.
    """
    accessModes: 'List[str]' = None
    dataSource: 'TypedLocalObjectReference' = None
    resources: 'ResourceRequirements' = None
    selector: 'meta_v1.LabelSelector' = None
    storageClassName: 'str' = None
    volumeMode: 'str' = None
    volumeName: 'str' = None


@dataclass
class PersistentVolumeClaimStatus(DataclassDictMixIn):
    """PersistentVolumeClaimStatus is the current status of a persistent volume
      claim.

      **parameters**

      * **accessModes** ``List[str]`` - *(optional)* AccessModes contains the actual access modes the volume backing the PVC has.
        More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
      * **capacity** ``dict`` - *(optional)* Represents the actual resources of the underlying volume.
      * **conditions** ``List[PersistentVolumeClaimCondition]`` - *(optional)* Current Condition of persistent volume claim. If underlying persistent volume
        is being resized then the Condition will be set to 'ResizeStarted'.
      * **phase** ``str`` - *(optional)* Phase represents the current phase of PersistentVolumeClaim.
    """
    accessModes: 'List[str]' = None
    capacity: 'dict' = None
    conditions: 'List[PersistentVolumeClaimCondition]' = None
    phase: 'str' = None


@dataclass
class PersistentVolumeClaimVolumeSource(DataclassDictMixIn):
    """PersistentVolumeClaimVolumeSource references the user's PVC in the same
      namespace. This volume finds the bound PV and mounts that volume for the pod.
      A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another
      type of volume that is owned by someone else (the system).

      **parameters**

      * **claimName** ``str`` - ClaimName is the name of a PersistentVolumeClaim in the same namespace as the
        pod using this volume. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
      * **readOnly** ``bool`` - *(optional)* Will force the ReadOnly setting in VolumeMounts. Default false.
    """
    claimName: 'str'
    readOnly: 'bool' = None


@dataclass
class PersistentVolumeList(DataclassDictMixIn):
    """PersistentVolumeList is a list of PersistentVolume items.

      **parameters**

      * **items** ``List[PersistentVolume]`` - List of persistent volumes. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[PersistentVolume]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class PersistentVolumeSpec(DataclassDictMixIn):
    """PersistentVolumeSpec is the specification of a persistent volume.

      **parameters**

      * **accessModes** ``List[str]`` - *(optional)* AccessModes contains all ways the volume can be mounted. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes
      * **awsElasticBlockStore** ``AWSElasticBlockStoreVolumeSource`` - *(optional)* AWSElasticBlockStore represents an AWS Disk resource that is attached to a
        kubelet's host machine and then exposed to the pod. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
      * **azureDisk** ``AzureDiskVolumeSource`` - *(optional)* AzureDisk represents an Azure Data Disk mount on the host and bind mount to
        the pod.
      * **azureFile** ``AzureFilePersistentVolumeSource`` - *(optional)* AzureFile represents an Azure File Service mount on the host and bind mount to
        the pod.
      * **capacity** ``dict`` - *(optional)* A description of the persistent volume's resources and capacity. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#capacity
      * **cephfs** ``CephFSPersistentVolumeSource`` - *(optional)* CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
      * **cinder** ``CinderPersistentVolumeSource`` - *(optional)* Cinder represents a cinder volume attached and mounted on kubelets host
        machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
      * **claimRef** ``ObjectReference`` - *(optional)* ClaimRef is part of a bi-directional binding between PersistentVolume and
        PersistentVolumeClaim. Expected to be non-nil when bound. claim.VolumeName is
        the authoritative bind between PV and PVC. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#binding
      * **csi** ``CSIPersistentVolumeSource`` - *(optional)* CSI represents storage that is handled by an external CSI driver (Beta
        feature).
      * **fc** ``FCVolumeSource`` - *(optional)* FC represents a Fibre Channel resource that is attached to a kubelet's host
        machine and then exposed to the pod.
      * **flexVolume** ``FlexPersistentVolumeSource`` - *(optional)* FlexVolume represents a generic volume resource that is provisioned/attached
        using an exec based plugin.
      * **flocker** ``FlockerVolumeSource`` - *(optional)* Flocker represents a Flocker volume attached to a kubelet's host machine and
        exposed to the pod for its usage. This depends on the Flocker control service
        being running
      * **gcePersistentDisk** ``GCEPersistentDiskVolumeSource`` - *(optional)* GCEPersistentDisk represents a GCE Disk resource that is attached to a
        kubelet's host machine and then exposed to the pod. Provisioned by an admin.
        More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **glusterfs** ``GlusterfsPersistentVolumeSource`` - *(optional)* Glusterfs represents a Glusterfs volume that is attached to a host and exposed
        to the pod. Provisioned by an admin. More info:
        https://examples.k8s.io/volumes/glusterfs/README.md
      * **hostPath** ``HostPathVolumeSource`` - *(optional)* HostPath represents a directory on the host. Provisioned by a developer or
        tester. This is useful for single-node development and testing only! On-host
        storage is not supported in any way and WILL NOT WORK in a multi-node cluster.
        More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
      * **iscsi** ``ISCSIPersistentVolumeSource`` - *(optional)* ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host
        machine and then exposed to the pod. Provisioned by an admin.
      * **local** ``LocalVolumeSource`` - *(optional)* Local represents directly-attached storage with node affinity
      * **mountOptions** ``List[str]`` - *(optional)* A list of mount options, e.g. ["ro", "soft"]. Not validated - mount will
        simply fail if one is invalid. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes/#mount-options
      * **nfs** ``NFSVolumeSource`` - *(optional)* NFS represents an NFS mount on the host. Provisioned by an admin. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#nfs
      * **nodeAffinity** ``VolumeNodeAffinity`` - *(optional)* NodeAffinity defines constraints that limit what nodes this volume can be
        accessed from. This field influences the scheduling of pods that use this
        volume.
      * **persistentVolumeReclaimPolicy** ``str`` - *(optional)* What happens to a persistent volume when released from its claim. Valid
        options are Retain (default for manually created PersistentVolumes), Delete
        (default for dynamically provisioned PersistentVolumes), and Recycle
        (deprecated). Recycle must be supported by the volume plugin underlying this
        PersistentVolume. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#reclaiming
      * **photonPersistentDisk** ``PhotonPersistentDiskVolumeSource`` - *(optional)* PhotonPersistentDisk represents a PhotonController persistent disk attached
        and mounted on kubelets host machine
      * **portworxVolume** ``PortworxVolumeSource`` - *(optional)* PortworxVolume represents a portworx volume attached and mounted on kubelets
        host machine
      * **quobyte** ``QuobyteVolumeSource`` - *(optional)* Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
      * **rbd** ``RBDPersistentVolumeSource`` - *(optional)* RBD represents a Rados Block Device mount on the host that shares a pod's
        lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
      * **scaleIO** ``ScaleIOPersistentVolumeSource`` - *(optional)* ScaleIO represents a ScaleIO persistent volume attached and mounted on
        Kubernetes nodes.
      * **storageClassName** ``str`` - *(optional)* Name of StorageClass to which this persistent volume belongs. Empty value
        means that this volume does not belong to any StorageClass.
      * **storageos** ``StorageOSPersistentVolumeSource`` - *(optional)* StorageOS represents a StorageOS volume that is attached to the kubelet's host
        machine and mounted into the pod More info:
        https://examples.k8s.io/volumes/storageos/README.md
      * **volumeMode** ``str`` - *(optional)* volumeMode defines if a volume is intended to be used with a formatted
        filesystem or to remain in raw block state. Value of Filesystem is implied
        when not included in spec. This is a beta feature.
      * **vsphereVolume** ``VsphereVirtualDiskVolumeSource`` - *(optional)* VsphereVolume represents a vSphere volume attached and mounted on kubelets
        host machine
    """
    accessModes: 'List[str]' = None
    awsElasticBlockStore: 'AWSElasticBlockStoreVolumeSource' = None
    azureDisk: 'AzureDiskVolumeSource' = None
    azureFile: 'AzureFilePersistentVolumeSource' = None
    capacity: 'dict' = None
    cephfs: 'CephFSPersistentVolumeSource' = None
    cinder: 'CinderPersistentVolumeSource' = None
    claimRef: 'ObjectReference' = None
    csi: 'CSIPersistentVolumeSource' = None
    fc: 'FCVolumeSource' = None
    flexVolume: 'FlexPersistentVolumeSource' = None
    flocker: 'FlockerVolumeSource' = None
    gcePersistentDisk: 'GCEPersistentDiskVolumeSource' = None
    glusterfs: 'GlusterfsPersistentVolumeSource' = None
    hostPath: 'HostPathVolumeSource' = None
    iscsi: 'ISCSIPersistentVolumeSource' = None
    local: 'LocalVolumeSource' = None
    mountOptions: 'List[str]' = None
    nfs: 'NFSVolumeSource' = None
    nodeAffinity: 'VolumeNodeAffinity' = None
    persistentVolumeReclaimPolicy: 'str' = None
    photonPersistentDisk: 'PhotonPersistentDiskVolumeSource' = None
    portworxVolume: 'PortworxVolumeSource' = None
    quobyte: 'QuobyteVolumeSource' = None
    rbd: 'RBDPersistentVolumeSource' = None
    scaleIO: 'ScaleIOPersistentVolumeSource' = None
    storageClassName: 'str' = None
    storageos: 'StorageOSPersistentVolumeSource' = None
    volumeMode: 'str' = None
    vsphereVolume: 'VsphereVirtualDiskVolumeSource' = None


@dataclass
class PersistentVolumeStatus(DataclassDictMixIn):
    """PersistentVolumeStatus is the current status of a persistent volume.

      **parameters**

      * **message** ``str`` - *(optional)* A human-readable message indicating details about why the volume is in this
        state.
      * **phase** ``str`` - *(optional)* Phase indicates if a volume is available, bound to a claim, or released by a
        claim. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#phase
      * **reason** ``str`` - *(optional)* Reason is a brief CamelCase string that describes any failure and is meant for
        machine parsing and tidy display in the CLI.
    """
    message: 'str' = None
    phase: 'str' = None
    reason: 'str' = None


@dataclass
class PhotonPersistentDiskVolumeSource(DataclassDictMixIn):
    """Represents a Photon Controller persistent disk resource.

      **parameters**

      * **pdID** ``str`` - ID that identifies Photon Controller persistent disk
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
    """
    pdID: 'str'
    fsType: 'str' = None


@dataclass
class Pod(DataclassDictMixIn):
    """Pod is a collection of containers that can run on a host. This resource is
      created by clients and scheduled onto hosts.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``PodSpec`` - *(optional)* Specification of the desired behavior of the pod. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``PodStatus`` - *(optional)* Most recently observed status of the pod. This data may not be up to date.
        Populated by the system. Read-only. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'PodSpec' = None
    status: 'PodStatus' = None


@dataclass
class PodAffinity(DataclassDictMixIn):
    """Pod affinity is a group of inter pod affinity scheduling rules.

      **parameters**

      * **preferredDuringSchedulingIgnoredDuringExecution** ``List[WeightedPodAffinityTerm]`` - *(optional)* The scheduler will prefer to schedule pods to nodes that satisfy the affinity
        expressions specified by this field, but it may choose a node that violates
        one or more of the expressions. The node that is most preferred is the one
        with the greatest sum of weights, i.e. for each node that meets all of the
        scheduling requirements (resource request, requiredDuringScheduling affinity
        expressions, etc.), compute a sum by iterating through the elements of this
        field and adding "weight" to the sum if the node has pods which matches the
        corresponding podAffinityTerm; the node(s) with the highest sum are the most
        preferred.
      * **requiredDuringSchedulingIgnoredDuringExecution** ``List[PodAffinityTerm]`` - *(optional)* If the affinity requirements specified by this field are not met at scheduling
        time, the pod will not be scheduled onto the node. If the affinity
        requirements specified by this field cease to be met at some point during pod
        execution (e.g. due to a pod label update), the system may or may not try to
        eventually evict the pod from its node. When there are multiple elements, the
        lists of nodes corresponding to each podAffinityTerm are intersected, i.e. all
        terms must be satisfied.
    """
    preferredDuringSchedulingIgnoredDuringExecution: 'List[WeightedPodAffinityTerm]' = None
    requiredDuringSchedulingIgnoredDuringExecution: 'List[PodAffinityTerm]' = None


@dataclass
class PodAffinityTerm(DataclassDictMixIn):
    """Defines a set of pods (namely those matching the labelSelector relative to the
      given namespace(s)) that this pod should be co-located (affinity) or not
      co-located (anti-affinity) with, where co-located is defined as running on a
      node whose value of the label with key <topologyKey> matches that of any node
      on which a pod of the set of pods is running

      **parameters**

      * **topologyKey** ``str`` - This pod should be co-located (affinity) or not co-located (anti-affinity)
        with the pods matching the labelSelector in the specified namespaces, where
        co-located is defined as running on a node whose value of the label with key
        topologyKey matches that of any node on which any of the selected pods is
        running. Empty topologyKey is not allowed.
      * **labelSelector** ``meta_v1.LabelSelector`` - *(optional)* A label query over a set of resources, in this case pods.
      * **namespaces** ``List[str]`` - *(optional)* namespaces specifies which namespaces the labelSelector applies to (matches
        against); null or empty list means "this pod's namespace"
    """
    topologyKey: 'str'
    labelSelector: 'meta_v1.LabelSelector' = None
    namespaces: 'List[str]' = None


@dataclass
class PodAntiAffinity(DataclassDictMixIn):
    """Pod anti affinity is a group of inter pod anti affinity scheduling rules.

      **parameters**

      * **preferredDuringSchedulingIgnoredDuringExecution** ``List[WeightedPodAffinityTerm]`` - *(optional)* The scheduler will prefer to schedule pods to nodes that satisfy the
        anti-affinity expressions specified by this field, but it may choose a node
        that violates one or more of the expressions. The node that is most preferred
        is the one with the greatest sum of weights, i.e. for each node that meets all
        of the scheduling requirements (resource request, requiredDuringScheduling
        anti-affinity expressions, etc.), compute a sum by iterating through the
        elements of this field and adding "weight" to the sum if the node has pods
        which matches the corresponding podAffinityTerm; the node(s) with the highest
        sum are the most preferred.
      * **requiredDuringSchedulingIgnoredDuringExecution** ``List[PodAffinityTerm]`` - *(optional)* If the anti-affinity requirements specified by this field are not met at
        scheduling time, the pod will not be scheduled onto the node. If the
        anti-affinity requirements specified by this field cease to be met at some
        point during pod execution (e.g. due to a pod label update), the system may or
        may not try to eventually evict the pod from its node. When there are multiple
        elements, the lists of nodes corresponding to each podAffinityTerm are
        intersected, i.e. all terms must be satisfied.
    """
    preferredDuringSchedulingIgnoredDuringExecution: 'List[WeightedPodAffinityTerm]' = None
    requiredDuringSchedulingIgnoredDuringExecution: 'List[PodAffinityTerm]' = None


@dataclass
class PodCondition(DataclassDictMixIn):
    """PodCondition contains details for the current condition of this pod.

      **parameters**

      * **status** ``str`` - Status is the status of the condition. Can be True, False, Unknown. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
      * **type** ``str`` - Type is the type of the condition. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
      * **lastProbeTime** ``meta_v1.Time`` - *(optional)* Last time we probed the condition.
      * **lastTransitionTime** ``meta_v1.Time`` - *(optional)* Last time the condition transitioned from one status to another.
      * **message** ``str`` - *(optional)* Human-readable message indicating details about last transition.
      * **reason** ``str`` - *(optional)* Unique, one-word, CamelCase reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastProbeTime: 'meta_v1.Time' = None
    lastTransitionTime: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class PodDNSConfig(DataclassDictMixIn):
    """PodDNSConfig defines the DNS parameters of a pod in addition to those
      generated from DNSPolicy.

      **parameters**

      * **nameservers** ``List[str]`` - *(optional)* A list of DNS name server IP addresses. This will be appended to the base
        nameservers generated from DNSPolicy. Duplicated nameservers will be removed.
      * **options** ``List[PodDNSConfigOption]`` - *(optional)* A list of DNS resolver options. This will be merged with the base options
        generated from DNSPolicy. Duplicated entries will be removed. Resolution
        options given in Options will override those that appear in the base
        DNSPolicy.
      * **searches** ``List[str]`` - *(optional)* A list of DNS search domains for host-name lookup. This will be appended to
        the base search paths generated from DNSPolicy. Duplicated search paths will
        be removed.
    """
    nameservers: 'List[str]' = None
    options: 'List[PodDNSConfigOption]' = None
    searches: 'List[str]' = None


@dataclass
class PodDNSConfigOption(DataclassDictMixIn):
    """PodDNSConfigOption defines DNS resolver options of a pod.

      **parameters**

      * **name** ``str`` - *(optional)* Required.
      * **value** ``str`` - *(optional)* 
    """
    name: 'str' = None
    value: 'str' = None


@dataclass
class PodIP(DataclassDictMixIn):
    """IP address information for entries in the (plural) PodIPs field. Each entry
      includes:
         IP: An IP address allocated to the pod. Routable at least within the
      cluster.

      **parameters**

      * **ip** ``str`` - *(optional)* ip is an IP address (IPv4 or IPv6) assigned to the pod
    """
    ip: 'str' = None


@dataclass
class PodList(DataclassDictMixIn):
    """PodList is a list of Pods.

      **parameters**

      * **items** ``List[Pod]`` - List of pods. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Pod]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class PodReadinessGate(DataclassDictMixIn):
    """PodReadinessGate contains the reference to a pod condition

      **parameters**

      * **conditionType** ``str`` - ConditionType refers to a condition in the pod's condition list with matching
        type.
    """
    conditionType: 'str'


@dataclass
class PodSecurityContext(DataclassDictMixIn):
    """PodSecurityContext holds pod-level security attributes and common container
      settings. Some fields are also present in container.securityContext.  Field
      values of container.securityContext take precedence over field values of
      PodSecurityContext.

      **parameters**

      * **fsGroup** ``int`` - *(optional)* A special supplemental group that applies to all containers in a pod. Some
        volume types allow the Kubelet to change the ownership of that volume to be
        owned by the pod:
        1. The owning GID will be the FSGroup 2. The setgid bit is set (new files
        created in the volume will be owned by FSGroup) 3. The permission bits are
        OR'd with rw-rw----
        If unset, the Kubelet will not modify the ownership and permissions of any
        volume.
      * **runAsGroup** ``int`` - *(optional)* The GID to run the entrypoint of the container process. Uses runtime default
        if unset. May also be set in SecurityContext.  If set in both SecurityContext
        and PodSecurityContext, the value specified in SecurityContext takes
        precedence for that container.
      * **runAsNonRoot** ``bool`` - *(optional)* Indicates that the container must run as a non-root user. If true, the Kubelet
        will validate the image at runtime to ensure that it does not run as UID 0
        (root) and fail to start the container if it does. If unset or false, no such
        validation will be performed. May also be set in SecurityContext.  If set in
        both SecurityContext and PodSecurityContext, the value specified in
        SecurityContext takes precedence.
      * **runAsUser** ``int`` - *(optional)* The UID to run the entrypoint of the container process. Defaults to user
        specified in image metadata if unspecified. May also be set in
        SecurityContext.  If set in both SecurityContext and PodSecurityContext, the
        value specified in SecurityContext takes precedence for that container.
      * **seLinuxOptions** ``SELinuxOptions`` - *(optional)* The SELinux context to be applied to all containers. If unspecified, the
        container runtime will allocate a random SELinux context for each container.
        May also be set in SecurityContext.  If set in both SecurityContext and
        PodSecurityContext, the value specified in SecurityContext takes precedence
        for that container.
      * **supplementalGroups** ``List[int]`` - *(optional)* A list of groups applied to the first process run in each container, in
        addition to the container's primary GID.  If unspecified, no groups will be
        added to any container.
      * **sysctls** ``List[Sysctl]`` - *(optional)* Sysctls hold a list of namespaced sysctls used for the pod. Pods with
        unsupported sysctls (by the container runtime) might fail to launch.
      * **windowsOptions** ``WindowsSecurityContextOptions`` - *(optional)* The Windows specific settings applied to all containers. If unspecified, the
        options within a container's SecurityContext will be used. If set in both
        SecurityContext and PodSecurityContext, the value specified in SecurityContext
        takes precedence.
    """
    fsGroup: 'int' = None
    runAsGroup: 'int' = None
    runAsNonRoot: 'bool' = None
    runAsUser: 'int' = None
    seLinuxOptions: 'SELinuxOptions' = None
    supplementalGroups: 'List[int]' = None
    sysctls: 'List[Sysctl]' = None
    windowsOptions: 'WindowsSecurityContextOptions' = None


@dataclass
class PodSpec(DataclassDictMixIn):
    """PodSpec is a description of a pod.

      **parameters**

      * **containers** ``List[Container]`` - List of containers belonging to the pod. Containers cannot currently be added
        or removed. There must be at least one container in a Pod. Cannot be updated.
      * **activeDeadlineSeconds** ``int`` - *(optional)* Optional duration in seconds the pod may be active on the node relative to
        StartTime before the system will actively try to mark it failed and kill
        associated containers. Value must be a positive integer.
      * **affinity** ``Affinity`` - *(optional)* If specified, the pod's scheduling constraints
      * **automountServiceAccountToken** ``bool`` - *(optional)* AutomountServiceAccountToken indicates whether a service account token should
        be automatically mounted.
      * **dnsConfig** ``PodDNSConfig`` - *(optional)* Specifies the DNS parameters of a pod. Parameters specified here will be
        merged to the generated DNS configuration based on DNSPolicy.
      * **dnsPolicy** ``str`` - *(optional)* Set DNS policy for the pod. Defaults to "ClusterFirst". Valid values are
        'ClusterFirstWithHostNet', 'ClusterFirst', 'Default' or 'None'. DNS parameters
        given in DNSConfig will be merged with the policy selected with DNSPolicy. To
        have DNS options set along with hostNetwork, you have to specify DNS policy
        explicitly to 'ClusterFirstWithHostNet'.
      * **enableServiceLinks** ``bool`` - *(optional)* EnableServiceLinks indicates whether information about services should be
        injected into pod's environment variables, matching the syntax of Docker
        links. Optional: Defaults to true.
      * **ephemeralContainers** ``List[EphemeralContainer]`` - *(optional)* List of ephemeral containers run in this pod. Ephemeral containers may be run
        in an existing pod to perform user-initiated actions such as debugging. This
        list cannot be specified when creating a pod, and it cannot be modified by
        updating the pod spec. In order to add an ephemeral container to an existing
        pod, use the pod's ephemeralcontainers subresource. This field is alpha-level
        and is only honored by servers that enable the EphemeralContainers feature.
      * **hostAliases** ``List[HostAlias]`` - *(optional)* HostAliases is an optional list of hosts and IPs that will be injected into
        the pod's hosts file if specified. This is only valid for non-hostNetwork
        pods.
      * **hostIPC** ``bool`` - *(optional)* Use the host's ipc namespace. Optional: Default to false.
      * **hostNetwork** ``bool`` - *(optional)* Host networking requested for this pod. Use the host's network namespace. If
        this option is set, the ports that will be used must be specified. Default to
        false.
      * **hostPID** ``bool`` - *(optional)* Use the host's pid namespace. Optional: Default to false.
      * **hostname** ``str`` - *(optional)* Specifies the hostname of the Pod If not specified, the pod's hostname will be
        set to a system-defined value.
      * **imagePullSecrets** ``List[LocalObjectReference]`` - *(optional)* ImagePullSecrets is an optional list of references to secrets in the same
        namespace to use for pulling any of the images used by this PodSpec. If
        specified, these secrets will be passed to individual puller implementations
        for them to use. For example, in the case of docker, only DockerConfig type
        secrets are honored. More info:
        https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
      * **initContainers** ``List[Container]`` - *(optional)* List of initialization containers belonging to the pod. Init containers are
        executed in order prior to containers being started. If any init container
        fails, the pod is considered to have failed and is handled according to its
        restartPolicy. The name for an init container or normal container must be
        unique among all containers. Init containers may not have Lifecycle actions,
        Readiness probes, Liveness probes, or Startup probes. The resourceRequirements
        of an init container are taken into account during scheduling by finding the
        highest request/limit for each resource type, and then using the max of of
        that value or the sum of the normal containers. Limits are applied to init
        containers in a similar fashion. Init containers cannot currently be added or
        removed. Cannot be updated. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/init-containers/
      * **nodeName** ``str`` - *(optional)* NodeName is a request to schedule this pod onto a specific node. If it is
        non-empty, the scheduler simply schedules this pod onto that node, assuming
        that it fits resource requirements.
      * **nodeSelector** ``dict`` - *(optional)* NodeSelector is a selector which must be true for the pod to fit on a node.
        Selector which must match a node's labels for the pod to be scheduled on that
        node. More info:
        https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
      * **overhead** ``dict`` - *(optional)* Overhead represents the resource overhead associated with running a pod for a
        given RuntimeClass. This field will be autopopulated at admission time by the
        RuntimeClass admission controller. If the RuntimeClass admission controller is
        enabled, overhead must not be set in Pod create requests. The RuntimeClass
        admission controller will reject Pod create requests which have the overhead
        already set. If RuntimeClass is configured and selected in the PodSpec,
        Overhead will be set to the value defined in the corresponding RuntimeClass,
        otherwise it will remain unset and treated as zero. More info:
        https://git.k8s.io/enhancements/keps/sig-node/20190226-pod-overhead.md This
        field is alpha-level as of Kubernetes v1.16, and is only honored by servers
        that enable the PodOverhead feature.
      * **preemptionPolicy** ``str`` - *(optional)* PreemptionPolicy is the Policy for preempting pods with lower priority. One of
        Never, PreemptLowerPriority. Defaults to PreemptLowerPriority if unset. This
        field is alpha-level and is only honored by servers that enable the
        NonPreemptingPriority feature.
      * **priority** ``int`` - *(optional)* The priority value. Various system components use this field to find the
        priority of the pod. When Priority Admission Controller is enabled, it
        prevents users from setting this field. The admission controller populates
        this field from PriorityClassName. The higher the value, the higher the
        priority.
      * **priorityClassName** ``str`` - *(optional)* If specified, indicates the pod's priority. "system-node-critical" and
        "system-cluster-critical" are two special keywords which indicate the highest
        priorities with the former being the highest priority. Any other name must be
        defined by creating a PriorityClass object with that name. If not specified,
        the pod priority will be default or zero if there is no default.
      * **readinessGates** ``List[PodReadinessGate]`` - *(optional)* If specified, all readiness gates will be evaluated for pod readiness. A pod
        is ready when all its containers are ready AND all conditions specified in the
        readiness gates have status equal to "True" More info:
        https://git.k8s.io/enhancements/keps/sig-network/0007-pod-ready%2B%2B.md
      * **restartPolicy** ``str`` - *(optional)* Restart policy for all containers within the pod. One of Always, OnFailure,
        Never. Default to Always. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle/#restart-policy
      * **runtimeClassName** ``str`` - *(optional)* RuntimeClassName refers to a RuntimeClass object in the node.k8s.io group,
        which should be used to run this pod.  If no RuntimeClass resource matches the
        named class, the pod will not be run. If unset or empty, the "legacy"
        RuntimeClass will be used, which is an implicit class with an empty definition
        that uses the default runtime handler. More info:
        https://git.k8s.io/enhancements/keps/sig-node/runtime-class.md This is a beta
        feature as of Kubernetes v1.14.
      * **schedulerName** ``str`` - *(optional)* If specified, the pod will be dispatched by specified scheduler. If not
        specified, the pod will be dispatched by default scheduler.
      * **securityContext** ``PodSecurityContext`` - *(optional)* SecurityContext holds pod-level security attributes and common container
        settings. Optional: Defaults to empty.  See type description for default
        values of each field.
      * **serviceAccount** ``str`` - *(optional)* DeprecatedServiceAccount is a depreciated alias for ServiceAccountName.
        Deprecated: Use serviceAccountName instead.
      * **serviceAccountName** ``str`` - *(optional)* ServiceAccountName is the name of the ServiceAccount to use to run this pod.
        More info:
        https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
      * **shareProcessNamespace** ``bool`` - *(optional)* Share a single process namespace between all of the containers in a pod. When
        this is set containers will be able to view and signal processes from other
        containers in the same pod, and the first process in each container will not
        be assigned PID 1. HostPID and ShareProcessNamespace cannot both be set.
        Optional: Default to false.
      * **subdomain** ``str`` - *(optional)* If specified, the fully qualified Pod hostname will be
        "<hostname>.<subdomain>.<pod namespace>.svc.<cluster domain>". If not
        specified, the pod will not have a domainname at all.
      * **terminationGracePeriodSeconds** ``int`` - *(optional)* Optional duration in seconds the pod needs to terminate gracefully. May be
        decreased in delete request. Value must be non-negative integer. The value
        zero indicates delete immediately. If this value is nil, the default grace
        period will be used instead. The grace period is the duration in seconds after
        the processes running in the pod are sent a termination signal and the time
        when the processes are forcibly halted with a kill signal. Set this value
        longer than the expected cleanup time for your process. Defaults to 30
        seconds.
      * **tolerations** ``List[Toleration]`` - *(optional)* If specified, the pod's tolerations.
      * **topologySpreadConstraints** ``List[TopologySpreadConstraint]`` - *(optional)* TopologySpreadConstraints describes how a group of pods ought to spread across
        topology domains. Scheduler will schedule pods in a way which abides by the
        constraints. This field is alpha-level and is only honored by clusters that
        enables the EvenPodsSpread feature. All topologySpreadConstraints are ANDed.
      * **volumes** ``List[Volume]`` - *(optional)* List of volumes that can be mounted by containers belonging to the pod. More
        info: https://kubernetes.io/docs/concepts/storage/volumes
    """
    containers: 'List[Container]'
    activeDeadlineSeconds: 'int' = None
    affinity: 'Affinity' = None
    automountServiceAccountToken: 'bool' = None
    dnsConfig: 'PodDNSConfig' = None
    dnsPolicy: 'str' = None
    enableServiceLinks: 'bool' = None
    ephemeralContainers: 'List[EphemeralContainer]' = None
    hostAliases: 'List[HostAlias]' = None
    hostIPC: 'bool' = None
    hostNetwork: 'bool' = None
    hostPID: 'bool' = None
    hostname: 'str' = None
    imagePullSecrets: 'List[LocalObjectReference]' = None
    initContainers: 'List[Container]' = None
    nodeName: 'str' = None
    nodeSelector: 'dict' = None
    overhead: 'dict' = None
    preemptionPolicy: 'str' = None
    priority: 'int' = None
    priorityClassName: 'str' = None
    readinessGates: 'List[PodReadinessGate]' = None
    restartPolicy: 'str' = None
    runtimeClassName: 'str' = None
    schedulerName: 'str' = None
    securityContext: 'PodSecurityContext' = None
    serviceAccount: 'str' = None
    serviceAccountName: 'str' = None
    shareProcessNamespace: 'bool' = None
    subdomain: 'str' = None
    terminationGracePeriodSeconds: 'int' = None
    tolerations: 'List[Toleration]' = None
    topologySpreadConstraints: 'List[TopologySpreadConstraint]' = None
    volumes: 'List[Volume]' = None


@dataclass
class PodStatus(DataclassDictMixIn):
    """PodStatus represents information about the status of a pod. Status may trail
      the actual state of a system, especially if the node that hosts the pod cannot
      contact the control plane.

      **parameters**

      * **conditions** ``List[PodCondition]`` - *(optional)* Current service state of pod. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-conditions
      * **containerStatuses** ``List[ContainerStatus]`` - *(optional)* The list has one entry per container in the manifest. Each entry is currently
        the output of `docker inspect`. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
      * **ephemeralContainerStatuses** ``List[ContainerStatus]`` - *(optional)* Status for any ephemeral containers that have run in this pod. This field is
        alpha-level and is only populated by servers that enable the
        EphemeralContainers feature.
      * **hostIP** ``str`` - *(optional)* IP address of the host to which the pod is assigned. Empty if not yet
        scheduled.
      * **initContainerStatuses** ``List[ContainerStatus]`` - *(optional)* The list has one entry per init container in the manifest. The most recent
        successful init container will have ready = true, the most recently started
        container will have startTime set. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-and-container-status
      * **message** ``str`` - *(optional)* A human readable message indicating details about why the pod is in this
        condition.
      * **nominatedNodeName** ``str`` - *(optional)* nominatedNodeName is set only when this pod preempts other pods on the node,
        but it cannot be scheduled right away as preemption victims receive their
        graceful termination periods. This field does not guarantee that the pod will
        be scheduled on this node. Scheduler may decide to place the pod elsewhere if
        other nodes become available sooner. Scheduler may also decide to give the
        resources on this node to a higher priority pod that is created after
        preemption. As a result, this field may be different than PodSpec.nodeName
        when the pod is scheduled.
      * **phase** ``str`` - *(optional)* The phase of a Pod is a simple, high-level summary of where the Pod is in its
        lifecycle. The conditions array, the reason and message fields, and the
        individual container status arrays contain more detail about the pod's status.
        There are five possible phase values:
        Pending: The pod has been accepted by the Kubernetes system, but one or more
        of the container images has not been created. This includes time before being
        scheduled as well as time spent downloading images over the network, which
        could take a while. Running: The pod has been bound to a node, and all of the
        containers have been created. At least one container is still running, or is
        in the process of starting or restarting. Succeeded: All containers in the pod
        have terminated in success, and will not be restarted. Failed: All containers
        in the pod have terminated, and at least one container has terminated in
        failure. The container either exited with non-zero status or was terminated by
        the system. Unknown: For some reason the state of the pod could not be
        obtained, typically due to an error in communicating with the host of the pod.
        More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#pod-phase
      * **podIP** ``str`` - *(optional)* IP address allocated to the pod. Routable at least within the cluster. Empty
        if not yet allocated.
      * **podIPs** ``List[PodIP]`` - *(optional)* podIPs holds the IP addresses allocated to the pod. If this field is
        specified, the 0th entry must match the podIP field. Pods may be allocated at
        most 1 value for each of IPv4 and IPv6. This list is empty if no IPs have been
        allocated yet.
      * **qosClass** ``str`` - *(optional)* The Quality of Service (QOS) classification assigned to the pod based on
        resource requirements See PodQOSClass type for available QOS classes More
        info:
        https://git.k8s.io/community/contributors/design-proposals/node/resource-qos.md
      * **reason** ``str`` - *(optional)* A brief CamelCase message indicating details about why the pod is in this
        state. e.g. 'Evicted'
      * **startTime** ``meta_v1.Time`` - *(optional)* RFC 3339 date and time at which the object was acknowledged by the Kubelet.
        This is before the Kubelet pulled the container image(s) for the pod.
    """
    conditions: 'List[PodCondition]' = None
    containerStatuses: 'List[ContainerStatus]' = None
    ephemeralContainerStatuses: 'List[ContainerStatus]' = None
    hostIP: 'str' = None
    initContainerStatuses: 'List[ContainerStatus]' = None
    message: 'str' = None
    nominatedNodeName: 'str' = None
    phase: 'str' = None
    podIP: 'str' = None
    podIPs: 'List[PodIP]' = None
    qosClass: 'str' = None
    reason: 'str' = None
    startTime: 'meta_v1.Time' = None


@dataclass
class PodTemplate(DataclassDictMixIn):
    """PodTemplate describes a template for creating copies of a predefined pod.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **template** ``PodTemplateSpec`` - *(optional)* Template defines the pods that will be created from this pod template.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    template: 'PodTemplateSpec' = None


@dataclass
class PodTemplateList(DataclassDictMixIn):
    """PodTemplateList is a list of PodTemplates.

      **parameters**

      * **items** ``List[PodTemplate]`` - List of pod templates
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[PodTemplate]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class PodTemplateSpec(DataclassDictMixIn):
    """PodTemplateSpec describes the data a pod should have when created from a
      template

      **parameters**

      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``PodSpec`` - *(optional)* Specification of the desired behavior of the pod. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'PodSpec' = None


@dataclass
class PortworxVolumeSource(DataclassDictMixIn):
    """PortworxVolumeSource represents a Portworx volume resource.

      **parameters**

      * **volumeID** ``str`` - VolumeID uniquely identifies a Portworx volume
      * **fsType** ``str`` - *(optional)* FSType represents the filesystem type to mount Must be a filesystem type
        supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred
        to be "ext4" if unspecified.
      * **readOnly** ``bool`` - *(optional)* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
    """
    volumeID: 'str'
    fsType: 'str' = None
    readOnly: 'bool' = None


@dataclass
class PreferredSchedulingTerm(DataclassDictMixIn):
    """An empty preferred scheduling term matches all objects with implicit weight 0
      (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e.
      is also a no-op).

      **parameters**

      * **preference** ``NodeSelectorTerm`` - A node selector term, associated with the corresponding weight.
      * **weight** ``int`` - Weight associated with matching the corresponding nodeSelectorTerm, in the
        range 1-100.
    """
    preference: 'NodeSelectorTerm'
    weight: 'int'


@dataclass
class Probe(DataclassDictMixIn):
    """Probe describes a health check to be performed against a container to
      determine whether it is alive or ready to receive traffic.

      **parameters**

      * **exec** ``ExecAction`` - *(optional)* One and only one of the following should be specified. Exec specifies the
        action to take.
      * **failureThreshold** ``int`` - *(optional)* Minimum consecutive failures for the probe to be considered failed after
        having succeeded. Defaults to 3. Minimum value is 1.
      * **httpGet** ``HTTPGetAction`` - *(optional)* HTTPGet specifies the http request to perform.
      * **initialDelaySeconds** ``int`` - *(optional)* Number of seconds after the container has started before liveness probes are
        initiated. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
      * **periodSeconds** ``int`` - *(optional)* How often (in seconds) to perform the probe. Default to 10 seconds. Minimum
        value is 1.
      * **successThreshold** ``int`` - *(optional)* Minimum consecutive successes for the probe to be considered successful after
        having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum
        value is 1.
      * **tcpSocket** ``TCPSocketAction`` - *(optional)* TCPSocket specifies an action involving a TCP port. TCP hooks not yet
        supported
      * **timeoutSeconds** ``int`` - *(optional)* Number of seconds after which the probe times out. Defaults to 1 second.
        Minimum value is 1. More info:
        https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
    """
    exec: 'ExecAction' = None
    failureThreshold: 'int' = None
    httpGet: 'HTTPGetAction' = None
    initialDelaySeconds: 'int' = None
    periodSeconds: 'int' = None
    successThreshold: 'int' = None
    tcpSocket: 'TCPSocketAction' = None
    timeoutSeconds: 'int' = None


@dataclass
class ProjectedVolumeSource(DataclassDictMixIn):
    """Represents a projected volume source

      **parameters**

      * **sources** ``List[VolumeProjection]`` - list of volume projections
      * **defaultMode** ``int`` - *(optional)* Mode bits to use on created files by default. Must be a value between 0 and
        0777. Directories within the path are not affected by this setting. This might
        be in conflict with other options that affect the file mode, like fsGroup, and
        the result can be other mode bits set.
    """
    sources: 'List[VolumeProjection]'
    defaultMode: 'int' = None


@dataclass
class QuobyteVolumeSource(DataclassDictMixIn):
    """Represents a Quobyte mount that lasts the lifetime of a pod. Quobyte volumes
      do not support ownership management or SELinux relabeling.

      **parameters**

      * **registry** ``str`` - Registry represents a single or multiple Quobyte Registry services specified
        as a string as host:port pair (multiple entries are separated with commas)
        which acts as the central registry for volumes
      * **volume** ``str`` - Volume is a string that references an already created Quobyte volume by name.
      * **group** ``str`` - *(optional)* Group to map volume access to Default is no group
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the Quobyte volume to be mounted with read-only
        permissions. Defaults to false.
      * **tenant** ``str`` - *(optional)* Tenant owning the given Quobyte volume in the Backend Used with dynamically
        provisioned Quobyte volumes, value is set by the plugin
      * **user** ``str`` - *(optional)* User to map volume access to Defaults to serivceaccount user
    """
    registry: 'str'
    volume: 'str'
    group: 'str' = None
    readOnly: 'bool' = None
    tenant: 'str' = None
    user: 'str' = None


@dataclass
class RBDPersistentVolumeSource(DataclassDictMixIn):
    """Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD
      volumes support ownership management and SELinux relabeling.

      **parameters**

      * **image** ``str`` - The rados image name. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **monitors** ``List[str]`` - A collection of Ceph monitors. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **fsType** ``str`` - *(optional)* Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#rbd
      * **keyring** ``str`` - *(optional)* Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring.
        More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **pool** ``str`` - *(optional)* The rados pool name. Default is rbd. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **secretRef** ``SecretReference`` - *(optional)* SecretRef is name of the authentication secret for RBDUser. If provided
        overrides keyring. Default is nil. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **user** ``str`` - *(optional)* The rados user name. Default is admin. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    image: 'str'
    monitors: 'List[str]'
    fsType: 'str' = None
    keyring: 'str' = None
    pool: 'str' = None
    readOnly: 'bool' = None
    secretRef: 'SecretReference' = None
    user: 'str' = None


@dataclass
class RBDVolumeSource(DataclassDictMixIn):
    """Represents a Rados Block Device mount that lasts the lifetime of a pod. RBD
      volumes support ownership management and SELinux relabeling.

      **parameters**

      * **image** ``str`` - The rados image name. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **monitors** ``List[str]`` - A collection of Ceph monitors. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **fsType** ``str`` - *(optional)* Filesystem type of the volume that you want to mount. Tip: Ensure that the
        filesystem type is supported by the host operating system. Examples: "ext4",
        "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#rbd
      * **keyring** ``str`` - *(optional)* Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring.
        More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **pool** ``str`` - *(optional)* The rados pool name. Default is rbd. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **readOnly** ``bool`` - *(optional)* ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to
        false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **secretRef** ``LocalObjectReference`` - *(optional)* SecretRef is name of the authentication secret for RBDUser. If provided
        overrides keyring. Default is nil. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
      * **user** ``str`` - *(optional)* The rados user name. Default is admin. More info:
        https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
    """
    image: 'str'
    monitors: 'List[str]'
    fsType: 'str' = None
    keyring: 'str' = None
    pool: 'str' = None
    readOnly: 'bool' = None
    secretRef: 'LocalObjectReference' = None
    user: 'str' = None


@dataclass
class ReplicationController(DataclassDictMixIn):
    """ReplicationController represents the configuration of a replication
      controller.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* If the Labels of a ReplicationController are empty, they are defaulted to be
        the same as the Pod(s) that the replication controller manages. Standard
        object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``ReplicationControllerSpec`` - *(optional)* Spec defines the specification of the desired behavior of the replication
        controller. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``ReplicationControllerStatus`` - *(optional)* Status is the most recently observed status of the replication controller.
        This data may be out of date by some window of time. Populated by the system.
        Read-only. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'ReplicationControllerSpec' = None
    status: 'ReplicationControllerStatus' = None


@dataclass
class ReplicationControllerCondition(DataclassDictMixIn):
    """ReplicationControllerCondition describes the state of a replication controller
      at a certain point.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of replication controller condition.
      * **lastTransitionTime** ``meta_v1.Time`` - *(optional)* The last time the condition transitioned from one status to another.
      * **message** ``str`` - *(optional)* A human readable message indicating details about the transition.
      * **reason** ``str`` - *(optional)* The reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class ReplicationControllerList(DataclassDictMixIn):
    """ReplicationControllerList is a collection of replication controllers.

      **parameters**

      * **items** ``List[ReplicationController]`` - List of replication controllers. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ReplicationController]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ReplicationControllerSpec(DataclassDictMixIn):
    """ReplicationControllerSpec is the specification of a replication controller.

      **parameters**

      * **minReadySeconds** ``int`` - *(optional)* Minimum number of seconds for which a newly created pod should be ready
        without any of its container crashing, for it to be considered available.
        Defaults to 0 (pod will be considered available as soon as it is ready)
      * **replicas** ``int`` - *(optional)* Replicas is the number of desired replicas. This is a pointer to distinguish
        between explicit zero and unspecified. Defaults to 1. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
      * **selector** ``dict`` - *(optional)* Selector is a label query over pods that should match the Replicas count. If
        Selector is empty, it is defaulted to the labels present on the Pod template.
        Label keys and values that must match in order to be controlled by this
        replication controller, if empty defaulted to labels on Pod template. More
        info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
      * **template** ``PodTemplateSpec`` - *(optional)* Template is the object that describes the pod that will be created if
        insufficient replicas are detected. This takes precedence over a TemplateRef.
        More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template
    """
    minReadySeconds: 'int' = None
    replicas: 'int' = None
    selector: 'dict' = None
    template: 'PodTemplateSpec' = None


@dataclass
class ReplicationControllerStatus(DataclassDictMixIn):
    """ReplicationControllerStatus represents the current status of a replication
      controller.

      **parameters**

      * **replicas** ``int`` - Replicas is the most recently oberved number of replicas. More info:
        https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#what-is-a-replicationcontroller
      * **availableReplicas** ``int`` - *(optional)* The number of available replicas (ready for at least minReadySeconds) for this
        replication controller.
      * **conditions** ``List[ReplicationControllerCondition]`` - *(optional)* Represents the latest available observations of a replication controller's
        current state.
      * **fullyLabeledReplicas** ``int`` - *(optional)* The number of pods that have labels matching the labels of the pod template of
        the replication controller.
      * **observedGeneration** ``int`` - *(optional)* ObservedGeneration reflects the generation of the most recently observed
        replication controller.
      * **readyReplicas** ``int`` - *(optional)* The number of ready replicas for this replication controller.
    """
    replicas: 'int'
    availableReplicas: 'int' = None
    conditions: 'List[ReplicationControllerCondition]' = None
    fullyLabeledReplicas: 'int' = None
    observedGeneration: 'int' = None
    readyReplicas: 'int' = None


@dataclass
class ResourceFieldSelector(DataclassDictMixIn):
    """ResourceFieldSelector represents container resources (cpu, memory) and their
      output format

      **parameters**

      * **resource** ``str`` - Required: resource to select
      * **containerName** ``str`` - *(optional)* Container name: required for volumes, optional for env vars
      * **divisor** ``resource.Quantity`` - *(optional)* Specifies the output format of the exposed resources, defaults to "1"
    """
    resource: 'str'
    containerName: 'str' = None
    divisor: 'resource.Quantity' = None


@dataclass
class ResourceQuota(DataclassDictMixIn):
    """ResourceQuota sets aggregate quota restrictions enforced per namespace

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``ResourceQuotaSpec`` - *(optional)* Spec defines the desired quota.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``ResourceQuotaStatus`` - *(optional)* Status defines the actual enforced quota and its current usage.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'ResourceQuotaSpec' = None
    status: 'ResourceQuotaStatus' = None


@dataclass
class ResourceQuotaList(DataclassDictMixIn):
    """ResourceQuotaList is a list of ResourceQuota items.

      **parameters**

      * **items** ``List[ResourceQuota]`` - Items is a list of ResourceQuota objects. More info:
        https://kubernetes.io/docs/concepts/policy/resource-quotas/
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ResourceQuota]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ResourceQuotaSpec(DataclassDictMixIn):
    """ResourceQuotaSpec defines the desired hard limits to enforce for Quota.

      **parameters**

      * **hard** ``dict`` - *(optional)* hard is the set of desired hard limits for each named resource. More info:
        https://kubernetes.io/docs/concepts/policy/resource-quotas/
      * **scopeSelector** ``ScopeSelector`` - *(optional)* scopeSelector is also a collection of filters like scopes that must match each
        object tracked by a quota but expressed using ScopeSelectorOperator in
        combination with possible values. For a resource to match, both scopes AND
        scopeSelector (if specified in spec), must be matched.
      * **scopes** ``List[str]`` - *(optional)* A collection of filters that must match each object tracked by a quota. If not
        specified, the quota matches all objects.
    """
    hard: 'dict' = None
    scopeSelector: 'ScopeSelector' = None
    scopes: 'List[str]' = None


@dataclass
class ResourceQuotaStatus(DataclassDictMixIn):
    """ResourceQuotaStatus defines the enforced hard limits and observed use.

      **parameters**

      * **hard** ``dict`` - *(optional)* Hard is the set of enforced hard limits for each named resource. More info:
        https://kubernetes.io/docs/concepts/policy/resource-quotas/
      * **used** ``dict`` - *(optional)* Used is the current observed total usage of the resource in the namespace.
    """
    hard: 'dict' = None
    used: 'dict' = None


@dataclass
class ResourceRequirements(DataclassDictMixIn):
    """ResourceRequirements describes the compute resource requirements.

      **parameters**

      * **limits** ``dict`` - *(optional)* Limits describes the maximum amount of compute resources allowed. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
      * **requests** ``dict`` - *(optional)* Requests describes the minimum amount of compute resources required. If
        Requests is omitted for a container, it defaults to Limits if that is
        explicitly specified, otherwise to an implementation-defined value. More info:
        https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
    """
    limits: 'dict' = None
    requests: 'dict' = None


@dataclass
class SELinuxOptions(DataclassDictMixIn):
    """SELinuxOptions are the labels to be applied to the container

      **parameters**

      * **level** ``str`` - *(optional)* Level is SELinux level label that applies to the container.
      * **role** ``str`` - *(optional)* Role is a SELinux role label that applies to the container.
      * **type** ``str`` - *(optional)* Type is a SELinux type label that applies to the container.
      * **user** ``str`` - *(optional)* User is a SELinux user label that applies to the container.
    """
    level: 'str' = None
    role: 'str' = None
    type: 'str' = None
    user: 'str' = None


@dataclass
class ScaleIOPersistentVolumeSource(DataclassDictMixIn):
    """ScaleIOPersistentVolumeSource represents a persistent ScaleIO volume

      **parameters**

      * **gateway** ``str`` - The host address of the ScaleIO API Gateway.
      * **secretRef** ``SecretReference`` - SecretRef references to the secret for ScaleIO user and other sensitive
        information. If this is not provided, Login operation will fail.
      * **system** ``str`` - The name of the storage system as configured in ScaleIO.
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs"
      * **protectionDomain** ``str`` - *(optional)* The name of the ScaleIO Protection Domain for the configured storage.
      * **readOnly** ``bool`` - *(optional)* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **sslEnabled** ``bool`` - *(optional)* Flag to enable/disable SSL communication with Gateway, default false
      * **storageMode** ``str`` - *(optional)* Indicates whether the storage for a volume should be ThickProvisioned or
        ThinProvisioned. Default is ThinProvisioned.
      * **storagePool** ``str`` - *(optional)* The ScaleIO Storage Pool associated with the protection domain.
      * **volumeName** ``str`` - *(optional)* The name of a volume already created in the ScaleIO system that is associated
        with this volume source.
    """
    gateway: 'str'
    secretRef: 'SecretReference'
    system: 'str'
    fsType: 'str' = None
    protectionDomain: 'str' = None
    readOnly: 'bool' = None
    sslEnabled: 'bool' = None
    storageMode: 'str' = None
    storagePool: 'str' = None
    volumeName: 'str' = None


@dataclass
class ScaleIOVolumeSource(DataclassDictMixIn):
    """ScaleIOVolumeSource represents a persistent ScaleIO volume

      **parameters**

      * **gateway** ``str`` - The host address of the ScaleIO API Gateway.
      * **secretRef** ``LocalObjectReference`` - SecretRef references to the secret for ScaleIO user and other sensitive
        information. If this is not provided, Login operation will fail.
      * **system** ``str`` - The name of the storage system as configured in ScaleIO.
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs".
      * **protectionDomain** ``str`` - *(optional)* The name of the ScaleIO Protection Domain for the configured storage.
      * **readOnly** ``bool`` - *(optional)* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **sslEnabled** ``bool`` - *(optional)* Flag to enable/disable SSL communication with Gateway, default false
      * **storageMode** ``str`` - *(optional)* Indicates whether the storage for a volume should be ThickProvisioned or
        ThinProvisioned. Default is ThinProvisioned.
      * **storagePool** ``str`` - *(optional)* The ScaleIO Storage Pool associated with the protection domain.
      * **volumeName** ``str`` - *(optional)* The name of a volume already created in the ScaleIO system that is associated
        with this volume source.
    """
    gateway: 'str'
    secretRef: 'LocalObjectReference'
    system: 'str'
    fsType: 'str' = None
    protectionDomain: 'str' = None
    readOnly: 'bool' = None
    sslEnabled: 'bool' = None
    storageMode: 'str' = None
    storagePool: 'str' = None
    volumeName: 'str' = None


@dataclass
class ScopeSelector(DataclassDictMixIn):
    """A scope selector represents the AND of the selectors represented by the
      scoped-resource selector requirements.

      **parameters**

      * **matchExpressions** ``List[ScopedResourceSelectorRequirement]`` - *(optional)* A list of scope selector requirements by scope of the resources.
    """
    matchExpressions: 'List[ScopedResourceSelectorRequirement]' = None


@dataclass
class ScopedResourceSelectorRequirement(DataclassDictMixIn):
    """A scoped-resource selector requirement is a selector that contains values, a
      scope name, and an operator that relates the scope name and values.

      **parameters**

      * **operator** ``str`` - Represents a scope's relationship to a set of values. Valid operators are In,
        NotIn, Exists, DoesNotExist.
      * **scopeName** ``str`` - The name of the scope that the selector applies to.
      * **values** ``List[str]`` - *(optional)* An array of string values. If the operator is In or NotIn, the values array
        must be non-empty. If the operator is Exists or DoesNotExist, the values array
        must be empty. This array is replaced during a strategic merge patch.
    """
    operator: 'str'
    scopeName: 'str'
    values: 'List[str]' = None


@dataclass
class Secret(DataclassDictMixIn):
    """Secret holds secret data of a certain type. The total bytes of the values in
      the Data field must be less than MaxSecretSize bytes.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **data** ``dict`` - *(optional)* Data contains the secret data. Each key must consist of alphanumeric
        characters, '-', '_' or '.'. The serialized form of the secret data is a
        base64 encoded string, representing the arbitrary (possibly non-string) data
        value here. Described in https://tools.ietf.org/html/rfc4648#section-4
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **stringData** ``dict`` - *(optional)* stringData allows specifying non-binary secret data in string form. It is
        provided as a write-only convenience method. All keys and values are merged
        into the data field on write, overwriting any existing values. It is never
        output when reading from the API.
      * **type** ``str`` - *(optional)* Used to facilitate programmatic handling of secret data.
    """
    apiVersion: 'str' = None
    data: 'dict' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    stringData: 'dict' = None
    type: 'str' = None


@dataclass
class SecretEnvSource(DataclassDictMixIn):
    """SecretEnvSource selects a Secret to populate the environment variables with.
      
      The contents of the target Secret's Data field will represent the key-value
      pairs as environment variables.

      **parameters**

      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``bool`` - *(optional)* Specify whether the Secret must be defined
    """
    name: 'str' = None
    optional: 'bool' = None


@dataclass
class SecretKeySelector(DataclassDictMixIn):
    """SecretKeySelector selects a key of a Secret.

      **parameters**

      * **key** ``str`` - The key of the secret to select from.  Must be a valid secret key.
      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``bool`` - *(optional)* Specify whether the Secret or its key must be defined
    """
    key: 'str'
    name: 'str' = None
    optional: 'bool' = None


@dataclass
class SecretList(DataclassDictMixIn):
    """SecretList is a list of Secret.

      **parameters**

      * **items** ``List[Secret]`` - Items is a list of secret objects. More info:
        https://kubernetes.io/docs/concepts/configuration/secret
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Secret]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class SecretProjection(DataclassDictMixIn):
    """Adapts a secret into a projected volume.
      
      The contents of the target Secret's Data field will be presented in a
      projected volume as files using the keys in the Data field as the file names.
      Note that this is identical to a secret volume source without the default
      mode.

      **parameters**

      * **items** ``List[KeyToPath]`` - *(optional)* If unspecified, each key-value pair in the Data field of the referenced Secret
        will be projected into the volume as a file whose name is the key and content
        is the value. If specified, the listed keys will be projected into the
        specified paths, and unlisted keys will not be present. If a key is specified
        which is not present in the Secret, the volume setup will error unless it is
        marked optional. Paths must be relative and may not contain the '..' path or
        start with '..'.
      * **name** ``str`` - *(optional)* Name of the referent. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **optional** ``bool`` - *(optional)* Specify whether the Secret or its key must be defined
    """
    items: 'List[KeyToPath]' = None
    name: 'str' = None
    optional: 'bool' = None


@dataclass
class SecretReference(DataclassDictMixIn):
    """SecretReference represents a Secret Reference. It has enough information to
      retrieve secret in any namespace

      **parameters**

      * **name** ``str`` - *(optional)* Name is unique within a namespace to reference a secret resource.
      * **namespace** ``str`` - *(optional)* Namespace defines the space within which the secret name must be unique.
    """
    name: 'str' = None
    namespace: 'str' = None


@dataclass
class SecretVolumeSource(DataclassDictMixIn):
    """Adapts a Secret into a volume.
      
      The contents of the target Secret's Data field will be presented in a volume
      as files using the keys in the Data field as the file names. Secret volumes
      support ownership management and SELinux relabeling.

      **parameters**

      * **defaultMode** ``int`` - *(optional)* Optional: mode bits to use on created files by default. Must be a value
        between 0 and 0777. Defaults to 0644. Directories within the path are not
        affected by this setting. This might be in conflict with other options that
        affect the file mode, like fsGroup, and the result can be other mode bits set.
      * **items** ``List[KeyToPath]`` - *(optional)* If unspecified, each key-value pair in the Data field of the referenced Secret
        will be projected into the volume as a file whose name is the key and content
        is the value. If specified, the listed keys will be projected into the
        specified paths, and unlisted keys will not be present. If a key is specified
        which is not present in the Secret, the volume setup will error unless it is
        marked optional. Paths must be relative and may not contain the '..' path or
        start with '..'.
      * **optional** ``bool`` - *(optional)* Specify whether the Secret or its keys must be defined
      * **secretName** ``str`` - *(optional)* Name of the secret in the pod's namespace to use. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#secret
    """
    defaultMode: 'int' = None
    items: 'List[KeyToPath]' = None
    optional: 'bool' = None
    secretName: 'str' = None


@dataclass
class SecurityContext(DataclassDictMixIn):
    """SecurityContext holds security configuration that will be applied to a
      container. Some fields are present in both SecurityContext and
      PodSecurityContext.  When both are set, the values in SecurityContext take
      precedence.

      **parameters**

      * **allowPrivilegeEscalation** ``bool`` - *(optional)* AllowPrivilegeEscalation controls whether a process can gain more privileges
        than its parent process. This bool directly controls if the no_new_privs flag
        will be set on the container process. AllowPrivilegeEscalation is true always
        when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
      * **capabilities** ``Capabilities`` - *(optional)* The capabilities to add/drop when running containers. Defaults to the default
        set of capabilities granted by the container runtime.
      * **privileged** ``bool`` - *(optional)* Run container in privileged mode. Processes in privileged containers are
        essentially equivalent to root on the host. Defaults to false.
      * **procMount** ``str`` - *(optional)* procMount denotes the type of proc mount to use for the containers. The
        default is DefaultProcMount which uses the container runtime defaults for
        readonly paths and masked paths. This requires the ProcMountType feature flag
        to be enabled.
      * **readOnlyRootFilesystem** ``bool`` - *(optional)* Whether this container has a read-only root filesystem. Default is false.
      * **runAsGroup** ``int`` - *(optional)* The GID to run the entrypoint of the container process. Uses runtime default
        if unset. May also be set in PodSecurityContext.  If set in both
        SecurityContext and PodSecurityContext, the value specified in SecurityContext
        takes precedence.
      * **runAsNonRoot** ``bool`` - *(optional)* Indicates that the container must run as a non-root user. If true, the Kubelet
        will validate the image at runtime to ensure that it does not run as UID 0
        (root) and fail to start the container if it does. If unset or false, no such
        validation will be performed. May also be set in PodSecurityContext.  If set
        in both SecurityContext and PodSecurityContext, the value specified in
        SecurityContext takes precedence.
      * **runAsUser** ``int`` - *(optional)* The UID to run the entrypoint of the container process. Defaults to user
        specified in image metadata if unspecified. May also be set in
        PodSecurityContext.  If set in both SecurityContext and PodSecurityContext,
        the value specified in SecurityContext takes precedence.
      * **seLinuxOptions** ``SELinuxOptions`` - *(optional)* The SELinux context to be applied to the container. If unspecified, the
        container runtime will allocate a random SELinux context for each container.
        May also be set in PodSecurityContext.  If set in both SecurityContext and
        PodSecurityContext, the value specified in SecurityContext takes precedence.
      * **windowsOptions** ``WindowsSecurityContextOptions`` - *(optional)* The Windows specific settings applied to all containers. If unspecified, the
        options from the PodSecurityContext will be used. If set in both
        SecurityContext and PodSecurityContext, the value specified in SecurityContext
        takes precedence.
    """
    allowPrivilegeEscalation: 'bool' = None
    capabilities: 'Capabilities' = None
    privileged: 'bool' = None
    procMount: 'str' = None
    readOnlyRootFilesystem: 'bool' = None
    runAsGroup: 'int' = None
    runAsNonRoot: 'bool' = None
    runAsUser: 'int' = None
    seLinuxOptions: 'SELinuxOptions' = None
    windowsOptions: 'WindowsSecurityContextOptions' = None


@dataclass
class Service(DataclassDictMixIn):
    """Service is a named abstraction of software service (for example, mysql)
      consisting of local port (for example 3306) that the proxy listens on, and the
      selector that determines which pods will answer requests sent through the
      proxy.

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``ServiceSpec`` - *(optional)* Spec defines the behavior of a service.
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``ServiceStatus`` - *(optional)* Most recently observed status of the service. Populated by the system.
        Read-only. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'ServiceSpec' = None
    status: 'ServiceStatus' = None


@dataclass
class ServiceAccount(DataclassDictMixIn):
    """ServiceAccount binds together: * a name, understood by users, and perhaps by
      peripheral systems, for an identity * a principal that can be authenticated
      and authorized * a set of secrets

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **automountServiceAccountToken** ``bool`` - *(optional)* AutomountServiceAccountToken indicates whether pods running as this service
        account should have an API token automatically mounted. Can be overridden at
        the pod level.
      * **imagePullSecrets** ``List[LocalObjectReference]`` - *(optional)* ImagePullSecrets is a list of references to secrets in the same namespace to
        use for pulling any images in pods that reference this ServiceAccount.
        ImagePullSecrets are distinct from Secrets because Secrets can be mounted in
        the pod, but ImagePullSecrets are only accessed by the kubelet. More info:
        https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **secrets** ``List[ObjectReference]`` - *(optional)* Secrets is the list of secrets allowed to be used by pods running using this
        ServiceAccount. More info:
        https://kubernetes.io/docs/concepts/configuration/secret
    """
    apiVersion: 'str' = None
    automountServiceAccountToken: 'bool' = None
    imagePullSecrets: 'List[LocalObjectReference]' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    secrets: 'List[ObjectReference]' = None


@dataclass
class ServiceAccountList(DataclassDictMixIn):
    """ServiceAccountList is a list of ServiceAccount objects

      **parameters**

      * **items** ``List[ServiceAccount]`` - List of ServiceAccounts. More info:
        https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[ServiceAccount]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ServiceAccountTokenProjection(DataclassDictMixIn):
    """ServiceAccountTokenProjection represents a projected service account token
      volume. This projection can be used to insert a service account token into the
      pods runtime filesystem for use against APIs (Kubernetes API Server or
      otherwise).

      **parameters**

      * **path** ``str`` - Path is the path relative to the mount point of the file to project the token
        into.
      * **audience** ``str`` - *(optional)* Audience is the intended audience of the token. A recipient of a token must
        identify itself with an identifier specified in the audience of the token, and
        otherwise should reject the token. The audience defaults to the identifier of
        the apiserver.
      * **expirationSeconds** ``int`` - *(optional)* ExpirationSeconds is the requested duration of validity of the service account
        token. As the token approaches expiration, the kubelet volume plugin will
        proactively rotate the service account token. The kubelet will start trying to
        rotate the token if the token is older than 80 percent of its time to live or
        if the token is older than 24 hours.Defaults to 1 hour and must be at least 10
        minutes.
    """
    path: 'str'
    audience: 'str' = None
    expirationSeconds: 'int' = None


@dataclass
class ServiceList(DataclassDictMixIn):
    """ServiceList holds a list of services.

      **parameters**

      * **items** ``List[Service]`` - List of services
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
    """
    items: 'List[Service]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class ServicePort(DataclassDictMixIn):
    """ServicePort contains information on service's port.

      **parameters**

      * **port** ``int`` - The port that will be exposed by this service.
      * **name** ``str`` - *(optional)* The name of this port within the service. This must be a DNS_LABEL. All ports
        within a ServiceSpec must have unique names. When considering the endpoints
        for a Service, this must match the 'name' field in the EndpointPort. Optional
        if only one ServicePort is defined on this service.
      * **nodePort** ``int`` - *(optional)* The port on each node on which this service is exposed when type=NodePort or
        LoadBalancer. Usually assigned by the system. If specified, it will be
        allocated to the service if unused or else creation of the service will fail.
        Default is to auto-allocate a port if the ServiceType of this Service requires
        one. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
      * **protocol** ``str`` - *(optional)* The IP protocol for this port. Supports "TCP", "UDP", and "SCTP". Default is
        TCP.
      * **targetPort** ``util_intstr.IntOrString`` - *(optional)* Number or name of the port to access on the pods targeted by the service.
        Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME. If this
        is a string, it will be looked up as a named port in the target Pod's
        container ports. If this is not specified, the value of the 'port' field is
        used (an identity map). This field is ignored for services with
        clusterIP=None, and should be omitted or set equal to the 'port' field. More
        info:
        https://kubernetes.io/docs/concepts/services-networking/service/#defining-a-service
    """
    port: 'int'
    name: 'str' = None
    nodePort: 'int' = None
    protocol: 'str' = None
    targetPort: 'util_intstr.IntOrString' = None


@dataclass
class ServiceSpec(DataclassDictMixIn):
    """ServiceSpec describes the attributes that a user creates on a service.

      **parameters**

      * **clusterIP** ``str`` - *(optional)* clusterIP is the IP address of the service and is usually assigned randomly by
        the master. If an address is specified manually and is not in use by others,
        it will be allocated to the service; otherwise, creation of the service will
        fail. This field can not be changed through updates. Valid values are "None",
        empty string (""), or a valid IP address. "None" can be specified for headless
        services when proxying is not required. Only applies to types ClusterIP,
        NodePort, and LoadBalancer. Ignored if type is ExternalName. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
      * **externalIPs** ``List[str]`` - *(optional)* externalIPs is a list of IP addresses for which nodes in the cluster will also
        accept traffic for this service.  These IPs are not managed by Kubernetes.
        The user is responsible for ensuring that traffic arrives at a node with this
        IP.  A common example is external load-balancers that are not part of the
        Kubernetes system.
      * **externalName** ``str`` - *(optional)* externalName is the external reference that kubedns or equivalent will return
        as a CNAME record for this service. No proxying will be involved. Must be a
        valid RFC-1123 hostname (https://tools.ietf.org/html/rfc1123) and requires
        Type to be ExternalName.
      * **externalTrafficPolicy** ``str`` - *(optional)* externalTrafficPolicy denotes if this Service desires to route external
        traffic to node-local or cluster-wide endpoints. "Local" preserves the client
        source IP and avoids a second hop for LoadBalancer and Nodeport type services,
        but risks potentially imbalanced traffic spreading. "Cluster" obscures the
        client source IP and may cause a second hop to another node, but should have
        good overall load-spreading.
      * **healthCheckNodePort** ``int`` - *(optional)* healthCheckNodePort specifies the healthcheck nodePort for the service. If not
        specified, HealthCheckNodePort is created by the service api backend with the
        allocated nodePort. Will use user-specified nodePort value if specified by the
        client. Only effects when Type is set to LoadBalancer and
        ExternalTrafficPolicy is set to Local.
      * **ipFamily** ``str`` - *(optional)* ipFamily specifies whether this Service has a preference for a particular IP
        family (e.g. IPv4 vs. IPv6).  If a specific IP family is requested, the
        clusterIP field will be allocated from that family, if it is available in the
        cluster.  If no IP family is requested, the cluster's primary IP family will
        be used. Other IP fields (loadBalancerIP, loadBalancerSourceRanges,
        externalIPs) and controllers which allocate external load-balancers should use
        the same IP family.  Endpoints for this Service will be of this family.  This
        field is immutable after creation. Assigning a ServiceIPFamily not available
        in the cluster (e.g. IPv6 in IPv4 only cluster) is an error condition and will
        fail during clusterIP assignment.
      * **loadBalancerIP** ``str`` - *(optional)* Only applies to Service Type: LoadBalancer LoadBalancer will get created with
        the IP specified in this field. This feature depends on whether the underlying
        cloud-provider supports specifying the loadBalancerIP when a load balancer is
        created. This field will be ignored if the cloud-provider does not support the
        feature.
      * **loadBalancerSourceRanges** ``List[str]`` - *(optional)* If specified and supported by the platform, this will restrict traffic through
        the cloud-provider load-balancer will be restricted to the specified client
        IPs. This field will be ignored if the cloud-provider does not support the
        feature." More info:
        https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/
      * **ports** ``List[ServicePort]`` - *(optional)* The list of ports that are exposed by this service. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
      * **publishNotReadyAddresses** ``bool`` - *(optional)* publishNotReadyAddresses, when set to true, indicates that DNS implementations
        must publish the notReadyAddresses of subsets for the Endpoints associated
        with the Service. The default value is false. The primary use case for setting
        this field is to use a StatefulSet's Headless Service to propagate SRV records
        for its Pods without respect to their readiness for purpose of peer discovery.
      * **selector** ``dict`` - *(optional)* Route service traffic to pods with label keys and values matching this
        selector. If empty or not present, the service is assumed to have an external
        process managing its endpoints, which Kubernetes will not modify. Only applies
        to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is
        ExternalName. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/
      * **sessionAffinity** ``str`` - *(optional)* Supports "ClientIP" and "None". Used to maintain session affinity. Enable
        client IP based session affinity. Must be ClientIP or None. Defaults to None.
        More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
      * **sessionAffinityConfig** ``SessionAffinityConfig`` - *(optional)* sessionAffinityConfig contains the configurations of session affinity.
      * **topologyKeys** ``List[str]`` - *(optional)* topologyKeys is a preference-order list of topology keys which implementations
        of services should use to preferentially sort endpoints when accessing this
        Service, it can not be used at the same time as externalTrafficPolicy=Local.
        Topology keys must be valid label keys and at most 16 keys may be specified.
        Endpoints are chosen based on the first topology key with available backends.
        If this field is specified and all entries have no backends that match the
        topology of the client, the service has no backends for that client and
        connections should fail. The special value "*" may be used to mean "any
        topology". This catch-all value, if used, only makes sense as the last value
        in the list. If this is not specified or empty, no topology constraints will
        be applied.
      * **type** ``str`` - *(optional)* type determines how the Service is exposed. Defaults to ClusterIP. Valid
        options are ExternalName, ClusterIP, NodePort, and LoadBalancer.
        "ExternalName" maps to the specified externalName. "ClusterIP" allocates a
        cluster-internal IP address for load-balancing to endpoints. Endpoints are
        determined by the selector or if that is not specified, by manual construction
        of an Endpoints object. If clusterIP is "None", no virtual IP is allocated and
        the endpoints are published as a set of endpoints rather than a stable IP.
        "NodePort" builds on ClusterIP and allocates a port on every node which routes
        to the clusterIP. "LoadBalancer" builds on NodePort and creates an external
        load-balancer (if supported in the current cloud) which routes to the
        clusterIP. More info:
        https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services-service-types
    """
    clusterIP: 'str' = None
    externalIPs: 'List[str]' = None
    externalName: 'str' = None
    externalTrafficPolicy: 'str' = None
    healthCheckNodePort: 'int' = None
    ipFamily: 'str' = None
    loadBalancerIP: 'str' = None
    loadBalancerSourceRanges: 'List[str]' = None
    ports: 'List[ServicePort]' = None
    publishNotReadyAddresses: 'bool' = None
    selector: 'dict' = None
    sessionAffinity: 'str' = None
    sessionAffinityConfig: 'SessionAffinityConfig' = None
    topologyKeys: 'List[str]' = None
    type: 'str' = None


@dataclass
class ServiceStatus(DataclassDictMixIn):
    """ServiceStatus represents the current status of a service.

      **parameters**

      * **loadBalancer** ``LoadBalancerStatus`` - *(optional)* LoadBalancer contains the current status of the load-balancer, if one is
        present.
    """
    loadBalancer: 'LoadBalancerStatus' = None


@dataclass
class SessionAffinityConfig(DataclassDictMixIn):
    """SessionAffinityConfig represents the configurations of session affinity.

      **parameters**

      * **clientIP** ``ClientIPConfig`` - *(optional)* clientIP contains the configurations of Client IP based session affinity.
    """
    clientIP: 'ClientIPConfig' = None


@dataclass
class StorageOSPersistentVolumeSource(DataclassDictMixIn):
    """Represents a StorageOS persistent volume resource.

      **parameters**

      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **readOnly** ``bool`` - *(optional)* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **secretRef** ``ObjectReference`` - *(optional)* SecretRef specifies the secret to use for obtaining the StorageOS API
        credentials.  If not specified, default values will be attempted.
      * **volumeName** ``str`` - *(optional)* VolumeName is the human-readable name of the StorageOS volume.  Volume names
        are only unique within a namespace.
      * **volumeNamespace** ``str`` - *(optional)* VolumeNamespace specifies the scope of the volume within StorageOS.  If no
        namespace is specified then the Pod's namespace will be used.  This allows the
        Kubernetes name scoping to be mirrored within StorageOS for tighter
        integration. Set VolumeName to any name to override the default behaviour. Set
        to "default" if you are not using namespaces within StorageOS. Namespaces that
        do not pre-exist within StorageOS will be created.
    """
    fsType: 'str' = None
    readOnly: 'bool' = None
    secretRef: 'ObjectReference' = None
    volumeName: 'str' = None
    volumeNamespace: 'str' = None


@dataclass
class StorageOSVolumeSource(DataclassDictMixIn):
    """Represents a StorageOS persistent volume resource.

      **parameters**

      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **readOnly** ``bool`` - *(optional)* Defaults to false (read/write). ReadOnly here will force the ReadOnly setting
        in VolumeMounts.
      * **secretRef** ``LocalObjectReference`` - *(optional)* SecretRef specifies the secret to use for obtaining the StorageOS API
        credentials.  If not specified, default values will be attempted.
      * **volumeName** ``str`` - *(optional)* VolumeName is the human-readable name of the StorageOS volume.  Volume names
        are only unique within a namespace.
      * **volumeNamespace** ``str`` - *(optional)* VolumeNamespace specifies the scope of the volume within StorageOS.  If no
        namespace is specified then the Pod's namespace will be used.  This allows the
        Kubernetes name scoping to be mirrored within StorageOS for tighter
        integration. Set VolumeName to any name to override the default behaviour. Set
        to "default" if you are not using namespaces within StorageOS. Namespaces that
        do not pre-exist within StorageOS will be created.
    """
    fsType: 'str' = None
    readOnly: 'bool' = None
    secretRef: 'LocalObjectReference' = None
    volumeName: 'str' = None
    volumeNamespace: 'str' = None


@dataclass
class Sysctl(DataclassDictMixIn):
    """Sysctl defines a kernel parameter to be set

      **parameters**

      * **name** ``str`` - Name of a property to set
      * **value** ``str`` - Value of a property to set
    """
    name: 'str'
    value: 'str'


@dataclass
class TCPSocketAction(DataclassDictMixIn):
    """TCPSocketAction describes an action based on opening a socket

      **parameters**

      * **port** ``util_intstr.IntOrString`` - Number or name of the port to access on the container. Number must be in the
        range 1 to 65535. Name must be an IANA_SVC_NAME.
      * **host** ``str`` - *(optional)* Optional: Host name to connect to, defaults to the pod IP.
    """
    port: 'util_intstr.IntOrString'
    host: 'str' = None


@dataclass
class Taint(DataclassDictMixIn):
    """The node this Taint is attached to has the "effect" on any pod that does not
      tolerate the Taint.

      **parameters**

      * **effect** ``str`` - Required. The effect of the taint on pods that do not tolerate the taint.
        Valid effects are NoSchedule, PreferNoSchedule and NoExecute.
      * **key** ``str`` - Required. The taint key to be applied to a node.
      * **timeAdded** ``meta_v1.Time`` - *(optional)* TimeAdded represents the time at which the taint was added. It is only written
        for NoExecute taints.
      * **value** ``str`` - *(optional)* Required. The taint value corresponding to the taint key.
    """
    effect: 'str'
    key: 'str'
    timeAdded: 'meta_v1.Time' = None
    value: 'str' = None


@dataclass
class Toleration(DataclassDictMixIn):
    """The pod this Toleration is attached to tolerates any taint that matches the
      triple <key,value,effect> using the matching operator <operator>.

      **parameters**

      * **effect** ``str`` - *(optional)* Effect indicates the taint effect to match. Empty means match all taint
        effects. When specified, allowed values are NoSchedule, PreferNoSchedule and
        NoExecute.
      * **key** ``str`` - *(optional)* Key is the taint key that the toleration applies to. Empty means match all
        taint keys. If the key is empty, operator must be Exists; this combination
        means to match all values and all keys.
      * **operator** ``str`` - *(optional)* Operator represents a key's relationship to the value. Valid operators are
        Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for
        value, so that a pod can tolerate all taints of a particular category.
      * **tolerationSeconds** ``int`` - *(optional)* TolerationSeconds represents the period of time the toleration (which must be
        of effect NoExecute, otherwise this field is ignored) tolerates the taint. By
        default, it is not set, which means tolerate the taint forever (do not evict).
        Zero and negative values will be treated as 0 (evict immediately) by the
        system.
      * **value** ``str`` - *(optional)* Value is the taint value the toleration matches to. If the operator is Exists,
        the value should be empty, otherwise just a regular string.
    """
    effect: 'str' = None
    key: 'str' = None
    operator: 'str' = None
    tolerationSeconds: 'int' = None
    value: 'str' = None


@dataclass
class TopologySelectorLabelRequirement(DataclassDictMixIn):
    """A topology selector requirement is a selector that matches given label. This
      is an alpha feature and may change in the future.

      **parameters**

      * **key** ``str`` - The label key that the selector applies to.
      * **values** ``List[str]`` - An array of string values. One value must match the label to be selected. Each
        entry in Values is ORed.
    """
    key: 'str'
    values: 'List[str]'


@dataclass
class TopologySelectorTerm(DataclassDictMixIn):
    """A topology selector term represents the result of label queries. A null or
      empty topology selector term matches no objects. The requirements of them are
      ANDed. It provides a subset of functionality as NodeSelectorTerm. This is an
      alpha feature and may change in the future.

      **parameters**

      * **matchLabelExpressions** ``List[TopologySelectorLabelRequirement]`` - *(optional)* A list of topology selector requirements by labels.
    """
    matchLabelExpressions: 'List[TopologySelectorLabelRequirement]' = None


@dataclass
class TopologySpreadConstraint(DataclassDictMixIn):
    """TopologySpreadConstraint specifies how to spread matching pods among the given
      topology.

      **parameters**

      * **maxSkew** ``int`` - MaxSkew describes the degree to which pods may be unevenly distributed. It's
        the maximum permitted difference between the number of matching pods in any
        two topology domains of a given topology type. For example, in a 3-zone
        cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as
        1/1/0: | zone1 | zone2 | zone3 | |   P   |   P   |       | - if MaxSkew is 1,
        incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it
        onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate
        MaxSkew(1). - if MaxSkew is 2, incoming pod can be scheduled onto any zone.
        It's a required field. Default value is 1 and 0 is not allowed.
      * **topologyKey** ``str`` - TopologyKey is the key of node labels. Nodes that have a label with this key
        and identical values are considered to be in the same topology. We consider
        each <key, value> as a "bucket", and try to put balanced number of pods into
        each bucket. It's a required field.
      * **whenUnsatisfiable** ``str`` - WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy the
        spread constraint. - DoNotSchedule (default) tells the scheduler not to
        schedule it - ScheduleAnyway tells the scheduler to still schedule it It's
        considered as "Unsatisfiable" if and only if placing incoming pod on any
        topology violates "MaxSkew". For example, in a 3-zone cluster, MaxSkew is set
        to 1, and pods with the same labelSelector spread as 3/1/1: | zone1 | zone2 |
        zone3 | | P P P |   P   |   P   | If WhenUnsatisfiable is set to
        DoNotSchedule, incoming pod can only be scheduled to zone2(zone3) to become
        3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies MaxSkew(1). In other
        words, the cluster can still be imbalanced, but scheduler won't make it *more*
        imbalanced. It's a required field.
      * **labelSelector** ``meta_v1.LabelSelector`` - *(optional)* LabelSelector is used to find matching pods. Pods that match this label
        selector are counted to determine the number of pods in their corresponding
        topology domain.
    """
    maxSkew: 'int'
    topologyKey: 'str'
    whenUnsatisfiable: 'str'
    labelSelector: 'meta_v1.LabelSelector' = None


@dataclass
class TypedLocalObjectReference(DataclassDictMixIn):
    """TypedLocalObjectReference contains enough information to let you locate the
      typed referenced object inside the same namespace.

      **parameters**

      * **kind** ``str`` - Kind is the type of resource being referenced
      * **name** ``str`` - Name is the name of resource being referenced
      * **apiGroup** ``str`` - *(optional)* APIGroup is the group for the resource being referenced. If APIGroup is not
        specified, the specified Kind must be in the core API group. For any other
        third-party types, APIGroup is required.
    """
    kind: 'str'
    name: 'str'
    apiGroup: 'str' = None


@dataclass
class Volume(DataclassDictMixIn):
    """Volume represents a named volume in a pod that may be accessed by any
      container in the pod.

      **parameters**

      * **name** ``str`` - Volume's name. Must be a DNS_LABEL and unique within the pod. More info:
        https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
      * **awsElasticBlockStore** ``AWSElasticBlockStoreVolumeSource`` - *(optional)* AWSElasticBlockStore represents an AWS Disk resource that is attached to a
        kubelet's host machine and then exposed to the pod. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
      * **azureDisk** ``AzureDiskVolumeSource`` - *(optional)* AzureDisk represents an Azure Data Disk mount on the host and bind mount to
        the pod.
      * **azureFile** ``AzureFileVolumeSource`` - *(optional)* AzureFile represents an Azure File Service mount on the host and bind mount to
        the pod.
      * **cephfs** ``CephFSVolumeSource`` - *(optional)* CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
      * **cinder** ``CinderVolumeSource`` - *(optional)* Cinder represents a cinder volume attached and mounted on kubelets host
        machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
      * **configMap** ``ConfigMapVolumeSource`` - *(optional)* ConfigMap represents a configMap that should populate this volume
      * **csi** ``CSIVolumeSource`` - *(optional)* CSI (Container Storage Interface) represents storage that is handled by an
        external CSI driver (Alpha feature).
      * **downwardAPI** ``DownwardAPIVolumeSource`` - *(optional)* DownwardAPI represents downward API about the pod that should populate this
        volume
      * **emptyDir** ``EmptyDirVolumeSource`` - *(optional)* EmptyDir represents a temporary directory that shares a pod's lifetime. More
        info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
      * **fc** ``FCVolumeSource`` - *(optional)* FC represents a Fibre Channel resource that is attached to a kubelet's host
        machine and then exposed to the pod.
      * **flexVolume** ``FlexVolumeSource`` - *(optional)* FlexVolume represents a generic volume resource that is provisioned/attached
        using an exec based plugin.
      * **flocker** ``FlockerVolumeSource`` - *(optional)* Flocker represents a Flocker volume attached to a kubelet's host machine. This
        depends on the Flocker control service being running
      * **gcePersistentDisk** ``GCEPersistentDiskVolumeSource`` - *(optional)* GCEPersistentDisk represents a GCE Disk resource that is attached to a
        kubelet's host machine and then exposed to the pod. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
      * **gitRepo** ``GitRepoVolumeSource`` - *(optional)* GitRepo represents a git repository at a particular revision. DEPRECATED:
        GitRepo is deprecated. To provision a container with a git repo, mount an
        EmptyDir into an InitContainer that clones the repo using git, then mount the
        EmptyDir into the Pod's container.
      * **glusterfs** ``GlusterfsVolumeSource`` - *(optional)* Glusterfs represents a Glusterfs mount on the host that shares a pod's
        lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
      * **hostPath** ``HostPathVolumeSource`` - *(optional)* HostPath represents a pre-existing file or directory on the host machine that
        is directly exposed to the container. This is generally used for system agents
        or other privileged things that are allowed to see the host machine. Most
        containers will NOT need this. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#hostpath
      * **iscsi** ``ISCSIVolumeSource`` - *(optional)* ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host
        machine and then exposed to the pod. More info:
        https://examples.k8s.io/volumes/iscsi/README.md
      * **nfs** ``NFSVolumeSource`` - *(optional)* NFS represents an NFS mount on the host that shares a pod's lifetime More
        info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
      * **persistentVolumeClaim** ``PersistentVolumeClaimVolumeSource`` - *(optional)* PersistentVolumeClaimVolumeSource represents a reference to a
        PersistentVolumeClaim in the same namespace. More info:
        https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
      * **photonPersistentDisk** ``PhotonPersistentDiskVolumeSource`` - *(optional)* PhotonPersistentDisk represents a PhotonController persistent disk attached
        and mounted on kubelets host machine
      * **portworxVolume** ``PortworxVolumeSource`` - *(optional)* PortworxVolume represents a portworx volume attached and mounted on kubelets
        host machine
      * **projected** ``ProjectedVolumeSource`` - *(optional)* Items for all in one resources secrets, configmaps, and downward API
      * **quobyte** ``QuobyteVolumeSource`` - *(optional)* Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
      * **rbd** ``RBDVolumeSource`` - *(optional)* RBD represents a Rados Block Device mount on the host that shares a pod's
        lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
      * **scaleIO** ``ScaleIOVolumeSource`` - *(optional)* ScaleIO represents a ScaleIO persistent volume attached and mounted on
        Kubernetes nodes.
      * **secret** ``SecretVolumeSource`` - *(optional)* Secret represents a secret that should populate this volume. More info:
        https://kubernetes.io/docs/concepts/storage/volumes#secret
      * **storageos** ``StorageOSVolumeSource`` - *(optional)* StorageOS represents a StorageOS volume attached and mounted on Kubernetes
        nodes.
      * **vsphereVolume** ``VsphereVirtualDiskVolumeSource`` - *(optional)* VsphereVolume represents a vSphere volume attached and mounted on kubelets
        host machine
    """
    name: 'str'
    awsElasticBlockStore: 'AWSElasticBlockStoreVolumeSource' = None
    azureDisk: 'AzureDiskVolumeSource' = None
    azureFile: 'AzureFileVolumeSource' = None
    cephfs: 'CephFSVolumeSource' = None
    cinder: 'CinderVolumeSource' = None
    configMap: 'ConfigMapVolumeSource' = None
    csi: 'CSIVolumeSource' = None
    downwardAPI: 'DownwardAPIVolumeSource' = None
    emptyDir: 'EmptyDirVolumeSource' = None
    fc: 'FCVolumeSource' = None
    flexVolume: 'FlexVolumeSource' = None
    flocker: 'FlockerVolumeSource' = None
    gcePersistentDisk: 'GCEPersistentDiskVolumeSource' = None
    gitRepo: 'GitRepoVolumeSource' = None
    glusterfs: 'GlusterfsVolumeSource' = None
    hostPath: 'HostPathVolumeSource' = None
    iscsi: 'ISCSIVolumeSource' = None
    nfs: 'NFSVolumeSource' = None
    persistentVolumeClaim: 'PersistentVolumeClaimVolumeSource' = None
    photonPersistentDisk: 'PhotonPersistentDiskVolumeSource' = None
    portworxVolume: 'PortworxVolumeSource' = None
    projected: 'ProjectedVolumeSource' = None
    quobyte: 'QuobyteVolumeSource' = None
    rbd: 'RBDVolumeSource' = None
    scaleIO: 'ScaleIOVolumeSource' = None
    secret: 'SecretVolumeSource' = None
    storageos: 'StorageOSVolumeSource' = None
    vsphereVolume: 'VsphereVirtualDiskVolumeSource' = None


@dataclass
class VolumeDevice(DataclassDictMixIn):
    """volumeDevice describes a mapping of a raw block device within a container.

      **parameters**

      * **devicePath** ``str`` - devicePath is the path inside of the container that the device will be mapped
        to.
      * **name** ``str`` - name must match the name of a persistentVolumeClaim in the pod
    """
    devicePath: 'str'
    name: 'str'


@dataclass
class VolumeMount(DataclassDictMixIn):
    """VolumeMount describes a mounting of a Volume within a container.

      **parameters**

      * **mountPath** ``str`` - Path within the container at which the volume should be mounted.  Must not
        contain ':'.
      * **name** ``str`` - This must match the Name of a Volume.
      * **mountPropagation** ``str`` - *(optional)* mountPropagation determines how mounts are propagated from the host to
        container and the other way around. When not set, MountPropagationNone is
        used. This field is beta in 1.10.
      * **readOnly** ``bool`` - *(optional)* Mounted read-only if true, read-write otherwise (false or unspecified).
        Defaults to false.
      * **subPath** ``str`` - *(optional)* Path within the volume from which the container's volume should be mounted.
        Defaults to "" (volume's root).
      * **subPathExpr** ``str`` - *(optional)* Expanded path within the volume from which the container's volume should be
        mounted. Behaves similarly to SubPath but environment variable references
        $(VAR_NAME) are expanded using the container's environment. Defaults to ""
        (volume's root). SubPathExpr and SubPath are mutually exclusive.
    """
    mountPath: 'str'
    name: 'str'
    mountPropagation: 'str' = None
    readOnly: 'bool' = None
    subPath: 'str' = None
    subPathExpr: 'str' = None


@dataclass
class VolumeNodeAffinity(DataclassDictMixIn):
    """VolumeNodeAffinity defines constraints that limit what nodes this volume can
      be accessed from.

      **parameters**

      * **required** ``NodeSelector`` - *(optional)* Required specifies hard node constraints that must be met.
    """
    required: 'NodeSelector' = None


@dataclass
class VolumeProjection(DataclassDictMixIn):
    """Projection that may be projected along with other supported volume types

      **parameters**

      * **configMap** ``ConfigMapProjection`` - *(optional)* information about the configMap data to project
      * **downwardAPI** ``DownwardAPIProjection`` - *(optional)* information about the downwardAPI data to project
      * **secret** ``SecretProjection`` - *(optional)* information about the secret data to project
      * **serviceAccountToken** ``ServiceAccountTokenProjection`` - *(optional)* information about the serviceAccountToken data to project
    """
    configMap: 'ConfigMapProjection' = None
    downwardAPI: 'DownwardAPIProjection' = None
    secret: 'SecretProjection' = None
    serviceAccountToken: 'ServiceAccountTokenProjection' = None


@dataclass
class VsphereVirtualDiskVolumeSource(DataclassDictMixIn):
    """Represents a vSphere volume resource.

      **parameters**

      * **volumePath** ``str`` - Path that identifies vSphere volume vmdk
      * **fsType** ``str`` - *(optional)* Filesystem type to mount. Must be a filesystem type supported by the host
        operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4"
        if unspecified.
      * **storagePolicyID** ``str`` - *(optional)* Storage Policy Based Management (SPBM) profile ID associated with the
        StoragePolicyName.
      * **storagePolicyName** ``str`` - *(optional)* Storage Policy Based Management (SPBM) profile name.
    """
    volumePath: 'str'
    fsType: 'str' = None
    storagePolicyID: 'str' = None
    storagePolicyName: 'str' = None


@dataclass
class WeightedPodAffinityTerm(DataclassDictMixIn):
    """The weights of all of the matched WeightedPodAffinityTerm fields are added
      per-node to find the most preferred node(s)

      **parameters**

      * **podAffinityTerm** ``PodAffinityTerm`` - Required. A pod affinity term, associated with the corresponding weight.
      * **weight** ``int`` - weight associated with matching the corresponding podAffinityTerm, in the
        range 1-100.
    """
    podAffinityTerm: 'PodAffinityTerm'
    weight: 'int'


@dataclass
class WindowsSecurityContextOptions(DataclassDictMixIn):
    """WindowsSecurityContextOptions contain Windows-specific options and
      credentials.

      **parameters**

      * **gmsaCredentialSpec** ``str`` - *(optional)* GMSACredentialSpec is where the GMSA admission webhook
        (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the
        GMSA credential spec named by the GMSACredentialSpecName field. This field is
        alpha-level and is only honored by servers that enable the WindowsGMSA feature
        flag.
      * **gmsaCredentialSpecName** ``str`` - *(optional)* GMSACredentialSpecName is the name of the GMSA credential spec to use. This
        field is alpha-level and is only honored by servers that enable the
        WindowsGMSA feature flag.
      * **runAsUserName** ``str`` - *(optional)* The UserName in Windows to run the entrypoint of the container process.
        Defaults to the user specified in image metadata if unspecified. May also be
        set in PodSecurityContext. If set in both SecurityContext and
        PodSecurityContext, the value specified in SecurityContext takes precedence.
        This field is beta-level and may be disabled with the WindowsRunAsUserName
        feature flag.
    """
    gmsaCredentialSpec: 'str' = None
    gmsaCredentialSpecName: 'str' = None
    runAsUserName: 'str' = None


