# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1


@dataclass
class AuditSink(DataclassDictMixIn):
    """AuditSink represents a cluster level audit sink

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* 
      * **spec** ``AuditSinkSpec`` - *(optional)* Spec defines the audit configuration spec
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'AuditSinkSpec' = None


@dataclass
class AuditSinkList(DataclassDictMixIn):
    """AuditSinkList is a list of AuditSink items.

      **parameters**

      * **items** ``List[AuditSink]`` - List of audit configurations.
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* 
    """
    items: 'List[AuditSink]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class AuditSinkSpec(DataclassDictMixIn):
    """AuditSinkSpec holds the spec for the audit sink

      **parameters**

      * **policy** ``Policy`` - Policy defines the policy for selecting which events should be sent to the
        webhook required
      * **webhook** ``Webhook`` - Webhook to send events required
    """
    policy: 'Policy'
    webhook: 'Webhook'


@dataclass
class Policy(DataclassDictMixIn):
    """Policy defines the configuration of how audit events are logged

      **parameters**

      * **level** ``str`` - The Level that all requests are recorded at. available options: None,
        Metadata, Request, RequestResponse required
      * **stages** ``List[str]`` - *(optional)* Stages is a list of stages for which events are created.
    """
    level: 'str'
    stages: 'List[str]' = None


@dataclass
class ServiceReference(DataclassDictMixIn):
    """ServiceReference holds a reference to Service.legacy.k8s.io

      **parameters**

      * **name** ``str`` - `name` is the name of the service. Required
      * **namespace** ``str`` - `namespace` is the namespace of the service. Required
      * **path** ``str`` - *(optional)* `path` is an optional URL path which will be sent in any request to this
        service.
      * **port** ``int`` - *(optional)* If specified, the port on the service that hosting webhook. Default to 443 for
        backward compatibility. `port` should be a valid port number (1-65535,
        inclusive).
    """
    name: 'str'
    namespace: 'str'
    path: 'str' = None
    port: 'int' = None


@dataclass
class Webhook(DataclassDictMixIn):
    """Webhook holds the configuration of the webhook

      **parameters**

      * **clientConfig** ``WebhookClientConfig`` - ClientConfig holds the connection parameters for the webhook required
      * **throttle** ``WebhookThrottleConfig`` - *(optional)* Throttle holds the options for throttling the webhook
    """
    clientConfig: 'WebhookClientConfig'
    throttle: 'WebhookThrottleConfig' = None


@dataclass
class WebhookClientConfig(DataclassDictMixIn):
    """WebhookClientConfig contains the information to make a connection with the
      webhook

      **parameters**

      * **caBundle** ``str`` - *(optional)* `caBundle` is a PEM encoded CA bundle which will be used to validate the
        webhook's server certificate. If unspecified, system trust roots on the
        apiserver are used.
      * **service** ``ServiceReference`` - *(optional)* `service` is a reference to the service for this webhook. Either `service` or
        `url` must be specified.
        If the webhook is running within the cluster, then you should use `service`.
      * **url** ``str`` - *(optional)* `url` gives the location of the webhook, in standard URL form
        (`scheme://host:port/path`). Exactly one of `url` or `service` must be
        specified.
        The `host` should not refer to a service running in the cluster; use the
        `service` field instead. The host might be resolved via external DNS in some
        apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would
        be a layering violation). `host` may also be an IP address.
        Please note that using `localhost` or `127.0.0.1` as a `host` is risky unless
        you take great care to run this webhook on all hosts which run an apiserver
        which might need to make calls to this webhook. Such installs are likely to be
        non-portable, i.e., not easy to turn up in a new cluster.
        The scheme must be "https"; the URL must begin with "https://".
        A path is optional, and if present may be any string permissible in a URL. You
        may use the path to pass an arbitrary string to the webhook, for example, a
        cluster identifier.
        Attempting to use a user or basic auth e.g. "user:password@" is not allowed.
        Fragments ("#...") and query parameters ("?...") are not allowed, either.
    """
    caBundle: 'str' = None
    service: 'ServiceReference' = None
    url: 'str' = None


@dataclass
class WebhookThrottleConfig(DataclassDictMixIn):
    """WebhookThrottleConfig holds the configuration for throttling events

      **parameters**

      * **burst** ``int`` - *(optional)* ThrottleBurst is the maximum number of events sent at the same moment default
        15 QPS
      * **qps** ``int`` - *(optional)* ThrottleQPS maximum number of batches per second default 10 QPS
    """
    burst: 'int' = None
    qps: 'int' = None


