# autogenerated module
from dataclasses import dataclass, field
from typing import List

from ..core.dataclasses_dict import DataclassDictMixIn

from . import meta_v1


@dataclass
class APIService(DataclassDictMixIn):
    """APIService represents a server for a particular GroupVersion. Name must be
      "version.group".

      **parameters**

      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ObjectMeta`` - *(optional)* 
      * **spec** ``APIServiceSpec`` - *(optional)* Spec contains information for locating and communicating with a server
      * **status** ``APIServiceStatus`` - *(optional)* Status contains derived information about an API server
    """
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ObjectMeta' = None
    spec: 'APIServiceSpec' = None
    status: 'APIServiceStatus' = None


@dataclass
class APIServiceCondition(DataclassDictMixIn):
    """APIServiceCondition describes the state of an APIService at a particular point

      **parameters**

      * **status** ``str`` - Status is the status of the condition. Can be True, False, Unknown.
      * **type** ``str`` - Type is the type of the condition.
      * **lastTransitionTime** ``meta_v1.Time`` - *(optional)* Last time the condition transitioned from one status to another.
      * **message** ``str`` - *(optional)* Human-readable message indicating details about last transition.
      * **reason** ``str`` - *(optional)* Unique, one-word, CamelCase reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastTransitionTime: 'meta_v1.Time' = None
    message: 'str' = None
    reason: 'str' = None


@dataclass
class APIServiceList(DataclassDictMixIn):
    """APIServiceList is a list of APIService objects.

      **parameters**

      * **items** ``List[APIService]`` - 
      * **apiVersion** ``str`` - *(optional)* APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``str`` - *(optional)* Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``meta_v1.ListMeta`` - *(optional)* 
    """
    items: 'List[APIService]'
    apiVersion: 'str' = None
    kind: 'str' = None
    metadata: 'meta_v1.ListMeta' = None


@dataclass
class APIServiceSpec(DataclassDictMixIn):
    """APIServiceSpec contains information for locating and communicating with a
      server. Only https is supported, though you are able to disable certificate
      verification.

      **parameters**

      * **groupPriorityMinimum** ``int`` - GroupPriorityMininum is the priority this group should have at least. Higher
        priority means that the group is preferred by clients over lower priority
        ones. Note that other versions of this group might specify even higher
        GroupPriorityMininum values such that the whole group gets a higher priority.
        The primary sort is based on GroupPriorityMinimum, ordered highest number to
        lowest (20 before 10). The secondary sort is based on the alphabetical
        comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend
        something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift,
        Deis) are recommended to be in the 2000s
      * **service** ``ServiceReference`` - Service is a reference to the service for this API server.  It must
        communicate on port 443 If the Service is nil, that means the handling for the
        API groupversion is handled locally on this server. The call will simply
        delegate to the normal handler chain to be fulfilled.
      * **versionPriority** ``int`` - VersionPriority controls the ordering of this API version inside of its group.
        Must be greater than zero. The primary sort is based on VersionPriority,
        ordered highest to lowest (20 before 10). Since it's inside of a group, the
        number can be small, probably in the 10s. In case of equal version priorities,
        the version string will be used to compute the order inside a group. If the
        version string is "kube-like", it will sort above non "kube-like" version
        strings, which are ordered lexicographically. "Kube-like" versions start with
        a "v", then are followed by a number (the major version), then optionally the
        string "alpha" or "beta" and another number (the minor version). These are
        sorted first by GA > beta > alpha (where GA is a version with no suffix such
        as beta or alpha), and then by comparing major version, then minor version. An
        example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1,
        v12alpha1, v11alpha2, foo1, foo10.
      * **caBundle** ``str`` - *(optional)* CABundle is a PEM encoded CA bundle which will be used to validate an API
        server's serving certificate. If unspecified, system trust roots on the
        apiserver are used.
      * **group** ``str`` - *(optional)* Group is the API group name this server hosts
      * **insecureSkipTLSVerify** ``bool`` - *(optional)* InsecureSkipTLSVerify disables TLS certificate verification when communicating
        with this server. This is strongly discouraged.  You should use the CABundle
        instead.
      * **version** ``str`` - *(optional)* Version is the API version this server hosts.  For example, "v1"
    """
    groupPriorityMinimum: 'int'
    service: 'ServiceReference'
    versionPriority: 'int'
    caBundle: 'str' = None
    group: 'str' = None
    insecureSkipTLSVerify: 'bool' = None
    version: 'str' = None


@dataclass
class APIServiceStatus(DataclassDictMixIn):
    """APIServiceStatus contains derived information about an API server

      **parameters**

      * **conditions** ``List[APIServiceCondition]`` - *(optional)* Current service state of apiService.
    """
    conditions: 'List[APIServiceCondition]' = None


@dataclass
class ServiceReference(DataclassDictMixIn):
    """ServiceReference holds a reference to Service.legacy.k8s.io

      **parameters**

      * **name** ``str`` - *(optional)* Name is the name of the service
      * **namespace** ``str`` - *(optional)* Namespace is the namespace of the service
      * **port** ``int`` - *(optional)* If specified, the port on the service that hosting webhook. Default to 443 for
        backward compatibility. `port` should be a valid port number (1-65535,
        inclusive).
    """
    name: 'str' = None
    namespace: 'str' = None
    port: 'int' = None


