# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._key_vault_management_client_enums import *


class AccessPolicyEntry(msrest.serialization.Model):
    """An identity that have access to the key vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.

    All required parameters must be populated in order to send to Azure.

    :param tenant_id: Required. The Azure Active Directory tenant ID that should be used for
     authenticating requests to the key vault.
    :type tenant_id: str
    :param object_id: Required. The object ID of a user, service principal or security group in the
     Azure Active Directory tenant for the vault. The object ID must be unique for the list of
     access policies.
    :type object_id: str
    :param application_id: Application ID of the client making request on behalf of a principal.
    :type application_id: str
    :param permissions: Required. Permissions the identity has for keys, secrets and certificates.
    :type permissions: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Permissions
    """

    _validation = {
        'tenant_id': {'required': True},
        'object_id': {'required': True},
        'permissions': {'required': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'object_id': {'key': 'objectId', 'type': 'str'},
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'permissions': {'key': 'permissions', 'type': 'Permissions'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        object_id: str,
        permissions: "Permissions",
        application_id: Optional[str] = None,
        **kwargs
    ):
        super(AccessPolicyEntry, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.object_id = object_id
        self.application_id = application_id
        self.permissions = permissions


class Attributes(msrest.serialization.Model):
    """The object attributes managed by the KeyVault service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param enabled: Determines whether the object is enabled.
    :type enabled: bool
    :param not_before: Not before date in seconds since 1970-01-01T00:00:00Z.
    :type not_before: long
    :param expires: Expiry date in seconds since 1970-01-01T00:00:00Z.
    :type expires: long
    :ivar created: Creation time in seconds since 1970-01-01T00:00:00Z.
    :vartype created: long
    :ivar updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
    :vartype updated: long
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'not_before': {'key': 'nbf', 'type': 'long'},
        'expires': {'key': 'exp', 'type': 'long'},
        'created': {'key': 'created', 'type': 'long'},
        'updated': {'key': 'updated', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[int] = None,
        expires: Optional[int] = None,
        **kwargs
    ):
        super(Attributes, self).__init__(**kwargs)
        self.enabled = enabled
        self.not_before = not_before
        self.expires = expires
        self.created = None
        self.updated = None


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: A boolean value that indicates whether the name is available for you to
     use. If true, the name is available. If false, the name has already been taken or is invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: The reason that a vault name could not be used. The Reason element is only
     returned if NameAvailable is false. Possible values include: "AccountNameInvalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.Reason
    :ivar message: An error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CloudErrorBody(msrest.serialization.Model):
    """An error response from Key Vault resource provider.

    :param code: Error code. This is a mnemonic that can be consumed programmatically.
    :type code: str
    :param message: User friendly error message. The message is typically localized and may vary
     with service version.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message


class DeletedManagedHsm(msrest.serialization.Model):
    """DeletedManagedHsm.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the deleted managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :param properties: Properties of the deleted managed HSM.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedManagedHsmProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeletedManagedHsmProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DeletedManagedHsmProperties"] = None,
        **kwargs
    ):
        super(DeletedManagedHsm, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class DeletedManagedHsmListResult(msrest.serialization.Model):
    """List of deleted managed HSM Pools.

    :param value: The list of deleted managed HSM Pools.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedManagedHsm]
    :param next_link: The URL to get the next set of deleted managed HSM Pools.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedManagedHsm]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeletedManagedHsm"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DeletedManagedHsmListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeletedManagedHsmProperties(msrest.serialization.Model):
    """Properties of the deleted managed HSM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar mhsm_id: The resource id of the original managed HSM.
    :vartype mhsm_id: str
    :ivar location: The location of the original managed HSM.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar purge_protection_enabled: Purge protection status of the original managed HSM.
    :vartype purge_protection_enabled: bool
    :ivar tags: A set of tags. Tags of the original managed HSM.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'mhsm_id': {'readonly': True},
        'location': {'readonly': True},
        'deletion_date': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'purge_protection_enabled': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'mhsm_id': {'key': 'mhsmId', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'deletion_date': {'key': 'deletionDate', 'type': 'iso-8601'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'iso-8601'},
        'purge_protection_enabled': {'key': 'purgeProtectionEnabled', 'type': 'bool'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedManagedHsmProperties, self).__init__(**kwargs)
        self.mhsm_id = None
        self.location = None
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.purge_protection_enabled = None
        self.tags = None


class DeletedVault(msrest.serialization.Model):
    """Deleted vault information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID for the deleted key vault.
    :vartype id: str
    :ivar name: The name of the key vault.
    :vartype name: str
    :ivar type: The resource type of the key vault.
    :vartype type: str
    :param properties: Properties of the vault.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedVaultProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'DeletedVaultProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["DeletedVaultProperties"] = None,
        **kwargs
    ):
        super(DeletedVault, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = properties


class DeletedVaultListResult(msrest.serialization.Model):
    """List of vaults.

    :param value: The list of deleted vaults.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.DeletedVault]
    :param next_link: The URL to get the next set of deleted vaults.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DeletedVault]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DeletedVault"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DeletedVaultListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeletedVaultProperties(msrest.serialization.Model):
    """Properties of the deleted vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vault_id: The resource id of the original vault.
    :vartype vault_id: str
    :ivar location: The location of the original vault.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar tags: A set of tags. Tags of the original vault.
    :vartype tags: dict[str, str]
    :ivar purge_protection_enabled: Purge protection status of the original vault.
    :vartype purge_protection_enabled: bool
    """

    _validation = {
        'vault_id': {'readonly': True},
        'location': {'readonly': True},
        'deletion_date': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'tags': {'readonly': True},
        'purge_protection_enabled': {'readonly': True},
    }

    _attribute_map = {
        'vault_id': {'key': 'vaultId', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'deletion_date': {'key': 'deletionDate', 'type': 'iso-8601'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'iso-8601'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'purge_protection_enabled': {'key': 'purgeProtectionEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeletedVaultProperties, self).__init__(**kwargs)
        self.vault_id = None
        self.location = None
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.tags = None
        self.purge_protection_enabled = None


class Error(msrest.serialization.Model):
    """The server error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar inner_error: The inner error, contains a more specific error code.
    :vartype inner_error: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Error
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'inner_error': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'inner_error': {'key': 'innererror', 'type': 'Error'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.inner_error = None


class IPRule(msrest.serialization.Model):
    """A rule governing the accessibility of a vault from a specific ip address or ip range.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple
     IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(IPRule, self).__init__(**kwargs)
        self.value = value


class LogSpecification(msrest.serialization.Model):
    """Log specification of operation.

    :param name: Name of log specification.
    :type name: str
    :param display_name: Display name of log specification.
    :type display_name: str
    :param blob_duration: Blob duration of specification.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagedHsmResource(msrest.serialization.Model):
    """Managed HSM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :param location: The supported Azure location where the managed HSM Pool should be created.
    :type location: str
    :param sku: SKU details.
    :type sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ManagedHsmSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["ManagedHsmSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ManagedHsmResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.sku = sku
        self.tags = tags
        self.system_data = None


class ManagedHsm(ManagedHsmResource):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :param location: The supported Azure location where the managed HSM Pool should be created.
    :type location: str
    :param sku: SKU details.
    :type sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    :param properties: Properties of the managed HSM.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ManagedHsmSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ManagedHsmProperties'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["ManagedHsmSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["ManagedHsmProperties"] = None,
        **kwargs
    ):
        super(ManagedHsm, self).__init__(location=location, sku=sku, tags=tags, **kwargs)
        self.properties = properties


class ManagedHsmError(msrest.serialization.Model):
    """The error exception.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The server error.
    :vartype error: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Error
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'Error'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagedHsmError, self).__init__(**kwargs)
        self.error = None


class ManagedHsmListResult(msrest.serialization.Model):
    """List of managed HSM Pools.

    :param value: The list of managed HSM Pools.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsm]
    :param next_link: The URL to get the next set of managed HSM Pools.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagedHsm]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ManagedHsm"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ManagedHsmListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ManagedHsmProperties(msrest.serialization.Model):
    """Properties of the managed HSM Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the managed HSM pool.
    :type tenant_id: str
    :param initial_admin_object_ids: Array of initial administrators object ids for this managed
     hsm pool.
    :type initial_admin_object_ids: list[str]
    :ivar hsm_uri: The URI of the managed hsm pool for performing operations on keys.
    :vartype hsm_uri: str
    :param enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this managed HSM pool. If it's not set to any value(true or false) when creating
     new managed HSM pool, it will be set to true by default. Once set to true, it cannot be
     reverted to false.
    :type enable_soft_delete: bool
    :param soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
    :type soft_delete_retention_in_days: int
    :param enable_purge_protection: Property specifying whether protection against purge is enabled
     for this managed HSM pool. Setting this property to true activates protection against purge for
     this managed HSM pool and its content - only the Managed HSM service may initiate a hard,
     irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling
     this functionality is irreversible.
    :type enable_purge_protection: bool
    :param create_mode: The create mode to indicate whether the resource is being created or is
     being recovered from a deleted resource. Possible values include: "recover", "default".
    :type create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
    :ivar status_message: Resource Status Message.
    :vartype status_message: str
    :ivar provisioning_state: Provisioning state. Possible values include: "Succeeded",
     "Provisioning", "Failed", "Updating", "Deleting", "Activated", "SecurityDomainRestore",
     "Restoring".
    :vartype provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.ProvisioningState
    :param network_acls: Rules governing the accessibility of the key vault from specific network
     locations.
    :type network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMNetworkRuleSet
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     managed hsm pool.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpointConnectionItem]
    :param public_network_access: Control permission for data plane traffic coming from public
     networks while private endpoint is enabled. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PublicNetworkAccess
    :ivar scheduled_purge_date: The scheduled purge date in UTC.
    :vartype scheduled_purge_date: ~datetime.datetime
    """

    _validation = {
        'hsm_uri': {'readonly': True},
        'status_message': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'initial_admin_object_ids': {'key': 'initialAdminObjectIds', 'type': '[str]'},
        'hsm_uri': {'key': 'hsmUri', 'type': 'str'},
        'enable_soft_delete': {'key': 'enableSoftDelete', 'type': 'bool'},
        'soft_delete_retention_in_days': {'key': 'softDeleteRetentionInDays', 'type': 'int'},
        'enable_purge_protection': {'key': 'enablePurgeProtection', 'type': 'bool'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'network_acls': {'key': 'networkAcls', 'type': 'MHSMNetworkRuleSet'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[MHSMPrivateEndpointConnectionItem]'},
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        initial_admin_object_ids: Optional[List[str]] = None,
        enable_soft_delete: Optional[bool] = True,
        soft_delete_retention_in_days: Optional[int] = 90,
        enable_purge_protection: Optional[bool] = True,
        create_mode: Optional[Union[str, "CreateMode"]] = None,
        network_acls: Optional["MHSMNetworkRuleSet"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        **kwargs
    ):
        super(ManagedHsmProperties, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.initial_admin_object_ids = initial_admin_object_ids
        self.hsm_uri = None
        self.enable_soft_delete = enable_soft_delete
        self.soft_delete_retention_in_days = soft_delete_retention_in_days
        self.enable_purge_protection = enable_purge_protection
        self.create_mode = create_mode
        self.status_message = None
        self.provisioning_state = None
        self.network_acls = network_acls
        self.private_endpoint_connections = None
        self.public_network_access = public_network_access
        self.scheduled_purge_date = None


class ManagedHsmSku(msrest.serialization.Model):
    """SKU details.

    All required parameters must be populated in order to send to Azure.

    :param family: Required. SKU Family of the managed HSM Pool. Possible values include: "B".
    :type family: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSkuFamily
    :param name: Required. SKU of the managed HSM Pool. Possible values include: "Standard_B1",
     "Custom_B32".
    :type name: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSkuName
    """

    _validation = {
        'family': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        family: Union[str, "ManagedHsmSkuFamily"] = "B",
        name: Union[str, "ManagedHsmSkuName"],
        **kwargs
    ):
        super(ManagedHsmSku, self).__init__(**kwargs)
        self.family = family
        self.name = name


class MHSMIPRule(msrest.serialization.Model):
    """A rule governing the accessibility of a managed hsm pool from a specific ip address or ip range.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple
     IP address) or '124.56.78.0/24' (all addresses that start with 124.56.78).
    :type value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        **kwargs
    ):
        super(MHSMIPRule, self).__init__(**kwargs)
        self.value = value


class MHSMNetworkRuleSet(msrest.serialization.Model):
    """A set of rules governing the network accessibility of a managed hsm pool.

    :param bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
     'None'.  If not specified the default is 'AzureServices'. Possible values include:
     "AzureServices", "None".
    :type bypass: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleBypassOptions
    :param default_action: The default action when no rule from ipRules and from
     virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     Possible values include: "Allow", "Deny".
    :type default_action: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleAction
    :param ip_rules: The list of IP address rules.
    :type ip_rules: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMIPRule]
    :param virtual_network_rules: The list of virtual network rules.
    :type virtual_network_rules:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMVirtualNetworkRule]
    """

    _attribute_map = {
        'bypass': {'key': 'bypass', 'type': 'str'},
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'ip_rules': {'key': 'ipRules', 'type': '[MHSMIPRule]'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[MHSMVirtualNetworkRule]'},
    }

    def __init__(
        self,
        *,
        bypass: Optional[Union[str, "NetworkRuleBypassOptions"]] = None,
        default_action: Optional[Union[str, "NetworkRuleAction"]] = None,
        ip_rules: Optional[List["MHSMIPRule"]] = None,
        virtual_network_rules: Optional[List["MHSMVirtualNetworkRule"]] = None,
        **kwargs
    ):
        super(MHSMNetworkRuleSet, self).__init__(**kwargs)
        self.bypass = bypass
        self.default_action = default_action
        self.ip_rules = ip_rules
        self.virtual_network_rules = virtual_network_rules


class MHSMPrivateEndpoint(msrest.serialization.Model):
    """Private endpoint object properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Full identifier of the private endpoint resource.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MHSMPrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class MHSMPrivateEndpointConnection(ManagedHsmResource):
    """Private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :param location: The supported Azure location where the managed HSM Pool should be created.
    :type location: str
    :param sku: SKU details.
    :type sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    :param etag: Modified whenever there is a change in the state of private endpoint connection.
    :type etag: str
    :param private_endpoint: Properties of the private endpoint object.
    :type private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpoint
    :param private_link_service_connection_state: Approval state of the private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkServiceConnectionState
    :param provisioning_state: Provisioning state of the private endpoint connection. Possible
     values include: "Succeeded", "Creating", "Updating", "Deleting", "Failed", "Disconnected".
    :type provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ManagedHsmSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'MHSMPrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'MHSMPrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["ManagedHsmSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        private_endpoint: Optional["MHSMPrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["MHSMPrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs
    ):
        super(MHSMPrivateEndpointConnection, self).__init__(location=location, sku=sku, tags=tags, **kwargs)
        self.etag = etag
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class MHSMPrivateEndpointConnectionItem(msrest.serialization.Model):
    """Private endpoint connection item.

    :param private_endpoint: Properties of the private endpoint object.
    :type private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpoint
    :param private_link_service_connection_state: Approval state of the private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkServiceConnectionState
    :param provisioning_state: Provisioning state of the private endpoint connection. Possible
     values include: "Succeeded", "Creating", "Updating", "Deleting", "Failed", "Disconnected".
    :type provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _attribute_map = {
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'MHSMPrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'MHSMPrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["MHSMPrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["MHSMPrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs
    ):
        super(MHSMPrivateEndpointConnectionItem, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class MHSMPrivateEndpointConnectionsListResult(msrest.serialization.Model):
    """List of private endpoint connections associated with a managed HSM Pools.

    :param value: The private endpoint connection associated with a managed HSM Pools.
    :type value:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateEndpointConnection]
    :param next_link: The URL to get the next set of managed HSM Pools.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MHSMPrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MHSMPrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(MHSMPrivateEndpointConnectionsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class MHSMPrivateLinkResource(ManagedHsmResource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure Resource Manager resource ID for the managed HSM Pool.
    :vartype id: str
    :ivar name: The name of the managed HSM Pool.
    :vartype name: str
    :ivar type: The resource type of the managed HSM Pool.
    :vartype type: str
    :param location: The supported Azure location where the managed HSM Pool should be created.
    :type location: str
    :param sku: SKU details.
    :type sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.ManagedHsmSku
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar system_data: Metadata pertaining to creation and last modification of the key vault
     resource.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :param required_zone_names: Required DNS zone names of the the private link resource.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'ManagedHsmSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        sku: Optional["ManagedHsmSku"] = None,
        tags: Optional[Dict[str, str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(MHSMPrivateLinkResource, self).__init__(location=location, sku=sku, tags=tags, **kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class MHSMPrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.MHSMPrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MHSMPrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["MHSMPrivateLinkResource"]] = None,
        **kwargs
    ):
        super(MHSMPrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class MHSMPrivateLinkServiceConnectionState(msrest.serialization.Model):
    """An object that represents the approval state of the private link connection.

    :param status: Indicates whether the connection has been approved, rejected or removed by the
     key vault owner. Possible values include: "Pending", "Approved", "Rejected", "Disconnected".
    :type status: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval or rejection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. Possible values include: "None".
    :type actions_required: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.ActionsRequired
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[Union[str, "ActionsRequired"]] = None,
        **kwargs
    ):
        super(MHSMPrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class MHSMVirtualNetworkRule(msrest.serialization.Model):
    """A rule governing the accessibility of a managed hsm pool from a specific virtual network.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-
     vnet/subnets/subnet1'.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(MHSMVirtualNetworkRule, self).__init__(**kwargs)
        self.id = id


class NetworkRuleSet(msrest.serialization.Model):
    """A set of rules governing the network accessibility of a vault.

    :param bypass: Tells what traffic can bypass network rules. This can be 'AzureServices' or
     'None'.  If not specified the default is 'AzureServices'. Possible values include:
     "AzureServices", "None".
    :type bypass: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleBypassOptions
    :param default_action: The default action when no rule from ipRules and from
     virtualNetworkRules match. This is only used after the bypass property has been evaluated.
     Possible values include: "Allow", "Deny".
    :type default_action: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleAction
    :param ip_rules: The list of IP address rules.
    :type ip_rules: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.IPRule]
    :param virtual_network_rules: The list of virtual network rules.
    :type virtual_network_rules:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.VirtualNetworkRule]
    """

    _attribute_map = {
        'bypass': {'key': 'bypass', 'type': 'str'},
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
    }

    def __init__(
        self,
        *,
        bypass: Optional[Union[str, "NetworkRuleBypassOptions"]] = None,
        default_action: Optional[Union[str, "NetworkRuleAction"]] = None,
        ip_rules: Optional[List["IPRule"]] = None,
        virtual_network_rules: Optional[List["VirtualNetworkRule"]] = None,
        **kwargs
    ):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.bypass = bypass
        self.default_action = default_action
        self.ip_rules = ip_rules
        self.virtual_network_rules = virtual_network_rules


class Operation(msrest.serialization.Model):
    """Key Vault REST API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.keyvault.v2021_04_01_preview.models.OperationDisplay
    :param origin: The origin of operations.
    :type origin: str
    :param is_data_action: Property to specify whether the action is a data action.
    :type is_data_action: bool
    :param service_specification: One property of operation, include metric specifications.
    :type service_specification:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.is_data_action = is_data_action
        self.service_specification = service_specification


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft Key Vault.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Storage operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of Storage operations supported by the Storage resource provider.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Operation]
    :param next_link: The URL to get the next set of operations.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Permissions(msrest.serialization.Model):
    """Permissions the identity has for keys, secrets, certificates and storage.

    :param keys: Permissions to keys.
    :type keys: list[str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.KeyPermissions]
    :param secrets: Permissions to secrets.
    :type secrets: list[str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.SecretPermissions]
    :param certificates: Permissions to certificates.
    :type certificates: list[str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.CertificatePermissions]
    :param storage: Permissions to storage accounts.
    :type storage: list[str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.StoragePermissions]
    """

    _attribute_map = {
        'keys': {'key': 'keys', 'type': '[str]'},
        'secrets': {'key': 'secrets', 'type': '[str]'},
        'certificates': {'key': 'certificates', 'type': '[str]'},
        'storage': {'key': 'storage', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        keys: Optional[List[Union[str, "KeyPermissions"]]] = None,
        secrets: Optional[List[Union[str, "SecretPermissions"]]] = None,
        certificates: Optional[List[Union[str, "CertificatePermissions"]]] = None,
        storage: Optional[List[Union[str, "StoragePermissions"]]] = None,
        **kwargs
    ):
        super(Permissions, self).__init__(**kwargs)
        self.keys = keys
        self.secrets = secrets
        self.certificates = certificates
        self.storage = storage


class PrivateEndpoint(msrest.serialization.Model):
    """Private endpoint object properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Full identifier of the private endpoint resource.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class Resource(msrest.serialization.Model):
    """Key Vault resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: A set of tags. Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None


class PrivateEndpointConnection(Resource):
    """Private endpoint connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: A set of tags. Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :param etag: Modified whenever there is a change in the state of private endpoint connection.
    :type etag: str
    :param private_endpoint: Properties of the private endpoint object.
    :type private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpoint
    :param private_link_service_connection_state: Approval state of the private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkServiceConnectionState
    :param provisioning_state: Provisioning state of the private endpoint connection. Possible
     values include: "Succeeded", "Creating", "Updating", "Deleting", "Failed", "Disconnected".
    :type provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        etag: Optional[str] = None,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.etag = etag
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionItem(msrest.serialization.Model):
    """Private endpoint connection item.

    :param private_endpoint: Properties of the private endpoint object.
    :type private_endpoint: ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpoint
    :param private_link_service_connection_state: Approval state of the private link connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkServiceConnectionState
    :param provisioning_state: Provisioning state of the private endpoint connection. Possible
     values include: "Succeeded", "Creating", "Updating", "Deleting", "Failed", "Disconnected".
    :type provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionProvisioningState
    """

    _attribute_map = {
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        provisioning_state: Optional[Union[str, "PrivateEndpointConnectionProvisioningState"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionItem, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """List of private endpoint connections.

    :param value: The list of private endpoint connections.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnection]
    :param next_link: The URL to get the next set of private endpoint connections.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: A set of tags. Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :ivar group_id: Group identifier of private link resource.
    :vartype group_id: str
    :ivar required_members: Required member names of private link resource.
    :vartype required_members: list[str]
    :param required_zone_names: Required DNS zone names of the the private link resource.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """An object that represents the approval state of the private link connection.

    :param status: Indicates whether the connection has been approved, rejected or removed by the
     key vault owner. Possible values include: "Pending", "Approved", "Rejected", "Disconnected".
    :type status: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval or rejection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer. Possible values include: "None".
    :type actions_required: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.ActionsRequired
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[Union[str, "ActionsRequired"]] = None,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class ResourceListResult(msrest.serialization.Model):
    """List of vault resources.

    :param value: The list of vault resources.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Resource]
    :param next_link: The URL to get the next set of vault resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Resource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Resource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Secret(Resource):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :ivar location: Azure location of the key vault resource.
    :vartype location: str
    :ivar tags: A set of tags. Tags assigned to the key vault resource.
    :vartype tags: dict[str, str]
    :param properties: Required. Properties of the secret.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SecretProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'SecretProperties'},
    }

    def __init__(
        self,
        *,
        properties: "SecretProperties",
        **kwargs
    ):
        super(Secret, self).__init__(**kwargs)
        self.properties = properties


class SecretAttributes(Attributes):
    """The secret management attributes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param enabled: Determines whether the object is enabled.
    :type enabled: bool
    :param not_before: Not before date in seconds since 1970-01-01T00:00:00Z.
    :type not_before: long
    :param expires: Expiry date in seconds since 1970-01-01T00:00:00Z.
    :type expires: long
    :ivar created: Creation time in seconds since 1970-01-01T00:00:00Z.
    :vartype created: long
    :ivar updated: Last updated time in seconds since 1970-01-01T00:00:00Z.
    :vartype updated: long
    """

    _validation = {
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'not_before': {'key': 'nbf', 'type': 'long'},
        'expires': {'key': 'exp', 'type': 'long'},
        'created': {'key': 'created', 'type': 'long'},
        'updated': {'key': 'updated', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        not_before: Optional[int] = None,
        expires: Optional[int] = None,
        **kwargs
    ):
        super(SecretAttributes, self).__init__(enabled=enabled, not_before=not_before, expires=expires, **kwargs)


class SecretCreateOrUpdateParameters(msrest.serialization.Model):
    """Parameters for creating or updating a secret.

    All required parameters must be populated in order to send to Azure.

    :param tags: A set of tags. The tags that will be assigned to the secret.
    :type tags: dict[str, str]
    :param properties: Required. Properties of the secret.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SecretProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'SecretProperties'},
    }

    def __init__(
        self,
        *,
        properties: "SecretProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(SecretCreateOrUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class SecretListResult(msrest.serialization.Model):
    """List of secrets.

    :param value: The list of secrets.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Secret]
    :param next_link: The URL to get the next set of secrets.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Secret]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Secret"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SecretListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecretPatchParameters(msrest.serialization.Model):
    """Parameters for patching a secret.

    :param tags: A set of tags. The tags that will be assigned to the secret.
    :type tags: dict[str, str]
    :param properties: Properties of the secret.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SecretPatchProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'SecretPatchProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["SecretPatchProperties"] = None,
        **kwargs
    ):
        super(SecretPatchParameters, self).__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class SecretPatchProperties(msrest.serialization.Model):
    """Properties of the secret.

    :param value: The value of the secret.
    :type value: str
    :param content_type: The content type of the secret.
    :type content_type: str
    :param attributes: The attributes of the secret.
    :type attributes: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SecretAttributes
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'SecretAttributes'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        content_type: Optional[str] = None,
        attributes: Optional["SecretAttributes"] = None,
        **kwargs
    ):
        super(SecretPatchProperties, self).__init__(**kwargs)
        self.value = value
        self.content_type = content_type
        self.attributes = attributes


class SecretProperties(msrest.serialization.Model):
    """Properties of the secret.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The value of the secret. NOTE: 'value' will never be returned from the service,
     as APIs using this model are is intended for internal use in ARM deployments. Users should use
     the data-plane REST service for interaction with vault secrets.
    :type value: str
    :param content_type: The content type of the secret.
    :type content_type: str
    :param attributes: The attributes of the secret.
    :type attributes: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SecretAttributes
    :ivar secret_uri: The URI to retrieve the current version of the secret.
    :vartype secret_uri: str
    :ivar secret_uri_with_version: The URI to retrieve the specific version of the secret.
    :vartype secret_uri_with_version: str
    """

    _validation = {
        'secret_uri': {'readonly': True},
        'secret_uri_with_version': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'SecretAttributes'},
        'secret_uri': {'key': 'secretUri', 'type': 'str'},
        'secret_uri_with_version': {'key': 'secretUriWithVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        content_type: Optional[str] = None,
        attributes: Optional["SecretAttributes"] = None,
        **kwargs
    ):
        super(SecretProperties, self).__init__(**kwargs)
        self.value = value
        self.content_type = content_type
        self.attributes = attributes
        self.secret_uri = None
        self.secret_uri_with_version = None


class ServiceSpecification(msrest.serialization.Model):
    """One property of operation, include log specifications.

    :param log_specifications: Log specifications of operation.
    :type log_specifications:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.LogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["LogSpecification"]] = None,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = log_specifications


class Sku(msrest.serialization.Model):
    """SKU details.

    All required parameters must be populated in order to send to Azure.

    :param family: Required. SKU family name. Possible values include: "A".
    :type family: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.SkuFamily
    :param name: Required. SKU name to specify whether the key vault is a standard vault or a
     premium vault. Possible values include: "standard", "premium".
    :type name: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.SkuName
    """

    _validation = {
        'family': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'family': {'key': 'family', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        family: Union[str, "SkuFamily"] = "A",
        name: Union[str, "SkuName"],
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.family = family
        self.name = name


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the key vault resource.

    :param created_by: The identity that created the key vault resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the key vault resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.IdentityType
    :param created_at: The timestamp of the key vault resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the key vault resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the key vault resource.
     Possible values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.IdentityType
    :param last_modified_at: The timestamp of the key vault resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "IdentityType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "IdentityType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class Vault(msrest.serialization.Model):
    """Resource information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the key vault resource.
    :vartype id: str
    :ivar name: Name of the key vault resource.
    :vartype name: str
    :ivar type: Resource type of the key vault resource.
    :vartype type: str
    :param location: Azure location of the key vault resource.
    :type location: str
    :param tags: A set of tags. Tags assigned to the key vault resource.
    :type tags: dict[str, str]
    :ivar system_data: System metadata for the key vault.
    :vartype system_data: ~azure.mgmt.keyvault.v2021_04_01_preview.models.SystemData
    :param properties: Required. Properties of the vault.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
    }

    def __init__(
        self,
        *,
        properties: "VaultProperties",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Vault, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.system_data = None
        self.properties = properties


class VaultAccessPolicyParameters(msrest.serialization.Model):
    """Parameters for updating the access policy in a vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the access policy.
    :vartype id: str
    :ivar name: The resource name of the access policy.
    :vartype name: str
    :ivar type: The resource name of the access policy.
    :vartype type: str
    :ivar location: The resource type of the access policy.
    :vartype location: str
    :param properties: Required. Properties of the access policy.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultAccessPolicyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'VaultAccessPolicyProperties'},
    }

    def __init__(
        self,
        *,
        properties: "VaultAccessPolicyProperties",
        **kwargs
    ):
        super(VaultAccessPolicyParameters, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class VaultAccessPolicyProperties(msrest.serialization.Model):
    """Properties of the vault access policy.

    All required parameters must be populated in order to send to Azure.

    :param access_policies: Required. An array of 0 to 16 identities that have access to the key
     vault. All identities in the array must use the same tenant ID as the key vault's tenant ID.
    :type access_policies: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
    """

    _validation = {
        'access_policies': {'required': True},
    }

    _attribute_map = {
        'access_policies': {'key': 'accessPolicies', 'type': '[AccessPolicyEntry]'},
    }

    def __init__(
        self,
        *,
        access_policies: List["AccessPolicyEntry"],
        **kwargs
    ):
        super(VaultAccessPolicyProperties, self).__init__(**kwargs)
        self.access_policies = access_policies


class VaultCheckNameAvailabilityParameters(msrest.serialization.Model):
    """The parameters used to check the availability of the vault name.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The vault name.
    :type name: str
    :ivar type: Required. The type of resource, Microsoft.KeyVault/vaults. Default value:
     "Microsoft.KeyVault/vaults".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.KeyVault/vaults"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(VaultCheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class VaultCreateOrUpdateParameters(msrest.serialization.Model):
    """Parameters for creating or updating a vault.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The supported Azure location where the key vault should be created.
    :type location: str
    :param tags: A set of tags. The tags that will be assigned to the key vault.
    :type tags: dict[str, str]
    :param properties: Required. Properties of the vault.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProperties
    """

    _validation = {
        'location': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'VaultProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: "VaultProperties",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(VaultCreateOrUpdateParameters, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.properties = properties


class VaultListResult(msrest.serialization.Model):
    """List of vaults.

    :param value: The list of vaults.
    :type value: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.Vault]
    :param next_link: The URL to get the next set of vaults.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Vault]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Vault"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VaultListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VaultPatchParameters(msrest.serialization.Model):
    """Parameters for creating or updating a vault.

    :param tags: A set of tags. The tags that will be assigned to the key vault.
    :type tags: dict[str, str]
    :param properties: Properties of the vault.
    :type properties: ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultPatchProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'VaultPatchProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["VaultPatchProperties"] = None,
        **kwargs
    ):
        super(VaultPatchParameters, self).__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class VaultPatchProperties(msrest.serialization.Model):
    """Properties of the vault.

    :param tenant_id: The Azure Active Directory tenant ID that should be used for authenticating
     requests to the key vault.
    :type tenant_id: str
    :param sku: SKU details.
    :type sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Sku
    :param access_policies: An array of 0 to 16 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID.
    :type access_policies: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
    :param enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :type enabled_for_deployment: bool
    :param enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :type enabled_for_disk_encryption: bool
    :param enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :type enabled_for_template_deployment: bool
    :param enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this key vault. Once set to true, it cannot be reverted to false.
    :type enable_soft_delete: bool
    :param enable_rbac_authorization: Property that controls how data actions are authorized. When
     true, the key vault will use Role Based Access Control (RBAC) for authorization of data
     actions, and the access policies specified in vault properties will be  ignored (warning: this
     is a preview feature). When false, the key vault will use the access policies specified in
     vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or
     not specified, the value of this property will not change.
    :type enable_rbac_authorization: bool
    :param soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
    :type soft_delete_retention_in_days: int
    :param create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Possible values include: "recover", "default".
    :type create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
    :param enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :type enable_purge_protection: bool
    :param network_acls: A collection of rules governing the accessibility of the vault from
     specific network locations.
    :type network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleSet
    """

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'access_policies': {'key': 'accessPolicies', 'type': '[AccessPolicyEntry]'},
        'enabled_for_deployment': {'key': 'enabledForDeployment', 'type': 'bool'},
        'enabled_for_disk_encryption': {'key': 'enabledForDiskEncryption', 'type': 'bool'},
        'enabled_for_template_deployment': {'key': 'enabledForTemplateDeployment', 'type': 'bool'},
        'enable_soft_delete': {'key': 'enableSoftDelete', 'type': 'bool'},
        'enable_rbac_authorization': {'key': 'enableRbacAuthorization', 'type': 'bool'},
        'soft_delete_retention_in_days': {'key': 'softDeleteRetentionInDays', 'type': 'int'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'enable_purge_protection': {'key': 'enablePurgeProtection', 'type': 'bool'},
        'network_acls': {'key': 'networkAcls', 'type': 'NetworkRuleSet'},
    }

    def __init__(
        self,
        *,
        tenant_id: Optional[str] = None,
        sku: Optional["Sku"] = None,
        access_policies: Optional[List["AccessPolicyEntry"]] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = None,
        enable_rbac_authorization: Optional[bool] = None,
        soft_delete_retention_in_days: Optional[int] = None,
        create_mode: Optional[Union[str, "CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        network_acls: Optional["NetworkRuleSet"] = None,
        **kwargs
    ):
        super(VaultPatchProperties, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.enable_rbac_authorization = enable_rbac_authorization
        self.soft_delete_retention_in_days = soft_delete_retention_in_days
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
        self.network_acls = network_acls


class VaultProperties(msrest.serialization.Model):
    """Properties of the vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param tenant_id: Required. The Azure Active Directory tenant ID that should be used for
     authenticating requests to the key vault.
    :type tenant_id: str
    :param sku: Required. SKU details.
    :type sku: ~azure.mgmt.keyvault.v2021_04_01_preview.models.Sku
    :param access_policies: An array of 0 to 1024 identities that have access to the key vault. All
     identities in the array must use the same tenant ID as the key vault's tenant ID. When
     ``createMode`` is set to ``recover``\ , access policies are not required. Otherwise, access
     policies are required.
    :type access_policies: list[~azure.mgmt.keyvault.v2021_04_01_preview.models.AccessPolicyEntry]
    :param vault_uri: The URI of the vault for performing operations on keys and secrets.
    :type vault_uri: str
    :param enabled_for_deployment: Property to specify whether Azure Virtual Machines are permitted
     to retrieve certificates stored as secrets from the key vault.
    :type enabled_for_deployment: bool
    :param enabled_for_disk_encryption: Property to specify whether Azure Disk Encryption is
     permitted to retrieve secrets from the vault and unwrap keys.
    :type enabled_for_disk_encryption: bool
    :param enabled_for_template_deployment: Property to specify whether Azure Resource Manager is
     permitted to retrieve secrets from the key vault.
    :type enabled_for_template_deployment: bool
    :param enable_soft_delete: Property to specify whether the 'soft delete' functionality is
     enabled for this key vault. If it's not set to any value(true or false) when creating new key
     vault, it will be set to true by default. Once set to true, it cannot be reverted to false.
    :type enable_soft_delete: bool
    :param soft_delete_retention_in_days: softDelete data retention days. It accepts >=7 and <=90.
    :type soft_delete_retention_in_days: int
    :param enable_rbac_authorization: Property that controls how data actions are authorized. When
     true, the key vault will use Role Based Access Control (RBAC) for authorization of data
     actions, and the access policies specified in vault properties will be  ignored (warning: this
     is a preview feature). When false, the key vault will use the access policies specified in
     vault properties, and any policy stored on Azure Resource Manager will be ignored. If null or
     not specified, the vault is created with the default value of false. Note that management
     actions are always authorized with RBAC.
    :type enable_rbac_authorization: bool
    :param create_mode: The vault's create mode to indicate whether the vault need to be recovered
     or not. Possible values include: "recover", "default".
    :type create_mode: str or ~azure.mgmt.keyvault.v2021_04_01_preview.models.CreateMode
    :param enable_purge_protection: Property specifying whether protection against purge is enabled
     for this vault. Setting this property to true activates protection against purge for this vault
     and its content - only the Key Vault service may initiate a hard, irrecoverable deletion. The
     setting is effective only if soft delete is also enabled. Enabling this functionality is
     irreversible - that is, the property does not accept false as its value.
    :type enable_purge_protection: bool
    :param network_acls: Rules governing the accessibility of the key vault from specific network
     locations.
    :type network_acls: ~azure.mgmt.keyvault.v2021_04_01_preview.models.NetworkRuleSet
    :param provisioning_state: Provisioning state of the vault. Possible values include:
     "Succeeded", "RegisteringDns".
    :type provisioning_state: str or
     ~azure.mgmt.keyvault.v2021_04_01_preview.models.VaultProvisioningState
    :ivar private_endpoint_connections: List of private endpoint connections associated with the
     key vault.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.keyvault.v2021_04_01_preview.models.PrivateEndpointConnectionItem]
    """

    _validation = {
        'tenant_id': {'required': True},
        'sku': {'required': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'access_policies': {'key': 'accessPolicies', 'type': '[AccessPolicyEntry]'},
        'vault_uri': {'key': 'vaultUri', 'type': 'str'},
        'enabled_for_deployment': {'key': 'enabledForDeployment', 'type': 'bool'},
        'enabled_for_disk_encryption': {'key': 'enabledForDiskEncryption', 'type': 'bool'},
        'enabled_for_template_deployment': {'key': 'enabledForTemplateDeployment', 'type': 'bool'},
        'enable_soft_delete': {'key': 'enableSoftDelete', 'type': 'bool'},
        'soft_delete_retention_in_days': {'key': 'softDeleteRetentionInDays', 'type': 'int'},
        'enable_rbac_authorization': {'key': 'enableRbacAuthorization', 'type': 'bool'},
        'create_mode': {'key': 'createMode', 'type': 'str'},
        'enable_purge_protection': {'key': 'enablePurgeProtection', 'type': 'bool'},
        'network_acls': {'key': 'networkAcls', 'type': 'NetworkRuleSet'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'private_endpoint_connections': {'key': 'privateEndpointConnections', 'type': '[PrivateEndpointConnectionItem]'},
    }

    def __init__(
        self,
        *,
        tenant_id: str,
        sku: "Sku",
        access_policies: Optional[List["AccessPolicyEntry"]] = None,
        vault_uri: Optional[str] = None,
        enabled_for_deployment: Optional[bool] = None,
        enabled_for_disk_encryption: Optional[bool] = None,
        enabled_for_template_deployment: Optional[bool] = None,
        enable_soft_delete: Optional[bool] = True,
        soft_delete_retention_in_days: Optional[int] = 90,
        enable_rbac_authorization: Optional[bool] = False,
        create_mode: Optional[Union[str, "CreateMode"]] = None,
        enable_purge_protection: Optional[bool] = None,
        network_acls: Optional["NetworkRuleSet"] = None,
        provisioning_state: Optional[Union[str, "VaultProvisioningState"]] = None,
        **kwargs
    ):
        super(VaultProperties, self).__init__(**kwargs)
        self.tenant_id = tenant_id
        self.sku = sku
        self.access_policies = access_policies
        self.vault_uri = vault_uri
        self.enabled_for_deployment = enabled_for_deployment
        self.enabled_for_disk_encryption = enabled_for_disk_encryption
        self.enabled_for_template_deployment = enabled_for_template_deployment
        self.enable_soft_delete = enable_soft_delete
        self.soft_delete_retention_in_days = soft_delete_retention_in_days
        self.enable_rbac_authorization = enable_rbac_authorization
        self.create_mode = create_mode
        self.enable_purge_protection = enable_purge_protection
        self.network_acls = network_acls
        self.provisioning_state = provisioning_state
        self.private_endpoint_connections = None


class VirtualNetworkRule(msrest.serialization.Model):
    """A rule governing the accessibility of a vault from a specific virtual network.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Full resource id of a vnet subnet, such as
     '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-
     vnet/subnets/subnet1'.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.id = id
