from Core.JobBase import JobBase
import json
from Test.TestDao import TestDao


class TestAction(JobBase):
    api_key = ''

    def __init__(self, *args, **kwargs):
        super(self.__class__, self).__init__(*args, **kwargs)

    def initialize(self):
        self.maxHourlyPageView = 1000000
        self.proxy = [self.PROXY_SQUID_US_3]
        if self.debug():
            self.proxy = [self.LOCALHOST]
        self._dao = TestDao(run_id=self.run_id,run_date=self.run_date, log=self.log)

    def on_run(self):
        try:
            self.log.info("%s has started" % self.__class__.__name__,
                          "jobID:[%s]" % self.job_id)
            self.initialize()
            self.api_key = ''
            self.test()
            self.log.info("%s has finished" % self.__class__.__name__,
                          "jobID:[%s]" % self.job_id)
        except Exception as e:
            self.log.error("Unexpected/Unhandled Error", str(e))

    # def get_popularity(self, place_id):
    #     response = populartimes.get_id(self.api_key, place_id)
    #     # self.
    #     # for each in

    def test(self):
        url = 'http://ip-api.com/json'
        page = self.download_page(url, self.init_http_manager(default_header=True), validate_str_list=[''])
        self._dao.save(json.loads(page))

    pass

if __name__ == '__main__':
    t = TestAction()
    t.on_run()