# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6320, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ResponseBase(msrest.serialization.Model):
    """Response base.

    :param type:
    :type type: str
    """

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResponseBase, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)


class Identifiable(ResponseBase):
    """Defines the identity of a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identifiable, self).__init__(**kwargs)
        self.id = None


class Response(Identifiable):
    """Defines a response. All schemas that return at the root of the response must inherit from this object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Response, self).__init__(**kwargs)
        self.read_link = None
        self.web_search_url = None


class Thing(Response):
    """Defines a thing.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Thing, self).__init__(**kwargs)
        self.name = None
        self.url = None
        self.image = None
        self.description = None
        self.alternate_name = None
        self.bing_id = None


class CreativeWork(Thing):
    """The most generic kind of creative work, including books, movies, photographs, software programs, etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreativeWork, self).__init__(**kwargs)
        self.thumbnail_url = None
        self.provider = None
        self.date_published = None
        self.text = None


class Action(CreativeWork):
    """Defines an action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar result: The result produced in the action.
    :vartype result: list[~visual_search_client.models.Thing]
    :ivar display_name: A display name for the action.
    :vartype display_name: str
    :ivar is_top_action: A Boolean representing whether this result is the top action.
    :vartype is_top_action: bool
    :ivar service_url: Use this URL to get additional data to determine how to take the appropriate
     action. For example, the serviceUrl might return JSON along with an image URL.
    :vartype service_url: str
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Action, self).__init__(**kwargs)
        self.result = None
        self.display_name = None
        self.is_top_action = None
        self.service_url = None


class Offer(Thing):
    """Defines a merchant's offer.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar seller: Seller for this offer.
    :vartype seller: ~visual_search_client.models.Thing
    :ivar price: The item's price.
    :vartype price: float
    :ivar price_currency: The monetary currency. For example, USD. Possible values include: "USD",
     "CAD", "GBP", "EUR", "COP", "JPY", "CNY", "AUD", "INR", "AED", "AFN", "ALL", "AMD", "ANG",
     "AOA", "ARS", "AWG", "AZN", "BAM", "BBD", "BDT", "BGN", "BHD", "BIF", "BMD", "BND", "BOB",
     "BOV", "BRL", "BSD", "BTN", "BWP", "BYR", "BZD", "CDF", "CHE", "CHF", "CHW", "CLF", "CLP",
     "COU", "CRC", "CUC", "CUP", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD", "EGP", "ERN", "ETB",
     "FJD", "FKP", "GEL", "GHS", "GIP", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HRK", "HTG",
     "HUF", "IDR", "ILS", "IQD", "IRR", "ISK", "JMD", "JOD", "KES", "KGS", "KHR", "KMF", "KPW",
     "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LYD", "MAD", "MDL", "MGA",
     "MKD", "MMK", "MNT", "MOP", "MRO", "MUR", "MVR", "MWK", "MXN", "MXV", "MYR", "MZN", "NAD",
     "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG",
     "QAR", "RON", "RSD", "RUB", "RWF", "SAR", "SBD", "SCR", "SDG", "SEK", "SGD", "SHP", "SLL",
     "SOS", "SRD", "SSP", "STD", "SYP", "SZL", "THB", "TJS", "TMT", "TND", "TOP", "TRY", "TTD",
     "TWD", "TZS", "UAH", "UGX", "UYU", "UZS", "VEF", "VND", "VUV", "WST", "XAF", "XCD", "XOF",
     "XPF", "YER", "ZAR", "ZMW".
    :vartype price_currency: str or ~visual_search_client.models.Currency
    :ivar availability: The item's availability. The following are the possible values:
     Discontinued, InStock, InStoreOnly, LimitedAvailability, OnlineOnly, OutOfStock, PreOrder,
     SoldOut. Possible values include: "Discontinued", "InStock", "InStoreOnly",
     "LimitedAvailability", "OnlineOnly", "OutOfStock", "PreOrder", "SoldOut".
    :vartype availability: str or ~visual_search_client.models.ItemAvailability
    :ivar aggregate_rating: An aggregated rating that indicates how well the product has been rated
     by others.
    :vartype aggregate_rating: ~visual_search_client.models.AggregateRating
    :ivar last_updated: The last date that the offer was updated. The date is in the form YYYY-MM-
     DD.
    :vartype last_updated: str
    """

    _validation = {
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'seller': {'readonly': True},
        'price': {'readonly': True},
        'price_currency': {'readonly': True},
        'availability': {'readonly': True},
        'aggregate_rating': {'readonly': True},
        'last_updated': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'seller': {'key': 'seller', 'type': 'Thing'},
        'price': {'key': 'price', 'type': 'float'},
        'price_currency': {'key': 'priceCurrency', 'type': 'str'},
        'availability': {'key': 'availability', 'type': 'str'},
        'aggregate_rating': {'key': 'aggregateRating', 'type': 'AggregateRating'},
        'last_updated': {'key': 'lastUpdated', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Offer, self).__init__(**kwargs)
        self.seller = None
        self.price = None
        self.price_currency = None
        self.availability = None
        self.aggregate_rating = None
        self.last_updated = None


class AggregateOffer(Offer):
    """Defines a list of offers from merchants that are related to the image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar seller: Seller for this offer.
    :vartype seller: ~visual_search_client.models.Thing
    :ivar price: The item's price.
    :vartype price: float
    :ivar price_currency: The monetary currency. For example, USD. Possible values include: "USD",
     "CAD", "GBP", "EUR", "COP", "JPY", "CNY", "AUD", "INR", "AED", "AFN", "ALL", "AMD", "ANG",
     "AOA", "ARS", "AWG", "AZN", "BAM", "BBD", "BDT", "BGN", "BHD", "BIF", "BMD", "BND", "BOB",
     "BOV", "BRL", "BSD", "BTN", "BWP", "BYR", "BZD", "CDF", "CHE", "CHF", "CHW", "CLF", "CLP",
     "COU", "CRC", "CUC", "CUP", "CVE", "CZK", "DJF", "DKK", "DOP", "DZD", "EGP", "ERN", "ETB",
     "FJD", "FKP", "GEL", "GHS", "GIP", "GMD", "GNF", "GTQ", "GYD", "HKD", "HNL", "HRK", "HTG",
     "HUF", "IDR", "ILS", "IQD", "IRR", "ISK", "JMD", "JOD", "KES", "KGS", "KHR", "KMF", "KPW",
     "KRW", "KWD", "KYD", "KZT", "LAK", "LBP", "LKR", "LRD", "LSL", "LYD", "MAD", "MDL", "MGA",
     "MKD", "MMK", "MNT", "MOP", "MRO", "MUR", "MVR", "MWK", "MXN", "MXV", "MYR", "MZN", "NAD",
     "NGN", "NIO", "NOK", "NPR", "NZD", "OMR", "PAB", "PEN", "PGK", "PHP", "PKR", "PLN", "PYG",
     "QAR", "RON", "RSD", "RUB", "RWF", "SAR", "SBD", "SCR", "SDG", "SEK", "SGD", "SHP", "SLL",
     "SOS", "SRD", "SSP", "STD", "SYP", "SZL", "THB", "TJS", "TMT", "TND", "TOP", "TRY", "TTD",
     "TWD", "TZS", "UAH", "UGX", "UYU", "UZS", "VEF", "VND", "VUV", "WST", "XAF", "XCD", "XOF",
     "XPF", "YER", "ZAR", "ZMW".
    :vartype price_currency: str or ~visual_search_client.models.Currency
    :ivar availability: The item's availability. The following are the possible values:
     Discontinued, InStock, InStoreOnly, LimitedAvailability, OnlineOnly, OutOfStock, PreOrder,
     SoldOut. Possible values include: "Discontinued", "InStock", "InStoreOnly",
     "LimitedAvailability", "OnlineOnly", "OutOfStock", "PreOrder", "SoldOut".
    :vartype availability: str or ~visual_search_client.models.ItemAvailability
    :ivar aggregate_rating: An aggregated rating that indicates how well the product has been rated
     by others.
    :vartype aggregate_rating: ~visual_search_client.models.AggregateRating
    :ivar last_updated: The last date that the offer was updated. The date is in the form YYYY-MM-
     DD.
    :vartype last_updated: str
    :ivar offers: A list of offers from merchants that have offerings related to the image.
    :vartype offers: list[~visual_search_client.models.Offer]
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'seller': {'readonly': True},
        'price': {'readonly': True},
        'price_currency': {'readonly': True},
        'availability': {'readonly': True},
        'aggregate_rating': {'readonly': True},
        'last_updated': {'readonly': True},
        'offers': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'seller': {'key': 'seller', 'type': 'Thing'},
        'price': {'key': 'price', 'type': 'float'},
        'price_currency': {'key': 'priceCurrency', 'type': 'str'},
        'availability': {'key': 'availability', 'type': 'str'},
        'aggregate_rating': {'key': 'aggregateRating', 'type': 'AggregateRating'},
        'last_updated': {'key': 'lastUpdated', 'type': 'str'},
        'offers': {'key': 'offers', 'type': '[Offer]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AggregateOffer, self).__init__(**kwargs)
        self.offers = None


class PropertiesItem(msrest.serialization.Model):
    """Defines an item.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: Rating.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Text representation of an item.
    :vartype text: str
    :param type: Required. Constant filled by server.
    :type type: str
    """

    _validation = {
        'text': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
    }

    _subtype_map = {
        'type': {'Rating': 'Rating'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PropertiesItem, self).__init__(**kwargs)
        self.text = None
        self.type = None  # type: Optional[str]


class Rating(PropertiesItem):
    """Defines a rating.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AggregateRating.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Text representation of an item.
    :vartype text: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param rating_value: Required. The mean (average) rating. The possible values are 1.0 through
     5.0.
    :type rating_value: float
    :ivar best_rating: The highest rated review. The possible values are 1.0 through 5.0.
    :vartype best_rating: float
    """

    _validation = {
        'text': {'readonly': True},
        'type': {'required': True},
        'rating_value': {'required': True},
        'best_rating': {'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'rating_value': {'key': 'ratingValue', 'type': 'float'},
        'best_rating': {'key': 'bestRating', 'type': 'float'},
    }

    _subtype_map = {
        'type': {'AggregateRating': 'AggregateRating'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Rating, self).__init__(**kwargs)
        self.type = 'Rating'  # type: str
        self.rating_value = kwargs['rating_value']
        self.best_rating = None


class AggregateRating(Rating):
    """Defines the metrics that indicate how well an item was rated by others.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Text representation of an item.
    :vartype text: str
    :param type: Required. Constant filled by server.
    :type type: str
    :param rating_value: Required. The mean (average) rating. The possible values are 1.0 through
     5.0.
    :type rating_value: float
    :ivar best_rating: The highest rated review. The possible values are 1.0 through 5.0.
    :vartype best_rating: float
    :ivar review_count: The number of times the recipe has been rated or reviewed.
    :vartype review_count: int
    """

    _validation = {
        'text': {'readonly': True},
        'type': {'required': True},
        'rating_value': {'required': True},
        'best_rating': {'readonly': True},
        'review_count': {'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'rating_value': {'key': 'ratingValue', 'type': 'float'},
        'best_rating': {'key': 'bestRating', 'type': 'float'},
        'review_count': {'key': 'reviewCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AggregateRating, self).__init__(**kwargs)
        self.type = 'AggregateRating'  # type: str
        self.review_count = None


class CropArea(msrest.serialization.Model):
    """A JSON object consisting of coordinates specifying the four corners of a cropped rectangle within the input image.

    All required parameters must be populated in order to send to Azure.

    :param top: Required. The top coordinate of the region to be cropped. The coordinate is a
     fractional value of the original image's height and is measured from the top edge of the image.
     Specify the coordinate as a value from 0.0 through 1.0.
    :type top: float
    :param bottom: Required. The bottom coordinate of the region to be cropped. The coordinate is a
     fractional value of the original image's height and is measured from the top edge of the image.
     Specify the coordinate as a value from 0.0 through 1.0.
    :type bottom: float
    :param left: Required. The left coordinate of the region to be cropped. The coordinate is a
     fractional value of the original image's width and is measured from the left edge of the image.
     Specify the coordinate as a value from 0.0 through 1.0.
    :type left: float
    :param right: Required. The right coordinate of the region to be cropped. The coordinate is a
     fractional value of the original image's width and is measured from the left edge of the image.
     Specify the coordinate as a value from 0.0 through 1.0.
    :type right: float
    """

    _validation = {
        'top': {'required': True},
        'bottom': {'required': True},
        'left': {'required': True},
        'right': {'required': True},
    }

    _attribute_map = {
        'top': {'key': 'top', 'type': 'float'},
        'bottom': {'key': 'bottom', 'type': 'float'},
        'left': {'key': 'left', 'type': 'float'},
        'right': {'key': 'right', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CropArea, self).__init__(**kwargs)
        self.top = kwargs['top']
        self.bottom = kwargs['bottom']
        self.left = kwargs['left']
        self.right = kwargs['right']


class Error(msrest.serialization.Model):
    """Defines the error that occurred.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error code that identifies the category of error. Possible values
     include: "None", "ServerError", "InvalidRequest", "RateLimitExceeded", "InvalidAuthorization",
     "InsufficientAuthorization". Default value: "None".
    :type code: str or ~visual_search_client.models.ErrorCode
    :ivar sub_code: The error code that further helps to identify the error. Possible values
     include: "UnexpectedError", "ResourceError", "NotImplemented", "ParameterMissing",
     "ParameterInvalidValue", "HttpNotAllowed", "Blocked", "AuthorizationMissing",
     "AuthorizationRedundancy", "AuthorizationDisabled", "AuthorizationExpired".
    :vartype sub_code: str or ~visual_search_client.models.ErrorSubCode
    :param message: Required. A description of the error.
    :type message: str
    :ivar more_details: A description that provides additional information about the error.
    :vartype more_details: str
    :ivar parameter: The parameter in the request that caused the error.
    :vartype parameter: str
    :ivar value: The parameter's value in the request that was not valid.
    :vartype value: str
    """

    _validation = {
        'code': {'required': True},
        'sub_code': {'readonly': True},
        'message': {'required': True},
        'more_details': {'readonly': True},
        'parameter': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'sub_code': {'key': 'subCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'more_details': {'key': 'moreDetails', 'type': 'str'},
        'parameter': {'key': 'parameter', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.code = kwargs.get('code', "None")
        self.sub_code = None
        self.message = kwargs['message']
        self.more_details = None
        self.parameter = None
        self.value = None


class ErrorResponse(Response):
    """The top-level response that represents a failed request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :param errors: Required. A list of errors that describe the reasons why the request failed.
    :type errors: list[~visual_search_client.models.Error]
    """

    _validation = {
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'errors': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'errors': {'key': 'errors', 'type': '[Error]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.errors = kwargs['errors']


class Filters(msrest.serialization.Model):
    """A key-value object consisting of filters that may be specified to limit the results returned by the API. Current available filters: site.

    :param site: The URL of the site to return similar images and similar products from. (e.g.,
     "www.bing.com", "bing.com").
    :type site: str
    """

    _attribute_map = {
        'site': {'key': 'site', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Filters, self).__init__(**kwargs)
        self.site = kwargs.get('site', None)


class ImageAction(Action):
    """Defines an image action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar result: The result produced in the action.
    :vartype result: list[~visual_search_client.models.Thing]
    :ivar display_name: A display name for the action.
    :vartype display_name: str
    :ivar is_top_action: A Boolean representing whether this result is the top action.
    :vartype is_top_action: bool
    :ivar service_url: Use this URL to get additional data to determine how to take the appropriate
     action. For example, the serviceUrl might return JSON along with an image URL.
    :vartype service_url: str
    :ivar action_type: A string representing the type of action.
    :vartype action_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageAction, self).__init__(**kwargs)
        self.action_type = None


class ImageEntityAction(ImageAction):
    """Defines an entity action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar result: The result produced in the action.
    :vartype result: list[~visual_search_client.models.Thing]
    :ivar display_name: A display name for the action.
    :vartype display_name: str
    :ivar is_top_action: A Boolean representing whether this result is the top action.
    :vartype is_top_action: bool
    :ivar service_url: Use this URL to get additional data to determine how to take the appropriate
     action. For example, the serviceUrl might return JSON along with an image URL.
    :vartype service_url: str
    :ivar action_type: A string representing the type of action.
    :vartype action_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageEntityAction, self).__init__(**kwargs)


class ImageInfo(msrest.serialization.Model):
    """A JSON object that identities the image to get insights of . It also includes the optional crop area that you use to identify the region of interest in the image.

    :param image_insights_token: An image insights token. To get the insights token, call one of
     the Image Search APIs (for example, /images/search). In the search results, the `Image
     <https://docs.microsoft.com/en-us/bing/bing-visual-search/overview>`_ object's
     `imageInsightsToken <https://docs.microsoft.com/en-us/bing/bing-visual-search/overview>`_ field
     contains the token. The imageInsightsToken and url fields mutually exclusive; do not specify
     both. Do not specify an insights token if the request includes the image form data.
    :type image_insights_token: str
    :param url: The URL of the input image. The imageInsightsToken and url fields are mutually
     exclusive; do not specify both. Do not specify the URL if the request includes the image form
     data.
    :type url: str
    :param crop_area: A JSON object consisting of coordinates specifying the four corners of a
     cropped rectangle within the input image. Use the crop area to identify the region of interest
     in the image. You can apply the crop area to the images specified using the imageInsightsToken
     or url fields, or an image binary specified in an image form data.
    :type crop_area: ~visual_search_client.models.CropArea
    """

    _attribute_map = {
        'image_insights_token': {'key': 'imageInsightsToken', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'crop_area': {'key': 'cropArea', 'type': 'CropArea'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageInfo, self).__init__(**kwargs)
        self.image_insights_token = kwargs.get('image_insights_token', None)
        self.url = kwargs.get('url', None)
        self.crop_area = kwargs.get('crop_area', None)


class ImageKnowledge(Response):
    """Defines a visual search API response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar tags: A set of tags. A list of visual search tags.
    :vartype tags: list[~visual_search_client.models.ImageTag]
    :ivar image: Image object containing metadata about the requested image.
    :vartype image: ~visual_search_client.models.ImageObject
    """

    _validation = {
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'tags': {'readonly': True},
        'image': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '[ImageTag]'},
        'image': {'key': 'image', 'type': 'ImageObject'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageKnowledge, self).__init__(**kwargs)
        self.tags = None
        self.image = None


class ImageModuleAction(ImageAction):
    """Defines an image list action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar result: The result produced in the action.
    :vartype result: list[~visual_search_client.models.Thing]
    :ivar display_name: A display name for the action.
    :vartype display_name: str
    :ivar is_top_action: A Boolean representing whether this result is the top action.
    :vartype is_top_action: bool
    :ivar service_url: Use this URL to get additional data to determine how to take the appropriate
     action. For example, the serviceUrl might return JSON along with an image URL.
    :vartype service_url: str
    :ivar action_type: A string representing the type of action.
    :vartype action_type: str
    :ivar data: A list of images.
    :vartype data: ~visual_search_client.models.ImagesModule
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
        'action_type': {'readonly': True},
        'data': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
        'data': {'key': 'data', 'type': 'ImagesModule'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageModuleAction, self).__init__(**kwargs)
        self.data = None


class MediaObject(CreativeWork):
    """Defines a media object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the media object (e.g., the
     source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar content_size: Size of the media object content. Use format "value unit" (e.g., "1024 B").
    :vartype content_size: str
    :ivar encoding_format: Encoding format (e.g., png, gif, jpeg, etc).
    :vartype encoding_format: str
    :ivar host_page_display_url: Display URL of the page that hosts the media object.
    :vartype host_page_display_url: str
    :ivar width: The width of the media object, in pixels.
    :vartype width: int
    :ivar height: The height of the media object, in pixels.
    :vartype height: int
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'content_size': {'readonly': True},
        'encoding_format': {'readonly': True},
        'host_page_display_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'content_size': {'key': 'contentSize', 'type': 'str'},
        'encoding_format': {'key': 'encodingFormat', 'type': 'str'},
        'host_page_display_url': {'key': 'hostPageDisplayUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MediaObject, self).__init__(**kwargs)
        self.content_url = None
        self.host_page_url = None
        self.content_size = None
        self.encoding_format = None
        self.host_page_display_url = None
        self.width = None
        self.height = None


class ImageObject(MediaObject):
    """Defines an image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar content_url: Original URL to retrieve the source (file) for the media object (e.g., the
     source URL for the image).
    :vartype content_url: str
    :ivar host_page_url: URL of the page that hosts the media object.
    :vartype host_page_url: str
    :ivar content_size: Size of the media object content. Use format "value unit" (e.g., "1024 B").
    :vartype content_size: str
    :ivar encoding_format: Encoding format (e.g., png, gif, jpeg, etc).
    :vartype encoding_format: str
    :ivar host_page_display_url: Display URL of the page that hosts the media object.
    :vartype host_page_display_url: str
    :ivar width: The width of the media object, in pixels.
    :vartype width: int
    :ivar height: The height of the media object, in pixels.
    :vartype height: int
    :ivar thumbnail: The URL to a thumbnail of the image.
    :vartype thumbnail: ~visual_search_client.models.ImageObject
    :ivar image_insights_token: The token that you use in a subsequent call to Visual Search API to
     get additional information about the image. For information about using this token, see the
     imageInsightsToken field inside the knowledgeRequest request parameter.
    :vartype image_insights_token: str
    :ivar insights_metadata: A count of the number of websites where you can shop or perform other
     actions related to the image. For example, if the image is of an apple pie, this object
     includes a count of the number of websites where you can buy an apple pie. To indicate the
     number of offers in your UX, include badging such as a shopping cart icon that contains the
     count. When the user clicks on the icon, use imageInsightsToken in a subsequent Visual Search
     API call to get the list of shopping websites.
    :vartype insights_metadata: ~visual_search_client.models.ImagesImageMetadata
    :ivar image_id: Unique Id for the image.
    :vartype image_id: str
    :ivar accent_color: A three-byte hexadecimal number that represents the color that dominates
     the image. Use the color as the temporary background in your client until the image is loaded.
    :vartype accent_color: str
    :ivar visual_words: For internal use only.
    :vartype visual_words: str
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'content_url': {'readonly': True},
        'host_page_url': {'readonly': True},
        'content_size': {'readonly': True},
        'encoding_format': {'readonly': True},
        'host_page_display_url': {'readonly': True},
        'width': {'readonly': True},
        'height': {'readonly': True},
        'thumbnail': {'readonly': True},
        'image_insights_token': {'readonly': True},
        'insights_metadata': {'readonly': True},
        'image_id': {'readonly': True},
        'accent_color': {'readonly': True},
        'visual_words': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'content_url': {'key': 'contentUrl', 'type': 'str'},
        'host_page_url': {'key': 'hostPageUrl', 'type': 'str'},
        'content_size': {'key': 'contentSize', 'type': 'str'},
        'encoding_format': {'key': 'encodingFormat', 'type': 'str'},
        'host_page_display_url': {'key': 'hostPageDisplayUrl', 'type': 'str'},
        'width': {'key': 'width', 'type': 'int'},
        'height': {'key': 'height', 'type': 'int'},
        'thumbnail': {'key': 'thumbnail', 'type': 'ImageObject'},
        'image_insights_token': {'key': 'imageInsightsToken', 'type': 'str'},
        'insights_metadata': {'key': 'insightsMetadata', 'type': 'ImagesImageMetadata'},
        'image_id': {'key': 'imageId', 'type': 'str'},
        'accent_color': {'key': 'accentColor', 'type': 'str'},
        'visual_words': {'key': 'visualWords', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageObject, self).__init__(**kwargs)
        self.thumbnail = None
        self.image_insights_token = None
        self.insights_metadata = None
        self.image_id = None
        self.accent_color = None
        self.visual_words = None


class ImageRecipesAction(ImageAction):
    """Defines an recipe action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar result: The result produced in the action.
    :vartype result: list[~visual_search_client.models.Thing]
    :ivar display_name: A display name for the action.
    :vartype display_name: str
    :ivar is_top_action: A Boolean representing whether this result is the top action.
    :vartype is_top_action: bool
    :ivar service_url: Use this URL to get additional data to determine how to take the appropriate
     action. For example, the serviceUrl might return JSON along with an image URL.
    :vartype service_url: str
    :ivar action_type: A string representing the type of action.
    :vartype action_type: str
    :ivar data: A list of recipes related to the image.
    :vartype data: ~visual_search_client.models.RecipesModule
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
        'action_type': {'readonly': True},
        'data': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
        'data': {'key': 'data', 'type': 'RecipesModule'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageRecipesAction, self).__init__(**kwargs)
        self.data = None


class ImageRelatedSearchesAction(ImageAction):
    """Defines an related search action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar result: The result produced in the action.
    :vartype result: list[~visual_search_client.models.Thing]
    :ivar display_name: A display name for the action.
    :vartype display_name: str
    :ivar is_top_action: A Boolean representing whether this result is the top action.
    :vartype is_top_action: bool
    :ivar service_url: Use this URL to get additional data to determine how to take the appropriate
     action. For example, the serviceUrl might return JSON along with an image URL.
    :vartype service_url: str
    :ivar action_type: A string representing the type of action.
    :vartype action_type: str
    :ivar data: A list of queries related to the image.
    :vartype data: ~visual_search_client.models.RelatedSearchesModule
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
        'action_type': {'readonly': True},
        'data': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
        'data': {'key': 'data', 'type': 'RelatedSearchesModule'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageRelatedSearchesAction, self).__init__(**kwargs)
        self.data = None


class ImageShoppingSourcesAction(ImageAction):
    """Defines a shopping sources action.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar result: The result produced in the action.
    :vartype result: list[~visual_search_client.models.Thing]
    :ivar display_name: A display name for the action.
    :vartype display_name: str
    :ivar is_top_action: A Boolean representing whether this result is the top action.
    :vartype is_top_action: bool
    :ivar service_url: Use this URL to get additional data to determine how to take the appropriate
     action. For example, the serviceUrl might return JSON along with an image URL.
    :vartype service_url: str
    :ivar action_type: A string representing the type of action.
    :vartype action_type: str
    :ivar data: A list of merchants that offer items related to the image.
    :vartype data: ~visual_search_client.models.AggregateOffer
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'result': {'readonly': True},
        'display_name': {'readonly': True},
        'is_top_action': {'readonly': True},
        'service_url': {'readonly': True},
        'action_type': {'readonly': True},
        'data': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'result': {'key': 'result', 'type': '[Thing]'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'is_top_action': {'key': 'isTopAction', 'type': 'bool'},
        'service_url': {'key': 'serviceUrl', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
        'data': {'key': 'data', 'type': 'AggregateOffer'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageShoppingSourcesAction, self).__init__(**kwargs)
        self.data = None


class ImagesImageMetadata(msrest.serialization.Model):
    """Defines a count of the number of websites where you can shop or perform other actions related to the image.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar shopping_sources_count: The number of websites that sell the products seen in the image.
    :vartype shopping_sources_count: int
    :ivar recipe_sources_count: The number of websites that offer recipes of the food seen in the
     image.
    :vartype recipe_sources_count: int
    :ivar aggregate_offer: A summary of the online offers of products found in the image. For
     example, if the image is of a dress, the offer might identify the lowest price and the number
     of offers found. Only visually similar products insights include this field. The offer includes
     the following fields: Name, AggregateRating, OfferCount, and LowPrice.
    :vartype aggregate_offer: ~visual_search_client.models.AggregateOffer
    """

    _validation = {
        'shopping_sources_count': {'readonly': True},
        'recipe_sources_count': {'readonly': True},
        'aggregate_offer': {'readonly': True},
    }

    _attribute_map = {
        'shopping_sources_count': {'key': 'shoppingSourcesCount', 'type': 'int'},
        'recipe_sources_count': {'key': 'recipeSourcesCount', 'type': 'int'},
        'aggregate_offer': {'key': 'aggregateOffer', 'type': 'AggregateOffer'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImagesImageMetadata, self).__init__(**kwargs)
        self.shopping_sources_count = None
        self.recipe_sources_count = None
        self.aggregate_offer = None


class ImagesModule(msrest.serialization.Model):
    """Defines a list of images.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of images.
    :vartype value: list[~visual_search_client.models.ImageObject]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ImageObject]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImagesModule, self).__init__(**kwargs)
        self.value = None


class ImageTag(Thing):
    """A visual search tag.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar display_name: Display name for this tag. For the default tag, the display name is empty.
    :vartype display_name: str
    :ivar bounding_box: The bounding box for this tag. For the default tag, there is no bounding
     box.
    :vartype bounding_box: ~visual_search_client.models.ImageTagRegion
    :ivar actions: Actions within this tag. The order of the items denotes the default ranking
     order of these actions, with the first action being the most likely user intent.
    :vartype actions: list[~visual_search_client.models.ImageAction]
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'display_name': {'readonly': True},
        'bounding_box': {'readonly': True},
        'actions': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'bounding_box': {'key': 'boundingBox', 'type': 'ImageTagRegion'},
        'actions': {'key': 'actions', 'type': '[ImageAction]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageTag, self).__init__(**kwargs)
        self.display_name = None
        self.bounding_box = None
        self.actions = None


class ImageTagRegion(msrest.serialization.Model):
    """Defines an image region relevant to the ImageTag.

    All required parameters must be populated in order to send to Azure.

    :param query_rectangle: Required. A rectangle that outlines the area of interest for this tag.
    :type query_rectangle: ~visual_search_client.models.NormalizedQuadrilateral
    :param display_rectangle: Required. A recommended rectangle to show to the user.
    :type display_rectangle: ~visual_search_client.models.NormalizedQuadrilateral
    """

    _validation = {
        'query_rectangle': {'required': True},
        'display_rectangle': {'required': True},
    }

    _attribute_map = {
        'query_rectangle': {'key': 'queryRectangle', 'type': 'NormalizedQuadrilateral'},
        'display_rectangle': {'key': 'displayRectangle', 'type': 'NormalizedQuadrilateral'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImageTagRegion, self).__init__(**kwargs)
        self.query_rectangle = kwargs['query_rectangle']
        self.display_rectangle = kwargs['display_rectangle']


class Intangible(Thing):
    """A utility class that serves as the umbrella for a number of 'intangible' things such as quantities, structured values, etc.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Intangible, self).__init__(**kwargs)


class KnowledgeRequest(msrest.serialization.Model):
    """A JSON object containing information about the request, such as filters for the resulting actions.

    :param filters: A key-value object consisting of filters that may be specified to limit the
     results returned by the API.
    :type filters: ~visual_search_client.models.Filters
    """

    _attribute_map = {
        'filters': {'key': 'filters', 'type': 'Filters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KnowledgeRequest, self).__init__(**kwargs)
        self.filters = kwargs.get('filters', None)


class NormalizedQuadrilateral(Intangible):
    """Defines a region of an image. The region is a convex quadrilateral defined by coordinates of its top left, top right, bottom left, and bottom right points. The coordinates are fractional values of the original image's width and height in the range 0.0 through 1.0.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :param top_left: Required. The top left corner coordinate.
    :type top_left: ~visual_search_client.models.Point2D
    :param top_right: Required. The top right corner coordinate.
    :type top_right: ~visual_search_client.models.Point2D
    :param bottom_right: Required. The bottom right corner coordinate.
    :type bottom_right: ~visual_search_client.models.Point2D
    :param bottom_left: Required. The bottom left corner coordinate.
    :type bottom_left: ~visual_search_client.models.Point2D
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'top_left': {'required': True},
        'top_right': {'required': True},
        'bottom_right': {'required': True},
        'bottom_left': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'top_left': {'key': 'topLeft', 'type': 'Point2D'},
        'top_right': {'key': 'topRight', 'type': 'Point2D'},
        'bottom_right': {'key': 'bottomRight', 'type': 'Point2D'},
        'bottom_left': {'key': 'bottomLeft', 'type': 'Point2D'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NormalizedQuadrilateral, self).__init__(**kwargs)
        self.top_left = kwargs['top_left']
        self.top_right = kwargs['top_right']
        self.bottom_right = kwargs['bottom_right']
        self.bottom_left = kwargs['bottom_left']


class Organization(Thing):
    """Defines an organization.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Organization, self).__init__(**kwargs)


class PathsPsg33EImagesVisualsearchPostRequestbodyContentMultipartFormDataSchema(msrest.serialization.Model):
    """PathsPsg33EImagesVisualsearchPostRequestbodyContentMultipartFormDataSchema.

    :param visual_search: The form data is a JSON object that identifies the image using an
     insights token or URL to the image. The object may also include an optional crop area that
     identifies an area of interest in the image. The insights token and URL are mutually exclusive
     – do not specify both. You may specify knowledgeRequest form data and image form data in the
     same request only if knowledgeRequest form data specifies the cropArea field only (it must not
     include an insights token or URL).
    :type visual_search: str
    :param image: The form data is an image binary. The Content-Disposition header's name parameter
     must be set to "image". You must specify an image binary if you do not use knowledgeRequest
     form data to specify the image; you may not use both forms to specify an image. You may specify
     knowledgeRequest form data and image form data in the same request only if knowledgeRequest
     form data specifies the cropArea field only  (it must not include an insights token or URL).
    :type image: IO
    """

    _attribute_map = {
        'visual_search': {'key': 'knowledgeRequest', 'type': 'str'},
        'image': {'key': 'image', 'type': 'IO'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PathsPsg33EImagesVisualsearchPostRequestbodyContentMultipartFormDataSchema, self).__init__(**kwargs)
        self.visual_search = kwargs.get('visual_search', None)
        self.image = kwargs.get('image', None)


class Person(Thing):
    """Defines a person.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar job_title: The person's job title.
    :vartype job_title: str
    :ivar twitter_profile: The URL of the person's twitter profile.
    :vartype twitter_profile: str
    """

    _validation = {
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'job_title': {'readonly': True},
        'twitter_profile': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'job_title': {'key': 'jobTitle', 'type': 'str'},
        'twitter_profile': {'key': 'twitterProfile', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Person, self).__init__(**kwargs)
        self.job_title = None
        self.twitter_profile = None


class Point2D(Intangible):
    """Defines a 2D point with X and Y coordinates.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :param x: Required. The x-coordinate of the point.
    :type x: float
    :param y: Required. The y-coordinate of the point.
    :type y: float
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'x': {'required': True},
        'y': {'required': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'x': {'key': 'x', 'type': 'float'},
        'y': {'key': 'y', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Point2D, self).__init__(**kwargs)
        self.x = kwargs['x']
        self.y = kwargs['y']


class Query(msrest.serialization.Model):
    """Defines a search query.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param text: Required. The query string. Use this string as the query term in a new search
     request.
    :type text: str
    :ivar display_text: The display version of the query term.
    :vartype display_text: str
    :ivar web_search_url: The URL that takes the user to the Bing search results page for the
     query.
    :vartype web_search_url: str
    :ivar search_link: The URL that you use to get the results of the related search. Before using
     the URL, you must append query parameters as appropriate and include the Ocp-Apim-Subscription-
     Key header. Use this URL if you're displaying the results in your own user interface.
     Otherwise, use the webSearchUrl URL.
    :vartype search_link: str
    :ivar thumbnail: The URL to a thumbnail of a related image.
    :vartype thumbnail: ~visual_search_client.models.ImageObject
    """

    _validation = {
        'text': {'required': True},
        'display_text': {'readonly': True},
        'web_search_url': {'readonly': True},
        'search_link': {'readonly': True},
        'thumbnail': {'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'display_text': {'key': 'displayText', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'search_link': {'key': 'searchLink', 'type': 'str'},
        'thumbnail': {'key': 'thumbnail', 'type': 'ImageObject'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Query, self).__init__(**kwargs)
        self.text = kwargs['text']
        self.display_text = None
        self.web_search_url = None
        self.search_link = None
        self.thumbnail = None


class Recipe(CreativeWork):
    """Defines a cooking recipe.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    :ivar thumbnail_url: The URL to a thumbnail of the item.
    :vartype thumbnail_url: str
    :ivar provider: The source of the creative work.
    :vartype provider: list[~visual_search_client.models.Thing]
    :ivar date_published: The date on which the CreativeWork was published.
    :vartype date_published: str
    :ivar text: Text content of this creative work.
    :vartype text: str
    :ivar cook_time: The amount of time the food takes to cook. For example, PT25M. For information
     about the time format, see http://en.wikipedia.org/wiki/ISO_8601#Durations.
    :vartype cook_time: str
    :ivar prep_time: The amount of time required to prepare the ingredients. For example, PT15M.
     For information about the time format, see http://en.wikipedia.org/wiki/ISO_8601#Durations.
    :vartype prep_time: str
    :ivar total_time: The total amount of time it takes to prepare and cook the recipe. For
     example, PT45M. For information about the time format, see
     http://en.wikipedia.org/wiki/ISO_8601#Durations.
    :vartype total_time: str
    """

    _validation = {
        'id': {'readonly': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
        'thumbnail_url': {'readonly': True},
        'provider': {'readonly': True},
        'date_published': {'readonly': True},
        'text': {'readonly': True},
        'cook_time': {'readonly': True},
        'prep_time': {'readonly': True},
        'total_time': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
        'thumbnail_url': {'key': 'thumbnailUrl', 'type': 'str'},
        'provider': {'key': 'provider', 'type': '[Thing]'},
        'date_published': {'key': 'datePublished', 'type': 'str'},
        'text': {'key': 'text', 'type': 'str'},
        'cook_time': {'key': 'cookTime', 'type': 'str'},
        'prep_time': {'key': 'prepTime', 'type': 'str'},
        'total_time': {'key': 'totalTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Recipe, self).__init__(**kwargs)
        self.cook_time = None
        self.prep_time = None
        self.total_time = None


class RecipesModule(msrest.serialization.Model):
    """Defines a list of recipes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of recipes.
    :vartype value: list[~visual_search_client.models.Recipe]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Recipe]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecipesModule, self).__init__(**kwargs)
        self.value = None


class RelatedSearchesModule(msrest.serialization.Model):
    """Defines a list of related searches.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of related searches.
    :vartype value: list[~visual_search_client.models.Query]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Query]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RelatedSearchesModule, self).__init__(**kwargs)
        self.value = None


class StructuredValue(Thing):
    """StructuredValue.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource. To use the URL, append query parameters as
     appropriate and include the Ocp-Apim-Subscription-Key header.
    :vartype read_link: str
    :ivar web_search_url: The URL to Bing's search result for this item.
    :vartype web_search_url: str
    :ivar name: The name of the thing represented by this object.
    :vartype name: str
    :ivar url: The URL to get more information about the thing represented by this object.
    :vartype url: str
    :ivar image: An image of the item.
    :vartype image: ~visual_search_client.models.ImageObject
    :ivar description: A short description of the item.
    :vartype description: str
    :ivar alternate_name: An alias for the item.
    :vartype alternate_name: str
    :ivar bing_id: An ID that uniquely identifies this item.
    :vartype bing_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'name': {'readonly': True},
        'url': {'readonly': True},
        'image': {'readonly': True},
        'description': {'readonly': True},
        'alternate_name': {'readonly': True},
        'bing_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'image': {'key': 'image', 'type': 'ImageObject'},
        'description': {'key': 'description', 'type': 'str'},
        'alternate_name': {'key': 'alternateName', 'type': 'str'},
        'bing_id': {'key': 'bingId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StructuredValue, self).__init__(**kwargs)


class VisualSearchRequest(msrest.serialization.Model):
    """A JSON object that contains information about the image to get insights of. Specify this object only in a knowledgeRequest form data.

    :param image_info: A JSON object that identities the image to get insights of.
    :type image_info: ~visual_search_client.models.ImageInfo
    :param knowledge_request: A JSON object containing information about the request, such as
     filters, or a description.
    :type knowledge_request: ~visual_search_client.models.KnowledgeRequest
    """

    _attribute_map = {
        'image_info': {'key': 'imageInfo', 'type': 'ImageInfo'},
        'knowledge_request': {'key': 'knowledgeRequest', 'type': 'KnowledgeRequest'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VisualSearchRequest, self).__init__(**kwargs)
        self.image_info = kwargs.get('image_info', None)
        self.knowledge_request = kwargs.get('knowledge_request', None)
