/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.log;

import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.JavaLoggerFactory;
import com.sas.util.log.Log4jReflectionLoggerFactory;
import com.sas.util.log.LoggerFactoryInterface;

public class CommonLoggerFactory {
    private CommonLoggerFactory() {
    }

    public static LoggerFactoryInterface getInstance() {
        boolean debug = Boolean.getBoolean("com.sas.util.log.debug");
        String log4jLoggerClassName = "org.apache.log4j.Logger";
        try {
            Class<?> log4jLoggerClass = Class.forName("org.apache.log4j.Logger");
            return new Log4jReflectionLoggerFactory(log4jLoggerClass);
        }
        catch (Exception e) {
            if (debug) {
                CommonLoggerFactory.say("could not load org.apache.log4j.Logger: " + e);
            }
            if (debug) {
                CommonLoggerFactory.say("using java.util.logging factory");
            }
            return new JavaLoggerFactory();
        }
    }

    public static CommonLoggerInterface getLogger(Class<?> clazz) {
        return CommonLoggerFactory.getLogger(clazz.getName());
    }

    public static CommonLoggerInterface getLogger(String context) {
        LoggerFactoryInterface loggerFactory = CommonLoggerFactory.getInstance();
        return loggerFactory.makeNewLoggerInstance(context);
    }

    private static void say(String s) {
        System.out.println(s);
    }
}

