/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.util.RB;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

@SASScope(value="ALL")
public class NumberUtil {
    public static final String RB_KEY = "NumberUtil.";
    private static NumberFormat numFormatter;
    private static NumberFormat numberFormatter;
    private static Locale lastLocale;
    private static Locale numberFormatterLocale;

    public static String toString(Double value) {
        if (value == null) {
            return "null";
        }
        return NumberUtil.toString((double)value);
    }

    public static String toString(double d) {
        return NumberUtil.toString(d, Locale.getDefault());
    }

    public static String toString(double d, Locale locale) {
        Locale loc = locale;
        if (numFormatter == null || lastLocale != loc) {
            numFormatter = DecimalFormat.getInstance(loc);
            lastLocale = loc;
        }
        DecimalFormat formatter = null;
        if (numFormatter instanceof DecimalFormat) {
            formatter = (DecimalFormat)numFormatter;
        }
        if (Double.isNaN(d) || formatter == null) {
            return numFormatter.format(d);
        }
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        StringBuffer buffer = new StringBuffer();
        buffer.append(d < 0.0 ? formatter.getNegativePrefix() : formatter.getPositivePrefix());
        String formatted = Double.toString(Math.abs(d));
        int len = formatted.length();
        for (int i = 0; i < len; ++i) {
            char c = formatted.charAt(i);
            buffer.append(c == '.' ? symbols.getDecimalSeparator() : c);
        }
        buffer.append(d < 0.0 ? formatter.getNegativeSuffix() : formatter.getPositiveSuffix());
        return buffer.toString();
    }

    public static String toString(Float value) {
        if (value == null) {
            return "null";
        }
        return NumberUtil.toString(value.floatValue());
    }

    public static String toString(float d) {
        return NumberUtil.toString(d, Locale.getDefault());
    }

    public static String toString(float d, Locale locale) {
        Locale loc = locale;
        if (numFormatter == null || lastLocale != loc) {
            numFormatter = DecimalFormat.getInstance(loc);
            lastLocale = loc;
        }
        DecimalFormat formatter = null;
        if (numFormatter instanceof DecimalFormat) {
            formatter = (DecimalFormat)numFormatter;
        }
        if (Float.isNaN(d) || formatter == null) {
            return numFormatter.format(d);
        }
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        StringBuffer buffer = new StringBuffer();
        buffer.append(d < 0.0f ? formatter.getNegativePrefix() : formatter.getPositivePrefix());
        String formatted = Float.toString(Math.abs(d));
        int len = formatted.length();
        for (int i = 0; i < len; ++i) {
            char c = formatted.charAt(i);
            buffer.append(c == '.' ? symbols.getDecimalSeparator() : c);
        }
        buffer.append(d < 0.0f ? formatter.getNegativeSuffix() : formatter.getPositiveSuffix());
        return buffer.toString();
    }

    public static float floatValueOf(String floatString) {
        return NumberUtil.floatValueOf(floatString, Locale.getDefault());
    }

    public static synchronized float floatValueOf(String floatString, Locale locale) {
        Locale loc = locale;
        if (numberFormatter == null || !numberFormatterLocale.equals(loc)) {
            numberFormatterLocale = loc;
            numberFormatter = NumberFormat.getInstance(numberFormatterLocale);
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormatter.parse(floatString.toUpperCase(), parsePosition);
        if (parsePosition.getIndex() != 0 && number != null) {
            return number.floatValue();
        }
        String message = RB.getStringResource(RB_KEY, "floatValueOf.invalidString.ex.txt");
        throw new NumberFormatException(MessageFormat.format(message, floatString));
    }

    public static double doubleValueOf(String doubleString) {
        return NumberUtil.doubleValueOf(doubleString, Locale.getDefault());
    }

    public static synchronized double doubleValueOf(String doubleString, Locale locale) {
        Locale loc = locale;
        if (numberFormatter == null || !numberFormatterLocale.equals(loc)) {
            numberFormatterLocale = loc;
            numberFormatter = NumberFormat.getInstance(numberFormatterLocale);
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = numberFormatter.parse(doubleString.toUpperCase(), parsePosition);
        if (parsePosition.getIndex() != 0 && number != null) {
            return number.doubleValue();
        }
        String message = RB.getStringResource(RB_KEY, "doubleValueOf.invalidString.ex.txt");
        throw new NumberFormatException(MessageFormat.format(message, doubleString));
    }

    @SASScope
    public static int getPrecisionDigitCount(String input, Locale locale) {
        int eIndex = (input = input.toLowerCase(locale)).indexOf("e");
        if (eIndex != -1) {
            input = input.substring(0, eIndex);
        }
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(locale);
        DecimalFormatSymbols formatSymbols = decimalFormat.getDecimalFormatSymbols();
        StringBuffer strippedVersion = NumberUtil.deleteCharacters(input, new char[]{formatSymbols.getMinusSign(), formatSymbols.getGroupingSeparator(), formatSymbols.getDecimalSeparator()});
        while (strippedVersion.length() > 0 && strippedVersion.charAt(0) == formatSymbols.getZeroDigit()) {
            strippedVersion.deleteCharAt(0);
        }
        while (strippedVersion.length() > 0 && strippedVersion.charAt(strippedVersion.length() - 1) == formatSymbols.getZeroDigit()) {
            strippedVersion.deleteCharAt(strippedVersion.length() - 1);
        }
        int digitCount = strippedVersion.length();
        return digitCount;
    }

    private static StringBuffer deleteCharacters(String input, char[] charsToDelete) {
        StringBuffer output = new StringBuffer(input.length());
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            boolean copy = true;
            char inputChar = input.charAt(i);
            for (int charIndex = 0; charIndex < charsToDelete.length; ++charIndex) {
                if (inputChar != charsToDelete[charIndex]) continue;
                copy = false;
                break;
            }
            if (!copy) continue;
            output.append(inputChar);
        }
        return output;
    }

    @SASScope
    public static int getDecimalDigitCount(String input, Locale locale) {
        input = input.toLowerCase();
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance(locale);
        DecimalFormatSymbols formatSymbols = decimalFormat.getDecimalFormatSymbols();
        int eValue = 0;
        int eIndexOrEnd = input.indexOf("e");
        if (eIndexOrEnd != -1) {
            String eText = input.substring(eIndexOrEnd + 1);
            eValue = Integer.parseInt(eText);
            input = input.substring(0, eIndexOrEnd);
        }
        StringBuffer strippedVersion = NumberUtil.deleteCharacters(input, new char[]{formatSymbols.getMinusSign(), formatSymbols.getGroupingSeparator()});
        input = strippedVersion.toString();
        int decimalPlaces = 0;
        int decimalIndex = input.indexOf(formatSymbols.getDecimalSeparator());
        if (decimalIndex != -1) {
            decimalPlaces = input.length() - decimalIndex - 1;
        }
        if ((decimalPlaces -= eValue) < 0) {
            decimalPlaces = 0;
        }
        return decimalPlaces;
    }
}

