/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.codepolicy.SASScope;
import com.sas.util.NumberUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.text.NumberFormat;

@SASScope
public class ObjectTokenizer
extends StreamTokenizer {
    public static final int TT_OBJECT = -600;
    protected Object lastObject;
    private boolean parseCharacters;
    private boolean parseBooleans;
    private boolean parseBytes;
    private boolean parseShorts;
    private boolean parseIntegers;
    private boolean parseLongs;
    private boolean parseFloats;
    private boolean parseDoubles;
    private int token;
    private StringBuffer buffer;
    private String localeFormattedNumber;

    public ObjectTokenizer(Reader reader) {
        super(reader);
        this.resetSyntax();
        this.quoteChar(34);
        this.ordinaryChars(0, 32);
    }

    @Override
    public void resetSyntax() {
        super.resetSyntax();
        this.ordinaryChars(0, 32);
        this.parseCharacters();
        this.parseBytes(false);
        this.parseShorts(false);
        this.parseIntegers(false);
        this.parseLongs(false);
        this.parseFloats(false);
        this.parseDoubles(false);
        this.parseBooleans(false);
    }

    protected boolean parsingNumbers() {
        return this.parseBytes | this.parseShorts | this.parseIntegers | this.parseLongs | this.parseFloats | this.parseDoubles;
    }

    private boolean tokenIsNumeric(String delimiters) {
        if (delimiters.indexOf((char)this.token) >= 0) {
            return false;
        }
        if (this.localeFormattedNumber == null) {
            NumberFormat format = NumberFormat.getInstance();
            this.localeFormattedNumber = format.format(-1.5);
        }
        return Character.isDigit((char)this.token) || this.localeFormattedNumber.indexOf(this.token) >= 0;
    }

    private void resetStringBuffer() {
        if (this.buffer == null) {
            this.buffer = new StringBuffer(16);
        }
        this.buffer.setLength(0);
    }

    public int nextObject(String delimiters, boolean allowNull) throws IOException {
        this.lastObject = null;
        this.parseObjects();
        this.skipWhitespace(delimiters);
        this.token = this.nextToken();
        if (this.token == -1) {
            return -1;
        }
        if (this.token == 39 && this.sval.length() == 1 && this.parseCharacters) {
            this.lastObject = new Character(this.sval.charAt(0));
        } else if (this.token == 34 | this.token == 39) {
            this.lastObject = this.sval;
        } else {
            if (delimiters.indexOf(this.token) != -1) {
                return this.token;
            }
            this.parseAnObject(delimiters, allowNull);
        }
        this.skipWhitespace(delimiters);
        return -600;
    }

    private void parseAnObject(String delimiters, boolean allowNull) throws IOException {
        this.resetStringBuffer();
        boolean numeric = this.tokenIsNumeric(delimiters);
        if (numeric) {
            while (this.tokenIsNumeric(delimiters) || this.token == 101 || this.token == 69) {
                this.buffer.append((char)this.token);
                this.token = this.nextToken();
            }
            int len = this.buffer.length();
            this.skipWhitespace(delimiters, true);
            if (this.token == -1 || delimiters.indexOf(this.token) != -1) {
                this.pushBack();
                try {
                    this.buffer.setLength(len);
                    this.nval = NumberUtil.doubleValueOf(this.buffer.toString());
                    this.lastObject = this.parseBytes && this.nval >= -128.0 && this.nval <= 127.0 && this.nval == (double)((byte)this.nval) ? new Byte((byte)this.nval) : (this.parseShorts && this.nval >= -32768.0 && this.nval <= 32767.0 && this.nval == (double)((short)this.nval) ? new Short((short)this.nval) : (this.parseIntegers && this.nval >= -2.147483648E9 && this.nval <= 2.147483647E9 && this.nval == (double)((int)this.nval) ? new Integer((int)this.nval) : (this.parseLongs && this.nval >= -9.223372036854776E18 && this.nval <= 9.223372036854776E18 && this.nval == (double)((long)this.nval) ? new Long((long)this.nval) : (this.parseFloats && this.nval >= (double)1.4E-45f && this.nval <= 3.4028234663852886E38 ? new Float((float)this.nval) : (this.parseDoubles ? new Double(this.nval) : this.sval)))));
                    return;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.resetSyntax();
        this.ordinaryChars(0, 32);
        while (this.token != -1 && delimiters.indexOf(this.token) == -1) {
            if (this.sval == null) {
                this.buffer.append((char)this.token);
            } else {
                this.buffer.append(this.sval);
            }
            this.token = this.nextToken();
        }
        this.pushBack();
        this.parseBooleans(true);
        String itemText = this.buffer.toString();
        String trimmedText = itemText.trim();
        this.lastObject = allowNull && trimmedText.equals("null") ? null : (this.parseBooleans && trimmedText.equals("true") ? Boolean.TRUE : (this.parseBooleans && trimmedText.equals("false") ? Boolean.FALSE : trimmedText));
        this.parseObjects();
    }

    public Object getLastObject() {
        return this.lastObject;
    }

    public void parseCharacters() {
        this.quoteChar(39);
        this.parseCharacters = true;
    }

    public void parseBooleans(boolean state) {
        this.parseBooleans = state;
    }

    protected void parseObjects() {
        this.resetSyntax();
        this.parseNumbers();
        this.parseBooleans(true);
        this.ordinaryChars(0, 32);
        this.quoteChar(34);
    }

    public void parseBytes(boolean state) {
        this.parseBytes = state;
    }

    public void parseShorts(boolean state) {
        this.parseShorts = state;
    }

    public void parseIntegers(boolean state) {
        this.parseIntegers = state;
    }

    public void parseLongs(boolean state) {
        this.parseLongs = state;
    }

    public void parseFloats(boolean state) {
        this.parseFloats = state;
    }

    public void parseDoubles(boolean state) {
        this.parseDoubles = state;
    }

    @Override
    public void parseNumbers() {
        this.parseBytes(false);
        this.parseShorts(false);
        this.parseIntegers(true);
        this.parseLongs(true);
        this.parseFloats(false);
        this.parseDoubles(true);
    }

    public void skipWhitespace(String delimiters) throws IOException {
        this.token = this.nextToken();
        while (this.token != -1 && delimiters.indexOf(this.token) == -1 && Character.isWhitespace((char)this.token)) {
            this.token = this.nextToken();
        }
        this.pushBack();
    }

    public void skipWhitespace(String delimiters, boolean append) throws IOException {
        while (this.token != -1 && delimiters.indexOf(this.token) == -1 && Character.isWhitespace((char)this.token)) {
            if (append) {
                this.buffer.append((char)this.token);
            }
            this.token = this.nextToken();
        }
    }
}

