/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans;

import com.sas.beans.Introspector;
import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;

public abstract class BaseCustomizerUtil {
    public static Class getCustomizerClass(Class beanClass) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return null;
        }
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        if (beanDescriptor == null) {
            return null;
        }
        Class<?> customizerClass = beanDescriptor.getCustomizerClass();
        return customizerClass;
    }

    public static Class getCustomizerClass(Class beanClass, boolean useSuperclass) {
        if (!useSuperclass) {
            return BaseCustomizerUtil.getCustomizerClass(beanClass);
        }
        while (beanClass != null) {
            Class customizerClass = BaseCustomizerUtil.getCustomizerClass(beanClass);
            if (customizerClass != null) {
                return customizerClass;
            }
            beanClass = beanClass.getSuperclass();
        }
        return null;
    }

    public static Class getCustomizerClass(Object bean, boolean useSuperclass) {
        return BaseCustomizerUtil.getCustomizerClass(bean.getClass(), useSuperclass);
    }

    public static Class getCustomizerClass(Object bean) {
        return BaseCustomizerUtil.getCustomizerClass(bean.getClass());
    }

    public static Component getCustomizer(Object bean, boolean useSuperclass) {
        Component customizer;
        try {
            Class customizerClass = BaseCustomizerUtil.getCustomizerClass(bean, useSuperclass);
            customizer = (Component)customizerClass.newInstance();
        }
        catch (Exception e) {
            return null;
        }
        return customizer;
    }

    public static Component getCustomizer(Object bean) {
        return BaseCustomizerUtil.getCustomizer(bean, false);
    }
}

