# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/Client.ipynb (unless otherwise specified).

__all__ = ["Client", "DataBlob", "DataSource"]

# Cell

from typing import *
import types

import airt

from airt.env import *

# Internal Cell


def _replace_env_var(s: str) -> str:
    return s.replace("AIRT_", "CAPTN_").replace("airt", "captn")


# Internal Cell


def _fix_doc_string(cls: Type):

    cls.__doc__ = _replace_env_var(cls.__doc__)  # type: ignore

    for i in dir(cls):
        if not i.startswith("_"):
            try:
                getattr(cls, i).__doc__ = _replace_env_var(getattr(cls, i).__doc__)
            except:
                pass

            assert "AIRT_" not in getattr(cls, i).__doc__


# Internal Cell


def _set_global_env_vars(m: types.ModuleType):
    for v in dir(m):
        if not v.startswith("_"):
            setattr(m, v, _replace_env_var(getattr(m, v)))

            assert "AIRT_" not in getattr(m, v)


# Cell

from .components.client import Client as _Client

Client = _Client

from airt.client import DataBlob as _DataBlob

DataBlob = _DataBlob

from airt.client import DataSource as _DataSource

DataSource = _DataSource

for cls in [Client, DataBlob, DataSource]:
    cls.__module__ = "captn.client"
    _fix_doc_string(cls)

_set_global_env_vars(airt.env)
