# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/CLI.ipynb (unless otherwise specified).

__all__ = ["app"]

# Internal Cell

from contextlib import contextmanager
import os
import types

import typer

import airt

import captn
from .token import token
from .version import version
from . import db, ds
from ..client import _replace_env_var

# Cell

app = typer.Typer(help="CLI for interfacing with Capt’n.")

# Internal Cell


@contextmanager
def authenicate_user():
    airt.client.Client(
        auth_token=os.environ["CAPTN_SERVICE_TOKEN"],
        server=os.environ.get("CAPTN_SERVER_URL", None),
    )

    yield


airt.cli.helper.authenicate_user = authenicate_user

# Internal Cell

# token root command

app.command()(token)

# Internal Cell

# version root command

app.command()(version)

# Internal Cell

# db root command

app.add_typer(db.app, name="db")

# Internal Cell

# ds root command

app.add_typer(ds.app, name="ds")

# Internal Cell


def _fix_cli_doc_string(cmd: types.ModuleType):
    root_cmd_name = cmd.__name__.split(".")[-1]
    for c in cmd.app.registered_commands:
        if c.name:

            name = c.name.replace("-", "_")

            getattr(getattr(airt.cli, root_cmd_name), name).__doc__ = _replace_env_var(
                getattr(getattr(airt.cli, root_cmd_name), name).__doc__
            )


# Internal Cell

for c in [db, ds]:
    _fix_cli_doc_string(c)
