// this file is autogenerated using stringify.bat (premake --stringify) in the
// build folder of this project
static const char* useShadowMapInstancingFragmentShader =
    "#version 330 core\n"
    "//precision highp float;\n"
    "in Fragment\n"
    "{\n"
    "     vec4 color;\n"
    "} fragment;\n"
    "in Vert\n"
    "{\n"
    "	vec2 texcoord;\n"
    "} vert;\n"
    "uniform sampler2D Diffuse;\n"
    "uniform sampler2DShadow shadowMap;\n"
    "uniform mat4 ViewMatrixInverse;\n"
    "in vec3 lightPos,cameraPosition, normal,ambient;\n"
    "in vec4 ShadowCoord;\n"
    "in vec4 vertexPos;\n"
    "in float materialShininess;\n"
    "in vec3 lightSpecularIntensity;\n"
    "in vec3 materialSpecularColor;\n"
    "out vec4 color;\n"
    "void main(void)\n"
    "{\n"
    "	vec4 texel = fragment.color*texture(Diffuse,vert.texcoord);\n"
    "	vec3 ct,cf;\n"
    "	float intensity,at,af;\n"
    "	if (fragment.color.w==0)\n"
    "		discard;\n"
    "	vec3 lightDir = normalize(lightPos);\n"
    "	\n"
    "	vec3 normalDir = normalize(normal);\n"
    " \n"
    "	intensity = 0.5+0.5*clamp( dot( normalDir,lightDir ), -1,1 );\n"
    "	\n"
    "	af = 1.0;\n"
    "		\n"
    "	ct = texel.rgb;\n"
    "	at = texel.a;\n"
    "		\n"
    "	//float bias = 0.005f;\n"
    "	\n"
    "	vec3 specularReflection;\n"
    "	\n"
    "	if (dot(normalDir, lightDir) < 0.0) \n"
    "	{\n"
    "		specularReflection = vec3(0.0, 0.0, 0.0);\n"
    "	}\n"
    "  else // light source on the right side\n"
    "	{\n"
    "		vec3 surfaceToLight = normalize(lightPos - vertexPos.xyz);\n"
    "    vec3 surfaceToCamera = normalize(cameraPosition - vertexPos.xyz);\n"
    "    \n"
    "    \n"
    "    float specularCoefficient = 0.0;\n"
    "		specularCoefficient = pow(max(0.0, dot(surfaceToCamera, "
    "reflect(-surfaceToLight, normalDir))), materialShininess);\n"
    "    specularReflection = specularCoefficient * materialSpecularColor * "
    "lightSpecularIntensity;\n"
    "  \n"
    "	}\n"
    "    \n"
    "	float visibility = texture(shadowMap, "
    "vec3(ShadowCoord.xy,(ShadowCoord.z)/ShadowCoord.w));\n"
    "	if (intensity<0.5)\n"
    "		visibility = 0;\n"
    "	intensity = 0.7*intensity  + 0.3*intensity*visibility;\n"
    "	\n"
    "	cf = "
    "intensity*(vec3(1.0,1.0,1.0)-ambient)+ambient+specularReflection*"
    "visibility;\n"
    "	color  = vec4(ct * cf, fragment.color.w);\n"
    "}\n";
