"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.report = self.__class__.report(path + ["report"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.server = self.__class__.server(path + ["server"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        super().__init__(path, service)
    def views(self, *args, **kwargs):
        """
        Enter the view manipulation menu.
        """
        return PyMenu(self.service, "/views").execute(*args, **kwargs)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)

    class report(TUIMenu):
        """
        Enter the report menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.dpm_histogram = self.__class__.dpm_histogram(path + ["dpm_histogram"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.system = self.__class__.system(path + ["system"], service)
            self.fluxes = self.__class__.fluxes(path + ["fluxes"], service)
            self.forces = self.__class__.forces(path + ["forces"], service)
            self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
            self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
            self.icing = self.__class__.icing(path + ["icing"], service)
            self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
            super().__init__(path, service)
        def volume_integrals(self, *args, **kwargs):
            """
            Enters the volume integral menu.
            """
            return PyMenu(self.service, "/report/volume_integrals").execute(*args, **kwargs)
        def aero_optical_distortions(self, *args, **kwargs):
            """
            Optics report menu.
            """
            return PyMenu(self.service, "/report/aero_optical_distortions").execute(*args, **kwargs)
        def element_mass_flow(self, *args, **kwargs):
            """
            Prints list of element flow rate at inlets and outlets. This reports the mass flow rates of all chemical elements (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/element_mass_flow").execute(*args, **kwargs)
        def particle_summary(self, *args, **kwargs):
            """
            Prints summary report for all current particles.
            """
            return PyMenu(self.service, "/report/particle_summary").execute(*args, **kwargs)
        def dpm_extended_summary(self, *args, **kwargs):
            """
            Create an extended discrete phase summary report of the discrete phase injection(s). You can choose whether you want to save the extended report to a file or print it in the console window. For unsteady tracking, you will be asked whether you want to include in-domain particle/tracks in the report. You will be also prompted whether you want to select a single injection for the summary report. By default, all injections are included. The output depends on whether you have enabled the report/dpm-zone-summaries-per-injection? text command, in which case additional information is printed for escaped particles, such as per-injection data. Note that, for unsteady particle tracking, it is necessary to enable the report/dpm-zone-summaries-per-injection? text command before any particle parcels are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_extended_summary").execute(*args, **kwargs)
        def dpm_zone_summaries_per_injection(self, *args, **kwargs):
            """
            Enables/disables calculation of the escaped mass per injection. Note that for unsteady particle tracking, if you want to report the mass of escaped particles per injection, this text command must be enabled before any particles are injected into the domain.
            """
            return PyMenu(self.service, "/report/dpm_zone_summaries_per_injection").execute(*args, **kwargs)
        def surface_integrals(self, *args, **kwargs):
            """
            Enters the surface integral menu.
            """
            return PyMenu(self.service, "/report/surface_integrals").execute(*args, **kwargs)
        def dpm_sample(self, *args, **kwargs):
            """
            Samples trajectories at boundaries and lines/planes.
            """
            return PyMenu(self.service, "/report/dpm_sample").execute(*args, **kwargs)
        def projected_surface_area(self, *args, **kwargs):
            """
            Computes the area of the projection of selected surfaces along the  ,  , or   axis.
            """
            return PyMenu(self.service, "/report/projected_surface_area").execute(*args, **kwargs)
        def dpm_sample_sort_file(self, *args, **kwargs):
            """
            Enables/disables writing of sorted DPM sample files.
            """
            return PyMenu(self.service, "/report/dpm_sample_sort_file").execute(*args, **kwargs)
        def uds_flow(self, *args, **kwargs):
            """
            Prints list of user-defined scalar flow rate at boundaries.
            """
            return PyMenu(self.service, "/report/uds_flow").execute(*args, **kwargs)
        def path_line_summary(self, *args, **kwargs):
            """
            Prints pathline summary report.
            """
            return PyMenu(self.service, "/report/path_line_summary").execute(*args, **kwargs)
        def summary(self, *args, **kwargs):
            """
            Prints the current settings for physical models, boundary conditions, material properties, and solution parameters.
            """
            return PyMenu(self.service, "/report/summary").execute(*args, **kwargs)
        def dpm_sample_output_udf(self, *args, **kwargs):
            """
            Allows you to hook a previously loaded DEFINE_DPM_OUTPUT UDF for file format specification for sampling of trajectories and VOF-to-DPM lump conversion transcripts.
            """
            return PyMenu(self.service, "/report/dpm_sample_output_udf").execute(*args, **kwargs)
        def dpm_summary(self, *args, **kwargs):
            """
            Prints discrete phase summary report.
            """
            return PyMenu(self.service, "/report/dpm_summary").execute(*args, **kwargs)
        def write_histogram(self, *args, **kwargs):
            """
            Write a histogram of a scalar quantity to a file.
            """
            return PyMenu(self.service, "/report/write_histogram").execute(*args, **kwargs)
        def mphase_summary(self, *args, **kwargs):
            """
            Prints summary report for a multiphase case setup.
            """
            return PyMenu(self.service, "/report/mphase_summary").execute(*args, **kwargs)
        def print_histogram(self, *args, **kwargs):
            """
            Prints a histogram of a scalar quantity.
            """
            return PyMenu(self.service, "/report/print_histogram").execute(*args, **kwargs)
        def species_mass_flow(self, *args, **kwargs):
            """
            Prints list of species mass flow rate at inlets and outlets. This reports the mass flow rates of all species (in kg/s) flowing through the simulation boundaries.
            """
            return PyMenu(self.service, "/report/species_mass_flow").execute(*args, **kwargs)
        def modified_setting(self, *args, **kwargs):
            """
            Enter the modified settings menu.
            """
            return PyMenu(self.service, "/report/modified_setting").execute(*args, **kwargs)

        class dpm_histogram(TUIMenu):
            """
            Enters the DPM histogram menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.setup_reduction = self.__class__.setup_reduction(path + ["setup_reduction"], service)
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def list_samples(self, *args, **kwargs):
                """
                Shows all samples in a loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/list_samples").execute(*args, **kwargs)
            def read_sample(self, *args, **kwargs):
                """
                Reads a sample file and adds it to the sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/read_sample").execute(*args, **kwargs)
            def pick_sample_to_reduce(self, *args, **kwargs):
                """
                Select a sample to be reduced.
                """
                return PyMenu(self.service, "/report/dpm_histogram/pick_sample_to_reduce").execute(*args, **kwargs)
            def compute_sample(self, *args, **kwargs):
                """
                Computes the minimum/maximum of a sample variable.
                """
                return PyMenu(self.service, "/report/dpm_histogram/compute_sample").execute(*args, **kwargs)
            def reduce_picked_sample(self, *args, **kwargs):
                """
                Reduce a sample as specified by the data reduction parameters. This command is available only after you selected the sample using the pick-sample-to-reduce text command.
                """
                return PyMenu(self.service, "/report/dpm_histogram/reduce_picked_sample").execute(*args, **kwargs)
            def delete_sample(self, *args, **kwargs):
                """
                Deletes a sample from the loaded sample list.
                """
                return PyMenu(self.service, "/report/dpm_histogram/delete_sample").execute(*args, **kwargs)
            def write_sample(self, *args, **kwargs):
                """
                Write a histogram of a loaded sample into a file.
                """
                return PyMenu(self.service, "/report/dpm_histogram/write_sample").execute(*args, **kwargs)
            def plot_sample(self, *args, **kwargs):
                """
                Plots a histogram of a loaded sample.
                """
                return PyMenu(self.service, "/report/dpm_histogram/plot_sample").execute(*args, **kwargs)

            class setup_reduction(TUIMenu):
                """
                Set up the sample data reduction by specifying all relevant options and setting parameters as desired.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def all_variables_number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for ALL variables in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/all_variables_number_of_bins").execute(*args, **kwargs)
                def reset_min_and_max(self, *args, **kwargs):
                    """
                    Reset the min and max values of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/reset_min_and_max").execute(*args, **kwargs)
                def list_settings(self, *args, **kwargs):
                    """
                    List all user inputs for the sample picked for data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/list_settings").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Set the number of bins to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/number_of_bins").execute(*args, **kwargs)
                def minimum(self, *args, **kwargs):
                    """
                    Set the minimum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/minimum").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Switch on or off logarithmic scaling to be used for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/logarithmic").execute(*args, **kwargs)
                def use_weighting(self, *args, **kwargs):
                    """
                    Specify whether to use any weighting in the averaging that is done in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/use_weighting").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Set the maximum value of the range to be considered for a specific variable in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/maximum").execute(*args, **kwargs)
                def weighting_variable(self, *args, **kwargs):
                    """
                    Choose the weighting variable for the averaging in each bin in the data reduction.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/weighting_variable").execute(*args, **kwargs)
                def make_steady_from_unsteady_file(self, *args, **kwargs):
                    """
                    Specify whether the unsteady sample is to be reduced into a steady-state injection file.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/setup_reduction/make_steady_from_unsteady_file").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enters the settings menu for the histogram.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def minimum(self, *args, **kwargs):
                    """
                    Specifies the minimum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/minimum").execute(*args, **kwargs)
                def correlation(self, *args, **kwargs):
                    """
                    Computes the correlation of the sampling variable with another variable.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/correlation").execute(*args, **kwargs)
                def histogram_mode(self, *args, **kwargs):
                    """
                    Uses bars for the histogram plot or xy-style.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/histogram_mode").execute(*args, **kwargs)
                def percentage(self, *args, **kwargs):
                    """
                    Uses percentages of bins to be computed.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/percentage").execute(*args, **kwargs)
                def number_of_bins(self, *args, **kwargs):
                    """
                    Specifies the number of bins.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/number_of_bins").execute(*args, **kwargs)
                def diameter_statistics(self, *args, **kwargs):
                    """
                    Computes the Rosin Rammler parameters, Sauter, and other mean diameters.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/diameter_statistics").execute(*args, **kwargs)
                def cumulation_curve(self, *args, **kwargs):
                    """
                    Computes a cumulative curve for the sampling variable or correlation variable when correlation? is specified.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/cumulation_curve").execute(*args, **kwargs)
                def logarithmic(self, *args, **kwargs):
                    """
                    Enables/disables the use of logarithmic scaling on the abscissa of the histogram.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/logarithmic").execute(*args, **kwargs)
                def maximum(self, *args, **kwargs):
                    """
                    Specifies the maximum value of the x-axis variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/maximum").execute(*args, **kwargs)
                def weighting(self, *args, **kwargs):
                    """
                    Uses weighting with additional variables when sorting data into samples.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/weighting").execute(*args, **kwargs)
                def variable_power_3(self, *args, **kwargs):
                    """
                    Use the cubic of the cumulation variable during computation of the cumulative curve.
                    When the particle mass was not sampled, the diameter can be used instead.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/variable_power_3").execute(*args, **kwargs)
                def auto_range(self, *args, **kwargs):
                    """
                    Automatically computes the range of the sampling variable for histogram plots.
                    """
                    return PyMenu(self.service, "/report/dpm_histogram/set/auto_range").execute(*args, **kwargs)

        class reference_values(TUIMenu):
            """
            Enters the reference value menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.compute = self.__class__.compute(path + ["compute"], service)
                super().__init__(path, service)
            def enthalpy(self, *args, **kwargs):
                """
                Sets reference enthalpy for enthalpy damping and normalization.
                """
                return PyMenu(self.service, "/report/reference_values/enthalpy").execute(*args, **kwargs)
            def depth(self, *args, **kwargs):
                """
                Sets reference depth for volume calculation.
                """
                return PyMenu(self.service, "/report/reference_values/depth").execute(*args, **kwargs)
            def pressure(self, *args, **kwargs):
                """
                Sets reference pressure for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/pressure").execute(*args, **kwargs)
            def viscosity(self, *args, **kwargs):
                """
                Sets reference viscosity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/viscosity").execute(*args, **kwargs)
            def length(self, *args, **kwargs):
                """
                Sets reference length for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/length").execute(*args, **kwargs)
            def yplus(self, *args, **kwargs):
                """
                Sets reference yplus for calculation of Yplus Based Heat Transfer Coefficient.
                """
                return PyMenu(self.service, "/report/reference_values/yplus").execute(*args, **kwargs)
            def velocity(self, *args, **kwargs):
                """
                Sets reference velocity for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/velocity").execute(*args, **kwargs)
            def density(self, *args, **kwargs):
                """
                Sets reference density for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/density").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists current reference values.
                """
                return PyMenu(self.service, "/report/reference_values/list").execute(*args, **kwargs)
            def zone(self, *args, **kwargs):
                """
                Sets reference zone.
                """
                return PyMenu(self.service, "/report/reference_values/zone").execute(*args, **kwargs)
            def area(self, *args, **kwargs):
                """
                Sets reference area for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/area").execute(*args, **kwargs)
            def temperature(self, *args, **kwargs):
                """
                Sets reference temperature for normalization.
                """
                return PyMenu(self.service, "/report/reference_values/temperature").execute(*args, **kwargs)

            class compute(TUIMenu):
                """
                Computes reference values from zone boundary conditions.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/geometry").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fluid").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/wall").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interior").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/radiator").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/axis").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/outflow").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/porous_jump").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/periodic").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/intake_fan").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/fan").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/degassing").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/shadow").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/interface").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/overset").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/solid").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/symmetry").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/network_end").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/report/reference_values/compute/velocity_inlet").execute(*args, **kwargs)

        class system(TUIMenu):
            """
            Enters the system menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def sys_stats(self, *args, **kwargs):
                """
                System information. This is used to report the CPU configuration of the machines where ANSYS Fluent processes have been spawned.
                """
                return PyMenu(self.service, "/report/system/sys_stats").execute(*args, **kwargs)
            def proc_stats(self, *args, **kwargs):
                """
                Prints ANSYS Fluent process information. This is used to report the memory usage of each of the ANSYS Fluent processes.
                """
                return PyMenu(self.service, "/report/system/proc_stats").execute(*args, **kwargs)
            def gpgpu_stats(self, *args, **kwargs):
                """
                Prints information about installed general purpose graphical processing units.
                """
                return PyMenu(self.service, "/report/system/gpgpu_stats").execute(*args, **kwargs)
            def time_stats(self, *args, **kwargs):
                """
                Timer information. This is used to report CPU timings for user and kernel processes and detailed solver timings.
                """
                return PyMenu(self.service, "/report/system/time_stats").execute(*args, **kwargs)

        class fluxes(TUIMenu):
            """
            Enters the fluxes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def film_mass_flow(self, *args, **kwargs):
                """
                Prints wall film mass flow rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_mass_flow").execute(*args, **kwargs)
            def mass_flow(self, *args, **kwargs):
                """
                Prints mass flow rate at inlets and outlets.
                """
                return PyMenu(self.service, "/report/fluxes/mass_flow").execute(*args, **kwargs)
            def heat_transfer(self, *args, **kwargs):
                """
                Prints heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer").execute(*args, **kwargs)
            def viscous_work(self, *args, **kwargs):
                """
                Prints the viscous work rate at the boundaries. This text command is only available when the energy equation is enabled and the pressure-based solver is selected.
                """
                return PyMenu(self.service, "/report/fluxes/viscous_work").execute(*args, **kwargs)
            def rad_heat_trans(self, *args, **kwargs):
                """
                Prints radiation heat transfer rate at boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/rad_heat_trans").execute(*args, **kwargs)
            def heat_transfer_sensible(self, *args, **kwargs):
                """
                Prints the sensible heat transfer rate at the boundaries.
                """
                return PyMenu(self.service, "/report/fluxes/heat_transfer_sensible").execute(*args, **kwargs)
            def film_heat_transfer(self, *args, **kwargs):
                """
                Prints wall film heat transfer rate at boundaries. This text command is only available when you enable the Eulerian wall film model.
                """
                return PyMenu(self.service, "/report/fluxes/film_heat_transfer").execute(*args, **kwargs)
            def pressure_work(self, *args, **kwargs):
                """
                Prints the pressure work rate at the boundaries. This text command is only available when the energy equation is enabled, the absolute velocity formulation is selected, and zone motion is enabled for a fluid cell zone.
                """
                return PyMenu(self.service, "/report/fluxes/pressure_work").execute(*args, **kwargs)

        class forces(TUIMenu):
            """
            Enters the forces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def wall_moments(self, *args, **kwargs):
                """
                Computes the moments about the specified moment center for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_moments").execute(*args, **kwargs)
            def wall_forces(self, *args, **kwargs):
                """
                Computes the forces along the specified force vector for all wall zones.
                """
                return PyMenu(self.service, "/report/forces/wall_forces").execute(*args, **kwargs)
            def pressure_center(self, *args, **kwargs):
                """
                Prints the center of pressure on wall zones.
                """
                return PyMenu(self.service, "/report/forces/pressure_center").execute(*args, **kwargs)

        class heat_exchanger(TUIMenu):
            """
            Enters the heat exchanger menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def computed_heat_rejection(self, *args, **kwargs):
                """
                Prints total heat rejection.
                """
                return PyMenu(self.service, "/report/heat_exchanger/computed_heat_rejection").execute(*args, **kwargs)
            def mass_flow_rate(self, *args, **kwargs):
                """
                Prints mass flow rate.
                """
                return PyMenu(self.service, "/report/heat_exchanger/mass_flow_rate").execute(*args, **kwargs)
            def specific_heat(self, *args, **kwargs):
                """
                Prints fluid’s specific heat.
                """
                return PyMenu(self.service, "/report/heat_exchanger/specific_heat").execute(*args, **kwargs)
            def outlet_temperature(self, *args, **kwargs):
                """
                Prints outlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/outlet_temperature").execute(*args, **kwargs)
            def inlet_temperature(self, *args, **kwargs):
                """
                Prints inlet temperature.
                """
                return PyMenu(self.service, "/report/heat_exchanger/inlet_temperature").execute(*args, **kwargs)

        class population_balance(TUIMenu):
            """
            Population Balance menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def moments(self, *args, **kwargs):
                """
                Set moments for population balance.
                """
                return PyMenu(self.service, "/report/population_balance/moments").execute(*args, **kwargs)
            def number_density(self, *args, **kwargs):
                """
                Set number density functions.
                """
                return PyMenu(self.service, "/report/population_balance/number_density").execute(*args, **kwargs)

        class icing(TUIMenu):
            """
            Icing reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def mass_of_ice(self, *args, **kwargs):
                """
                Print Mass of Ice Accretion.
                """
                return PyMenu(self.service, "/report/icing/mass_of_ice").execute(*args, **kwargs)
            def energy_of_ice_formation(self, *args, **kwargs):
                """
                Print Energy of Ice Formation.
                """
                return PyMenu(self.service, "/report/icing/energy_of_ice_formation").execute(*args, **kwargs)
            def energy_of_water_impinged(self, *args, **kwargs):
                """
                Print Energy of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/energy_of_water_impinged").execute(*args, **kwargs)
            def mass_of_water_impinged(self, *args, **kwargs):
                """
                Print Mass of Water Impingement.
                """
                return PyMenu(self.service, "/report/icing/mass_of_water_impinged").execute(*args, **kwargs)
            def particles_crystals_collection_eff(self, *args, **kwargs):
                """
                Print Crystals Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_crystals_collection_eff").execute(*args, **kwargs)
            def particles_droplets_collection_eff(self, *args, **kwargs):
                """
                Print Droplets Collection Efficiency.
                """
                return PyMenu(self.service, "/report/icing/particles_droplets_collection_eff").execute(*args, **kwargs)
            def icing_energy_of_conduction(self, *args, **kwargs):
                """
                Print Energy of Conduction.
                """
                return PyMenu(self.service, "/report/icing/icing_energy_of_conduction").execute(*args, **kwargs)

        class simulation_reports(TUIMenu):
            """
            Enter the simulation reports menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
                super().__init__(path, service)
            def export_simulation_report_as_html(self, *args, **kwargs):
                """
                Export the provided simulation report as HTML.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_html").execute(*args, **kwargs)
            def duplicate_simulation_report(self, *args, **kwargs):
                """
                Duplicate a report and all of its settings to a new report.
                """
                return PyMenu(self.service, "/report/simulation_reports/duplicate_simulation_report").execute(*args, **kwargs)
            def list_simulation_reports(self, *args, **kwargs):
                """
                List all report names.
                """
                return PyMenu(self.service, "/report/simulation_reports/list_simulation_reports").execute(*args, **kwargs)
            def view_simulation_report(self, *args, **kwargs):
                """
                View a simulation report that has already been generated. In batch mode this will print the report's URL.
                """
                return PyMenu(self.service, "/report/simulation_reports/view_simulation_report").execute(*args, **kwargs)
            def write_report_names_to_file(self, *args, **kwargs):
                """
                Write the list of currently generated report names to a txt file.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_report_names_to_file").execute(*args, **kwargs)
            def write_simulation_report_template_file(self, *args, **kwargs):
                """
                Write a JSON template file with this case's Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/write_simulation_report_template_file").execute(*args, **kwargs)
            def export_simulation_report_as_pdf(self, *args, **kwargs):
                """
                Export the provided simulation report as a PDF file.
                """
                return PyMenu(self.service, "/report/simulation_reports/export_simulation_report_as_pdf").execute(*args, **kwargs)
            def delete_simulation_report(self, *args, **kwargs):
                """
                Delete the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/delete_simulation_report").execute(*args, **kwargs)
            def reset_report_to_defaults(self, *args, **kwargs):
                """
                Reset all report settings to default for the provided simulation report.
                """
                return PyMenu(self.service, "/report/simulation_reports/reset_report_to_defaults").execute(*args, **kwargs)
            def generate_simulation_report(self, *args, **kwargs):
                """
                Generate a new simulation report or regenerate an existing simulation report with the provided name.
                """
                return PyMenu(self.service, "/report/simulation_reports/generate_simulation_report").execute(*args, **kwargs)
            def rename_simulation_report(self, *args, **kwargs):
                """
                Rename a report which has already been generated.
                """
                return PyMenu(self.service, "/report/simulation_reports/rename_simulation_report").execute(*args, **kwargs)
            def read_simulation_report_template_file(self, *args, **kwargs):
                """
                Read a JSON template file with existing Simulation Report settings.
                """
                return PyMenu(self.service, "/report/simulation_reports/read_simulation_report_template_file").execute(*args, **kwargs)

            class parametric_study(TUIMenu):
                """
                Enter the parametric study menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def generate_design_point_report(self, *args, **kwargs):
                    """
                    Generate a simulation report for an updated design point.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_design_point_report").execute(*args, **kwargs)
                def generate_parametric_report(self, *args, **kwargs):
                    """
                    Generate a parametric report for your study.
                    """
                    return PyMenu(self.service, "/report/simulation_reports/parametric_study/generate_parametric_report").execute(*args, **kwargs)

    class setup(TUIMenu):
        """
        Enter setup menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.models = self.__class__.models(path + ["models"], service)
            super().__init__(path, service)

        class mixing_planes(TUIMenu):
            """
            Enter the mixing planes menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete a mixing plane.
                """
                return PyMenu(self.service, "/setup/mixing_planes/delete").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a mixing plane.
                """
                return PyMenu(self.service, "/setup/mixing_planes/create").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List defined mixing plane(s).
                """
                return PyMenu(self.service, "/setup/mixing_planes/list").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the mixing plane set menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.conserve_total_enthalpy = self.__class__.conserve_total_enthalpy(path + ["conserve_total_enthalpy"], service)
                    self.conserve_swirl = self.__class__.conserve_swirl(path + ["conserve_swirl"], service)
                    super().__init__(path, service)
                def averaging_method(self, *args, **kwargs):
                    """
                    Set mixing plane profile averaging method.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/averaging_method").execute(*args, **kwargs)
                def fix_pressure_level(self, *args, **kwargs):
                    """
                    Set fix pressure level using define/reference-pressure-location.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/fix_pressure_level").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Set mixing plane under-relaxation factor.
                    """
                    return PyMenu(self.service, "/setup/mixing_planes/set/under_relaxation").execute(*args, **kwargs)

                class conserve_total_enthalpy(TUIMenu):
                    """
                    Enter the menu to set total enthalpy conservation in mixing plane menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable total enthalpy conservation in mixing plane.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_total_enthalpy/enable").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Enable/disable verbosity in total-enthalpy conservation calculations.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_total_enthalpy/verbosity").execute(*args, **kwargs)

                class conserve_swirl(TUIMenu):
                    """
                    Enter the mixing plane conserve-swirl menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def report_swirl_integration(self, *args, **kwargs):
                        """
                        Report swirl integration (torque) on inflow and outflow zones.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/report_swirl_integration").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable swirl conservation in mixing plane.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/enable").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Enable/disable verbosity in swirl conservation calculations.
                        """
                        return PyMenu(self.service, "/setup/mixing_planes/set/conserve_swirl/verbosity").execute(*args, **kwargs)

        class operating_conditions(TUIMenu):
            """
            Enter the define operating conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def operating_density(self, *args, **kwargs):
                """
                Multiphase flow Operating Density menu.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_density").execute(*args, **kwargs)
            def reference_pressure_method(self, *args, **kwargs):
                """
                Choosing reference pressure type.
                """
                return PyMenu(self.service, "/setup/operating_conditions/reference_pressure_method").execute(*args, **kwargs)
            def use_inlet_temperature_for_operating_density(self, *args, **kwargs):
                """
                Use Inlet Temperature to calculate Opearating Density.
                """
                return PyMenu(self.service, "/setup/operating_conditions/use_inlet_temperature_for_operating_density").execute(*args, **kwargs)
            def set_state(self, *args, **kwargs):
                """
                Select state for real gas EOS subcritical condition.
                """
                return PyMenu(self.service, "/setup/operating_conditions/set_state").execute(*args, **kwargs)
            def reference_pressure_location(self, *args, **kwargs):
                """
                Set coordinates of reference pressure.
                """
                return PyMenu(self.service, "/setup/operating_conditions/reference_pressure_location").execute(*args, **kwargs)
            def operating_temperature(self, *args, **kwargs):
                """
                Set the operating temperature for Boussinesq.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_temperature").execute(*args, **kwargs)
            def gravity_mrf_rotation(self, *args, **kwargs):
                """
                Enable/disable rotation of gravity vector in moving reference frame simulations.
                """
                return PyMenu(self.service, "/setup/operating_conditions/gravity_mrf_rotation").execute(*args, **kwargs)
            def used_ref_pressure_location(self, *args, **kwargs):
                """
                See the actual coordinates of reference pressure used.
                """
                return PyMenu(self.service, "/setup/operating_conditions/used_ref_pressure_location").execute(*args, **kwargs)
            def gravity(self, *args, **kwargs):
                """
                Set gravitational acceleration.
                """
                return PyMenu(self.service, "/setup/operating_conditions/gravity").execute(*args, **kwargs)
            def operating_pressure(self, *args, **kwargs):
                """
                Set the operating pressure.
                """
                return PyMenu(self.service, "/setup/operating_conditions/operating_pressure").execute(*args, **kwargs)

        class expert(TUIMenu):
            """
            Enter expert setup menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.spectral = self.__class__.spectral(path + ["spectral"], service)
                super().__init__(path, service)
            def beta_feature_access(self, *args, **kwargs):
                """
                Enable access to beta features in the interface.
                """
                return PyMenu(self.service, "/setup/expert/beta_feature_access").execute(*args, **kwargs)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Set solver options for stiff-chemistry solutions.
                """
                return PyMenu(self.service, "/setup/expert/stiff_chemistry").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Set heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/setup/expert/heterogeneous_stiff_chemistry").execute(*args, **kwargs)
            def enable_mesh_morpher_optimizer(self, *args, **kwargs):
                """
                Enable use of mesh morpher/optimizer.
                """
                return PyMenu(self.service, "/setup/expert/enable_mesh_morpher_optimizer").execute(*args, **kwargs)

            class spectral(TUIMenu):
                """
                Enter the Spectral menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_fourier_coefficients(self, *args, **kwargs):
                    """
                    Deletes Fourier coefficient data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/delete_fourier_coefficients").execute(*args, **kwargs)
                def delete_harmonic_exports(self, *args, **kwargs):
                    """
                    Deletes Harmonic Export data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/delete_harmonic_exports").execute(*args, **kwargs)
                def calculate_harmonic_exports(self, *args, **kwargs):
                    """
                    Calculates Harmonic Export data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/calculate_harmonic_exports").execute(*args, **kwargs)
                def calculate_fourier_coefficients(self, *args, **kwargs):
                    """
                    Calculates Fourier coefficient data.
                    """
                    return PyMenu(self.service, "/setup/expert/spectral/calculate_fourier_coefficients").execute(*args, **kwargs)

        class turbo_model(TUIMenu):
            """
            Turbo features menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.general_turbo_interface_settings = self.__class__.general_turbo_interface_settings(path + ["general_turbo_interface_settings"], service)
                self.turbo_topology = self.__class__.turbo_topology(path + ["turbo_topology"], service)
                self.blade_flutter_harmonics = self.__class__.blade_flutter_harmonics(path + ["blade_flutter_harmonics"], service)
                super().__init__(path, service)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/setup/turbo_model/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def create_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_phaselag_spectral_content").execute(*args, **kwargs)
            def graphics_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/graphics_extra_settings").execute(*args, **kwargs)
            def append_phaselag_spectral_content(self, *args, **kwargs):
                """
                Define phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/append_phaselag_spectral_content").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Create a general turbo interface.
                """
                return PyMenu(self.service, "/setup/turbo_model/turbo_create").execute(*args, **kwargs)
            def phaselag_extra_settings(self, *args, **kwargs):
                """
                Define phaselag related extra settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/phaselag_extra_settings").execute(*args, **kwargs)
            def list_graphics_spectral_content(self, *args, **kwargs):
                """
                List post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_graphics_spectral_content").execute(*args, **kwargs)
            def separate_nonoverlapping_interface_boundary(self, *args, **kwargs):
                """
                Split a general turbo interface non-overlapping zone.
                """
                return PyMenu(self.service, "/setup/turbo_model/separate_nonoverlapping_interface_boundary").execute(*args, **kwargs)
            def isentropic_efficiency(self, *args, **kwargs):
                """
                Compute isentropic efficiency using general property functions for enthalpy.
                """
                return PyMenu(self.service, "/setup/turbo_model/isentropic_efficiency").execute(*args, **kwargs)
            def list_turbomachine_description(self, *args, **kwargs):
                """
                List turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_turbomachine_description").execute(*args, **kwargs)
            def delete_turbomachine_description(self, *args, **kwargs):
                """
                Delete turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_turbomachine_description").execute(*args, **kwargs)
            def enable_turbo_model(self, *args, **kwargs):
                """
                Enable/disable turbo model menu.
                """
                return PyMenu(self.service, "/setup/turbo_model/enable_turbo_model").execute(*args, **kwargs)
            def create_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_graphics_spectral_content").execute(*args, **kwargs)
            def list_phaselag_state(self, *args, **kwargs):
                """
                List all phaselag related case settings.
                """
                return PyMenu(self.service, "/setup/turbo_model/list_phaselag_state").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/setup/turbo_model/make_phaselag_from_periodic").execute(*args, **kwargs)
            def create_turbomachine_description(self, *args, **kwargs):
                """
                Define turbomachine description.
                """
                return PyMenu(self.service, "/setup/turbo_model/create_turbomachine_description").execute(*args, **kwargs)
            def delete_graphics_spectral_content(self, *args, **kwargs):
                """
                Delete post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_graphics_spectral_content").execute(*args, **kwargs)
            def blade_flutter_row(self, *args, **kwargs):
                """
                Define the periodic displacement row.
                """
                return PyMenu(self.service, "/setup/turbo_model/blade_flutter_row").execute(*args, **kwargs)
            def append_graphics_spectral_content(self, *args, **kwargs):
                """
                Define post-processing related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/append_graphics_spectral_content").execute(*args, **kwargs)
            def delete_phaselag_spectral_content(self, *args, **kwargs):
                """
                Delete phaselag related spectral content.
                """
                return PyMenu(self.service, "/setup/turbo_model/delete_phaselag_spectral_content").execute(*args, **kwargs)

            class general_turbo_interface_settings(TUIMenu):
                """
                Set General Turbo Interface options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mixing_plane_model_settings(self, *args, **kwargs):
                    """
                    Set the mixing plane model settings.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/mixing_plane_model_settings").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Set the expert parameters for turbo interfaces.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/general_turbo_interface_settings/expert").execute(*args, **kwargs)

            class turbo_topology(TUIMenu):
                """
                Define turbo topology.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def search_method(self, *args, **kwargs):
                    """
                    Set search method for a topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/search_method").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete a turbo topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/delete").execute(*args, **kwargs)
                def define_topology(self, *args, **kwargs):
                    """
                    Define a turbo topology.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/define_topology").execute(*args, **kwargs)
                def mesh_method(self, *args, **kwargs):
                    """
                    Set turbo structured mesh generation method.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/mesh_method").execute(*args, **kwargs)
                def projection_method(self, *args, **kwargs):
                    """
                    Set 2D projection method.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/turbo_topology/projection_method").execute(*args, **kwargs)

            class blade_flutter_harmonics(TUIMenu):
                """
                Enter the blade flutter harmonics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_aerodamping_vs_nodal_diameter(self, *args, **kwargs):
                    """
                    Reads report definition file and Writes influence coefficient aerodynamic damping values vs nodal diameter.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/write_aerodamping_vs_nodal_diameter").execute(*args, **kwargs)
                def write_harmonic_exports(self, *args, **kwargs):
                    """
                    Writes harmonic export data.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/write_harmonic_exports").execute(*args, **kwargs)
                def enable_harmonic_exports(self, *args, **kwargs):
                    """
                    Calculates/Deletes flutter harmonic export data.
                    """
                    return PyMenu(self.service, "/setup/turbo_model/blade_flutter_harmonics/enable_harmonic_exports").execute(*args, **kwargs)

        class reference_frames(TUIMenu):
            """
            Manage reference frames.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/delete").execute(*args, **kwargs)
            def hide(self, *args, **kwargs):
                """
                Hide Reference Frame.
                """
                return PyMenu(self.service, "/setup/reference_frames/hide").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/setup/reference_frames/add").execute(*args, **kwargs)
            def display_edit(self, *args, **kwargs):
                """
                Display and edit reference frame from graphics.
                """
                return PyMenu(self.service, "/setup/reference_frames/display_edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/list_properties").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display Reference Frame.
                """
                return PyMenu(self.service, "/setup/reference_frames/display").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/setup/reference_frames/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/setup/reference_frames/list").execute(*args, **kwargs)

        class named_expressions(TUIMenu):
            """
            Manage named expressions.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def import_from_tsv(self, *args, **kwargs):
                """
                Export expressions.
                """
                return PyMenu(self.service, "/setup/named_expressions/import_from_tsv").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/list_properties").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/setup/named_expressions/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/setup/named_expressions/add").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Compute expression.
                """
                return PyMenu(self.service, "/setup/named_expressions/compute").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy expression.
                """
                return PyMenu(self.service, "/setup/named_expressions/copy").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/delete").execute(*args, **kwargs)
            def export_to_tsv(self, *args, **kwargs):
                """
                Export expressions.
                """
                return PyMenu(self.service, "/setup/named_expressions/export_to_tsv").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/setup/named_expressions/edit").execute(*args, **kwargs)

        class overset_interfaces(TUIMenu):
            """
            Enter the overset-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.options = self.__class__.options(path + ["options"], service)
                self.adapt = self.__class__.adapt(path + ["adapt"], service)
                self.cut_control = self.__class__.cut_control(path + ["cut_control"], service)
                super().__init__(path, service)
            def mark_cell_change(self, *args, **kwargs):
                """
                Mark overset interface related cell type change.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/mark_cell_change").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/create").execute(*args, **kwargs)
            def write_dci(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to a text file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_dci").execute(*args, **kwargs)
            def intersect(self, *args, **kwargs):
                """
                Intersect an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/intersect").execute(*args, **kwargs)
            def write_dci_to_case(self, *args, **kwargs):
                """
                Save domain connectivity information (DCI) to case file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_dci_to_case").execute(*args, **kwargs)
            def display_cells(self, *args, **kwargs):
                """
                Display the marked overset cells.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/display_cells").execute(*args, **kwargs)
            def clear(self, *args, **kwargs):
                """
                Clear an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/clear").execute(*args, **kwargs)
            def debug_hole_cut(self, *args, **kwargs):
                """
                Debugging tool for overset hole cutting.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/debug_hole_cut").execute(*args, **kwargs)
            def check(self, *args, **kwargs):
                """
                Check all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/check").execute(*args, **kwargs)
            def fill_dci(self, *args, **kwargs):
                """
                Fill overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/fill_dci").execute(*args, **kwargs)
            def update_from_dci(self, *args, **kwargs):
                """
                Update all overset intrfaces from stored domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/update_from_dci").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/delete").execute(*args, **kwargs)
            def grid_priorities(self, *args, **kwargs):
                """
                Edit grid priorities for an overset interface.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/grid_priorities").execute(*args, **kwargs)
            def clear_all(self, *args, **kwargs):
                """
                Clear all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/clear_all").execute(*args, **kwargs)
            def intersect_all(self, *args, **kwargs):
                """
                Intersect all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/intersect_all").execute(*args, **kwargs)
            def read_dci_from_case(self, *args, **kwargs):
                """
                Read domain connectivity information (DCI) from case file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/read_dci_from_case").execute(*args, **kwargs)
            def free_dci(self, *args, **kwargs):
                """
                Free overset domain connectivity information (DCI).
                """
                return PyMenu(self.service, "/setup/overset_interfaces/free_dci").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/delete_all").execute(*args, **kwargs)
            def write_cell_types(self, *args, **kwargs):
                """
                Write overset cell types into file.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/write_cell_types").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List all overset interfaces.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/list").execute(*args, **kwargs)
            def find_bounding_cell(self, *args, **kwargs):
                """
                Find bounding cell for given cell or search point.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/find_bounding_cell").execute(*args, **kwargs)
            def mark_cells(self, *args, **kwargs):
                """
                Mark overset interface related cell types.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/mark_cells").execute(*args, **kwargs)
            def set_mark_bounds(self, *args, **kwargs):
                """
                Set bounds (center, radius) for overset cell marking.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/set_mark_bounds").execute(*args, **kwargs)
            def find_all_bounding_cells(self, *args, **kwargs):
                """
                Find bounding cells for all cell centroids.
                """
                return PyMenu(self.service, "/setup/overset_interfaces/find_all_bounding_cells").execute(*args, **kwargs)

            class options(TUIMenu):
                """
                Enter the overset interface options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def update_before_case_write(self, *args, **kwargs):
                    """
                    Enable update of overset interfaces before writing case file (CFF format only).
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/update_before_case_write").execute(*args, **kwargs)
                def dead_cell_update(self, *args, **kwargs):
                    """
                    Enable dead cell update in moving or dynamic mesh simulations.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/dead_cell_update").execute(*args, **kwargs)
                def transient_caching(self, *args, **kwargs):
                    """
                    Set options to control caching of entities in transient overset simulations.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/transient_caching").execute(*args, **kwargs)
                def partial_cut_faces(self, *args, **kwargs):
                    """
                    Enable enhanced hole cutting where cut faces partially overlap.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/partial_cut_faces").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enable additional overset options and tools.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/expert").execute(*args, **kwargs)
                def modified_donor_search(self, *args, **kwargs):
                    """
                    Enable modified and more extensive donor search.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/modified_donor_search").execute(*args, **kwargs)
                def modified_hole_cutting(self, *args, **kwargs):
                    """
                    Enable modified hole cutting parameters.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/modified_hole_cutting").execute(*args, **kwargs)
                def parallel(self, *args, **kwargs):
                    """
                    Set options to control running overset in parallel.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/parallel").execute(*args, **kwargs)
                def donor_priority_method(self, *args, **kwargs):
                    """
                    Set method used to evaludate the cell donor priority.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/donor_priority_method").execute(*args, **kwargs)
                def node_connected_donors(self, *args, **kwargs):
                    """
                    Enable node or face connected donor cells.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/node_connected_donors").execute(*args, **kwargs)
                def overlap_boundaries(self, *args, **kwargs):
                    """
                    Enable overset topologies with overlap boundaries.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/overlap_boundaries").execute(*args, **kwargs)
                def render_receptor_cells(self, *args, **kwargs):
                    """
                    Set the option to include receptor cells in postprocessing.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/render_receptor_cells").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set overset mesh reporting verbosity.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/verbosity").execute(*args, **kwargs)
                def solve_island_removal(self, *args, **kwargs):
                    """
                    Set method used to control the removal of isolated patches of solve cells.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/solve_island_removal").execute(*args, **kwargs)
                def mesh_interfaces(self, *args, **kwargs):
                    """
                    Allow mesh interfaces inside overset cell zones.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/mesh_interfaces").execute(*args, **kwargs)
                def minimize_overlap(self, *args, **kwargs):
                    """
                    Enable overlap minimization for overset interfaces.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/minimize_overlap").execute(*args, **kwargs)
                def auto_create(self, *args, **kwargs):
                    """
                    Enable automatic creation of default overset interface.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/options/auto_create").execute(*args, **kwargs)

            class adapt(TUIMenu):
                """
                Enter the overset adaption menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.set = self.__class__.set(path + ["set"], service)
                    super().__init__(path, service)
                def adapt_mesh(self, *args, **kwargs):
                    """
                    Mark and adapt the mesh to remove orphan cells and large donor-receptor cell size differences.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/adapt/adapt_mesh").execute(*args, **kwargs)
                def mark_adaption(self, *args, **kwargs):
                    """
                    Mark cells for overset orphan adaption and donor-receptor size differences.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/adapt/mark_adaption").execute(*args, **kwargs)

                class set(TUIMenu):
                    """
                    Enter the overset adaption set menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def adaption_sweeps(self, *args, **kwargs):
                        """
                        Set the number of adaption sweeps per overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/adaption_sweeps").execute(*args, **kwargs)
                    def mark_coarsening(self, *args, **kwargs):
                        """
                        Enable the option to coarsen the mesh during overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_coarsening").execute(*args, **kwargs)
                    def length_ratio_max(self, *args, **kwargs):
                        """
                        Set the length scale ratio threshold used to determine which cells are marked for adaption based on donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/length_ratio_max").execute(*args, **kwargs)
                    def mark_size(self, *args, **kwargs):
                        """
                        Enable the option to adapt for donor-receptor cell size differences.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_size").execute(*args, **kwargs)
                    def buffer_layers(self, *args, **kwargs):
                        """
                        Set the number of cell layers marked in addition to the cells marked for orphan adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/buffer_layers").execute(*args, **kwargs)
                    def anisotropic(self, *args, **kwargs):
                        """
                        Enable the option to use anisotropic adaption in prismatic cells.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/anisotropic").execute(*args, **kwargs)
                    def mark_gaps(self, *args, **kwargs):
                        """
                        Enable the option to adapt underresolved gaps.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_gaps").execute(*args, **kwargs)
                    def mark_orphans(self, *args, **kwargs):
                        """
                        Enable the option to adapt for orphan reduction.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_orphans").execute(*args, **kwargs)
                    def maximum_refinement_level(self, *args, **kwargs):
                        """
                        Set the maximum level of refinement in overset adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/maximum_refinement_level").execute(*args, **kwargs)
                    def automatic(self, *args, **kwargs):
                        """
                        Enable the option to automatically adapt overset meshes during solution update.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/automatic").execute(*args, **kwargs)
                    def mark_fixed_orphans(self, *args, **kwargs):
                        """
                        Enable the option to adapt for orphans which were removed by accepting neighbor donors.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/mark_fixed_orphans").execute(*args, **kwargs)
                    def gap_resolution(self, *args, **kwargs):
                        """
                        Set the target (minimum) gap resolution used when marking cells for gap adaption.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/adapt/set/gap_resolution").execute(*args, **kwargs)

            class cut_control(TUIMenu):
                """
                Enter the overset hole cut control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.cut_seeds = self.__class__.cut_seeds(path + ["cut_seeds"], service)
                    super().__init__(path, service)
                def list(self, *args, **kwargs):
                    """
                    List the defined hole cut controls.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/list").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add hole cut control for a boundary zone.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete hole cut control for a boundary zone.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/delete").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete the hole cut controls for all boundary zones.
                    """
                    return PyMenu(self.service, "/setup/overset_interfaces/cut_control/delete_all").execute(*args, **kwargs)

                class cut_seeds(TUIMenu):
                    """
                    Enter the overset hole cut seed menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a hole cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/delete").execute(*args, **kwargs)
                    def delete_all(self, *args, **kwargs):
                        """
                        Delete all hole cut seeds.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/delete_all").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a hole cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/add").execute(*args, **kwargs)
                    def cut_seeds_for_all_component_zones(self, *args, **kwargs):
                        """
                        Enable that all component zones get a cut seed.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/cut_seeds_for_all_component_zones").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the defined hole cut seeds.
                        """
                        return PyMenu(self.service, "/setup/overset_interfaces/cut_control/cut_seeds/list").execute(*args, **kwargs)

        class gap_model(TUIMenu):
            """
            Enter the narrow-gaps menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.advanced_options = self.__class__.advanced_options(path + ["advanced_options"], service)
                super().__init__(path, service)
            def list_gap_regions(self, *args, **kwargs):
                """
                List gap regions.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_regions").execute(*args, **kwargs)
            def render_gap_regions(self, *args, **kwargs):
                """
                Update gap regions for postprocessing.
                """
                return PyMenu(self.service, "/setup/gap_model/render_gap_regions").execute(*args, **kwargs)
            def list_gap_face_zones(self, *args, **kwargs):
                """
                List name of the gap face zones that can be used for gaps creation.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_face_zones").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/create").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an exiting gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an exiting gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/edit").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enable/Disable gap model.
                """
                return PyMenu(self.service, "/setup/gap_model/enable").execute(*args, **kwargs)
            def list_gap_cell_zones(self, *args, **kwargs):
                """
                List name of the gap cells zones that can be used as exclided cell zones in gaps creation.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_cell_zones").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all of the exiting gap objects.
                """
                return PyMenu(self.service, "/setup/gap_model/delete_all").execute(*args, **kwargs)

            class advanced_options(TUIMenu):
                """
                Show options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_gap_regions(self, *args, **kwargs):
                    """
                    Clear gap model solution information and marks.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/clear_gap_regions").execute(*args, **kwargs)
                def sponge_layer(self, *args, **kwargs):
                    """
                    Set advanced settings for gap sponge layer.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/sponge_layer").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enable expert options for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/expert").execute(*args, **kwargs)
                def cell_check_distance_factor(self, *args, **kwargs):
                    """
                    Enter value of the cell distance factor.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/cell_check_distance_factor").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Set solution stabilization level for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/solution_stabilization").execute(*args, **kwargs)
                def precise_gap_marking(self, *args, **kwargs):
                    """
                    Mark cells in gap regions using more accurate search algorithm.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/precise_gap_marking").execute(*args, **kwargs)
                def include_coupled_walls(self, *args, **kwargs):
                    """
                    Include coupled walls in gap face zones.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/include_coupled_walls").execute(*args, **kwargs)
                def check_cfl_condition(self, *args, **kwargs):
                    """
                    Check time step size for better convergence.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/check_cfl_condition").execute(*args, **kwargs)
                def update_gap_regions(self, *args, **kwargs):
                    """
                    Update gap regions and gap model solution information.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/update_gap_regions").execute(*args, **kwargs)
                def reduce_gap_regions(self, *args, **kwargs):
                    """
                    Using a more restrictive algorithm for marking cells in gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/reduce_gap_regions").execute(*args, **kwargs)
                def alternative_marking(self, *args, **kwargs):
                    """
                    Mark gap regions using an alternative marking algorithm.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/alternative_marking").execute(*args, **kwargs)
                def render_gap_interface(self, *args, **kwargs):
                    """
                    Render gap interface.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/render_gap_interface").execute(*args, **kwargs)
                def render_flow_modeling_gaps(self, *args, **kwargs):
                    """
                    Render solution inside flow modeling gap cells.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/render_flow_modeling_gaps").execute(*args, **kwargs)
                def flow_blocking_stabilization_parameters(self, *args, **kwargs):
                    """
                    Adjust stabilization settings for the sponge layer used for blocked gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/flow_blocking_stabilization_parameters").execute(*args, **kwargs)
                def extend_gap_regions(self, *args, **kwargs):
                    """
                    Extend gap regions for better convergence.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/extend_gap_regions").execute(*args, **kwargs)
                def revert_controls_to_default(self, *args, **kwargs):
                    """
                    Revert gap stabilization and any related solver settings to default.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/revert_controls_to_default").execute(*args, **kwargs)
                def fill_data_in_gap_regions(self, *args, **kwargs):
                    """
                    Interpolate solution data into the whole gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/fill_data_in_gap_regions").execute(*args, **kwargs)
                def enhanced_data_interpolation(self, *args, **kwargs):
                    """
                    Use enhanced data interpolation for updating information in gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/enhanced_data_interpolation").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set the verbosity for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/verbosity").execute(*args, **kwargs)

        class mesh_interfaces(TUIMenu):
            """
            Enter the mesh-interfaces menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.auto_options = self.__class__.auto_options(path + ["auto_options"], service)
                self.non_conformal_interface_numerics = self.__class__.non_conformal_interface_numerics(path + ["non_conformal_interface_numerics"], service)
                self.mapped_interface_options = self.__class__.mapped_interface_options(path + ["mapped_interface_options"], service)
                super().__init__(path, service)
            def non_overlapping_zone_name(self, *args, **kwargs):
                """
                Get non-overlapping zone name from the associated interface zone.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/non_overlapping_zone_name").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/create").execute(*args, **kwargs)
            def one_to_one_pairing(self, *args, **kwargs):
                """
                Use the default one-to-one interface creation method?.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/one_to_one_pairing").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit a mesh interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/edit").execute(*args, **kwargs)
            def enable_visualization_of_interfaces(self, *args, **kwargs):
                """
                Display facets on mesh interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enable_visualization_of_interfaces").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List all mesh-interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/list").execute(*args, **kwargs)
            def make_periodic(self, *args, **kwargs):
                """
                Make interface zones periodic.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_periodic").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all mesh interfaces.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/delete_all").execute(*args, **kwargs)
            def enforce_continuity_after_bc(self, *args, **kwargs):
                """
                Across the interface, enforces continuity over boundary condition.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enforce_continuity_after_bc").execute(*args, **kwargs)
            def transfer_motion_across_interfaces(self, *args, **kwargs):
                """
                Transfer motion from one side of the interface to the other when only one side undergoes user-defined or system-coupling motion.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/transfer_motion_across_interfaces").execute(*args, **kwargs)
            def make_phaselag_from_periodic(self, *args, **kwargs):
                """
                Convert periodic interface to phase lagged.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_phaselag_from_periodic").execute(*args, **kwargs)
            def enforce_coupled_wall_between_solids(self, *args, **kwargs):
                """
                Create coupled wall interface between solids.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enforce_coupled_wall_between_solids").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display specified mesh interface zone.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/display").execute(*args, **kwargs)
            def remove_left_handed_interface_faces(self, *args, **kwargs):
                """
                Remove left-handed faces during mesh interface creation.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/remove_left_handed_interface_faces").execute(*args, **kwargs)
            def improve_quality(self, *args, **kwargs):
                """
                Improve mesh interface quality.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/improve_quality").execute(*args, **kwargs)
            def auto_pairing(self, *args, **kwargs):
                """
                Automatically pair and create mesh interfaces for some or all interface zones.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/auto_pairing").execute(*args, **kwargs)
            def make_phaselag_from_boundaries(self, *args, **kwargs):
                """
                Make interface zones phase lagged.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/make_phaselag_from_boundaries").execute(*args, **kwargs)
            def turbo_create(self, *args, **kwargs):
                """
                Create a general turbo interface.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/turbo_create").execute(*args, **kwargs)
            def verbosity(self, *args, **kwargs):
                """
                Set mesh interface verbosity.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/verbosity").execute(*args, **kwargs)
            def enable_si_with_nodes(self, *args, **kwargs):
                """
                Enable sliding interfaces with nodes.
                """
                return PyMenu(self.service, "/setup/mesh_interfaces/enable_si_with_nodes").execute(*args, **kwargs)

            class auto_options(TUIMenu):
                """
                Enter auto-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def naming_option(self, *args, **kwargs):
                    """
                    Specify whether or not to include an informative suffix to the mesh interface name.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/naming_option").execute(*args, **kwargs)
                def proximity_tolerance(self, *args, **kwargs):
                    """
                    Specification of auto pairing tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/proximity_tolerance").execute(*args, **kwargs)
                def pairing_between_interface_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones only.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/pairing_between_interface_zones_only").execute(*args, **kwargs)
                def pairing_between_different_cell_zones_only(self, *args, **kwargs):
                    """
                    Pairing between interface zones from different cell zones only.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/pairing_between_different_cell_zones_only").execute(*args, **kwargs)
                def set_default_name_prefix(self, *args, **kwargs):
                    """
                    Specification of auto pairing default name prefix.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/set_default_name_prefix").execute(*args, **kwargs)
                def set_one_to_one_pairing_tolerance(self, *args, **kwargs):
                    """
                    Enable/disable one-to-one auto pairing tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/set_one_to_one_pairing_tolerance").execute(*args, **kwargs)
                def keep_empty_interface(self, *args, **kwargs):
                    """
                    Keep empty interfaces during one-to-one mesh interface creation.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/auto_options/keep_empty_interface").execute(*args, **kwargs)

            class non_conformal_interface_numerics(TUIMenu):
                """
                Setting non-conformal numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def change_numerics(self, *args, **kwargs):
                    """
                    Enable modified non-conformal interface numerics.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/non_conformal_interface_numerics/change_numerics").execute(*args, **kwargs)

            class mapped_interface_options(TUIMenu):
                """
                Enter the mapped-interface-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def convert_to_mapped_interface(self, *args, **kwargs):
                    """
                    Convert non-conformal mesh interface to mapped mesh interfaces.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/convert_to_mapped_interface").execute(*args, **kwargs)
                def solution_controls(self, *args, **kwargs):
                    """
                    Specification of mapped frequency and under-relaxation factor for mapped interfaces.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/solution_controls").execute(*args, **kwargs)
                def tolerance(self, *args, **kwargs):
                    """
                    Specification of mapped interface tolerance.
                    """
                    return PyMenu(self.service, "/setup/mesh_interfaces/mapped_interface_options/tolerance").execute(*args, **kwargs)

        class dynamic_mesh(TUIMenu):
            """
            Enter the dynamic mesh menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.actions = self.__class__.actions(path + ["actions"], service)
                self.controls = self.__class__.controls(path + ["controls"], service)
                self.events = self.__class__.events(path + ["events"], service)
                self.transient_settings = self.__class__.transient_settings(path + ["transient_settings"], service)
                self.zones = self.__class__.zones(path + ["zones"], service)
                super().__init__(path, service)
            def dynamic_mesh(self, *args, **kwargs):
                """
                Enable/disable the dynamic mesh solver and options.
                """
                return PyMenu(self.service, "/setup/dynamic_mesh/dynamic_mesh").execute(*args, **kwargs)

            class actions(TUIMenu):
                """
                Enter the dynamic mesh actions menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remesh_cell_zone(self, *args, **kwargs):
                    """
                    Manually remesh cell zone with option to remesh adjacent dynamic face zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/actions/remesh_cell_zone").execute(*args, **kwargs)

            class controls(TUIMenu):
                """
                Enter the dynamic mesh control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.layering_parameters = self.__class__.layering_parameters(path + ["layering_parameters"], service)
                    self.in_cylinder_parameters = self.__class__.in_cylinder_parameters(path + ["in_cylinder_parameters"], service)
                    self.remeshing_parameters = self.__class__.remeshing_parameters(path + ["remeshing_parameters"], service)
                    self.smoothing_parameters = self.__class__.smoothing_parameters(path + ["smoothing_parameters"], service)
                    self.implicit_update_parameters = self.__class__.implicit_update_parameters(path + ["implicit_update_parameters"], service)
                    self.six_dof_parameters = self.__class__.six_dof_parameters(path + ["six_dof_parameters"], service)
                    self.contact_parameters = self.__class__.contact_parameters(path + ["contact_parameters"], service)
                    self.periodic_displacement_parameters = self.__class__.periodic_displacement_parameters(path + ["periodic_displacement_parameters"], service)
                    super().__init__(path, service)
                def steady_pseudo_time_control(self, *args, **kwargs):
                    """
                    Enable/disable pseudo time step control in user interface.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/steady_pseudo_time_control").execute(*args, **kwargs)
                def remeshing(self, *args, **kwargs):
                    """
                    Enable/disable local remeshing in tri/tet and mixed cell zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing").execute(*args, **kwargs)
                def in_cylinder_output(self, *args, **kwargs):
                    """
                    Enable/disable in-cylinder output.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_output").execute(*args, **kwargs)
                def smoothing(self, *args, **kwargs):
                    """
                    Enable/disable dynamic mesh smoothing.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing").execute(*args, **kwargs)
                def layering(self, *args, **kwargs):
                    """
                    Enable/disable dynamic-layering in quad/hex cell zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering").execute(*args, **kwargs)

                class layering_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh layering menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def split_factor(self, *args, **kwargs):
                        """
                        Set the factor determining when to split dynamic layers.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/split_factor").execute(*args, **kwargs)
                    def constant_height(self, *args, **kwargs):
                        """
                        Enable/disable layering based on constant height, else layering based on constant ratio.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/constant_height").execute(*args, **kwargs)
                    def collapse_factor(self, *args, **kwargs):
                        """
                        Set the factor determining when to collapse dynamic layers.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/layering_parameters/collapse_factor").execute(*args, **kwargs)

                class in_cylinder_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh in-cylinder menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def print_plot_lift(self, *args, **kwargs):
                        """
                        Print or plot valve lift curve.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/print_plot_lift").execute(*args, **kwargs)
                    def crank_angle_step(self, *args, **kwargs):
                        """
                        Specify the crank angle step size.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/crank_angle_step").execute(*args, **kwargs)
                    def piston_data(self, *args, **kwargs):
                        """
                        Specify the crank radius, connecting rod length, and piston pin offset.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/piston_data").execute(*args, **kwargs)
                    def position_starting_mesh(self, *args, **kwargs):
                        """
                        Move mesh from top dead center to starting crank angle.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/position_starting_mesh").execute(*args, **kwargs)
                    def modify_lift(self, *args, **kwargs):
                        """
                        Modify the lift curve (shift or scale).
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/modify_lift").execute(*args, **kwargs)
                    def starting_crank_angle(self, *args, **kwargs):
                        """
                        Specify the starting crank angle.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/starting_crank_angle").execute(*args, **kwargs)
                    def crank_period(self, *args, **kwargs):
                        """
                        Specify the crank period.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/crank_period").execute(*args, **kwargs)
                    def max_crank_angle_step(self, *args, **kwargs):
                        """
                        Specify the maximum crank angle step size.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/max_crank_angle_step").execute(*args, **kwargs)
                    def piston_stroke_cutoff(self, *args, **kwargs):
                        """
                        Specify the cut off point for in-cylinder piston.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/piston_stroke_cutoff").execute(*args, **kwargs)
                    def minimum_lift(self, *args, **kwargs):
                        """
                        Specify the minimum lift for in-cylinder valves.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/in_cylinder_parameters/minimum_lift").execute(*args, **kwargs)

                class remeshing_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh remeshing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.prism_controls = self.__class__.prism_controls(path + ["prism_controls"], service)
                        self.prism_layer_parameters = self.__class__.prism_layer_parameters(path + ["prism_layer_parameters"], service)
                        self.sizing_controls = self.__class__.sizing_controls(path + ["sizing_controls"], service)
                        super().__init__(path, service)
                    def sizing_funct_variation(self, *args, **kwargs):
                        """
                        Set the maximum sizing function increase/decrease in the interior.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_variation").execute(*args, **kwargs)
                    def sizing_funct_resolution(self, *args, **kwargs):
                        """
                        Set the sizing function resolution with respect to shortest boundary.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_resolution").execute(*args, **kwargs)
                    def sizing_funct_defaults(self, *args, **kwargs):
                        """
                        Set sizing function defaults.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_defaults").execute(*args, **kwargs)
                    def sizing_funct_rate(self, *args, **kwargs):
                        """
                        Determine how far from the boundary the increase/decrease happens.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_funct_rate").execute(*args, **kwargs)
                    def face_skew_max(self, *args, **kwargs):
                        """
                        Set the face skewness threshold above which faces will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/face_skew_max").execute(*args, **kwargs)
                    def parallel_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable parallel remeshing for zone remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/parallel_remeshing").execute(*args, **kwargs)
                    def unified_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable unified remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/unified_remeshing").execute(*args, **kwargs)
                    def size_remesh_interval(self, *args, **kwargs):
                        """
                        Set the interval (in time steps) when remeshing based on size is done.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/size_remesh_interval").execute(*args, **kwargs)
                    def length_max(self, *args, **kwargs):
                        """
                        Set the length threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/length_max").execute(*args, **kwargs)
                    def remeshing_after_moving(self, *args, **kwargs):
                        """
                        Enable/disable optional remeshing after mesh motion to meet skewness threshold.
                        Steady state dynamic mesh only.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/remeshing_after_moving").execute(*args, **kwargs)
                    def poly_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable poly remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/poly_remeshing").execute(*args, **kwargs)
                    def length_min(self, *args, **kwargs):
                        """
                        Set the length threshold below which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/length_min").execute(*args, **kwargs)
                    def cell_skew_max(self, *args, **kwargs):
                        """
                        Set the cell skewness threshold above which cells will be remeshed.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/cell_skew_max").execute(*args, **kwargs)
                    def sizing_function(self, *args, **kwargs):
                        """
                        Enable/disable sizing function to control size based remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_function").execute(*args, **kwargs)
                    def remeshing_methods(self, *args, **kwargs):
                        """
                        Enable/disable remeshing methods.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/remeshing_methods").execute(*args, **kwargs)
                    def retain_size_distribution(self, *args, **kwargs):
                        """
                        Enable/disable retaining of size distribution.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/retain_size_distribution").execute(*args, **kwargs)
                    def zone_remeshing(self, *args, **kwargs):
                        """
                        Enable/disable cell zone remeshing method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/zone_remeshing").execute(*args, **kwargs)

                    class prism_controls(TUIMenu):
                        """
                        Specify optional prism controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def add(self, *args, **kwargs):
                            """
                            Add a new object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/add").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edit an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/edit").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/delete").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List objects.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/list").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            List properties of an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_controls/list_properties").execute(*args, **kwargs)

                    class prism_layer_parameters(TUIMenu):
                        """
                        Enter the dynamic mesh prism remeshing menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def number_of_layers(self, *args, **kwargs):
                            """
                            Set the number of elements in the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/number_of_layers").execute(*args, **kwargs)
                        def first_height(self, *args, **kwargs):
                            """
                            Set first cell height in the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/first_height").execute(*args, **kwargs)
                        def growth_rate(self, *args, **kwargs):
                            """
                            Set the geometric growth rate of the prism layer.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/prism_layer_parameters/growth_rate").execute(*args, **kwargs)

                    class sizing_controls(TUIMenu):
                        """
                        Specify optional sizing controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def add(self, *args, **kwargs):
                            """
                            Add a new object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/add").execute(*args, **kwargs)
                        def list_properties(self, *args, **kwargs):
                            """
                            List properties of an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list_properties").execute(*args, **kwargs)
                        def edit(self, *args, **kwargs):
                            """
                            Edit an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/edit").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete an object.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/delete").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List objects.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/remeshing_parameters/sizing_controls/list").execute(*args, **kwargs)

                class smoothing_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh smoothing menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def diffusion_fvm(self, *args, **kwargs):
                        """
                        Set the numerical method used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_fvm").execute(*args, **kwargs)
                    def poisson_ratio(self, *args, **kwargs):
                        """
                        Set the Poisson's ratio used by the linearly elastic solid model.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/poisson_ratio").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the convergence tolerance for spring-based solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/convergence_tolerance").execute(*args, **kwargs)
                    def smoothing_method(self, *args, **kwargs):
                        """
                        Specify the smoothing method used by the dynamic mesh model.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/smoothing_method").execute(*args, **kwargs)
                    def skew_smooth_cell_skew_max(self, *args, **kwargs):
                        """
                        Set the cell skewness threshold above which cells will be smoothed
                        using the skewness method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_cell_skew_max").execute(*args, **kwargs)
                    def bnd_node_relaxation(self, *args, **kwargs):
                        """
                        Set the spring boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/bnd_node_relaxation").execute(*args, **kwargs)
                    def diffusion_coeff_function(self, *args, **kwargs):
                        """
                        Specify whether the diffusion coefficient is based on the
                        boundary distance or the cell volume.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_function").execute(*args, **kwargs)
                    def skew_smooth_niter(self, *args, **kwargs):
                        """
                        Set the number of skewness-based smoothing cycles.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_niter").execute(*args, **kwargs)
                    def boundary_distance_method(self, *args, **kwargs):
                        """
                        Set the method used to evaluate the boundary distance for the
                        diffusion coefficient calculation.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/boundary_distance_method").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for spring-based solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/max_iter").execute(*args, **kwargs)
                    def skew_smooth_all_deforming_boundaries(self, *args, **kwargs):
                        """
                        Enable/disable skewness smoothing for all deforming
                        dynamic boundary zones. If disabled, only the deforming dynamic boundary zones are
                        smoothed which have smoothing explicitly enabled or use local face remeshing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_all_deforming_boundaries").execute(*args, **kwargs)
                    def smooth_from_reference_position(self, *args, **kwargs):
                        """
                        Enable smoothing from reference position.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/smooth_from_reference_position").execute(*args, **kwargs)
                    def spring_on_all_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for all cell shapes.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/spring_on_all_elements").execute(*args, **kwargs)
                    def skew_smooth_face_skew_max(self, *args, **kwargs):
                        """
                        Set the face skewness threshold above which deforming boundary faces
                        will be smoothed using the skewness method.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/skew_smooth_face_skew_max").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for mesh smoothing (FEM).
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/amg_stabilization").execute(*args, **kwargs)
                    def diffusion_coeff_parameter(self, *args, **kwargs):
                        """
                        Set the diffusion coefficient parameter used for diffusion-based smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/diffusion_coeff_parameter").execute(*args, **kwargs)
                    def laplace_node_relaxation(self, *args, **kwargs):
                        """
                        Set the Laplace boundary node relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/laplace_node_relaxation").execute(*args, **kwargs)
                    def spring_on_simplex_elements(self, *args, **kwargs):
                        """
                        Enable/disable spring-based smoothing for tri/tet elements in mixed element zones.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/spring_on_simplex_elements").execute(*args, **kwargs)
                    def relative_convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the relative residual convergence tolerance for diffusion-based (FVM) smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/relative_convergence_tolerance").execute(*args, **kwargs)
                    def bnd_stiffness_factor(self, *args, **kwargs):
                        """
                        Set the stiffness factor for springs connected to boundary nodes.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/bnd_stiffness_factor").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for spring smoothing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/verbosity").execute(*args, **kwargs)
                    def constant_factor(self, *args, **kwargs):
                        """
                        Set the spring constant relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/smoothing_parameters/constant_factor").execute(*args, **kwargs)

                class implicit_update_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh implicit update menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def update_interval(self, *args, **kwargs):
                        """
                        Specify update interval of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/update_interval").execute(*args, **kwargs)
                    def residual_criteria(self, *args, **kwargs):
                        """
                        Specify residual criteria of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/residual_criteria").execute(*args, **kwargs)
                    def motion_relaxation(self, *args, **kwargs):
                        """
                        Specify motion relaxation of implicit update.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/implicit_update_parameters/motion_relaxation").execute(*args, **kwargs)

                class six_dof_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh six-dof menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def y_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify y-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/y_component_of_gravity").execute(*args, **kwargs)
                    def motion_history_file_name(self, *args, **kwargs):
                        """
                        Location of six DOF motion history file.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/motion_history_file_name").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        List Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/list_properties").execute(*args, **kwargs)
                    def motion_history(self, *args, **kwargs):
                        """
                        Enable/disable writing position/orientation of six DOF zones to file.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/motion_history").execute(*args, **kwargs)
                    def create_properties(self, *args, **kwargs):
                        """
                        Create a set of Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/create_properties").execute(*args, **kwargs)
                    def z_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify z-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/z_component_of_gravity").execute(*args, **kwargs)
                    def delete_properties(self, *args, **kwargs):
                        """
                        Delete a set of Six DOF Properties.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/delete_properties").execute(*args, **kwargs)
                    def x_component_of_gravity(self, *args, **kwargs):
                        """
                        Specify x-component-of-gravity.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/x_component_of_gravity").execute(*args, **kwargs)
                    def second_order(self, *args, **kwargs):
                        """
                        Enable/disable second order six DOF solver.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/six_dof_parameters/second_order").execute(*args, **kwargs)

                class contact_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh contact detection menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.flow_control_parameters = self.__class__.flow_control_parameters(path + ["flow_control_parameters"], service)
                        super().__init__(path, service)
                    def flow_control(self, *args, **kwargs):
                        """
                        Enable/disable flow control.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control").execute(*args, **kwargs)
                    def update_contact_marks(self, *args, **kwargs):
                        """
                        Update which cells are marked in order to block flow in the contact region.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/update_contact_marks").execute(*args, **kwargs)
                    def contact_method(self, *args, **kwargs):
                        """
                        Select the method used for flow control in the contact region.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_method").execute(*args, **kwargs)
                    def contact_threshold(self, *args, **kwargs):
                        """
                        Specify threshold distance for contact detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_threshold").execute(*args, **kwargs)
                    def contact_udf(self, *args, **kwargs):
                        """
                        Select UDF to be invoked when contact is detected.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_udf").execute(*args, **kwargs)
                    def render_contact_cells(self, *args, **kwargs):
                        """
                        Set the option to include contact-cells in post-processing.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/render_contact_cells").execute(*args, **kwargs)
                    def contact_face_zones(self, *args, **kwargs):
                        """
                        Select face zones involved in contact detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/contact_face_zones").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set the verbosity for contact-detection.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/verbosity").execute(*args, **kwargs)

                    class flow_control_parameters(TUIMenu):
                        """
                        Enter the flow control menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def create_flow_control_zone(self, *args, **kwargs):
                            """
                            Create a flow control zone.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/create_flow_control_zone").execute(*args, **kwargs)
                        def solution_stabilization(self, *args, **kwargs):
                            """
                            Enable/disable the performance of additional iterations per time step and
                            the application of solution controls to improve the stability of the solver.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/solution_stabilization").execute(*args, **kwargs)
                        def delete_flow_control_zone(self, *args, **kwargs):
                            """
                            Delete a flow control zone.
                            """
                            return PyMenu(self.service, "/setup/dynamic_mesh/controls/contact_parameters/flow_control_parameters/delete_flow_control_zone").execute(*args, **kwargs)

                class periodic_displacement_parameters(TUIMenu):
                    """
                    Enter the dynamic mesh periodic displacement menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete_displacement(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_displacement").execute(*args, **kwargs)
                    def list_displacements(self, *args, **kwargs):
                        """
                        List Periodic Displacements.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/list_displacements").execute(*args, **kwargs)
                    def delete_all_groups(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_groups").execute(*args, **kwargs)
                    def create_displacement(self, *args, **kwargs):
                        """
                        Create Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/create_displacement").execute(*args, **kwargs)
                    def create_group(self, *args, **kwargs):
                        """
                        Create Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/create_group").execute(*args, **kwargs)
                    def list_groups(self, *args, **kwargs):
                        """
                        List Periodic Displacement Groups.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/list_groups").execute(*args, **kwargs)
                    def set_active_displacement(self, *args, **kwargs):
                        """
                        Set Active Periodic Displacement in Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/set_active_displacement").execute(*args, **kwargs)
                    def delete_all_displacements(self, *args, **kwargs):
                        """
                        Delete All Periodic Displacements.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_all_displacements").execute(*args, **kwargs)
                    def edit_group(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/edit_group").execute(*args, **kwargs)
                    def copy_displacement(self, *args, **kwargs):
                        """
                        Copy Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/copy_displacement").execute(*args, **kwargs)
                    def edit_displacement(self, *args, **kwargs):
                        """
                        Edit Periodic Displacement.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/edit_displacement").execute(*args, **kwargs)
                    def delete_group(self, *args, **kwargs):
                        """
                        Delete Periodic Displacement Group.
                        """
                        return PyMenu(self.service, "/setup/dynamic_mesh/controls/periodic_displacement_parameters/delete_group").execute(*args, **kwargs)

            class events(TUIMenu):
                """
                Enter the dynamic mesh events menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def import_event_file(self, *args, **kwargs):
                    """
                    Import dynamic mesh event file.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/events/import_event_file").execute(*args, **kwargs)
                def export_event_file(self, *args, **kwargs):
                    """
                    Export dynamic mesh events to file.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/events/export_event_file").execute(*args, **kwargs)

            class transient_settings(TUIMenu):
                """
                Enter the dynamic mesh transient settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def verbosity(self, *args, **kwargs):
                    """
                    Enable/disable transient scheme verbosity for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/transient_settings/verbosity").execute(*args, **kwargs)
                def allow_second_order(self, *args, **kwargs):
                    """
                    Enable/disable 2nd order transient scheme for dynamic mesh cases.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/transient_settings/allow_second_order").execute(*args, **kwargs)

            class zones(TUIMenu):
                """
                Enter the dynamic mesh zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create(self, *args, **kwargs):
                    """
                    Create dynamic zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/create").execute(*args, **kwargs)
                def insert_boundary_layer(self, *args, **kwargs):
                    """
                    Insert new cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/insert_boundary_layer").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete dynamic zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/delete").execute(*args, **kwargs)
                def remove_interior_layer(self, *args, **kwargs):
                    """
                    Remove interior layer cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/remove_interior_layer").execute(*args, **kwargs)
                def remove_boundary_layer(self, *args, **kwargs):
                    """
                    Remove cell zone.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/remove_boundary_layer").execute(*args, **kwargs)
                def insert_interior_layer(self, *args, **kwargs):
                    """
                    Insert new layer cell zone at specified location.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/insert_interior_layer").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List dynamic zones.
                    """
                    return PyMenu(self.service, "/setup/dynamic_mesh/zones/list").execute(*args, **kwargs)

        class materials(TUIMenu):
            """
            Enter the materials menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_base = self.__class__.data_base(path + ["data_base"], service)
                super().__init__(path, service)
            def list_materials(self, *args, **kwargs):
                """
                List all locally-stored materials.
                """
                return PyMenu(self.service, "/setup/materials/list_materials").execute(*args, **kwargs)
            def change_create(self, *args, **kwargs):
                """
                Change the properties of a locally-stored material or create a new material.
                """
                return PyMenu(self.service, "/setup/materials/change_create").execute(*args, **kwargs)
            def copy_by_formula(self, *args, **kwargs):
                """
                Copy a material from the database by formula.
                """
                return PyMenu(self.service, "/setup/materials/copy_by_formula").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy a material from the database.
                """
                return PyMenu(self.service, "/setup/materials/copy").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List the properties of a locally-stored material.
                """
                return PyMenu(self.service, "/setup/materials/list_properties").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a material from local storage.
                """
                return PyMenu(self.service, "/setup/materials/delete").execute(*args, **kwargs)

            class data_base(TUIMenu):
                """
                Enter the database menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def database_type(self, *args, **kwargs):
                    """
                    Set the database type.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/database_type").execute(*args, **kwargs)
                def save(self, *args, **kwargs):
                    """
                    Save user-defined database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/save").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit a material.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/edit").execute(*args, **kwargs)
                def list_materials(self, *args, **kwargs):
                    """
                    List all materials in the database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/list_materials").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List the properties of a material in the database.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/list_properties").execute(*args, **kwargs)
                def new(self, *args, **kwargs):
                    """
                    Define a new material.
                    """
                    return PyMenu(self.service, "/setup/materials/data_base/new").execute(*args, **kwargs)

        class reference_values(TUIMenu):
            """
            Reference value menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.compute = self.__class__.compute(path + ["compute"], service)
                super().__init__(path, service)
            def pressure(self, *args, **kwargs):
                """
                Set reference pressure for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/pressure").execute(*args, **kwargs)
            def area(self, *args, **kwargs):
                """
                Set reference area for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/area").execute(*args, **kwargs)
            def depth(self, *args, **kwargs):
                """
                Set reference depth for volume calculation.
                """
                return PyMenu(self.service, "/setup/reference_values/depth").execute(*args, **kwargs)
            def velocity(self, *args, **kwargs):
                """
                Set reference velocity for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/velocity").execute(*args, **kwargs)
            def zone(self, *args, **kwargs):
                """
                Set reference zone.
                """
                return PyMenu(self.service, "/setup/reference_values/zone").execute(*args, **kwargs)
            def enthalpy(self, *args, **kwargs):
                """
                Set reference enthalpy for enthalpy damping and normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/enthalpy").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List current reference values.
                """
                return PyMenu(self.service, "/setup/reference_values/list").execute(*args, **kwargs)
            def length(self, *args, **kwargs):
                """
                Set reference length for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/length").execute(*args, **kwargs)
            def yplus(self, *args, **kwargs):
                """
                Set reference yplus for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/yplus").execute(*args, **kwargs)
            def viscosity(self, *args, **kwargs):
                """
                Set reference viscosity for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/viscosity").execute(*args, **kwargs)
            def density(self, *args, **kwargs):
                """
                Set reference density for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/density").execute(*args, **kwargs)
            def temperature(self, *args, **kwargs):
                """
                Set reference temperature for normalization.
                """
                return PyMenu(self.service, "/setup/reference_values/temperature").execute(*args, **kwargs)

            class compute(TUIMenu):
                """
                Enter the compute menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def geometry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/geometry").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/fluid").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/network").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/radiator").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/outflow").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/interface").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_far_field").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/inlet_vent").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/network_end").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/fan").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/velocity_inlet").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/intake_fan").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_outlet").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/dummy_entry").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/solid").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/overset").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/interior").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/outlet_vent").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/rans_les_interface").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/porous_jump").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/shadow").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/degassing").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/periodic").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/recirculation_outlet").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/recirculation_inlet").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/exhaust_fan").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/axis").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/pressure_inlet").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/symmetry").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/mass_flow_outlet").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/wall").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute reference values from a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/reference_values/compute/mass_flow_inlet").execute(*args, **kwargs)

        class boundary_conditions(TUIMenu):
            """
            Enter the boudary conditions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set = self.__class__.set(path + ["set"], service)
                self.query = self.__class__.query(path + ["query"], service)
                self.rename_zone = self.__class__.rename_zone(path + ["rename_zone"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                self.bc_settings = self.__class__.bc_settings(path + ["bc_settings"], service)
                self.profiles = self.__class__.profiles(path + ["profiles"], service)
                self.modify_zones = self.__class__.modify_zones(path + ["modify_zones"], service)
                super().__init__(path, service)
            def axis(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/axis").execute(*args, **kwargs)
            def recirculation_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/recirculation_inlet").execute(*args, **kwargs)
            def mass_flow_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/mass_flow_inlet").execute(*args, **kwargs)
            def velocity_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/velocity_inlet").execute(*args, **kwargs)
            def list_zones(self, *args, **kwargs):
                """
                List zone IDs, types, kinds, and names.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/list_zones").execute(*args, **kwargs)
            def exhaust_fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/exhaust_fan").execute(*args, **kwargs)
            def pressure_far_field(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_far_field").execute(*args, **kwargs)
            def rans_les_interface(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/rans_les_interface").execute(*args, **kwargs)
            def intake_fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/intake_fan").execute(*args, **kwargs)
            def mass_flow_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/mass_flow_outlet").execute(*args, **kwargs)
            def geometry(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/geometry").execute(*args, **kwargs)
            def radiator(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/radiator").execute(*args, **kwargs)
            def network_end(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/network_end").execute(*args, **kwargs)
            def symmetry(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/symmetry").execute(*args, **kwargs)
            def inlet_vent(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/inlet_vent").execute(*args, **kwargs)
            def outlet_vent(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/outlet_vent").execute(*args, **kwargs)
            def shadow(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/shadow").execute(*args, **kwargs)
            def degassing(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/degassing").execute(*args, **kwargs)
            def interface(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/interface").execute(*args, **kwargs)
            def overset(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/overset").execute(*args, **kwargs)
            def zone_name(self, *args, **kwargs):
                """
                Give a zone a new name.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/zone_name").execute(*args, **kwargs)
            def zone_type(self, *args, **kwargs):
                """
                Set a zone's type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/zone_type").execute(*args, **kwargs)
            def solid(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/solid").execute(*args, **kwargs)
            def network(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/network").execute(*args, **kwargs)
            def recirculation_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/recirculation_outlet").execute(*args, **kwargs)
            def fluid(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/fluid").execute(*args, **kwargs)
            def wall(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/wall").execute(*args, **kwargs)
            def outflow(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/outflow").execute(*args, **kwargs)
            def pressure_outlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_outlet").execute(*args, **kwargs)
            def copy_bc(self, *args, **kwargs):
                """
                Copy boundary conditions to another zone.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/copy_bc").execute(*args, **kwargs)
            def fan(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/fan").execute(*args, **kwargs)
            def periodic(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/periodic").execute(*args, **kwargs)
            def porous_jump(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/porous_jump").execute(*args, **kwargs)
            def pressure_inlet(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/pressure_inlet").execute(*args, **kwargs)
            def interior(self, *args, **kwargs):
                """
                Set boundary conditions for a zone of this type.
                """
                return PyMenu(self.service, "/setup/boundary_conditions/interior").execute(*args, **kwargs)

            class set(TUIMenu):
                """
                Enter the set boundary conditions menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/exhaust_fan").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/network").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_far_field").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/solid").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_inlet").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/network_end").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/axis").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/overset").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/interior").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/mass_flow_inlet").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/wall").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/intake_fan").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/outlet_vent").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/velocity_inlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/degassing").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/interface").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/rans_les_interface").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/radiator").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/fluid").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/periodic").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/mass_flow_outlet").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/pressure_outlet").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/outflow").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/shadow").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/fan").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/geometry").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/recirculation_inlet").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/inlet_vent").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/recirculation_outlet").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/symmetry").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Set boundary conditions for a zone or multiple zones of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/set/porous_jump").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter zone query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/outlet_vent").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/overset").execute(*args, **kwargs)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/delete_query").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/network").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/recirculation_inlet").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_far_field").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_inlet").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/mass_flow_outlet").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/geometry").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/shadow").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/outflow").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/mass_flow_inlet").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/degassing").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/exhaust_fan").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/rans_les_interface").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/axis").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/fluid").execute(*args, **kwargs)
                def list_cell_zone_conditions(self, *args, **kwargs):
                    """
                    List cell zone conditions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_cell_zone_conditions").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_queries").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/fan").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/radiator").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/solid").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/recirculation_outlet").execute(*args, **kwargs)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of zone type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_named_selection").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/wall").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/intake_fan").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/network_end").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/velocity_inlet").execute(*args, **kwargs)
                def list_boundary_conditions(self, *args, **kwargs):
                    """
                    List boundary conditions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/list_boundary_conditions").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/symmetry").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/periodic").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/interface").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/inlet_vent").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/interior").execute(*args, **kwargs)
                def named_zone_list(self, *args, **kwargs):
                    """
                    Create named list of zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/named_zone_list").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/pressure_outlet").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Show boundary conditions for a zone of this type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/query/porous_jump").execute(*args, **kwargs)

            class rename_zone(TUIMenu):
                """
                Enter zone rename menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rename_to_default(self, *args, **kwargs):
                    """
                    Rename zone to default name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/rename_to_default").execute(*args, **kwargs)
                def rename_by_adjacency(self, *args, **kwargs):
                    """
                    Rename zone to adjacent zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/rename_by_adjacency").execute(*args, **kwargs)
                def add_suffix_or_prefix(self, *args, **kwargs):
                    """
                    Add suffix or prefix to zone name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/rename_zone/add_suffix_or_prefix").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert bc menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.non_reflecting_bc = self.__class__.non_reflecting_bc(path + ["non_reflecting_bc"], service)
                    self.impedance_data_fitting = self.__class__.impedance_data_fitting(path + ["impedance_data_fitting"], service)
                    self.periodic_conditions = self.__class__.periodic_conditions(path + ["periodic_conditions"], service)
                    self.perforated_walls = self.__class__.perforated_walls(path + ["perforated_walls"], service)
                    super().__init__(path, service)
                def non_overlapping_zone_name(self, *args, **kwargs):
                    """
                    Get non-overlapping zone name from the associated interface zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/non_overlapping_zone_name").execute(*args, **kwargs)
                def target_mass_flow_rate_settings(self, *args, **kwargs):
                    """
                    Enter the targeted mass flow rate setting menu.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/target_mass_flow_rate_settings").execute(*args, **kwargs)
                def open_channel_wave_settings(self, *args, **kwargs):
                    """
                    Open channel wave input analysis.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/open_channel_wave_settings").execute(*args, **kwargs)
                def openchannel_threads(self, *args, **kwargs):
                    """
                    List open channel group IDs, names, types, and variables.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/expert/openchannel_threads").execute(*args, **kwargs)

                class non_reflecting_bc(TUIMenu):
                    """
                    Enter the non-reflecting b.c. menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.turbo_specific_nrbc = self.__class__.turbo_specific_nrbc(path + ["turbo_specific_nrbc"], service)
                        self.general_nrbc = self.__class__.general_nrbc(path + ["general_nrbc"], service)
                        super().__init__(path, service)

                    class turbo_specific_nrbc(TUIMenu):
                        """
                        Enter the turbo-specific n.r.b.c. menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.set = self.__class__.set(path + ["set"], service)
                            super().__init__(path, service)
                        def enable(self, *args, **kwargs):
                            """
                            Enable/disable turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/enable").execute(*args, **kwargs)
                        def initialize(self, *args, **kwargs):
                            """
                            Initialize turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/initialize").execute(*args, **kwargs)
                        def show_status(self, *args, **kwargs):
                            """
                            Show current status of turbo-specific non-reflecting b.c.'s.
                            """
                            return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/show_status").execute(*args, **kwargs)

                        class set(TUIMenu):
                            """
                            Enter the set menu for turbo-specific non-reflecting b.c. parameters.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def discretization(self, *args, **kwargs):
                                """
                                Enable use of higher-order reconstruction at boundaries if available.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/discretization").execute(*args, **kwargs)
                            def under_relaxation(self, *args, **kwargs):
                                """
                                Set turbo-specific non-reflecting b.c. under-relaxation factor.
                                specify < 0 => use P/a_ave
                                specify = 0 => use 1/N
                                specify > 0 => use specified.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/under_relaxation").execute(*args, **kwargs)
                            def verbosity(self, *args, **kwargs):
                                """
                                Set turbo-specific non-reflecting b.c. verbosity level.
                                0 : silent
                                1 : basic info. default
                                2 : detailed info. for debugging
                                .
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/turbo_specific_nrbc/set/verbosity").execute(*args, **kwargs)

                    class general_nrbc(TUIMenu):
                        """
                        Enter the menu for setting general non-reflecting boundary conditions.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.set = self.__class__.set(path + ["set"], service)
                            super().__init__(path, service)

                        class set(TUIMenu):
                            """
                            Enter the general non-reflecting b.c. menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def verbosity(self, *args, **kwargs):
                                """
                                Print boundary equations convergence info.
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/verbosity").execute(*args, **kwargs)
                            def relax(self, *args, **kwargs):
                                """
                                Set NRBC relaxation factor (default value 0.5).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/relax").execute(*args, **kwargs)
                            def tangential_source(self, *args, **kwargs):
                                """
                                Include or not NRBC tangential source (default value #t).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/tangential_source").execute(*args, **kwargs)
                            def sigma2(self, *args, **kwargs):
                                """
                                Set nrbc sigma2 factor (default value 5.0).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/sigma2").execute(*args, **kwargs)
                            def sigma(self, *args, **kwargs):
                                """
                                Set nrbc sigma factor (default value 0.15).
                                """
                                return PyMenu(self.service, "/setup/boundary_conditions/expert/non_reflecting_bc/general_nrbc/set/sigma").execute(*args, **kwargs)

                class impedance_data_fitting(TUIMenu):
                    """
                    Enter the impedance data fitting menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def iterations(self, *args, **kwargs):
                        """
                        Set the number of iterations for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/iterations").execute(*args, **kwargs)
                    def import_parameters(self, *args, **kwargs):
                        """
                        Import impedance parameters into boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/import_parameters").execute(*args, **kwargs)
                    def reflection_data(self, *args, **kwargs):
                        """
                        Read experimental reflection coefficient data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/reflection_data").execute(*args, **kwargs)
                    def impedance_data(self, *args, **kwargs):
                        """
                        Read experimental impedance data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/impedance_data").execute(*args, **kwargs)
                    def absorption_data(self, *args, **kwargs):
                        """
                        Read experimental absorption coefficient data and output impedance parameters for a boundary condition.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/absorption_data").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set verbosity level [0, 1] for fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/verbosity").execute(*args, **kwargs)
                    def residue_tolerance(self, *args, **kwargs):
                        """
                        Set the residue tolerance for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/residue_tolerance").execute(*args, **kwargs)
                    def convergence_tolerance(self, *args, **kwargs):
                        """
                        Set the convergence tolerance for the fitting algorithm.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/impedance_data_fitting/convergence_tolerance").execute(*args, **kwargs)

                class periodic_conditions(TUIMenu):
                    """
                    Enter the periodic conditions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_gradient_specification(self, *args, **kwargs):
                        """
                        Enable/disable specification of pressure gradient at the periodic boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/periodic_conditions/pressure_gradient_specification").execute(*args, **kwargs)
                    def massflow_rate_specification(self, *args, **kwargs):
                        """
                        Enable/disable specification of mass flow rate at the periodic boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/periodic_conditions/massflow_rate_specification").execute(*args, **kwargs)

                class perforated_walls(TUIMenu):
                    """
                    Enter the perforated walls setting menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def read_input_file(self, *args, **kwargs):
                        """
                        Read an input file.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/perforated_walls/read_input_file").execute(*args, **kwargs)
                    def model_setup(self, *args, **kwargs):
                        """
                        Set up perforated walls.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/expert/perforated_walls/model_setup").execute(*args, **kwargs)

            class bc_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.pressure_far_field = self.__class__.pressure_far_field(path + ["pressure_far_field"], service)
                    super().__init__(path, service)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Select pressure specification method on pressure-outlet boundaries.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_outlet").execute(*args, **kwargs)
                def mass_flow(self, *args, **kwargs):
                    """
                    Select method for setting the mass flow rate.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/mass_flow").execute(*args, **kwargs)

                class pressure_far_field(TUIMenu):
                    """
                    Select presure-far-field boundary-condition options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def riemann_invariants_tangency_correction(self, *args, **kwargs):
                        """
                        Apply a local correction where the flow is tangential to the boundary.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_far_field/riemann_invariants_tangency_correction").execute(*args, **kwargs)
                    def type(self, *args, **kwargs):
                        """
                        Choose pressure-far-field boundary-condition type.
                        """
                        return PyMenu(self.service, "/setup/boundary_conditions/bc_settings/pressure_far_field/type").execute(*args, **kwargs)

            class profiles(TUIMenu):
                """
                Enter the boundary profiles menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def orient_profile(self, *args, **kwargs):
                    """
                    Orient Profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/orient_profile").execute(*args, **kwargs)
                def list_profile_fields(self, *args, **kwargs):
                    """
                    List the fields of a particular profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profile_fields").execute(*args, **kwargs)
                def set_preference_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Set Preference Profile Point Cloud Data e.g., Point marker symbol,size,color.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/set_preference_profile_point_cloud_data").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete a profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/delete").execute(*args, **kwargs)
                def overlay_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Overlay Profile Point Cloud Data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/overlay_profile_point_cloud_data").execute(*args, **kwargs)
                def replicate_profile(self, *args, **kwargs):
                    """
                    Replicate Profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/replicate_profile").execute(*args, **kwargs)
                def list_profiles(self, *args, **kwargs):
                    """
                    List all profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profiles").execute(*args, **kwargs)
                def display_profile_point_cloud_data(self, *args, **kwargs):
                    """
                    Display Profile Point Cloud Data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/display_profile_point_cloud_data").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all boundary-profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/delete_all").execute(*args, **kwargs)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Choose the method for interpolation of profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/interpolation_method").execute(*args, **kwargs)
                def update_interval(self, *args, **kwargs):
                    """
                    Set interval between updates of dynamic profiles.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/update_interval").execute(*args, **kwargs)
                def link_profile_to_reference_frame(self, *args, **kwargs):
                    """
                    Link profile to a reference frame.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/link_profile_to_reference_frame").execute(*args, **kwargs)
                def morphing(self, *args, **kwargs):
                    """
                    Enable/disable profile morphing options in Orient Profile panel.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/morphing").execute(*args, **kwargs)
                def display_profile_surface(self, *args, **kwargs):
                    """
                    Display a profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/display_profile_surface").execute(*args, **kwargs)
                def list_profile_parameters(self, *args, **kwargs):
                    """
                    List the parameters of a particular profile.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/list_profile_parameters").execute(*args, **kwargs)
                def overlay_profile_surface(self, *args, **kwargs):
                    """
                    Overlay Profile Surface.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/profiles/overlay_profile_surface").execute(*args, **kwargs)

            class modify_zones(TUIMenu):
                """
                Enter the modify zones menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def copy_move_cell_zone(self, *args, **kwargs):
                    """
                    Copy and translate or rotate a cell zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_move_cell_zone").execute(*args, **kwargs)
                def create_all_shell_threads(self, *args, **kwargs):
                    """
                    Mark all finite thickness wall for shell creation. Shell zones will be created at the start of iterations.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/create_all_shell_threads").execute(*args, **kwargs)
                def translate_zone(self, *args, **kwargs):
                    """
                    Translate nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/translate_zone").execute(*args, **kwargs)
                def append_mesh(self, *args, **kwargs):
                    """
                    Append new mesh.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/append_mesh").execute(*args, **kwargs)
                def recreate_all_shells(self, *args, **kwargs):
                    """
                    Create shell on all the walls where which were deleted using the command delete-all-shells.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/recreate_all_shells").execute(*args, **kwargs)
                def slit_periodic(self, *args, **kwargs):
                    """
                    Slit a periodic zone into two symmetry zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_periodic").execute(*args, **kwargs)
                def orient_face_zone(self, *args, **kwargs):
                    """
                    Orient the face zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/orient_face_zone").execute(*args, **kwargs)
                def change_zone_state(self, *args, **kwargs):
                    """
                    Change the realgas material state for a zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/change_zone_state").execute(*args, **kwargs)
                def merge_zones(self, *args, **kwargs):
                    """
                    Merge zones of the same type and condition into one.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/merge_zones").execute(*args, **kwargs)
                def mrf_to_sliding_mesh(self, *args, **kwargs):
                    """
                    Change motion specification from MRF to moving mesh.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/mrf_to_sliding_mesh").execute(*args, **kwargs)
                def matching_tolerance(self, *args, **kwargs):
                    """
                    Set the normalized tolerance used for finding coincident nodes.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/matching_tolerance").execute(*args, **kwargs)
                def change_zone_phase(self, *args, **kwargs):
                    """
                    Change the realgas phase for a zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/change_zone_phase").execute(*args, **kwargs)
                def list_zones(self, *args, **kwargs):
                    """
                    List zone IDs, types, kinds, and names.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/list_zones").execute(*args, **kwargs)
                def copy_mrf_to_mesh_motion(self, *args, **kwargs):
                    """
                    Copy motion variable values for origin, axis and velocities from Frame Motion to Mesh Motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_mrf_to_mesh_motion").execute(*args, **kwargs)
                def make_periodic(self, *args, **kwargs):
                    """
                    Attempt to establish conformal periodic face zone connectivity.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/make_periodic").execute(*args, **kwargs)
                def slit_face_zone(self, *args, **kwargs):
                    """
                    Slit a two-sided wall into two connected wall zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_face_zone").execute(*args, **kwargs)
                def scale_zone(self, *args, **kwargs):
                    """
                    Scale nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/scale_zone").execute(*args, **kwargs)
                def zone_name(self, *args, **kwargs):
                    """
                    Give a zone a new name.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/zone_name").execute(*args, **kwargs)
                def extrude_face_zone_para(self, *args, **kwargs):
                    """
                    Extrude a face thread a specified distance based on a distance and a list of parametric locations between 0 and 1 (eg. 0 0.2 0.4 0.8 1.0).
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/extrude_face_zone_para").execute(*args, **kwargs)
                def zone_type(self, *args, **kwargs):
                    """
                    Set a zone's type.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/zone_type").execute(*args, **kwargs)
                def deactivate_cell_zone(self, *args, **kwargs):
                    """
                    Deactivate cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/deactivate_cell_zone").execute(*args, **kwargs)
                def slit_interior_between_diff_solids(self, *args, **kwargs):
                    """
                    Slit interior created between different solids into coupled walls.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/slit_interior_between_diff_solids").execute(*args, **kwargs)
                def copy_mesh_to_mrf_motion(self, *args, **kwargs):
                    """
                    Copy motion variable values for origin, axis and velocities from Mesh Motion to Frame Motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/copy_mesh_to_mrf_motion").execute(*args, **kwargs)
                def fuse_face_zones(self, *args, **kwargs):
                    """
                    Attempt to fuse zones by removing duplicate faces and nodes.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/fuse_face_zones").execute(*args, **kwargs)
                def activate_cell_zone(self, *args, **kwargs):
                    """
                    Activate a cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/activate_cell_zone").execute(*args, **kwargs)
                def extrude_face_zone_delta(self, *args, **kwargs):
                    """
                    Extrude a face thread a specified distance based on a list of deltas.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/extrude_face_zone_delta").execute(*args, **kwargs)
                def delete_all_shells(self, *args, **kwargs):
                    """
                    Delete all shell zones and switch off shell conduction on all the walls. These zones can be recreated using the command recreate-all-shells.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/delete_all_shells").execute(*args, **kwargs)
                def replace_zone(self, *args, **kwargs):
                    """
                    Replace a cell zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/replace_zone").execute(*args, **kwargs)
                def sep_face_zone_region(self, *args, **kwargs):
                    """
                    Separate a face zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_region").execute(*args, **kwargs)
                def rotate_zone(self, *args, **kwargs):
                    """
                    Rotate nodal coordinates of input cell zones.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/rotate_zone").execute(*args, **kwargs)
                def append_mesh_data(self, *args, **kwargs):
                    """
                    Append new mesh with data.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/append_mesh_data").execute(*args, **kwargs)
                def sep_cell_zone_region(self, *args, **kwargs):
                    """
                    Separate a cell zone based on contiguous regions.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_cell_zone_region").execute(*args, **kwargs)
                def create_periodic_interface(self, *args, **kwargs):
                    """
                    Create a conformal or non-conformal periodic interface.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/create_periodic_interface").execute(*args, **kwargs)
                def sep_face_zone_angle(self, *args, **kwargs):
                    """
                    Separate a face zone based on significant angle.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_angle").execute(*args, **kwargs)
                def convert_all_solid_mrf_to_solid_motion(self, *args, **kwargs):
                    """
                    Change all solid zones motion specification from MRF to solid motion.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/convert_all_solid_mrf_to_solid_motion").execute(*args, **kwargs)
                def sep_cell_zone_mark(self, *args, **kwargs):
                    """
                    Separate a cell zone based on cell marking.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_cell_zone_mark").execute(*args, **kwargs)
                def sep_face_zone_mark(self, *args, **kwargs):
                    """
                    Separate a face zone based on cell marking.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_mark").execute(*args, **kwargs)
                def delete_cell_zone(self, *args, **kwargs):
                    """
                    Delete a cell thread.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/delete_cell_zone").execute(*args, **kwargs)
                def sep_face_zone_face(self, *args, **kwargs):
                    """
                    Separate each face in a zone into unique zone.
                    """
                    return PyMenu(self.service, "/setup/boundary_conditions/modify_zones/sep_face_zone_face").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enter the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                super().__init__(path, service)
            def crevice_model(self, *args, **kwargs):
                """
                Enable/disable the crevice model.
                """
                return PyMenu(self.service, "/setup/models/crevice_model").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enable/disable ablation model.
                """
                return PyMenu(self.service, "/setup/models/ablation").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Enable/disable Newmark unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                Enable/disable the energy model.
                """
                return PyMenu(self.service, "/setup/models/energy").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enter battery model menu.
                """
                return PyMenu(self.service, "/setup/models/battery_model").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/setup/models/noniterative_time_advance").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enable/disable the electric-potential model.
                """
                return PyMenu(self.service, "/setup/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_1st_order").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Enable/disable Backward Euler unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_euler").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_global_time").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enable/disable the soot model.
                """
                return PyMenu(self.service, "/setup/models/soot").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enter the crevice model controls menu.
                """
                return PyMenu(self.service, "/setup/models/crevice_model_controls").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enable/disable the steady solution model.
                """
                return PyMenu(self.service, "/setup/models/steady").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enable/disable axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/setup/models/swirl").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Load addon module.
                """
                return PyMenu(self.service, "/setup/models/addon_module").execute(*args, **kwargs)
            def nox(self, *args, **kwargs):
                """
                Enable/disable the NOx model.
                """
                return PyMenu(self.service, "/setup/models/nox").execute(*args, **kwargs)
            def optics(self, *args, **kwargs):
                """
                Enter the optics model menu.
                """
                return PyMenu(self.service, "/setup/models/optics").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/setup/models/frozen_flux").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/setup/models/vbm").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enable/disable the solidification and melting model.
                """
                return PyMenu(self.service, "/setup/models/solidification_melting").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Enable/disable the axisymmetric model.
                """
                return PyMenu(self.service, "/setup/models/axisymmetric").execute(*args, **kwargs)

            class soot_parameters(TUIMenu):
                """
                Enter the soot parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def soot_process_parameters(self, *args, **kwargs):
                    """
                    Set soot process parameters.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_process_parameters").execute(*args, **kwargs)
                def soot_model_udfs(self, *args, **kwargs):
                    """
                    User defined functions for soot model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_model_udfs").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/inlet_diffusion").execute(*args, **kwargs)
                def modify_schmidt_number(self, *args, **kwargs):
                    """
                    Change Turbulent Schmidt Number for Soot/Nuclei Equations.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/modify_schmidt_number").execute(*args, **kwargs)
                def soot_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set Soot-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_turbulence_interaction").execute(*args, **kwargs)
                def soot_model_parameters(self, *args, **kwargs):
                    """
                    Enter the soot model parameters menu.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_model_parameters").execute(*args, **kwargs)
                def soot_radiation_interaction(self, *args, **kwargs):
                    """
                    Enable/disable the soot-radiation interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/soot_parameters/soot_radiation_interaction").execute(*args, **kwargs)

            class nox_parameters(TUIMenu):
                """
                Enter the NOx parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nox_chemistry(self, *args, **kwargs):
                    """
                    Select NOx chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_chemistry").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/inlet_diffusion").execute(*args, **kwargs)
                def nox_expert(self, *args, **kwargs):
                    """
                    Select additional nox equations.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_expert").execute(*args, **kwargs)
                def nox_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set NOx-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_turbulence_interaction").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enter the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    super().__init__(path, service)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initialize Eulerian wall film model.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enable Eulerian wall film model.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activate Eulerian wall film equations.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def solution_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model solution options.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Set film material and properties.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
                    """
                    Enter Implicit Scheme Option (beta).
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def new_implicit_scheme(self, *args, **kwargs):
                        """
                        Enable alternative implicit scheme.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/implicit_options/new_implicit_scheme").execute(*args, **kwargs)
                    def relative_error_residual(self, *args, **kwargs):
                        """
                        Enable relative error residual.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/implicit_options/relative_error_residual").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enter Eulerian wall film coupled solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enable Eulerian wall film coupled solution.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enable Eulerian wall film curvature smoothing.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)

            class radiation(TUIMenu):
                """
                Enter the radiation models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.s2s_parameters = self.__class__.s2s_parameters(path + ["s2s_parameters"], service)
                    self.dtrm_parameters = self.__class__.dtrm_parameters(path + ["dtrm_parameters"], service)
                    self.solar_parameters = self.__class__.solar_parameters(path + ["solar_parameters"], service)
                    super().__init__(path, service)
                def mc_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for montecarlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/mc_model_parameters").execute(*args, **kwargs)
                def p1(self, *args, **kwargs):
                    """
                    Enable/disable the P1 radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/p1").execute(*args, **kwargs)
                def method_partially_specular_wall(self, *args, **kwargs):
                    """
                    Set method for partially specular wall with discrete ordinate model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/method_partially_specular_wall").execute(*args, **kwargs)
                def rosseland(self, *args, **kwargs):
                    """
                    Enable/disable the Rosseland radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/rosseland").execute(*args, **kwargs)
                def wsggm_cell_based(self, *args, **kwargs):
                    """
                    Enable/disable WSGGM cell based method.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/wsggm_cell_based").execute(*args, **kwargs)
                def radiation_iteration_parameters(self, *args, **kwargs):
                    """
                    Set iteration parameters for radiation models.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/radiation_iteration_parameters").execute(*args, **kwargs)
                def do_acceleration(self, *args, **kwargs):
                    """
                    Enable/disable acceleration of computation of DO model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/do_acceleration").execute(*args, **kwargs)
                def montecarlo(self, *args, **kwargs):
                    """
                    Enable/disable the Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/montecarlo").execute(*args, **kwargs)
                def discrete_ordinates(self, *args, **kwargs):
                    """
                    Enable/disable the discrete ordinates radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/discrete_ordinates").execute(*args, **kwargs)
                def fast_second_order_discrete_ordinate(self, *args, **kwargs):
                    """
                    Enable/disable the fast-second-order option for Discrete Ordinate Model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/fast_second_order_discrete_ordinate").execute(*args, **kwargs)
                def solar_calculator(self, *args, **kwargs):
                    """
                    Calculate sun direction and intensity.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar_calculator").execute(*args, **kwargs)
                def blending_factor(self, *args, **kwargs):
                    """
                    Set numeric option for Discrete Ordinate model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/blending_factor").execute(*args, **kwargs)
                def non_gray_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for non-gray model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/non_gray_model_parameters").execute(*args, **kwargs)
                def solar_irradiation(self, *args, **kwargs):
                    """
                    Enable/disable the Solar irradiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar_irradiation").execute(*args, **kwargs)
                def radiation_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for radiation models.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/radiation_model_parameters").execute(*args, **kwargs)
                def discrete_transfer(self, *args, **kwargs):
                    """
                    Enable/disable discrete the transfer radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/discrete_transfer").execute(*args, **kwargs)
                def target_cells_per_volume_cluster(self, *args, **kwargs):
                    """
                    Enter cells per volume cluster for Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/target_cells_per_volume_cluster").execute(*args, **kwargs)
                def solar(self, *args, **kwargs):
                    """
                    Enable/disable the solar model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar").execute(*args, **kwargs)
                def beta_radiation_features(self, *args, **kwargs):
                    """
                    Enable Radiation Models with Non-Iterative Time Advancement (NITA) as Beta features in FL12.0.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/beta_radiation_features").execute(*args, **kwargs)
                def solution_method_for_do_coupling(self, *args, **kwargs):
                    """
                    Enable the solution method for DO/Energy  Coupling.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solution_method_for_do_coupling").execute(*args, **kwargs)
                def apply_full_solar_irradiation(self, *args, **kwargs):
                    """
                    Enable/disable application of solar irradiation to first band with DO model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/apply_full_solar_irradiation").execute(*args, **kwargs)
                def do_coupling(self, *args, **kwargs):
                    """
                    Enabled DO Energy Coupling.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/do_coupling").execute(*args, **kwargs)
                def mc_under_relaxation(self, *args, **kwargs):
                    """
                    Set under-relaxation factor for montecarlo radiation sources used in the energy equation.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/mc_under_relaxation").execute(*args, **kwargs)
                def s2s(self, *args, **kwargs):
                    """
                    Enable/disable the S2S radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/s2s").execute(*args, **kwargs)

                class s2s_parameters(TUIMenu):
                    """
                    Enter the S2S parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def compute_write_vf(self, *args, **kwargs):
                        """
                        Compute/write surface clusters and view factors for S2S radiation model.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_write_vf").execute(*args, **kwargs)
                    def compute_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write view factors from existing surface clusters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_vf_accelerated").execute(*args, **kwargs)
                    def print_zonewise_radiation(self, *args, **kwargs):
                        """
                        Prints the zonewise incoming radiation, viewfactors, and average temperature.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/print_zonewise_radiation").execute(*args, **kwargs)
                    def read_vf_file(self, *args, **kwargs):
                        """
                        Read an S2S file.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/read_vf_file").execute(*args, **kwargs)
                    def enable_mesh_interface_clustering(self, *args, **kwargs):
                        """
                        Enable clustering on mesh interfaces?.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/enable_mesh_interface_clustering").execute(*args, **kwargs)
                    def set_global_faces_per_surface_cluster(self, *args, **kwargs):
                        """
                        Set global value of faces per surface cluster for all boundary zones.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/set_global_faces_per_surface_cluster").execute(*args, **kwargs)
                    def use_old_cluster_algorithm(self, *args, **kwargs):
                        """
                        Use the old surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/use_old_cluster_algorithm").execute(*args, **kwargs)
                    def split_angle(self, *args, **kwargs):
                        """
                        Set the split angle for the clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/split_angle").execute(*args, **kwargs)
                    def compute_clusters_and_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write surface cluster first and then view factors.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_clusters_and_vf_accelerated").execute(*args, **kwargs)
                    def compute_fpsc_values(self, *args, **kwargs):
                        """
                        Compute only fpsc values based on current settings.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_fpsc_values").execute(*args, **kwargs)
                    def set_vf_parameters(self, *args, **kwargs):
                        """
                        Set the parameters needed for the view factor calculations.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/set_vf_parameters").execute(*args, **kwargs)
                    def print_thread_clusters(self, *args, **kwargs):
                        """
                        Prints the following for all boundary threads: thread-id, number of faces, faces per surface cluster, and the number of surface clusters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/print_thread_clusters").execute(*args, **kwargs)
                    def compute_vf_only(self, *args, **kwargs):
                        """
                        Compute/write view factors only.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_vf_only").execute(*args, **kwargs)
                    def use_new_cluster_algorithm(self, *args, **kwargs):
                        """
                        Use the new surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/use_new_cluster_algorithm").execute(*args, **kwargs)
                    def non_participating_boundary_zones_temperature(self, *args, **kwargs):
                        """
                        Set temperature for the non-participating boundary zones.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/non_participating_boundary_zones_temperature").execute(*args, **kwargs)

                class dtrm_parameters(TUIMenu):
                    """
                    Enter the DTRM parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def check_ray_file(self, *args, **kwargs):
                        """
                        Read DTRM rays file.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/check_ray_file").execute(*args, **kwargs)
                    def ray_trace(self, *args, **kwargs):
                        """
                        Create DTRM rays for radiation.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/ray_trace").execute(*args, **kwargs)
                    def controls(self, *args, **kwargs):
                        """
                        Set DTRM solution controls.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/controls").execute(*args, **kwargs)
                    def make_globs(self, *args, **kwargs):
                        """
                        Make globs (coarser mesh) for radiation.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/make_globs").execute(*args, **kwargs)

                class solar_parameters(TUIMenu):
                    """
                    Enter the solar parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def iteration_parameters(self, *args, **kwargs):
                        """
                        Set update parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/iteration_parameters").execute(*args, **kwargs)
                    def sun_direction_vector(self, *args, **kwargs):
                        """
                        Set sun direction vector.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sun_direction_vector").execute(*args, **kwargs)
                    def autosave_solar_data(self, *args, **kwargs):
                        """
                        Set autosave solar data parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/autosave_solar_data").execute(*args, **kwargs)
                    def sol_on_demand(self, *args, **kwargs):
                        """
                        Enable  solar load on demand.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_on_demand").execute(*args, **kwargs)
                    def scattering_fraction(self, *args, **kwargs):
                        """
                        Set scattering fraction parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/scattering_fraction").execute(*args, **kwargs)
                    def illumination_parameters(self, *args, **kwargs):
                        """
                        Set illumination parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/illumination_parameters").execute(*args, **kwargs)
                    def quad_tree_parameters(self, *args, **kwargs):
                        """
                        Set quad-tree refinement parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/quad_tree_parameters").execute(*args, **kwargs)
                    def solar_thread_control(self, *args, **kwargs):
                        """
                        Solar thread control.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/solar_thread_control").execute(*args, **kwargs)
                    def ground_reflectivity(self, *args, **kwargs):
                        """
                        Set ground reflectivity parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/ground_reflectivity").execute(*args, **kwargs)
                    def sol_camera_pos(self, *args, **kwargs):
                        """
                        Set camera position based on sun direction vector.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_camera_pos").execute(*args, **kwargs)
                    def sol_adjacent_fluidcells(self, *args, **kwargs):
                        """
                        Enable solar load for adjacent fluid cells.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_adjacent_fluidcells").execute(*args, **kwargs)
                    def use_direction_from_sol_calc(self, *args, **kwargs):
                        """
                        Set direction computed from solar calculator.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/use_direction_from_sol_calc").execute(*args, **kwargs)
                    def autoread_solar_data(self, *args, **kwargs):
                        """
                        Set autoread solar data parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/autoread_solar_data").execute(*args, **kwargs)

            class system_coupling_settings(TUIMenu):
                """
                Enter the system coupling model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.htc = self.__class__.htc(path + ["htc"], service)
                    super().__init__(path, service)
                def specify_system_coupling_volumetric_cell_zones(self, *args, **kwargs):
                    """
                    Enable/disable volumetric cell zones.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/specify_system_coupling_volumetric_cell_zones").execute(*args, **kwargs)
                def use_face_or_element_based_data_transfer(self, *args, **kwargs):
                    """
                    Enable/disable face based data transfer.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/use_face_or_element_based_data_transfer").execute(*args, **kwargs)
                def update_rigid_body_mesh_motion_before_mesh_transfer(self, *args, **kwargs):
                    """
                    SC Enable/disable mesh motion.
                    """
                    return PyMenu(self.service, "/setup/models/system_coupling_settings/update_rigid_body_mesh_motion_before_mesh_transfer").execute(*args, **kwargs)

                class htc(TUIMenu):
                    """
                    Enter the heat transfer coeficient menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.unsteady_statistics = self.__class__.unsteady_statistics(path + ["unsteady_statistics"], service)
                        self.htc_calculation_method = self.__class__.htc_calculation_method(path + ["htc_calculation_method"], service)
                        super().__init__(path, service)

                    class unsteady_statistics(TUIMenu):
                        """
                        Enter the unsteady statistics menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def sc_enable_sub_stepping_option_per_coupling_step(self, *args, **kwargs):
                            """
                            Enable/disable sub stepping option per coupling step.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/unsteady_statistics/sc_enable_sub_stepping_option_per_coupling_step").execute(*args, **kwargs)

                    class htc_calculation_method(TUIMenu):
                        """
                        Enter the htc calculation menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def use_tref_in_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable tref in htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_tref_in_htc_calculation").execute(*args, **kwargs)
                        def use_yplus_based_htc_calculation(self, *args, **kwargs):
                            """
                            Enable/disable yplus in htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_yplus_based_htc_calculation").execute(*args, **kwargs)
                        def use_wall_function_based_htc(self, *args, **kwargs):
                            """
                            Enable/disable wall function based htc computation.
                            """
                            return PyMenu(self.service, "/setup/models/system_coupling_settings/htc/htc_calculation_method/use_wall_function_based_htc").execute(*args, **kwargs)

            class electrolysis(TUIMenu):
                """
                Enter the electrolysis model setup menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.membrane_setup = self.__class__.membrane_setup(path + ["membrane_setup"], service)
                    self.anode_setup = self.__class__.anode_setup(path + ["anode_setup"], service)
                    self.cathode_setup = self.__class__.cathode_setup(path + ["cathode_setup"], service)
                    super().__init__(path, service)
                def model_options(self, *args, **kwargs):
                    """
                    Specify electrolysis model options.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/model_options").execute(*args, **kwargs)
                def parameters(self, *args, **kwargs):
                    """
                    Specify electrolysis model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/parameters").execute(*args, **kwargs)
                def electrical_tabs_setup(self, *args, **kwargs):
                    """
                    Specify settings for the electrical tabs.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/electrical_tabs_setup").execute(*args, **kwargs)

                class membrane_setup(TUIMenu):
                    """
                    Specify parameters for electrolyte.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/current_collector").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/electrolyte").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/catalyst_layer").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/porous_layer").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/flow_channel").execute(*args, **kwargs)

                class anode_setup(TUIMenu):
                    """
                    Enter the menu for the anode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/porous_layer").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/electrolyte").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/current_collector").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/flow_channel").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/catalyst_layer").execute(*args, **kwargs)

                class cathode_setup(TUIMenu):
                    """
                    Enter the menu for the cathode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/porous_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/current_collector").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/flow_channel").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/electrolyte").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/catalyst_layer").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enter the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dual_cell_model = self.__class__.dual_cell_model(path + ["dual_cell_model"], service)
                    self.macro_model = self.__class__.macro_model(path + ["macro_model"], service)
                    super().__init__(path, service)

                class dual_cell_model(TUIMenu):
                    """
                    Enter the dual cell model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def delete_heat_exchanger(self, *args, **kwargs):
                        """
                        Delete heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/delete_heat_exchanger").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plot NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/plot_NTU").execute(*args, **kwargs)
                    def add_heat_exchanger(self, *args, **kwargs):
                        """
                        Add heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/add_heat_exchanger").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Write NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/write_NTU").execute(*args, **kwargs)
                    def modify_heat_exchanger(self, *args, **kwargs):
                        """
                        Modify heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/modify_heat_exchanger").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enable/disable the dual cell heat-exchanger model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/heat_exchanger").execute(*args, **kwargs)
                    def alternative_formulation(self, *args, **kwargs):
                        """
                        Enable/disable alternative formulation for heat transfer calculations.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/alternative_formulation").execute(*args, **kwargs)

                class macro_model(TUIMenu):
                    """
                    Enter the heat macro-model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plot NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/plot_NTU").execute(*args, **kwargs)
                    def heat_exchanger_macro_report(self, *args, **kwargs):
                        """
                        Report heat-exchanger information for all the macros.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_macro_report").execute(*args, **kwargs)
                    def delete_heat_exchanger_group(self, *args, **kwargs):
                        """
                        Delete heat-exchanger group.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/delete_heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_model(self, *args, **kwargs):
                        """
                        Define heat-exchanger core model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_model").execute(*args, **kwargs)
                    def heat_exchanger_group(self, *args, **kwargs):
                        """
                        Define heat-exchanger group.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enable/disable heat-exchanger model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger").execute(*args, **kwargs)
                    def heat_exchanger_zone(self, *args, **kwargs):
                        """
                        Define heat-exchanger zone.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_zone").execute(*args, **kwargs)
                    def heat_exchanger_report(self, *args, **kwargs):
                        """
                        Report heat-exchanger information.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_report").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Write NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/write_NTU").execute(*args, **kwargs)

            class viscous(TUIMenu):
                """
                Enter the viscous model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.near_wall_treatment = self.__class__.near_wall_treatment(path + ["near_wall_treatment"], service)
                    self.turbulence_expert = self.__class__.turbulence_expert(path + ["turbulence_expert"], service)
                    self.transition_model_options = self.__class__.transition_model_options(path + ["transition_model_options"], service)
                    self.geko_options = self.__class__.geko_options(path + ["geko_options"], service)
                    self.multiphase_turbulence = self.__class__.multiphase_turbulence(path + ["multiphase_turbulence"], service)
                    super().__init__(path, service)
                def les_subgrid_smagorinsky(self, *args, **kwargs):
                    """
                    Enable/disable the Smagorinsky-Lilly subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_smagorinsky").execute(*args, **kwargs)
                def kw_bsl(self, *args, **kwargs):
                    """
                    Enable/disable the BSL k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_bsl").execute(*args, **kwargs)
                def inviscid(self, *args, **kwargs):
                    """
                    Enable/disable the inviscid flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/inviscid").execute(*args, **kwargs)
                def sa_enhanced_wall_treatment(self, *args, **kwargs):
                    """
                    Enable/disable the enhanced wall treatment for the Spalart-Allmaras model.
                    If disabled, no smooth blending between the viscous sublayer and the
                    log-law formulation is employed, as was done in versions previous to Fluent14.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_enhanced_wall_treatment").execute(*args, **kwargs)
                def trans_sst_roughness_correlation(self, *args, **kwargs):
                    """
                    Enable/disable the Transition-SST roughness correlation option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/trans_sst_roughness_correlation").execute(*args, **kwargs)
                def les_subgrid_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_rng").execute(*args, **kwargs)
                def ke_realizable(self, *args, **kwargs):
                    """
                    Enable/disable the realizable k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_realizable").execute(*args, **kwargs)
                def rsm_ssg_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the quadratic pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_ssg_pressure_strain").execute(*args, **kwargs)
                def sas(self, *args, **kwargs):
                    """
                    Enable/disable the SAS turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sas").execute(*args, **kwargs)
                def laminar(self, *args, **kwargs):
                    """
                    Enable/disable the laminar flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/laminar").execute(*args, **kwargs)
                def curvature_correction_ccurv(self, *args, **kwargs):
                    """
                    Set the curvature correction coefficient CCURV.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction_ccurv").execute(*args, **kwargs)
                def rsm_or_earsm_geko_option(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO option for RSM or EARSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_or_earsm_geko_option").execute(*args, **kwargs)
                def user_defined_transition(self, *args, **kwargs):
                    """
                    Set user-defined transition correlations.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined_transition").execute(*args, **kwargs)
                def kw_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_easm").execute(*args, **kwargs)
                def spalart_allmaras(self, *args, **kwargs):
                    """
                    Enable/disable the Spalart-Allmaras turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/spalart_allmaras").execute(*args, **kwargs)
                def detached_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable detached eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/detached_eddy_simulation").execute(*args, **kwargs)
                def kw_shear_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega shear-flow correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_shear_correction").execute(*args, **kwargs)
                def les_subgrid_tke(self, *args, **kwargs):
                    """
                    Enable/disable the kinetic energy transport subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_tke").execute(*args, **kwargs)
                def rng_swirl_model(self, *args, **kwargs):
                    """
                    Enable/disable swirl corrections for rng-model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_swirl_model").execute(*args, **kwargs)
                def mixing_length(self, *args, **kwargs):
                    """
                    Enable/disable the mixing-length (algebraic) turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/mixing_length").execute(*args, **kwargs)
                def turb_buoyancy_effects(self, *args, **kwargs):
                    """
                    Select buoyancy effects on turbulence.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_buoyancy_effects").execute(*args, **kwargs)
                def les_subgrid_wale(self, *args, **kwargs):
                    """
                    Enable/disable the WALE subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wale").execute(*args, **kwargs)
                def corner_flow_correction_ccorner(self, *args, **kwargs):
                    """
                    Set the corner flow correction coefficient CCORNER.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction_ccorner").execute(*args, **kwargs)
                def les_subgrid_wmles(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles").execute(*args, **kwargs)
                def add_transition_model(self, *args, **kwargs):
                    """
                    Enable/disable a transition model to account for transitional effects.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/add_transition_model").execute(*args, **kwargs)
                def kw_geko(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_geko").execute(*args, **kwargs)
                def large_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable large eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/large_eddy_simulation").execute(*args, **kwargs)
                def corner_flow_correction(self, *args, **kwargs):
                    """
                    Enable/disable the corner flow correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction").execute(*args, **kwargs)
                def reynolds_stress_model(self, *args, **kwargs):
                    """
                    Enable/disable the RSM turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/reynolds_stress_model").execute(*args, **kwargs)
                def sa_damping(self, *args, **kwargs):
                    """
                    Enable/disable the full low-Reynolds number form of Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_damping").execute(*args, **kwargs)
                def v2f(self, *args, **kwargs):
                    """
                    Enable/disable the V2F turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/v2f").execute(*args, **kwargs)
                def kw_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_standard").execute(*args, **kwargs)
                def rsm_bsl_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-BSL model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_bsl_based").execute(*args, **kwargs)
                def sa_alternate_prod(self, *args, **kwargs):
                    """
                    Enable/disable strain/vorticity production in Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_alternate_prod").execute(*args, **kwargs)
                def ke1e(self, *args, **kwargs):
                    """
                    Enable/disable the KE1E turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke1e").execute(*args, **kwargs)
                def low_pressure_boundary_slip(self, *args, **kwargs):
                    """
                    Enable/disable the slip boundary formulation for low-pressure gas systems.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/low_pressure_boundary_slip").execute(*args, **kwargs)
                def turb_compressibility(self, *args, **kwargs):
                    """
                    Enable/disable the compressibility correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_compressibility").execute(*args, **kwargs)
                def transition_sst(self, *args, **kwargs):
                    """
                    Enable/disable the transition SST turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/transition_sst").execute(*args, **kwargs)
                def ke_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_standard").execute(*args, **kwargs)
                def curvature_correction(self, *args, **kwargs):
                    """
                    Enable/disable the curvature correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction").execute(*args, **kwargs)
                def k_kl_w(self, *args, **kwargs):
                    """
                    Enable/disable the k-kl-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/k_kl_w").execute(*args, **kwargs)
                def kw_wj_bsl_earsm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_wj_bsl_earsm").execute(*args, **kwargs)
                def rsm_wall_echo(self, *args, **kwargs):
                    """
                    Enable/disable wall-echo effects in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_wall_echo").execute(*args, **kwargs)
                def rsm_omega_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-omega model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_omega_based").execute(*args, **kwargs)
                def les_subgrid_wmles_s_minus_omega(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES S-Omega subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles_s_minus_omega").execute(*args, **kwargs)
                def ke_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_rng").execute(*args, **kwargs)
                def rsm_solve_tke(self, *args, **kwargs):
                    """
                    Enable/disable the solution of T.K.E. in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_solve_tke").execute(*args, **kwargs)
                def les_dynamic_energy_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Prandtl Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_energy_flux").execute(*args, **kwargs)
                def ke_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_easm").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Select user-defined functions to define the turbulent viscosity and the turbulent Prandtl and Schmidt numbers.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined").execute(*args, **kwargs)
                def rsm_linear_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the linear pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_linear_pressure_strain").execute(*args, **kwargs)
                def rng_differential_visc(self, *args, **kwargs):
                    """
                    Enable/disable the differential-viscosity model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_differential_visc").execute(*args, **kwargs)
                def les_subgrid_dynamic_fvar(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                def kw_low_re_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega low Re option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_low_re_correction").execute(*args, **kwargs)
                def kw_sst(self, *args, **kwargs):
                    """
                    Enable/disable the SST k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_sst").execute(*args, **kwargs)
                def zero_equation_hvac(self, *args, **kwargs):
                    """
                    Enable/disable the zero-equation HVAC turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/zero_equation_hvac").execute(*args, **kwargs)
                def les_dynamic_scalar_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Schmidt Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_scalar_flux").execute(*args, **kwargs)
                def des_limiter_option(self, *args, **kwargs):
                    """
                    Select DES limiter option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/des_limiter_option").execute(*args, **kwargs)

                class near_wall_treatment(TUIMenu):
                    """
                    Enter the near wall treatment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def user_defined_wall_functions(self, *args, **kwargs):
                        """
                        Enable user defined wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/user_defined_wall_functions").execute(*args, **kwargs)
                    def scalable_wall_functions(self, *args, **kwargs):
                        """
                        Enable/disable scalable wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/scalable_wall_functions").execute(*args, **kwargs)
                    def wf_pressure_gradient_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function pressure-gradient effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_pressure_gradient_effects").execute(*args, **kwargs)
                    def menter_lechner(self, *args, **kwargs):
                        """
                        Enable/disable near wall treatment Menter-Lechner.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/menter_lechner").execute(*args, **kwargs)
                    def werner_wengle_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable Werner-Wengle wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/werner_wengle_wall_fn").execute(*args, **kwargs)
                    def non_equilibrium_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable non-equilibrium wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/non_equilibrium_wall_fn").execute(*args, **kwargs)
                    def wf_thermal_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function thermal effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_thermal_effects").execute(*args, **kwargs)
                    def enhanced_wall_treatment(self, *args, **kwargs):
                        """
                        Enable/disable enhanced wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/enhanced_wall_treatment").execute(*args, **kwargs)
                    def wall_omega_treatment(self, *args, **kwargs):
                        """
                        Set wall omega treatment.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wall_omega_treatment").execute(*args, **kwargs)

                class turbulence_expert(TUIMenu):
                    """
                    Enter the turbulence expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def sbes_sdes_hybrid_model(self, *args, **kwargs):
                        """
                        Select the SBES / SDES hybrid model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sdes_hybrid_model").execute(*args, **kwargs)
                    def rke_cmu_rotation_term(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of omega in the Cmu definition.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/rke_cmu_rotation_term").execute(*args, **kwargs)
                    def kw_add_des(self, *args, **kwargs):
                        """
                        Enable/disable DES-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_des").execute(*args, **kwargs)
                    def turb_non_newtonian(self, *args, **kwargs):
                        """
                        Enable/disable turbulence for non-Newtonian fluids.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_non_newtonian").execute(*args, **kwargs)
                    def sbes_sgs_option(self, *args, **kwargs):
                        """
                        Select SBES subgrid-scale model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sgs_option").execute(*args, **kwargs)
                    def turb_pk_compressible(self, *args, **kwargs):
                        """
                        Enable/disable turbulent production due to compressible divergence.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_pk_compressible").execute(*args, **kwargs)
                    def kato_launder_model(self, *args, **kwargs):
                        """
                        Enable/disable Kato-Launder modification for production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kato_launder_model").execute(*args, **kwargs)
                    def turbulence_damping(self, *args, **kwargs):
                        """
                        Enable/disable turbulence damping and set turbulence damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turbulence_damping").execute(*args, **kwargs)
                    def sbes_les_subgrid_dynamic_fvar(self, *args, **kwargs):
                        """
                        Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                    def low_re_ke_index(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon model version.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke_index").execute(*args, **kwargs)
                    def sbes_update_interval_k_omega(self, *args, **kwargs):
                        """
                        Set an integer value how often the k and omega equations are updated in a transient SBES run.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_update_interval_k_omega").execute(*args, **kwargs)
                    def non_newtonian_modification(self, *args, **kwargs):
                        """
                        Enable/disable non-Newtonian modification for Lam-Bremhorst model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/non_newtonian_modification").execute(*args, **kwargs)
                    def kw_vorticity_based_production(self, *args, **kwargs):
                        """
                        Enable/disable vorticity based production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_vorticity_based_production").execute(*args, **kwargs)
                    def turb_add_sbes_sdes(self, *args, **kwargs):
                        """
                        Enable/disable SBES / SDES with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_add_sbes_sdes").execute(*args, **kwargs)
                    def low_re_ke(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke").execute(*args, **kwargs)
                    def restore_sst_v61(self, *args, **kwargs):
                        """
                        Enable/disable SST formulation of v6.1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/restore_sst_v61").execute(*args, **kwargs)
                    def kw_add_sas(self, *args, **kwargs):
                        """
                        Enable/disable the SAS-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_sas").execute(*args, **kwargs)
                    def production_limiter(self, *args, **kwargs):
                        """
                        Enable/disable the Production Limiter.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/production_limiter").execute(*args, **kwargs)
                    def thermal_p_function(self, *args, **kwargs):
                        """
                        Enable/disable the Jayatilleke P function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/thermal_p_function").execute(*args, **kwargs)

                class transition_model_options(TUIMenu):
                    """
                    Enter the transition model options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rec_max(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_MAX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_max").execute(*args, **kwargs)
                    def rec_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c2").execute(*args, **kwargs)
                    def capg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_lowtu").execute(*args, **kwargs)
                    def critical_reynolds_number_correlation(self, *args, **kwargs):
                        """
                        Set the critical Reynolds number correlation.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/critical_reynolds_number_correlation").execute(*args, **kwargs)
                    def cfpg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_lowtu").execute(*args, **kwargs)
                    def clambda_scale(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CLAMBDA_SCALE.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/clambda_scale").execute(*args, **kwargs)
                    def rv1_switch(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient RV1_SWITCH.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rv1_switch").execute(*args, **kwargs)
                    def ctu_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_hightu").execute(*args, **kwargs)
                    def rec_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c1").execute(*args, **kwargs)
                    def cfpg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_hightu").execute(*args, **kwargs)
                    def cbubble_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c2").execute(*args, **kwargs)
                    def ctu_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_lowtu").execute(*args, **kwargs)
                    def capg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_hightu").execute(*args, **kwargs)
                    def cbubble_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c1").execute(*args, **kwargs)
                    def crossflow_transition(self, *args, **kwargs):
                        """
                        Enable/disable crossflow transition for the intermittency transition model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/crossflow_transition").execute(*args, **kwargs)

                class geko_options(TUIMenu):
                    """
                    Enter the GEKO options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def creal(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CREAL.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/creal").execute(*args, **kwargs)
                    def geko_defaults(self, *args, **kwargs):
                        """
                        Set GEKO options to default.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/geko_defaults").execute(*args, **kwargs)
                    def wall_distance_free(self, *args, **kwargs):
                        """
                        Enable/disable wall-distance-free version of GEKO model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/wall_distance_free").execute(*args, **kwargs)
                    def cjet_aux(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET_AUX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet_aux").execute(*args, **kwargs)
                    def cbf_lam(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_LAM.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_lam").execute(*args, **kwargs)
                    def cnw(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw").execute(*args, **kwargs)
                    def cmix(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CMIX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cmix").execute(*args, **kwargs)
                    def cbf_tur(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_TUR.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_tur").execute(*args, **kwargs)
                    def cjet(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet").execute(*args, **kwargs)
                    def blending_function(self, *args, **kwargs):
                        """
                        Set the GEKO model blending function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/blending_function").execute(*args, **kwargs)
                    def csep(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CSEP.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/csep").execute(*args, **kwargs)
                    def cnw_sub(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW_SUB.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw_sub").execute(*args, **kwargs)

                class multiphase_turbulence(TUIMenu):
                    """
                    Enter the multiphase turbulence menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rsm_multiphase_models(self, *args, **kwargs):
                        """
                        Enable/disable the Reynolds Stress multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/rsm_multiphase_models").execute(*args, **kwargs)
                    def turbulence_multiphase_models(self, *args, **kwargs):
                        """
                        Select the k-epsilon multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/turbulence_multiphase_models").execute(*args, **kwargs)
                    def subgrid_turbulence_contribution_aiad(self, *args, **kwargs):
                        """
                        Enable/disable the Subgrid Turbulence Contribution for the AIAD model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/subgrid_turbulence_contribution_aiad").execute(*args, **kwargs)
                    def multiphase_options(self, *args, **kwargs):
                        """
                        Enable/disable multiphase options.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/multiphase_options").execute(*args, **kwargs)

            class cht(TUIMenu):
                """
                Enter the mapped interface model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.explicit_time_averaged_coupling = self.__class__.explicit_time_averaged_coupling(path + ["explicit_time_averaged_coupling"], service)
                    super().__init__(path, service)
                def read_mi_type_wall(self, *args, **kwargs):
                    """
                    Read mapped interface data settings from a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/cht/read_mi_type_wall").execute(*args, **kwargs)
                def write_mi_type_wall(self, *args, **kwargs):
                    """
                    Write mapped interface settings to a scv file.
                    """
                    return PyMenu(self.service, "/setup/models/cht/write_mi_type_wall").execute(*args, **kwargs)
                def implicit_coupling(self, *args, **kwargs):
                    """
                    Enable/disable implicit coupling for mapped interface.
                    """
                    return PyMenu(self.service, "/setup/models/cht/implicit_coupling").execute(*args, **kwargs)

                class explicit_time_averaged_coupling(TUIMenu):
                    """
                    Enter the explcit time averaged thermal coupling menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mapped_interfaces(self, *args, **kwargs):
                        """
                        Select fluid-solid mapped interfaces for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/mapped_interfaces").execute(*args, **kwargs)
                    def coupling_controls(self, *args, **kwargs):
                        """
                        Specify explcit coupling controls.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/coupling_controls").execute(*args, **kwargs)
                    def conformal_coupled_walls(self, *args, **kwargs):
                        """
                        Select fluid-solid coupled walls (without shell) for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/conformal_coupled_walls").execute(*args, **kwargs)
                    def fuse_explicit_cht_zones(self, *args, **kwargs):
                        """
                        Fuse slitted conformal coupled walls marked for transient explicit thermal coupling.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/fuse_explicit_cht_zones").execute(*args, **kwargs)

            class two_temperature(TUIMenu):
                """
                Define two-temperature model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def robustness_enhancement(self, *args, **kwargs):
                    """
                    Apply robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/robustness_enhancement").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set two-temperature model verbosity option.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/set_verbosity").execute(*args, **kwargs)
                def nasa9_enhancement(self, *args, **kwargs):
                    """
                    Apply nasa9 robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/nasa9_enhancement").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/enable").execute(*args, **kwargs)
                def weak_ionization(self, *args, **kwargs):
                    """
                    Apply weak ionization in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/weak_ionization").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enter the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/nonlinear_elasticity").execute(*args, **kwargs)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/setup/models/structure/thermal_effects").execute(*args, **kwargs)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enable the linear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/linear_elasticity").execute(*args, **kwargs)
                def structure_off(self, *args, **kwargs):
                    """
                    Disable the structural model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/structure_off").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enter the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/enhanced_strain").execute(*args, **kwargs)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Set structure damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/max_iter").execute(*args, **kwargs)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/amg_stabilization").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enable explicit fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of viscous fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of operating p into fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)

            class acoustics(TUIMenu):
                """
                Enter the acoustics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.sponge_layers = self.__class__.sponge_layers(path + ["sponge_layers"], service)
                    self.wave_equation_options = self.__class__.wave_equation_options(path + ["wave_equation_options"], service)
                    self.sources_fft = self.__class__.sources_fft(path + ["sources_fft"], service)
                    self.far_field_parameters = self.__class__.far_field_parameters(path + ["far_field_parameters"], service)
                    super().__init__(path, service)
                def moving_receiver(self, *args, **kwargs):
                    """
                    Enable/disable moving receiver option.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/moving_receiver").execute(*args, **kwargs)
                def ffowcs_williams(self, *args, **kwargs):
                    """
                    Enable/disable the Ffowcs-Williams-and-Hawkings model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/ffowcs_williams").execute(*args, **kwargs)
                def broad_band_noise(self, *args, **kwargs):
                    """
                    Enable/disable the broadband noise model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/broad_band_noise").execute(*args, **kwargs)
                def export_volumetric_sources_cgns(self, *args, **kwargs):
                    """
                    Enable/disable the export of fluid zones.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_volumetric_sources_cgns").execute(*args, **kwargs)
                def acoustic_modal_analysis(self, *args, **kwargs):
                    """
                    Iterate linear acoustic solver to compute the resonance frequencies and the acoustic modes.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/acoustic_modal_analysis").execute(*args, **kwargs)
                def convective_effects(self, *args, **kwargs):
                    """
                    Enable/disable convective effects option.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/convective_effects").execute(*args, **kwargs)
                def compute_write(self, *args, **kwargs):
                    """
                    Compute sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/compute_write").execute(*args, **kwargs)
                def modal_analysis(self, *args, **kwargs):
                    """
                    Enable/disable the modal analysis model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/modal_analysis").execute(*args, **kwargs)
                def display_frequencies(self, *args, **kwargs):
                    """
                    Display resonance frequencies.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/display_frequencies").execute(*args, **kwargs)
                def export_volumetric_sources(self, *args, **kwargs):
                    """
                    Enable/disable the export of fluid zones.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_volumetric_sources").execute(*args, **kwargs)
                def export_source_data(self, *args, **kwargs):
                    """
                    Enable export acoustic source data in ASD format during the wave equation model run.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_source_data").execute(*args, **kwargs)
                def display_flow_time(self, *args, **kwargs):
                    """
                    Enable/disable the display of flow time during read-and-compute.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/display_flow_time").execute(*args, **kwargs)
                def cylindrical_export(self, *args, **kwargs):
                    """
                    Enable/disable the export data in cylindrical coordinates.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/cylindrical_export").execute(*args, **kwargs)
                def write_acoustic_signals(self, *args, **kwargs):
                    """
                    Write on-the-fly sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/write_acoustic_signals").execute(*args, **kwargs)
                def read_compute_write(self, *args, **kwargs):
                    """
                    Read acoustic source data files and compute sound pressure.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/read_compute_write").execute(*args, **kwargs)
                def wave_equation(self, *args, **kwargs):
                    """
                    Enable/disable the wave equation model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/wave_equation").execute(*args, **kwargs)
                def receivers(self, *args, **kwargs):
                    """
                    Set acoustic receivers.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/receivers").execute(*args, **kwargs)
                def auto_prune(self, *args, **kwargs):
                    """
                    Enable/disable auto prune of the receiver signal(s) during read-and-compute.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/auto_prune").execute(*args, **kwargs)
                def export_source_data_cgns(self, *args, **kwargs):
                    """
                    Export acoustic source data in CGNS format.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/export_source_data_cgns").execute(*args, **kwargs)
                def sources(self, *args, **kwargs):
                    """
                    Set acoustic sources.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/sources").execute(*args, **kwargs)
                def write_centroid_info(self, *args, **kwargs):
                    """
                    Write centroid info.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/write_centroid_info").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable the acoustics model.
                    """
                    return PyMenu(self.service, "/setup/models/acoustics/off").execute(*args, **kwargs)

                class sponge_layers(TUIMenu):
                    """
                    Manage sponge layers where density is blended to eliminate reflections from boundary zones.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_active(self, *args, **kwargs):
                        """
                        List the names of the active sponge layer definitions.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list_active").execute(*args, **kwargs)
                    def deactivate(self, *args, **kwargs):
                        """
                        Deactivate a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/deactivate").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/delete").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the names of the sponge layer definitions.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/edit").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Add a new sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/add").execute(*args, **kwargs)
                    def activate(self, *args, **kwargs):
                        """
                        Activate a sponge object.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/activate").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        List the properties of a sponge layer definition.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sponge_layers/list_properties").execute(*args, **kwargs)

                class wave_equation_options(TUIMenu):
                    """
                    Enter the options menu for the wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.basic_shapes = self.__class__.basic_shapes(path + ["basic_shapes"], service)
                        self.remote_receivers_options = self.__class__.remote_receivers_options(path + ["remote_receivers_options"], service)
                        super().__init__(path, service)
                    def sponge_layer_base_level(self, *args, **kwargs):
                        """
                        Specify artificial viscosity base level applied everywhere.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_base_level").execute(*args, **kwargs)
                    def time_filter_source(self, *args, **kwargs):
                        """
                        Activate time-filtering of sound sources.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/time_filter_source").execute(*args, **kwargs)
                    def sponge_layer_factor(self, *args, **kwargs):
                        """
                        Specify artificial viscosity factor for sponge layer.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_factor").execute(*args, **kwargs)
                    def sponge_layer_udf(self, *args, **kwargs):
                        """
                        Select user-defined function for sponge layer.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/sponge_layer_udf").execute(*args, **kwargs)
                    def source_mask_udf(self, *args, **kwargs):
                        """
                        Select user-defined function for sound source masking.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/source_mask_udf").execute(*args, **kwargs)
                    def remote_receivers(self, *args, **kwargs):
                        """
                        Activate the Kirchhoff's integral method for remote receivers.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers").execute(*args, **kwargs)

                    class basic_shapes(TUIMenu):
                        """
                        Enter the basic shapes menu to build source mask and sponge layer
                        geometry shapes using cell registers.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def add_source_mask_shape(self, *args, **kwargs):
                            """
                            Add a region register for the source mask.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/add_source_mask_shape").execute(*args, **kwargs)
                        def list_sponge_layer_shapes(self, *args, **kwargs):
                            """
                            List all active sponge layer registers.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_sponge_layer_shapes").execute(*args, **kwargs)
                        def list_source_mask_shapes(self, *args, **kwargs):
                            """
                            List all active source mask registers.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_source_mask_shapes").execute(*args, **kwargs)
                        def add_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Add a region register for the sponge layer.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/add_sponge_layer_shape").execute(*args, **kwargs)
                        def remove_sponge_layer_shape(self, *args, **kwargs):
                            """
                            Remove a region register from the sponge layer.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/remove_sponge_layer_shape").execute(*args, **kwargs)
                        def remove_source_mask_shape(self, *args, **kwargs):
                            """
                            Remove a region register from the source mask.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/remove_source_mask_shape").execute(*args, **kwargs)
                        def list_region_registers(self, *args, **kwargs):
                            """
                            List all available region registers (hex/cylinder/sphere).
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/basic_shapes/list_region_registers").execute(*args, **kwargs)

                    class remote_receivers_options(TUIMenu):
                        """
                        Enter the menu to set up the Kirchhoff's integral method and output its results.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def integration_surface(self, *args, **kwargs):
                            """
                            Select Kirchhoff's integration surface.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers_options/integration_surface").execute(*args, **kwargs)
                        def write_signals(self, *args, **kwargs):
                            """
                            Write signals calculated at receiver locations.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/wave_equation_options/remote_receivers_options/write_signals").execute(*args, **kwargs)

                class sources_fft(TUIMenu):
                    """
                    Enter the acoustic sources FFT menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.fft_surface_variables = self.__class__.fft_surface_variables(path + ["fft_surface_variables"], service)
                        super().__init__(path, service)
                    def read_asd_files(self, *args, **kwargs):
                        """
                        Read ASD files.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/read_asd_files").execute(*args, **kwargs)
                    def write_cgns_files(self, *args, **kwargs):
                        """
                        Write CGNS files.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/write_cgns_files").execute(*args, **kwargs)
                    def clean_up_storage_area(self, *args, **kwargs):
                        """
                        Clean up storage area.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/clean_up_storage_area").execute(*args, **kwargs)
                    def compute_fft_fields(self, *args, **kwargs):
                        """
                        Compute FFT fields.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/sources_fft/compute_fft_fields").execute(*args, **kwargs)

                    class fft_surface_variables(TUIMenu):
                        """
                        Enter the FFT surface variables menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def create_octave_bands(self, *args, **kwargs):
                            """
                            Create octave bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_octave_bands").execute(*args, **kwargs)
                        def remove_variables(self, *args, **kwargs):
                            """
                            Remove variables.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/remove_variables").execute(*args, **kwargs)
                        def create_set_of_modes(self, *args, **kwargs):
                            """
                            Create set of modes.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_set_of_modes").execute(*args, **kwargs)
                        def create_third_bands(self, *args, **kwargs):
                            """
                            Create third bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_third_bands").execute(*args, **kwargs)
                        def create_constant_width_bands(self, *args, **kwargs):
                            """
                            Create constant-width bands.
                            """
                            return PyMenu(self.service, "/setup/models/acoustics/sources_fft/fft_surface_variables/create_constant_width_bands").execute(*args, **kwargs)

                class far_field_parameters(TUIMenu):
                    """
                    Enter the far field parameters menu for the wave equation model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def far_field_sound_speed(self, *args, **kwargs):
                        """
                        Specify far field speed of sound.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/far_field_parameters/far_field_sound_speed").execute(*args, **kwargs)
                    def far_field_density(self, *args, **kwargs):
                        """
                        Specify far field density.
                        """
                        return PyMenu(self.service, "/setup/models/acoustics/far_field_parameters/far_field_density").execute(*args, **kwargs)

            class dpm(TUIMenu):
                """
                Enter the dispersed phase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.stripping_options = self.__class__.stripping_options(path + ["stripping_options"], service)
                    self.numerics = self.__class__.numerics(path + ["numerics"], service)
                    self.splash_options = self.__class__.splash_options(path + ["splash_options"], service)
                    self.collisions = self.__class__.collisions(path + ["collisions"], service)
                    self.erosion_dynamic_mesh = self.__class__.erosion_dynamic_mesh(path + ["erosion_dynamic_mesh"], service)
                    self.parallel = self.__class__.parallel(path + ["parallel"], service)
                    self.options = self.__class__.options(path + ["options"], service)
                    self.interaction = self.__class__.interaction(path + ["interaction"], service)
                    super().__init__(path, service)
                def spray_model(self, *args, **kwargs):
                    """
                    Enter the spray model menu.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/spray_model").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Set DPM user-defined functions.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/user_defined").execute(*args, **kwargs)
                def fill_injection_material_sources(self, *args, **kwargs):
                    """
                    Initialize the DPM sources corresponding to each material.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/fill_injection_material_sources").execute(*args, **kwargs)
                def clear_particles_from_domain(self, *args, **kwargs):
                    """
                    Remove/keep all particles currently in the domain.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/clear_particles_from_domain").execute(*args, **kwargs)
                def injections(self, *args, **kwargs):
                    """
                    Enter the injections menu.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/injections").execute(*args, **kwargs)
                def unsteady_tracking(self, *args, **kwargs):
                    """
                    Enable/disable unsteady particle tracking.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/unsteady_tracking").execute(*args, **kwargs)

                class stripping_options(TUIMenu):
                    """
                    Enter the stripping options menu to set optional parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def diameter_coefficient(self, *args, **kwargs):
                        """
                        Set the stripping diameter coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/stripping_options/diameter_coefficient").execute(*args, **kwargs)
                    def mass_coefficient(self, *args, **kwargs):
                        """
                        Set the stripping mass coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/stripping_options/mass_coefficient").execute(*args, **kwargs)

                class numerics(TUIMenu):
                    """
                    Enter the numerics menu to set numerical solution parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.high_resolution_tracking = self.__class__.high_resolution_tracking(path + ["high_resolution_tracking"], service)
                        super().__init__(path, service)
                    def vaporization_limiting_factors(self, *args, **kwargs):
                        """
                        Set Vaporization Fractional Change Limits.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/vaporization_limiting_factors").execute(*args, **kwargs)
                    def drag_law(self, *args, **kwargs):
                        """
                        Set the drag law.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/drag_law").execute(*args, **kwargs)
                    def tracking_scheme(self, *args, **kwargs):
                        """
                        Specify a tracking scheme.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_scheme").execute(*args, **kwargs)
                    def error_control(self, *args, **kwargs):
                        """
                        Set the adapt integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/error_control").execute(*args, **kwargs)
                    def average_kernel(self, *args, **kwargs):
                        """
                        Specify a kernel for the averaging.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_kernel").execute(*args, **kwargs)
                    def underrelax_film_height(self, *args, **kwargs):
                        """
                        Define underrelaxation factor for film height.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/underrelax_film_height").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Adjust the DPM tracker's verbosity level.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/verbosity").execute(*args, **kwargs)
                    def tracking_parameters(self, *args, **kwargs):
                        """
                        Set parameters for the (initial) tracking step length.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_parameters").execute(*args, **kwargs)
                    def minimum_liquid_fraction(self, *args, **kwargs):
                        """
                        Evaporate droplet completely when the remaining mass is below this fraction of initial mass.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/minimum_liquid_fraction").execute(*args, **kwargs)
                    def gaussian_factor(self, *args, **kwargs):
                        """
                        Set a factor for the gaussian kernel for node-based averaging.~%Large values give small size, small values give large size of kernel.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/gaussian_factor").execute(*args, **kwargs)
                    def enable_node_based_averaging(self, *args, **kwargs):
                        """
                        Enable node based averaging of DPM variables.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/enable_node_based_averaging").execute(*args, **kwargs)
                    def tracking_statistics(self, *args, **kwargs):
                        """
                        Control the format of the one-line tracking statistics printed after every DPM tracking pass.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_statistics").execute(*args, **kwargs)
                    def average_source_terms(self, *args, **kwargs):
                        """
                        Average DPM source terms on nodes.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_source_terms").execute(*args, **kwargs)
                    def coupled_heat_mass_update(self, *args, **kwargs):
                        """
                        Enable/disable coupled heat and mass update.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/coupled_heat_mass_update").execute(*args, **kwargs)
                    def enhanced_packing_limit_numerics(self, *args, **kwargs):
                        """
                        Enable enhanced packing limit numerics to avoid exceeding of packing limit for granular phases.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/enhanced_packing_limit_numerics").execute(*args, **kwargs)
                    def average_each_step(self, *args, **kwargs):
                        """
                        Do the averaging after each integration step for higher accuracy at a higher cost.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_each_step").execute(*args, **kwargs)
                    def mppic_settings(self, *args, **kwargs):
                        """
                        Enable PIC and MPPIC to compute DPM and DDPM source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/mppic_settings").execute(*args, **kwargs)
                    def average_DDPM_variables(self, *args, **kwargs):
                        """
                        Average DDPM specific variables like volume fractions and velocities on nodes.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_DDPM_variables").execute(*args, **kwargs)
                    def automated_scheme_selection(self, *args, **kwargs):
                        """
                        Enable/disable the adaptation of integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/automated_scheme_selection").execute(*args, **kwargs)

                    class high_resolution_tracking(TUIMenu):
                        """
                        Enter the high resolution tracking menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.barycentric_interpolation = self.__class__.barycentric_interpolation(path + ["barycentric_interpolation"], service)
                            self.particle_relocation = self.__class__.particle_relocation(path + ["particle_relocation"], service)
                            super().__init__(path, service)
                        def set_subtet_intersection_tolerance(self, *args, **kwargs):
                            """
                            Set the tolerance for subtet intersection calculations.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/set_subtet_intersection_tolerance").execute(*args, **kwargs)
                        def use_particle_timestep_for_intersection_tolerance(self, *args, **kwargs):
                            """
                            Use the particle timestep for the axisymmetric subtet intersection tolerance.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_particle_timestep_for_intersection_tolerance").execute(*args, **kwargs)
                        def use_barycentric_sampling(self, *args, **kwargs):
                            """
                            Use barycentric coordinates when sampling at planes.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_barycentric_sampling").execute(*args, **kwargs)
                        def remove_stuck_particles(self, *args, **kwargs):
                            """
                            Remove particles that are stuck at edges or faces.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/remove_stuck_particles").execute(*args, **kwargs)
                        def boundary_layer_tracking(self, *args, **kwargs):
                            """
                            Adjust the particle timestep to account for high aspect ratio cells.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/boundary_layer_tracking").execute(*args, **kwargs)
                        def set_film_spreading_parameter(self, *args, **kwargs):
                            """
                            Set the spreading parameter for Lagrangian wallfilm particles.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/set_film_spreading_parameter").execute(*args, **kwargs)
                        def enable_barycentric_intersections(self, *args, **kwargs):
                            """
                            Use barycentric coordinates for intersection calculations.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_barycentric_intersections").execute(*args, **kwargs)
                        def sliding_interface_crossover_fraction(self, *args, **kwargs):
                            """
                            Move the particle a fraction of the distance to the subtet center when crossing a sliding interface.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/sliding_interface_crossover_fraction").execute(*args, **kwargs)
                        def always_use_face_centroid_with_periodics(self, *args, **kwargs):
                            """
                            Use quad face centroids when creating subtets if the case contains periodic boundaries.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/always_use_face_centroid_with_periodics").execute(*args, **kwargs)
                        def enable_high_resolution_tracking(self, *args, **kwargs):
                            """
                            Enable high resolution tracking.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_high_resolution_tracking").execute(*args, **kwargs)
                        def use_velocity_based_error_control(self, *args, **kwargs):
                            """
                            Use adaptive time stepping based upon the particle velocity.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_velocity_based_error_control").execute(*args, **kwargs)
                        def enable_automatic_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enable automatic scaling of subtet intersection tolerance.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_automatic_intersection_tolerance").execute(*args, **kwargs)
                        def project_wall_film_particles_to_film(self, *args, **kwargs):
                            """
                            Project existing particles to film to track using high resolution tracking?.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/project_wall_film_particles_to_film").execute(*args, **kwargs)
                        def use_quad_face_centroid(self, *args, **kwargs):
                            """
                            Use quad face centroids when creating subtets.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_quad_face_centroid").execute(*args, **kwargs)
                        def check_subtet_validity(self, *args, **kwargs):
                            """
                            Test for inverted subtets due to warped cells.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/check_subtet_validity").execute(*args, **kwargs)

                        class barycentric_interpolation(TUIMenu):
                            """
                            Enter the barycentric interpolation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def nodal_reconstruction_frequency(self, *args, **kwargs):
                                """
                                Update nodal reconstruction every N'th DPM iteration.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/nodal_reconstruction_frequency").execute(*args, **kwargs)
                            def interpolate_flow_solution_gradients(self, *args, **kwargs):
                                """
                                Enable interpolation of flow solution gradients.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_solution_gradients").execute(*args, **kwargs)
                            def interpolate_flow_viscosity(self, *args, **kwargs):
                                """
                                Enable interpolation of flow viscosity to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_viscosity").execute(*args, **kwargs)
                            def interpolate_temperature(self, *args, **kwargs):
                                """
                                Enable interpolation of temperature to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_temperature").execute(*args, **kwargs)
                            def user_interpolation_function(self, *args, **kwargs):
                                """
                                Enter user interpolation function.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/user_interpolation_function").execute(*args, **kwargs)
                            def zero_nodal_velocity_on_walls(self, *args, **kwargs):
                                """
                                Set the nodal velocity on all walls to zero.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/zero_nodal_velocity_on_walls").execute(*args, **kwargs)
                            def enable_transient_variable_interpolation(self, *args, **kwargs):
                                """
                                Enable transient variable interpolation.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/enable_transient_variable_interpolation").execute(*args, **kwargs)
                            def interpolate_flow_density(self, *args, **kwargs):
                                """
                                Enable interpolation of flow density to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_density").execute(*args, **kwargs)
                            def precompute_pdf_species(self, *args, **kwargs):
                                """
                                Precompute cell values of PDF species mass fractions prior to particle tracking.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/precompute_pdf_species").execute(*args, **kwargs)
                            def interpolate_wallfilm_properties(self, *args, **kwargs):
                                """
                                Enable interpolation of wallfilm properties to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_wallfilm_properties").execute(*args, **kwargs)
                            def interpolate_flow_cp(self, *args, **kwargs):
                                """
                                Enable interpolation of flow specific heat to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_cp").execute(*args, **kwargs)

                        class particle_relocation(TUIMenu):
                            """
                            Enter the particle relocation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def enhanced_cell_relocation_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_cell_relocation_method").execute(*args, **kwargs)
                            def wallfilm_relocation_tolerance_scale_factor(self, *args, **kwargs):
                                """
                                Set the relocation tolerance scaling factor for wallfilm particles after remeshing.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/wallfilm_relocation_tolerance_scale_factor").execute(*args, **kwargs)
                            def use_legacy_particle_location_method(self, *args, **kwargs):
                                """
                                Enable legacy method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/use_legacy_particle_location_method").execute(*args, **kwargs)
                            def load_legacy_particles(self, *args, **kwargs):
                                """
                                Load particles that were tracked without high-resolution tracking enabled.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/load_legacy_particles").execute(*args, **kwargs)
                            def overset_relocation_robustness_level(self, *args, **kwargs):
                                """
                                Set the robustness level for particle relocation in overset meshes.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/overset_relocation_robustness_level").execute(*args, **kwargs)
                            def enhanced_wallfilm_location_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating film particles on faces.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_wallfilm_location_method").execute(*args, **kwargs)

                class splash_options(TUIMenu):
                    """
                    Enter the splash options menu to set optional parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def splash_pdf_limiting(self, *args, **kwargs):
                        """
                        Select splash pdf limiting method.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/splash_options/splash_pdf_limiting").execute(*args, **kwargs)
                    def orourke_splash_fraction(self, *args, **kwargs):
                        """
                        Select splash fraction method.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/splash_options/orourke_splash_fraction").execute(*args, **kwargs)

                class collisions(TUIMenu):
                    """
                    Enter the DEM collisions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.collision_partners = self.__class__.collision_partners(path + ["collision_partners"], service)
                        super().__init__(path, service)
                    def collision_pair_settings(self, *args, **kwargs):
                        """
                        Supply settings for collisions to a pair of collision partners.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/collision_pair_settings").execute(*args, **kwargs)
                    def collision_mesh(self, *args, **kwargs):
                        """
                        Input for the collision mesh.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/collision_mesh").execute(*args, **kwargs)
                    def list_all_pair_settings(self, *args, **kwargs):
                        """
                        For each pair of collision partners, lists the collision laws and their parameters.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/list_all_pair_settings").execute(*args, **kwargs)
                    def dem_collisions(self, *args, **kwargs):
                        """
                        Enable/disable the DEM collision model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/dem_collisions").execute(*args, **kwargs)
                    def max_particle_velocity(self, *args, **kwargs):
                        """
                        Set the maximum particle velocity that may arise from collisions.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/max_particle_velocity").execute(*args, **kwargs)

                    class collision_partners(TUIMenu):
                        """
                        Manage collision partners.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list(self, *args, **kwargs):
                            """
                            Lists all known collision partners.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/list").execute(*args, **kwargs)
                        def rename(self, *args, **kwargs):
                            """
                            Rename a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/rename").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/delete").execute(*args, **kwargs)
                        def create(self, *args, **kwargs):
                            """
                            Create a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/create").execute(*args, **kwargs)
                        def copy(self, *args, **kwargs):
                            """
                            Copy a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/copy").execute(*args, **kwargs)

                class erosion_dynamic_mesh(TUIMenu):
                    """
                    Enter the erosion-dynamic mesh interactions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.run_parameters = self.__class__.run_parameters(path + ["run_parameters"], service)
                        self.general_parameters = self.__class__.general_parameters(path + ["general_parameters"], service)
                        super().__init__(path, service)
                    def enable_erosion_dynamic_mesh_coupling(self, *args, **kwargs):
                        """
                        Enable mesh deformation due to wall erosion.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/enable_erosion_dynamic_mesh_coupling").execute(*args, **kwargs)
                    def run_simulation(self, *args, **kwargs):
                        """
                        Perform coupled erosion-dynamic mesh simulation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_simulation").execute(*args, **kwargs)

                    class run_parameters(TUIMenu):
                        """
                        Enter the erosion-dynamic mesh run menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def flow_simulation_control(self, *args, **kwargs):
                            """
                            Set number of iterations per flow simulation step.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/flow_simulation_control").execute(*args, **kwargs)
                        def simulation_termination(self, *args, **kwargs):
                            """
                            Set total time of erosion.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/simulation_termination").execute(*args, **kwargs)
                        def autosave_files(self, *args, **kwargs):
                            """
                            Set the iteration increment to save data files.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_files").execute(*args, **kwargs)
                        def mesh_motion_time_step(self, *args, **kwargs):
                            """
                            Set the mesh motion time stepping parameters and method.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/mesh_motion_time_step").execute(*args, **kwargs)
                        def autosave_graphics(self, *args, **kwargs):
                            """
                            Set the iteration increment to save graphics files.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_graphics").execute(*args, **kwargs)

                    class general_parameters(TUIMenu):
                        """
                        Enter the erosion-dynamic mesh setup menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def erosion_settings(self, *args, **kwargs):
                            """
                            Set erosion modelling specific settings.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/erosion_settings").execute(*args, **kwargs)
                        def dynamic_mesh_settings(self, *args, **kwargs):
                            """
                            Perform dynamic mesh related setup.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/dynamic_mesh_settings").execute(*args, **kwargs)
                        def participating_walls(self, *args, **kwargs):
                            """
                            Specify all participating walls.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/participating_walls").execute(*args, **kwargs)

                class parallel(TUIMenu):
                    """
                    Enter the parallel menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def use_shared_memory(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to shared memory.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_shared_memory").execute(*args, **kwargs)
                    def hybrid_2domain(self, *args, **kwargs):
                        """
                        Use DPM domain to simulate particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_2domain").execute(*args, **kwargs)
                    def hybrid_workpile(self, *args, **kwargs):
                        """
                        Optimize multi-thread load balancing within each partition in hybrid-parallel DPM tracking.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_workpile").execute(*args, **kwargs)
                    def hybrid_collision_model(self, *args, **kwargs):
                        """
                        An EXPERIMENTAL feature to allow 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_model").execute(*args, **kwargs)
                    def hybrid_collision_variant(self, *args, **kwargs):
                        """
                        Further reduce the residual risk of dead-locks in the experimental feature that
                        allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_variant").execute(*args, **kwargs)
                    def enable_workpile(self, *args, **kwargs):
                        """
                        Enable/disable the particle workpile algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/enable_workpile").execute(*args, **kwargs)
                    def n_threads(self, *args, **kwargs):
                        """
                        Set the number of processors to use for DPM.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/n_threads").execute(*args, **kwargs)
                    def use_message_passing(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to message passing.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_message_passing").execute(*args, **kwargs)
                    def use_hybrid(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to hybrid.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_hybrid").execute(*args, **kwargs)
                    def report(self, *args, **kwargs):
                        """
                        Print particle workpile statistics.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/report").execute(*args, **kwargs)
                    def hybrid_collision_unidirectional(self, *args, **kwargs):
                        """
                        A faster, yet potentially somewhat less accurate, modification to the beta feature
                        that allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_unidirectional").execute(*args, **kwargs)
                    def fix_source_term_accumulation_order(self, *args, **kwargs):
                        """
                        Enforce deterministic order of source term accumulation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/fix_source_term_accumulation_order").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the menu to set expert DPM parallel options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def partition_method_hybrid_2domain(self, *args, **kwargs):
                            """
                            Set DPM Domain partition method.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/parallel/expert/partition_method_hybrid_2domain").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    Enter the options menu to set optional DPM models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ensemble_average(self, *args, **kwargs):
                        """
                        Set ensemble average cloud properties.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/ensemble_average").execute(*args, **kwargs)
                    def convective_film_heat_transfer(self, *args, **kwargs):
                        """
                        Enable/disable convection/conduction film to wall heat transfer model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/convective_film_heat_transfer").execute(*args, **kwargs)
                    def include_lwf_particles_in_dpm_concentration(self, *args, **kwargs):
                        """
                        Include LWF particle mass in DPM Concentration.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/include_lwf_particles_in_dpm_concentration").execute(*args, **kwargs)
                    def track_in_absolute_frame(self, *args, **kwargs):
                        """
                        Enable/disable tracking in absolute frame.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/track_in_absolute_frame").execute(*args, **kwargs)
                    def use_absolute_pressure_for_vaporization(self, *args, **kwargs):
                        """
                        Enable/disable using Absolute Pressure for Vaporization.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/use_absolute_pressure_for_vaporization").execute(*args, **kwargs)
                    def vaporization_options(self, *args, **kwargs):
                        """
                        Set Vaporization options.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/vaporization_options").execute(*args, **kwargs)
                    def remove_wall_film_temperature_limiter(self, *args, **kwargs):
                        """
                        Remove the wall film temperature limiter.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/remove_wall_film_temperature_limiter").execute(*args, **kwargs)
                    def allow_supercritical_pressure_vaporization(self, *args, **kwargs):
                        """
                        Skip the pressure dependent boiling point calculation to allow supercritical pressure conditions for vaporization.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/allow_supercritical_pressure_vaporization").execute(*args, **kwargs)
                    def pressure_gradient_force(self, *args, **kwargs):
                        """
                        Enable/disable pressure gradient force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/pressure_gradient_force").execute(*args, **kwargs)
                    def staggering_factor(self, *args, **kwargs):
                        """
                        Set the staggering factor between 0 and 1 to control the amount of staggering.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/staggering_factor").execute(*args, **kwargs)
                    def stagger_radius(self, *args, **kwargs):
                        """
                        Provide a stagger radius for non atomizer injections.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_radius").execute(*args, **kwargs)
                    def saffman_lift_force(self, *args, **kwargs):
                        """
                        Enable/disable Saffman lift force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/saffman_lift_force").execute(*args, **kwargs)
                    def maximum_udf_species(self, *args, **kwargs):
                        """
                        Maximum number of species that can interact with particles in the DPM UDFs.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/maximum_udf_species").execute(*args, **kwargs)
                    def scr_urea_deposition_risk_analysis(self, *args, **kwargs):
                        """
                        Options to activate and configure the SCR urea deposition risk analysis.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/scr_urea_deposition_risk_analysis").execute(*args, **kwargs)
                    def virtual_mass_force(self, *args, **kwargs):
                        """
                        Enable/disable virtual mass force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/virtual_mass_force").execute(*args, **kwargs)
                    def enable_contour_plots(self, *args, **kwargs):
                        """
                        Enable contour and vector plots of particle data.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/enable_contour_plots").execute(*args, **kwargs)
                    def set_minimum_particle_diameter(self, *args, **kwargs):
                        """
                        Set the minimum particle diameter.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/set_minimum_particle_diameter").execute(*args, **kwargs)
                    def stagger_temporally(self, *args, **kwargs):
                        """
                        Stagger transient parcels for their first time step?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_temporally").execute(*args, **kwargs)
                    def erosion_accretion(self, *args, **kwargs):
                        """
                        Enable/disable erosion/accretion.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/erosion_accretion").execute(*args, **kwargs)
                    def stagger_spatially_standard_injections(self, *args, **kwargs):
                        """
                        Spatially stagger non-atomizer injections?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_spatially_standard_injections").execute(*args, **kwargs)
                    def uniform_mass_distribution_for_injections(self, *args, **kwargs):
                        """
                        A uniform mass distribution will be enabled for all solid cone and atomizer injections.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/uniform_mass_distribution_for_injections").execute(*args, **kwargs)
                    def init_erosion_accretion_rate(self, *args, **kwargs):
                        """
                        Initialize erosion/accretion rates with Zero.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/init_erosion_accretion_rate").execute(*args, **kwargs)
                    def vaporization_heat_transfer_averaging(self, *args, **kwargs):
                        """
                        Enable/disable correction for Vaporization heat transfer.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/vaporization_heat_transfer_averaging").execute(*args, **kwargs)
                    def step_report_sig_figures(self, *args, **kwargs):
                        """
                        Set significant figures in the step-by-step report.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/step_report_sig_figures").execute(*args, **kwargs)
                    def set_thermolysis_limit(self, *args, **kwargs):
                        """
                        Set the thermolysis limit.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/set_thermolysis_limit").execute(*args, **kwargs)
                    def lowest_volatiles_mass_fraction(self, *args, **kwargs):
                        """
                        Set the lowest volatiles mass fraction.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/lowest_volatiles_mass_fraction").execute(*args, **kwargs)
                    def treat_multicomponent_saturation_temperature_failure(self, *args, **kwargs):
                        """
                        Dump multicomponent particle mass if the saturation temperature cannot be determined.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/treat_multicomponent_saturation_temperature_failure").execute(*args, **kwargs)
                    def stagger_spatially_atomizer_injections(self, *args, **kwargs):
                        """
                        Spatially stagger atomizer injections?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_spatially_atomizer_injections").execute(*args, **kwargs)
                    def current_positions_in_sample_file_format(self, *args, **kwargs):
                        """
                        Write the current positions (step-by-step history report for unsteady tracking) in the sampling file format.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/current_positions_in_sample_file_format").execute(*args, **kwargs)
                    def thermophoretic_force(self, *args, **kwargs):
                        """
                        Enable/disable thermophoretic force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/thermophoretic_force").execute(*args, **kwargs)
                    def brownian_motion(self, *args, **kwargs):
                        """
                        Enable/disable Brownian motion of particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/brownian_motion").execute(*args, **kwargs)
                    def two_way_coupling(self, *args, **kwargs):
                        """
                        Enable/disable calculation of DPM sources in TKE equation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/two_way_coupling").execute(*args, **kwargs)
                    def particle_radiation(self, *args, **kwargs):
                        """
                        Enable/disable particle radiation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/particle_radiation").execute(*args, **kwargs)

                class interaction(TUIMenu):
                    """
                    Enter the interaction menu to set parameters for coupled discrete phase calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def replace_dpm_mass_source_by_mixture_fraction(self, *args, **kwargs):
                        """
                        Recalculate the mixture fraction source terms as function of the primary mixture fraction?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/replace_dpm_mass_source_by_mixture_fraction").execute(*args, **kwargs)
                    def enable_flow_blocking_by_particles(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_flow_blocking_by_particles").execute(*args, **kwargs)
                    def linear_growth_of_dpm_source_term(self, *args, **kwargs):
                        """
                        Enable/disable the linear growth of DPM source terms every DPM iteration.
                        .
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linear_growth_of_dpm_source_term").execute(*args, **kwargs)
                    def linearized_dpm_source_terms_limiter(self, *args, **kwargs):
                        """
                        Relative limit for DPM source linear coefficient with respect to fluid linear Ap coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_source_terms_limiter").execute(*args, **kwargs)
                    def linearized_dpm_species_source_terms(self, *args, **kwargs):
                        """
                        Perform linearization of species source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_species_source_terms").execute(*args, **kwargs)
                    def ddpm_enhanced_inter_phase_exchange(self, *args, **kwargs):
                        """
                        Enhanced Eulerian inter-phase exchange.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_enhanced_inter_phase_exchange").execute(*args, **kwargs)
                    def underrelaxation_factor(self, *args, **kwargs):
                        """
                        Set the under-relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/underrelaxation_factor").execute(*args, **kwargs)
                    def enable_drag_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM drag coefficient due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_drag_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def choice_of_eulerian_phase_for_interaction(self, *args, **kwargs):
                        """
                        Enable/disable the option to choose for every injection the Eulerian phase for the DPM continuous phase interaction.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/choice_of_eulerian_phase_for_interaction").execute(*args, **kwargs)
                    def implicit_source_term_coupling(self, *args, **kwargs):
                        """
                        Enable/disable implicit treatment for all DPM source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/implicit_source_term_coupling").execute(*args, **kwargs)
                    def reset_sources_at_timestep(self, *args, **kwargs):
                        """
                        Enable/disable flush of DPM source terms at beginning of every time step.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/reset_sources_at_timestep").execute(*args, **kwargs)
                    def linearized_dpm_mixture_fraction_source_terms(self, *args, **kwargs):
                        """
                        Perform a linearization of mixture fraction source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_mixture_fraction_source_terms").execute(*args, **kwargs)
                    def implicit_momentum_coupling(self, *args, **kwargs):
                        """
                        Enable/disable implicit treatment for the DPM momentum source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/implicit_momentum_coupling").execute(*args, **kwargs)
                    def enable_source_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM source terms due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_source_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def min_vf_threshold_for_dpm_src_scaling(self, *args, **kwargs):
                        """
                        Minimum DPM volume fraction below which no DPM source scaling is applied.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/min_vf_threshold_for_dpm_src_scaling").execute(*args, **kwargs)
                    def dpm_iteration_interval(self, *args, **kwargs):
                        """
                        Set the number of continuous phase iterations per DPM iteration.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/dpm_iteration_interval").execute(*args, **kwargs)
                    def ddpm_iad_particle(self, *args, **kwargs):
                        """
                        Enable/disable the non-default interfacial area method IA-particle.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_iad_particle").execute(*args, **kwargs)
                    def linearized_dpm_source_terms(self, *args, **kwargs):
                        """
                        Perform a linearization of all DPM source terms to increase numerical robustness.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_source_terms").execute(*args, **kwargs)
                    def update_dpm_sources_every_flow_iteration(self, *args, **kwargs):
                        """
                        Enable/disable the update of DPM source terms every flow iteration.
                        (if not, the terms will be updated every DPM iteration).
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/update_dpm_sources_every_flow_iteration").execute(*args, **kwargs)
                    def coupled_calculations(self, *args, **kwargs):
                        """
                        Enable/disable coupling of continuous and discrete phase calculations.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/coupled_calculations").execute(*args, **kwargs)
                    def max_vf_allowed_for_blocking(self, *args, **kwargs):
                        """
                        Maximum DPM volume fraction used in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/max_vf_allowed_for_blocking").execute(*args, **kwargs)
                    def ddpm_energy_coupling_via_source_term(self, *args, **kwargs):
                        """
                        Energy coupling in DDPM established via source term.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_energy_coupling_via_source_term").execute(*args, **kwargs)
                    def keep_linearized_dpm_source_terms_constant(self, *args, **kwargs):
                        """
                        Keep linearized DPM source terms constant until the next DPM Update.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/keep_linearized_dpm_source_terms_constant").execute(*args, **kwargs)

            class solver(TUIMenu):
                """
                Enter the menu to select the solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def density_based_explicit(self, *args, **kwargs):
                    """
                    Enable/disable the coupled-explicit solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/density_based_explicit").execute(*args, **kwargs)
                def adjust_solver_defaults_based_on_setup(self, *args, **kwargs):
                    """
                    Enable/disable adjustment of solver defaults based on setup.
                    """
                    return PyMenu(self.service, "/setup/models/solver/adjust_solver_defaults_based_on_setup").execute(*args, **kwargs)
                def density_based_implicit(self, *args, **kwargs):
                    """
                    Enable/disable the coupled-implicit solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/density_based_implicit").execute(*args, **kwargs)
                def pressure_based(self, *args, **kwargs):
                    """
                    Enable/disable the segregated solver.
                    """
                    return PyMenu(self.service, "/setup/models/solver/pressure_based").execute(*args, **kwargs)

            class species(TUIMenu):
                """
                Enter the species models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.CHEMKIN_CFD_parameters = self.__class__.CHEMKIN_CFD_parameters(path + ["CHEMKIN_CFD_parameters"], service)
                    super().__init__(path, service)
                def liquid_micro_mixing(self, *args, **kwargs):
                    """
                    Enable/disable liquid micro mixing option.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_micro_mixing").execute(*args, **kwargs)
                def non_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the non-premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion").execute(*args, **kwargs)
                def species_transport(self, *args, **kwargs):
                    """
                    Enable/disable the species transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport").execute(*args, **kwargs)
                def partially_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_expert").execute(*args, **kwargs)
                def species_migration(self, *args, **kwargs):
                    """
                    Enable/disable ion species migration in electric field.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_migration").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable solution of species models.
                    """
                    return PyMenu(self.service, "/setup/models/species/off").execute(*args, **kwargs)
                def init_unsteady_flamelet_prob(self, *args, **kwargs):
                    """
                    Initialize Unsteady Flamelet Probability.
                    """
                    return PyMenu(self.service, "/setup/models/species/init_unsteady_flamelet_prob").execute(*args, **kwargs)
                def coal_calculator(self, *args, **kwargs):
                    """
                    Set up coal modeling inputs.
                    """
                    return PyMenu(self.service, "/setup/models/species/coal_calculator").execute(*args, **kwargs)
                def ignition_model(self, *args, **kwargs):
                    """
                    Enable/disable the ignition model.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model").execute(*args, **kwargs)
                def clear_isat_table(self, *args, **kwargs):
                    """
                    Clear the ISAT table.
                    """
                    return PyMenu(self.service, "/setup/models/species/clear_isat_table").execute(*args, **kwargs)
                def partially_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable partially premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion").execute(*args, **kwargs)
                def combustion_numerics(self, *args, **kwargs):
                    """
                    Set combustion numerics options.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_numerics").execute(*args, **kwargs)
                def reacting_channel_model(self, *args, **kwargs):
                    """
                    Enable/Disable the Reacting Channel Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model").execute(*args, **kwargs)
                def set_turb_chem_interaction(self, *args, **kwargs):
                    """
                    Set Eddy-Dissipation Concept model constants.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_turb_chem_interaction").execute(*args, **kwargs)
                def mixing_model(self, *args, **kwargs):
                    """
                    Set PDF transport mixing model.
                    """
                    return PyMenu(self.service, "/setup/models/species/mixing_model").execute(*args, **kwargs)
                def electro_chemical_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable electrochemical surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/electro_chemical_surface_reactions").execute(*args, **kwargs)
                def species_transport_expert(self, *args, **kwargs):
                    """
                    Set species transport expert options.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport_expert").execute(*args, **kwargs)
                def set_multi_regime_fgm(self, *args, **kwargs):
                    """
                    Set-multi-regim-fgm-parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_multi_regime_fgm").execute(*args, **kwargs)
                def relax_to_equil(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/relax_to_equil").execute(*args, **kwargs)
                def reacting_channel_model_options(self, *args, **kwargs):
                    """
                    Set Reacting Channel Model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model_options").execute(*args, **kwargs)
                def epdf_energy(self, *args, **kwargs):
                    """
                    Enable/disable EPDF energy  option.
                    """
                    return PyMenu(self.service, "/setup/models/species/epdf_energy").execute(*args, **kwargs)
                def premixed_model(self, *args, **kwargs):
                    """
                    Set premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_model").execute(*args, **kwargs)
                def set_premixed_combustion(self, *args, **kwargs):
                    """
                    Set premixed combustion parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_premixed_combustion").execute(*args, **kwargs)
                def pdf_transport(self, *args, **kwargs):
                    """
                    Enable/disable the composition PDF transport combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport").execute(*args, **kwargs)
                def multicomponent_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable multicomponent diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/multicomponent_diffusion").execute(*args, **kwargs)
                def surf_reaction_netm_params(self, *args, **kwargs):
                    """
                    Set the surface reaction parameters for the Non-Equilibrium Thermal Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_netm_params").execute(*args, **kwargs)
                def inert_transport_controls(self, *args, **kwargs):
                    """
                    Set inert transport model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_controls").execute(*args, **kwargs)
                def full_tabulation(self, *args, **kwargs):
                    """
                    Enable/disable building of a full 2 mixture fraction table.
                    """
                    return PyMenu(self.service, "/setup/models/species/full_tabulation").execute(*args, **kwargs)
                def wall_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable wall surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/wall_surface_reactions").execute(*args, **kwargs)
                def ignition_model_controls(self, *args, **kwargs):
                    """
                    Set ignition model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model_controls").execute(*args, **kwargs)
                def combustion_expert(self, *args, **kwargs):
                    """
                    Set combustion expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_expert").execute(*args, **kwargs)
                def pdf_transport_expert(self, *args, **kwargs):
                    """
                    Enable/disable PDF transport expert user.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport_expert").execute(*args, **kwargs)
                def spark_model(self, *args, **kwargs):
                    """
                    Set spark model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/spark_model").execute(*args, **kwargs)
                def flamelet_expert(self, *args, **kwargs):
                    """
                    Set flamelet expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/flamelet_expert").execute(*args, **kwargs)
                def liquid_energy_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable energy diffusion for liquid regime.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_energy_diffusion").execute(*args, **kwargs)
                def save_gradients(self, *args, **kwargs):
                    """
                    Enable/disable storage of species mass fraction gradients.
                    """
                    return PyMenu(self.service, "/setup/models/species/save_gradients").execute(*args, **kwargs)
                def thermal_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable thermal diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/thermal_diffusion").execute(*args, **kwargs)
                def thickened_flame_model(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/thickened_flame_model").execute(*args, **kwargs)
                def stiff_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable stiff chemistry option.
                    """
                    return PyMenu(self.service, "/setup/models/species/stiff_chemistry").execute(*args, **kwargs)
                def partially_premixed_combustion_grids(self, *args, **kwargs):
                    """
                    Set user specified grid parameters for PDF and flamelet.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_grids").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/species/inlet_diffusion").execute(*args, **kwargs)
                def non_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_parameters").execute(*args, **kwargs)
                def mass_deposition_source(self, *args, **kwargs):
                    """
                    Enable/disable mass deposition source due to surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/mass_deposition_source").execute(*args, **kwargs)
                def reaction_diffusion_balance(self, *args, **kwargs):
                    """
                    Enable/disable reaction diffusion balance at reacting surface for surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/reaction_diffusion_balance").execute(*args, **kwargs)
                def partially_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_parameters").execute(*args, **kwargs)
                def integration_parameters(self, *args, **kwargs):
                    """
                    Set ISAT parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/integration_parameters").execute(*args, **kwargs)
                def partially_premixed_properties(self, *args, **kwargs):
                    """
                    Set/Change partially premixed mixture properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_properties").execute(*args, **kwargs)
                def import_flamelet_for_restart(self, *args, **kwargs):
                    """
                    Import Flamelet File for Restart.
                    """
                    return PyMenu(self.service, "/setup/models/species/import_flamelet_for_restart").execute(*args, **kwargs)
                def inert_transport_model(self, *args, **kwargs):
                    """
                    Enable/disable the inert transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_model").execute(*args, **kwargs)
                def reactor_network_model(self, *args, **kwargs):
                    """
                    Enable/disable the Reactor Network model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reactor_network_model").execute(*args, **kwargs)
                def CHEMKIN_CFD(self, *args, **kwargs):
                    """
                    Enable/disable CHEMKIN-CFD.
                    """
                    return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD").execute(*args, **kwargs)
                def non_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_expert").execute(*args, **kwargs)
                def diffusion_energy_source(self, *args, **kwargs):
                    """
                    Enable/disable diffusion energy source.
                    """
                    return PyMenu(self.service, "/setup/models/species/diffusion_energy_source").execute(*args, **kwargs)
                def volumetric_reactions(self, *args, **kwargs):
                    """
                    Enable/disable volumetric reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/volumetric_reactions").execute(*args, **kwargs)
                def particle_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable particle surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/particle_surface_reactions").execute(*args, **kwargs)
                def surf_reaction_aggressiveness_factor(self, *args, **kwargs):
                    """
                    Set the surface reaction aggressiveness factor.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_aggressiveness_factor").execute(*args, **kwargs)
                def premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_combustion").execute(*args, **kwargs)
                def decoupled_detailed_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable the Decoupled Detailed Chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/species/decoupled_detailed_chemistry").execute(*args, **kwargs)
                def heat_of_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable heat of surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/heat_of_surface_reactions").execute(*args, **kwargs)
                def re_calc_par_premix_props(self, *args, **kwargs):
                    """
                    Re-calculate partially-premixed properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/re_calc_par_premix_props").execute(*args, **kwargs)

                class CHEMKIN_CFD_parameters(TUIMenu):
                    """
                    Enter the expert CHEMKIN-CFD parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_cell_monitors(self, *args, **kwargs):
                        """
                        List cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/list_cell_monitors").execute(*args, **kwargs)
                    def advanced_options(self, *args, **kwargs):
                        """
                        Set advanced parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/advanced_options").execute(*args, **kwargs)
                    def basic_options(self, *args, **kwargs):
                        """
                        Set basic parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/basic_options").execute(*args, **kwargs)
                    def add_cell_monitor(self, *args, **kwargs):
                        """
                        Add a monitor cell for debug output.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/add_cell_monitor").execute(*args, **kwargs)
                    def delete_cell_monitors(self, *args, **kwargs):
                        """
                        Delete cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/delete_cell_monitors").execute(*args, **kwargs)

            class shell_conduction(TUIMenu):
                """
                Enter the shell conduction model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def settings(self, *args, **kwargs):
                    """
                    Enter Multi-layer Shell Conduction data.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/settings").execute(*args, **kwargs)
                def enhanced_encapsulation(self, *args, **kwargs):
                    """
                    Enable/disable enhanced encapsulation for shell conduction and S2S models. This is not applicable if coupled sliding interface walls exists.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/enhanced_encapsulation").execute(*args, **kwargs)
                def write_csv(self, *args, **kwargs):
                    """
                    Write shell conduction settings to a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/write_csv").execute(*args, **kwargs)
                def read_csv(self, *args, **kwargs):
                    """
                    Read shell conduction settings from a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/read_csv").execute(*args, **kwargs)
                def save_shell_zones(self, *args, **kwargs):
                    """
                    Enable/Disable saving shell zones to case file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/save_shell_zones").execute(*args, **kwargs)
                def multi_layer_shell(self, *args, **kwargs):
                    """
                    Enable/disable multi layer shell conduction model.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/multi_layer_shell").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Define multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Body force formulation.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/body_force_formulation").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Regime-transition-modeling-options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Interface Modeling Options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specify multiphase model.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/model").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Mixture parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/mixture_parameters").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    VOF sub-models.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/vof_sub_models").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specify the number of phases.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/number_of_phases").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Coupled level set.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/coupled_level_set").execute(*args, **kwargs)

                class explicit_expert_options(TUIMenu):
                    """
                    Expert options for explicit formulation.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.volume_fraction_filtering = self.__class__.volume_fraction_filtering(path + ["volume_fraction_filtering"], service)
                        super().__init__(path, service)
                    def solve_vof_every_iter(self, *args, **kwargs):
                        """
                        Solve volume fraction equation every iteration for explicit formulation.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/solve_vof_every_iter").execute(*args, **kwargs)
                    def sub_time_step_method(self, *args, **kwargs):
                        """
                        Select sub-time step method for the time integration in explicit formulation.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/sub_time_step_method").execute(*args, **kwargs)

                    class volume_fraction_filtering(TUIMenu):
                        """
                        Advanced volume fraction filtering controls for explicit formulation.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def filtering_options(self, *args, **kwargs):
                            """
                            Select volume fraction filtering method.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/filtering_options").execute(*args, **kwargs)
                        def vol_frac_cutoff(self, *args, **kwargs):
                            """
                            Enter node-averaged volume fraction cutoff.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/vol_frac_cutoff").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enable volume fraction filtering treatment.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/explicit_expert_options/volume_fraction_filtering/enable").execute(*args, **kwargs)

                class flow_regime_modeling(TUIMenu):
                    """
                    Flow Regime Modeling.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.aiad_parameters = self.__class__.aiad_parameters(path + ["aiad_parameters"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable flow regime modeling framework including phase state and morphology.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/enable").execute(*args, **kwargs)

                    class aiad_parameters(TUIMenu):
                        """
                        AIAD parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delta_vf(self, *args, **kwargs):
                            """
                            Parameter for transition width for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/delta_vf").execute(*args, **kwargs)
                        def critical_vf(self, *args, **kwargs):
                            """
                            Critical volume fraction for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/critical_vf").execute(*args, **kwargs)
                        def ncells_fs(self, *args, **kwargs):
                            """
                            Parameter for determining interfacial width.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/ncells_fs").execute(*args, **kwargs)
                        def delta_grad(self, *args, **kwargs):
                            """
                            Parameter for determining transition width for free surface blending factor.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/delta_grad").execute(*args, **kwargs)

                class population_balance(TUIMenu):
                    """
                    Enter the population balance model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        self.phenomena = self.__class__.phenomena(path + ["phenomena"], service)
                        super().__init__(path, service)
                    def include_expansion(self, *args, **kwargs):
                        """
                        Set expansion.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/include_expansion").execute(*args, **kwargs)
                    def model(self, *args, **kwargs):
                        """
                        Select the population balance model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/model").execute(*args, **kwargs)
                    def size_calculator(self, *args, **kwargs):
                        """
                        Calculate fluid particle diameters using different methods.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/size_calculator").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the expert menu for quadrature-based population balance method.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.qmom = self.__class__.qmom(path + ["qmom"], service)
                            super().__init__(path, service)

                        class qmom(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def realizable_moments(self, *args, **kwargs):
                                """
                                Set the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/realizable_moments").execute(*args, **kwargs)
                            def inversion_algorithm(self, *args, **kwargs):
                                """
                                Select the inversion algorithm for quadrature-based population balance method.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/inversion_algorithm").execute(*args, **kwargs)
                            def print_realizable_moment_warning(self, *args, **kwargs):
                                """
                                Print the information for realizable moments in the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/print_realizable_moment_warning").execute(*args, **kwargs)
                            def retain_qmom_sources_for_low_vof(self, *args, **kwargs):
                                """
                                Retain qmom source calculation for low secondary phase vof.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/retain_qmom_sources_for_low_vof").execute(*args, **kwargs)

                    class phenomena(TUIMenu):
                        """
                        Enter the phenomena menu for population balance.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def breakage_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_factor").execute(*args, **kwargs)
                        def breakage_aggregation_vof_cutoff(self, *args, **kwargs):
                            """
                            Control vof cut-off for breakage and aggregation.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_aggregation_vof_cutoff").execute(*args, **kwargs)
                        def aggregation(self, *args, **kwargs):
                            """
                            Set the aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation").execute(*args, **kwargs)
                        def nucleation(self, *args, **kwargs):
                            """
                            Set the nucleantion rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/nucleation").execute(*args, **kwargs)
                        def breakage(self, *args, **kwargs):
                            """
                            Set the breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage").execute(*args, **kwargs)
                        def aggregation_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation_factor").execute(*args, **kwargs)
                        def growth(self, *args, **kwargs):
                            """
                            Set the growth rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/growth").execute(*args, **kwargs)

                class hybrid_models(TUIMenu):
                    """
                    Enter the menu to select hybrid models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ddpm(self, *args, **kwargs):
                        """
                        Enable the dense discrete phase model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/hybrid_models/ddpm").execute(*args, **kwargs)
                    def multi_fluid_vof(self, *args, **kwargs):
                        """
                        Enable the multi-fluid VOF model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/hybrid_models/multi_fluid_vof").execute(*args, **kwargs)

                class sub_models(TUIMenu):
                    """
                    Enter the menu to select sub-models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling_options = self.__class__.boiling_options(path + ["boiling_options"], service)
                        super().__init__(path, service)
                    def boiling(self, *args, **kwargs):
                        """
                        Activate boiling model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling").execute(*args, **kwargs)

                    class boiling_options(TUIMenu):
                        """
                        Set boiling options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def nlbf_model(self, *args, **kwargs):
                            """
                            Set the non-local boundary field correction.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling_options/nlbf_model").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Choose the type of boiling model.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/sub_models/boiling_options/options").execute(*args, **kwargs)

                class wet_steam(TUIMenu):
                    """
                    Enter the wet steam model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set = self.__class__.set(path + ["set"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable/disable the wet steam model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/enable").execute(*args, **kwargs)
                    def load_unload_user_defined_wetsteam_library(self, *args, **kwargs):
                        """
                        Load or unload user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/load_unload_user_defined_wetsteam_library").execute(*args, **kwargs)
                    def compile_user_defined_wetsteam_functions(self, *args, **kwargs):
                        """
                        Compile user-defined wet steam library.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/wet_steam/compile_user_defined_wetsteam_functions").execute(*args, **kwargs)

                    class set(TUIMenu):
                        """
                        Enter the set menu for setting wet steam model options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def stagnation_conditions(self, *args, **kwargs):
                            """
                            If the gas phase is selected, zero wetness is assumed when evaluating total or static values of pressure and temperature.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/stagnation_conditions").execute(*args, **kwargs)
                        def rgp_tables(self, *args, **kwargs):
                            """
                            Select which properties to use: build-in or from RGP tables.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/rgp_tables").execute(*args, **kwargs)
                        def virial_equation(self, *args, **kwargs):
                            """
                            Select the formulation of the virial equation of state and associated equations for thermodynamic properties of steam.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/virial_equation").execute(*args, **kwargs)
                        def zonal_phase_change(self, *args, **kwargs):
                            """
                            Select cell zones where phase change process is active.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/zonal_phase_change").execute(*args, **kwargs)
                        def max_liquid_mass_fraction(self, *args, **kwargs):
                            """
                            Set the maximum limit on the condensed liquid-phase mass-fraction to prevent divergence.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/max_liquid_mass_fraction").execute(*args, **kwargs)
                        def droplet_growth_rate(self, *args, **kwargs):
                            """
                            Select the formula to model the droplet growth rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/wet_steam/set/droplet_growth_rate").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        super().__init__(path, service)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                super().__init__(path, service)

                            class interfacial_area(TUIMenu):
                                """
                                Enter the menu to set interfacial area models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    super().__init__(path, service)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/lift").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/surface_tension/vmass_coeff").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/slope_limiter").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/vmass_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/lift/jump_adhesion").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interphase_discretization/vmass_implicit").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/virtual_mass/lift_montoya").execute(*args, **kwargs)

                            class model_transition(TUIMenu):
                                """
                                Enter the menu to set model transition mechanisms.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    super().__init__(path, service)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interfacial_area").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/model_transition").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/drag").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/mass_transfer").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulence_interaction").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/reactions").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/restitution").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/turbulent_dispersion").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/wall_lubrication").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/heat_coeff").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/slip_velocity").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/surface_tension/slope_limiter").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/virtual_mass/virtual_mass").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/virtual_mass").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/interphase_discr").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/cavitation").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/lift/slope_limiter").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/interphase_discretization/sfc_modeling").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/model_transition/cavitation/slope_limiter").execute(*args, **kwargs)

                            class heat_mass_reactions(TUIMenu):
                                """
                                Enter the menu to set heat, mass-transfer, or reaction related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    super().__init__(path, service)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/mass_transfer").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/wall_lubrication").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/restitution").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulence_interaction").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/reactions").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/drag").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/turbulent_dispersion").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/model_transition").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interfacial_area").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/heat_coeff").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/slip_velocity").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/virtual_mass/sfc_modeling").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/cavitation/sfc_modeling").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/jump_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/lift").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/interphase_discr").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/vmass_implicit").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/sfc_modeling").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/lift/cavitation").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/cavitation").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/surface_tension/lift_montoya").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/heat_mass_reactions/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)

                            class forces(TUIMenu):
                                """
                                Enter the menu to set interfacial forces related models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    super().__init__(path, service)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/slip_velocity").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/restitution").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulence_interaction").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/heat_coeff").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/wall_lubrication").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/turbulent_dispersion").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/reactions").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interfacial_area").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/mass_transfer").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/model_transition").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/drag").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/lift").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/surface_tension/visc_disp_factor").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/virtual_mass/lift_montoya").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/virtual_mass").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/interphase_discretization/lift_montoya").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_coeff").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/slope_limiter").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift_montoya").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/sfc_model_type").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/jump_adhesion").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/wall_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/virtual_mass").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/lift/lift").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/cavitation").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/forces/cavitation/interphase_discr").execute(*args, **kwargs)

                            class numerics(TUIMenu):
                                """
                                Enter the menu to set numerics models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    super().__init__(path, service)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulence_interaction").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/turbulent_dispersion").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/reactions").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/slip_velocity").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/mass_transfer").execute(*args, **kwargs)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/wall_lubrication").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/drag").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/restitution").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interfacial_area").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/heat_coeff").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/model_transition").execute(*args, **kwargs)

                                class virtual_mass(TUIMenu):
                                    """
                                    Enter the menu to set virtual mass models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit_options").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/visc_disp_factor").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_tension_coeff").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/jump_adhesion").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/virtual_mass").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_implicit").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_discr").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/cavitation").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_montoya").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/vmass_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/interphase_visc_disp").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/virtual_mass/sfc_model_type").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_discr").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift_montoya").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/virtual_mass").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_coeff").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/cavitation").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/lift").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/jump_adhesion").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/cavitation/sfc_model_type").execute(*args, **kwargs)

                                class lift(TUIMenu):
                                    """
                                    Enter the menu to set lift models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/cavitation").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_coeff").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_visc_disp").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/jump_adhesion").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit_options").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_shaver_podowski").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/lift_montoya").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/visc_disp_factor").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/interphase_discr").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_modeling").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/vmass_implicit").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/virtual_mass").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/sfc_model_type").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/lift/slope_limiter").execute(*args, **kwargs)

                                class interphase_viscous_dissipation(TUIMenu):
                                    """
                                    Enter the menu to set interphase viscous dissipation related models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/jump_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/vmass_implicit_options").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/cavitation").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/virtual_mass").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift_montoya").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/slope_limiter").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/wall_adhesion").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/lift").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/sfc_modeling").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_viscous_dissipation/interphase_visc_disp").execute(*args, **kwargs)

                                class interphase_discretization(TUIMenu):
                                    """
                                    Enter the menu to set interphase discretization models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_tension_coeff").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_model_type").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_shaver_podowski").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/sfc_modeling").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/jump_adhesion").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_discr").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/slope_limiter").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/visc_disp_factor").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift_montoya").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/lift").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_coeff").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/vmass_implicit_options").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/interphase_discretization/virtual_mass").execute(*args, **kwargs)

                                class surface_tension(TUIMenu):
                                    """
                                    Enter the menu to set surface tension models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_coeff(self, *args, **kwargs):
                                        """
                                        Specify the virtual mass coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_coeff").execute(*args, **kwargs)
                                    def virtual_mass(self, *args, **kwargs):
                                        """
                                        Include the virtual mass force that is present when a secondary phase accelerates relative to the primary phase?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/virtual_mass").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_modeling").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_model_type").execute(*args, **kwargs)
                                    def sfc_tension_coeff(self, *args, **kwargs):
                                        """
                                        Specify the surface tension coefficient for each pair of phases.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/sfc_tension_coeff").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the treatment of the contact angle specification at the porous jump boundary?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/jump_adhesion").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_shaver_podowski").execute(*args, **kwargs)
                                    def lift_montoya(self, *args, **kwargs):
                                        """
                                        Include the Montoya correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/lift_montoya").execute(*args, **kwargs)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/wall_adhesion").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit_options").execute(*args, **kwargs)
                                    def interphase_discr(self, *args, **kwargs):
                                        """
                                        Enable the phase localized compressive discretization scheme where the degree of diffusion/sharpness is controlled through the value of the slope limiters?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/interphase_discr").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/visc_disp_factor").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/cavitation").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/numerics/surface_tension/vmass_implicit").execute(*args, **kwargs)

                    class iac_expert(TUIMenu):
                        """
                        Enter the IAC expert setting menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def iac_pseudo_time_step(self, *args, **kwargs):
                            """
                            Set iac pseudo-time.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/iac_pseudo_time_step").execute(*args, **kwargs)
                        def ishii_kim_model(self, *args, **kwargs):
                            """
                            Set ik model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/ishii_kim_model").execute(*args, **kwargs)
                        def hibiki_ishii_model(self, *args, **kwargs):
                            """
                            Set hi model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/hibiki_ishii_model").execute(*args, **kwargs)
                        def yao_morel_model(self, *args, **kwargs):
                            """
                            Set ym model coefficients.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/iac_expert/yao_morel_model").execute(*args, **kwargs)

    class turbo_workflow(TUIMenu):
        """
        Enter the turbo workflow menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.workflow = self.__class__.workflow(path + ["workflow"], service)
            super().__init__(path, service)

        class workflow(TUIMenu):
            """
            Enter the workflow menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def enable(self, *args, **kwargs):
                """
                Enable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/enable").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/disable").execute(*args, **kwargs)
            def reset(self, *args, **kwargs):
                """
                Reset the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/reset").execute(*args, **kwargs)

    class solve(TUIMenu):
        """
        Enter the solve menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.report_files = self.__class__.report_files(path + ["report_files"], service)
            self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
            self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            super().__init__(path, service)
        def patch(self, *args, **kwargs):
            """
            Patches a value for a flow variable in the domain. You can either provide a numerical value, which you can enter directly, or you can enter an expression, which must be entered within quotation marks.
            """
            return PyMenu(self.service, "/solve/patch").execute(*args, **kwargs)
        def update_physical_time(self, *args, **kwargs):
            """
            Advances the unsteady solution to the next physical time level. Using this command in conjunction with theiterate command allows you to manually advance the solution in time (rather than doing it automatically with the dual-time-iterate command).
            """
            return PyMenu(self.service, "/solve/update_physical_time").execute(*args, **kwargs)
        def iterate(self, *args, **kwargs):
            """
            Performs a specified number of iterations.  This option is still available during transient simulations, since it can be used to add more iterations to the same time step after interrupting iterations within a time step.
            """
            return PyMenu(self.service, "/solve/iterate").execute(*args, **kwargs)
        def convergence_conditions(self, *args, **kwargs):
            """
            Enters the convergence conditions menu.
            """
            return PyMenu(self.service, "/solve/convergence_conditions").execute(*args, **kwargs)
        def dual_time_iterate(self, *args, **kwargs):
            """
            Performs unsteady iterations for a specified number of time steps.
            """
            return PyMenu(self.service, "/solve/dual_time_iterate").execute(*args, **kwargs)
        def iterate_steady_2way_fsi(self, *args, **kwargs):
            """
            Perform a specified number of steps.
            """
            return PyMenu(self.service, "/solve/iterate_steady_2way_fsi").execute(*args, **kwargs)
        def mesh_motion(self, *args, **kwargs):
            """
            Performs mesh motion.
            """
            return PyMenu(self.service, "/solve/mesh_motion").execute(*args, **kwargs)
        def dpm_update(self, *args, **kwargs):
            """
            Updates discrete phase source terms.
            """
            return PyMenu(self.service, "/solve/dpm_update").execute(*args, **kwargs)
        def multistage_time_iterate(self, *args, **kwargs):
            """
            Perform unsteady iterations.
            """
            return PyMenu(self.service, "/solve/multistage_time_iterate").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Sets solution monitors.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                super().__init__(path, service)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solve/monitors/convergence_conditions").execute(*args, **kwargs)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solve/monitors/set_average_over").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/clear_data").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/add").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list_properties").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete_all").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/edit").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/edit").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/plot").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/axes").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/add").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/curves").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enters the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def normalize(self, *args, **kwargs):
                    """
                    Chooses whether to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalize").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/print").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Sets the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_display").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Sets the number of iterations through which normalization factors will be maximized.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Sets normalization factors for currently monitored residuals (if normalize? is set to yes).
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Chooses whether to scale residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Re-normalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/re_normalize").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Chooses which currently monitored residuals should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/check_convergence").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Sets number of residuals to be saved with data. History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_save").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Sets relative convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Chooses which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/monitor").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/plot").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Sets convergence criterion type.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/criterion_type").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Enables/disables an enhanced formulation for the local scaling of the continuity residuals with the pressure-based solver, so that the absolute mass flow rate at each cell is used. This text command is only available when the computing of the local scale is enabled through the solve/monitors/residual/scale-by-coefficient? text command.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Sets convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Chooses whether to delete the residual history and reset iteration counter to 1.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/reset").execute(*args, **kwargs)

        class report_files(TUIMenu):
            """
            Enters the report files menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def edit(self, *args, **kwargs):
                """
                Edits a report file.
                """
                return PyMenu(self.service, "/solve/report_files/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report file.
                """
                return PyMenu(self.service, "/solve/report_files/list_properties").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report file objects.
                """
                return PyMenu(self.service, "/solve/report_files/delete_all").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report file object.
                """
                return PyMenu(self.service, "/solve/report_files/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report files.
                """
                return PyMenu(self.service, "/solve/report_files/list").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report file.
                """
                return PyMenu(self.service, "/solve/report_files/clear_data").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report file.
                """
                return PyMenu(self.service, "/solve/report_files/add").execute(*args, **kwargs)

        class report_plots(TUIMenu):
            """
            Enters the report plots menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def curves(self, *args, **kwargs):
                """
                Defines the curves for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/curves").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Defines the axes for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/axes").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/list_properties").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report plot objects.
                """
                return PyMenu(self.service, "/solve/report_plots/delete_all").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/edit").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report plots.
                """
                return PyMenu(self.service, "/solve/report_plots/list").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/clear_data").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report plot object.
                """
                return PyMenu(self.service, "/solve/report_plots/delete").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/add").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plots the specified report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/plot").execute(*args, **kwargs)

        class execute_commands(TUIMenu):
            """
            Enters the execute commands menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/delete").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/copy").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/enable").execute(*args, **kwargs)
            def add_edit(self, *args, **kwargs):
                """
                Adds or edits execute commands.
                """
                return PyMenu(self.service, "/solve/execute_commands/add_edit").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/disable").execute(*args, **kwargs)
            def export(self, *args, **kwargs):
                """
                Export execute-commands to a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/export").execute(*args, **kwargs)
            def import_(self, *args, **kwargs):
                """
                Import execute-commands from a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/import").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enters the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.define = self.__class__.define(path + ["define"], service)
                self.playback = self.__class__.playback(path + ["playback"], service)
                self.objects = self.__class__.objects(path + ["objects"], service)
                self.pulse = self.__class__.pulse(path + ["pulse"], service)
                super().__init__(path, service)

            class define(TUIMenu):
                """
                Enters the animation definition menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def define_monitor(self, *args, **kwargs):
                    """
                    Defines new animation.
                    """
                    return PyMenu(self.service, "/solve/animate/define/define_monitor").execute(*args, **kwargs)
                def edit_monitor(self, *args, **kwargs):
                    """
                    Changes animation monitor attributes.
                    """
                    return PyMenu(self.service, "/solve/animate/define/edit_monitor").execute(*args, **kwargs)

            class playback(TUIMenu):
                """
                Enters the animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def play(self, *args, **kwargs):
                    """
                    Plays the selected animation.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/play").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes animation sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/delete").execute(*args, **kwargs)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Specify a custom start frame, increment, and end frame for video export.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Reads new animation from file or already defined animations.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/read").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Plays the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/stored_view").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Writes animation sequence to the file.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/write").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enters the video menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Controls whether the resolution of the saved video file matches that  of the images used to create it.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/use_original_resolution").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Expands or collapses the resolution based on this scaling  factor.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/scale").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Specifies what format the video file will be written in (MP4 | AVI |  FLV | MOV | MPEG).
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/format").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Sets the target frames per second (FPS) for the saved video  file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/fps").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Sets the name of the saved video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/name").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/height").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/quality").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/width").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)

            class objects(TUIMenu):
                """
                Enters the object manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def copy(self, *args, **kwargs):
                    """
                    Copies solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/copy").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/delete").execute(*args, **kwargs)
                def clear_history(self, *args, **kwargs):
                    """
                    Clears solution animation object history.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/clear_history").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/edit").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Creates new solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/create").execute(*args, **kwargs)

            class pulse(TUIMenu):
                """
                Enter the pulse animation menu (only available when one or more particle track or pathline graphics objects are defined).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    self.hardcopy = self.__class__.hardcopy(path + ["hardcopy"], service)
                    super().__init__(path, service)
                def pulse_mode(self, *args, **kwargs):
                    """
                    Set whether the pulse is a single pulse or continuous.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/pulse_mode").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Select a pathline or particle track graphics object, specify whether you want to write a video file or picture files, and enter the destination directory for the files. Continuous pulse animations result in a 5 second video. Single pulse animations run for a full cycle.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/write").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enter the video window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/quality").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/use_original_resolution").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/fps").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/format").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/scale").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/set_standard_resolution").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/name").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/width").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/height").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate").execute(*args, **kwargs)

                class hardcopy(TUIMenu):
                    """
                    Hardcopy options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.driver = self.__class__.driver(path + ["driver"], service)
                        self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                        super().__init__(path, service)
                    def dpi(self, *args, **kwargs):
                        """
                        Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/dpi").execute(*args, **kwargs)
                    def landscape(self, *args, **kwargs):
                        """
                        Plot hardcopies in landscape or portrait orientation.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/landscape").execute(*args, **kwargs)
                    def invert_background(self, *args, **kwargs):
                        """
                        Use a white background when the picture is saved.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/invert_background").execute(*args, **kwargs)
                    def preview(self, *args, **kwargs):
                        """
                        Display a preview image of a hardcopy.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/preview").execute(*args, **kwargs)
                    def x_resolution(self, *args, **kwargs):
                        """
                        Set the width of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/x_resolution").execute(*args, **kwargs)
                    def y_resolution(self, *args, **kwargs):
                        """
                        Set the height of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/y_resolution").execute(*args, **kwargs)
                    def use_window_resolution(self, *args, **kwargs):
                        """
                        Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/use_window_resolution").execute(*args, **kwargs)
                    def jpeg_hardcopy_quality(self, *args, **kwargs):
                        """
                        To set jpeg hardcopy quality.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/jpeg_hardcopy_quality").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/set_standard_resolution").execute(*args, **kwargs)

                    class driver(TUIMenu):
                        """
                        Enter the set hardcopy driver menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.post_format = self.__class__.post_format(path + ["post_format"], service)
                            super().__init__(path, service)
                        def jpeg(self, *args, **kwargs):
                            """
                            Produce JPEG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/jpeg").execute(*args, **kwargs)
                        def dump_window(self, *args, **kwargs):
                            """
                            Set the command used to dump the graphics window to a file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/dump_window").execute(*args, **kwargs)
                        def ppm(self, *args, **kwargs):
                            """
                            Produce PPM output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/ppm").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List the current hardcopy driver.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/list").execute(*args, **kwargs)
                        def png(self, *args, **kwargs):
                            """
                            Use PNG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/png").execute(*args, **kwargs)
                        def glb(self, *args, **kwargs):
                            """
                            Use GLB output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/glb").execute(*args, **kwargs)
                        def eps(self, *args, **kwargs):
                            """
                            Produce encapsulated PostScript (EPS) output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/eps").execute(*args, **kwargs)
                        def vrml(self, *args, **kwargs):
                            """
                            Use VRML output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/vrml").execute(*args, **kwargs)
                        def hsf(self, *args, **kwargs):
                            """
                            Use HSF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/hsf").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Set the hardcopy options. Available options are:
                            "no gamma correction", disables gamma correction of colors,
                            "physical size = (width,height)", where width and height
                            are the actual measurements of the printable area of the page
                            in centimeters.
                            "subscreen = (left,right,bottom,top)", where left,right,
                            bottom, and top are numbers in [-1,1] describing a subwindow on
                            the page in which to place the hardcopy.
                            The options may be combined by separating them with commas.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/options").execute(*args, **kwargs)
                        def post_script(self, *args, **kwargs):
                            """
                            Produce PostScript output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_script").execute(*args, **kwargs)
                        def avz(self, *args, **kwargs):
                            """
                            Use AVZ output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/avz").execute(*args, **kwargs)
                        def tiff(self, *args, **kwargs):
                            """
                            Use TIFF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/tiff").execute(*args, **kwargs)

                        class post_format(TUIMenu):
                            """
                            Enter the PostScript driver format menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def vector(self, *args, **kwargs):
                                """
                                Use vector format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/vector").execute(*args, **kwargs)
                            def fast_raster(self, *args, **kwargs):
                                """
                                Use the new raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/fast_raster").execute(*args, **kwargs)
                            def raster(self, *args, **kwargs):
                                """
                                Use the original raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/raster").execute(*args, **kwargs)
                            def rle_raster(self, *args, **kwargs):
                                """
                                Use the run-length encoded raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/rle_raster").execute(*args, **kwargs)

                    class color_mode(TUIMenu):
                        """
                        Enter the hardcopy color mode menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def color(self, *args, **kwargs):
                            """
                            Plot hardcopies in color.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/color").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Display the current hardcopy color mode.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/list").execute(*args, **kwargs)
                        def gray_scale(self, *args, **kwargs):
                            """
                            Convert color to grayscale for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/gray_scale").execute(*args, **kwargs)
                        def mono_chrome(self, *args, **kwargs):
                            """
                            Convert color to monochrome (black and white) for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/mono_chrome").execute(*args, **kwargs)

        class cell_register_operations(TUIMenu):
            """
            Enters the cell register operations menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/delete").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a new cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists the currently defined cell register operations.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list_properties").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enters the set solution parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                super().__init__(path, service)
            def residual_verbosity(self, *args, **kwargs):
                """
                Sets the amount of residual information to be printed. A value of 0 (the default) prints residuals at the end of each fine grid iteration. A value of 1 prints residuals after every stage of the fine grid iteration. A value of 2 prints residuals after every stage on every grid level.
                """
                return PyMenu(self.service, "/solve/set/residual_verbosity").execute(*args, **kwargs)
            def moving_mesh_numerics(self, *args, **kwargs):
                """
                Transient options for sliding, moving, and/or dynamic mesh.
                """
                return PyMenu(self.service, "/solve/set/moving_mesh_numerics").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Sets the number of iterations for which convergence monitors are reported. The default is 1 (after every iteration).
                """
                return PyMenu(self.service, "/solve/set/reporting_interval").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Sets pressure-velocity controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Sets gradient options.
                """
                return PyMenu(self.service, "/solve/set/gradient_scheme").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Sets damping function in flow direction. This command appears only when the VOF model is enabled. Select the damping function to be used:
                Index
                Damping Function
                0
                Linear
                1
                Quadratic
                2
                Cubic
                3
                Cosine.
                """
                return PyMenu(self.service, "/solve/set/numerical_beach_controls").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Sets the order in which the model equations are solved, which can affect the convergence speed when you are using the pressure-based solver. The standard method is enabled by default and corresponds to the ordering shown in  and  in the Theory Guide; alternatively, you can select theoptimized-for-volumetric-expansion method, which is recommended for flows in which the density is strongly dependent on thermal effects, chemical composition, and so on (such as combustion simulations). This text command is not available for steady simulations and/or when a multiphase model is enabled.
                """
                return PyMenu(self.service, "/solve/set/equation_ordering").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def multi_stage(self, *args, **kwargs):
                """
                Sets the multi-stage coefficients and the dissipation and viscous evaluation stages. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_stage").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Sets solution steering parameters.
                """
                return PyMenu(self.service, "/solve/set/set_solution_steering").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enters the max-corrections menu.
                """
                return PyMenu(self.service, "/solve/set/max_corrections").execute(*args, **kwargs)
            def multi_grid_controls(self, *args, **kwargs):
                """
                Sets multigrid parameters and termination criteria.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_controls").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Sets the number of iterations for a steady-state simulation without starting the calculation.
                """
                return PyMenu(self.service, "/solve/set/number_of_iterations").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Selects the equations to be solved.
                """
                return PyMenu(self.service, "/solve/set/equations").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enables solution steering for the density-based solver.
                """
                return PyMenu(self.service, "/solve/set/solution_steering").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when quantities are being limited. By default, limiter warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/limiter_warnings").execute(*args, **kwargs)
            def numerics(self, *args, **kwargs):
                """
                Sets numerics options.
                """
                return PyMenu(self.service, "/solve/set/numerics").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Sets the fine-grid Courant number (time step factor). This command is available only for the coupled solvers.
                """
                return PyMenu(self.service, "/solve/set/courant_number").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Sets the heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/solve/set/heterogeneous_stiff_chemistry").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enters the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solve/set/relaxation_factor").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Sets all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solve/set/set_all_species_together").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Sets the sub time step calculation method for VOF calculations.
                """
                return PyMenu(self.service, "/solve/set/vof_explicit_controls").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Specifies whether you want to lock (or “freeze”) the temperature values for all the cells in solid zones (including those to which you have a hooked an energy source through a UDF) and in walls that have shell conduction enabled, so that the values do not change during further solver iterations.
                """
                return PyMenu(self.service, "/solve/set/lock_solid_temperature").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Enables data sampling for steady or unsteady flow statistics.
                """
                return PyMenu(self.service, "/solve/set/data_sampling").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Completely disables reconstruction, resulting in totally first-order accuracy.
                """
                return PyMenu(self.service, "/solve/set/disable_reconstruction").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Selects which pressure-velocity coupling scheme is to be used. Five schemes are available:.
                """
                return PyMenu(self.service, "/solve/set/p_v_coupling").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                For flows that do not transition from sub-critical to super-critical, or vice-versa, you can speed-up the solution calculation by updating the frequency of Froude number during run time.
                """
                return PyMenu(self.service, "/solve/set/open_channel_controls").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solve/set/time_step").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension_expert").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Sets solver limits for various solution variables, in order to improve the stability of the solution.
                """
                return PyMenu(self.service, "/solve/set/limits").execute(*args, **kwargs)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Sets solver options for stiff chemistry solutions.
                """
                return PyMenu(self.service, "/solve/set/stiff_chemistry").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Sets controls to default values.
                """
                return PyMenu(self.service, "/solve/set/set_controls_to_default").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Sets anisotropic drag parameters for the Eulerian multiphase model.
                """
                return PyMenu(self.service, "/solve/set/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enables convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solve/set/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enables a modified NITA scheme and other setting changes that can speed up the simulation. This option is only available with the Large Eddy Simulation (LES) turbulence model, and is intended for unreacting flow simulations that use a constant-density fluid.
                """
                return PyMenu(self.service, "/solve/set/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solve/set/material_property_warnings").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when reversed flow occurs at inlets and outlets, and when mass-flow inlets develop supersonic regions. By default, flow warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/flow_warnings").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enters the discretization scheme menu. This allows you to select the discretization scheme for the convection terms in the solution equations. The following text commands can make a selection from a subset of the models in the following table:.
                """
                return PyMenu(self.service, "/solve/set/discretization_scheme").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Sets phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solve/set/phase_based_vof_discretization").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enters the residual tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/residual_tolerance").execute(*args, **kwargs)
            def p_v_controls_advanced(self, *args, **kwargs):
                """
                Set advanced pressure-velocity coupling controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls_advanced").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Sets pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solve/set/bc_pressure_extrapolations").execute(*args, **kwargs)
            def reactions(self, *args, **kwargs):
                """
                Enables the species reaction sources and sets relaxation factor.
                """
                return PyMenu(self.service, "/solve/set/reactions").execute(*args, **kwargs)
            def enable_output_dp_dt(self, *args, **kwargs):
                """
                Controls whether the output field variabledp-dt will be available for transient simulation postprocessing. If you select no, pressure fields at the previous time steps will not be stored in memory which reduces memory usage.
                """
                return PyMenu(self.service, "/solve/set/enable_output_dp_dt").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Sets the reference density method for the Eulerian multiphase model. The following options are available:
                0 (default): Averaged density of the phase
                1: Cell density of the phase
                1: Constant value of 1
                1: Cell density of the phase
                See  for more information.
                """
                return PyMenu(self.service, "/solve/set/mp_reference_density").execute(*args, **kwargs)
            def multi_grid_fas(self, *args, **kwargs):
                """
                Sets the parameters that control the FAS multigrid solver. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_fas").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enters the under-relaxation menu, which allows you to set the under-relaxation factor for each equation that is being solved in a segregated manner.
                """
                return PyMenu(self.service, "/solve/set/under_relaxation").execute(*args, **kwargs)
            def relaxation_method(self, *args, **kwargs):
                """
                Sets the solver relaxation method.
                """
                return PyMenu(self.service, "/solve/set/relaxation_method").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Sets VOF numeric options.
                """
                return PyMenu(self.service, "/solve/set/vof_numerics").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Switches between the modified treatment of node-based gradients at boundary cells and the legacy treatment (R14.5.7 and earlier). If using the density-based solver, you can also specify the extended treatment. For details, see .
                """
                return PyMenu(self.service, "/solve/set/nb_gradient_boundary_option").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Sets the solution methods to the default settings.
                """
                return PyMenu(self.service, "/solve/set/set_solution_methods_to_default").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Sets the implicit residual smoothing parameters. This command is available only for the explicit coupled solver.
                """
                return PyMenu(self.service, "/solve/set/residual_smoothing").execute(*args, **kwargs)
            def multi_grid_amg(self, *args, **kwargs):
                """
                Sets the parameters that govern the algebraic multigrid procedure.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_amg").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solve/set/flux_type").execute(*args, **kwargs)
            def correction_tolerance(self, *args, **kwargs):
                """
                Enters the correction tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/correction_tolerance").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/variable_time_stepping").execute(*args, **kwargs)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/adaptive_time_stepping").execute(*args, **kwargs)
            def slope_limiter_set(self, *args, **kwargs):
                """
                Selects a new Fluent solver slope limiter.
                """
                return PyMenu(self.service, "/solve/set/slope_limiter_set").execute(*args, **kwargs)
            def expert(self, *args, **kwargs):
                """
                Sets expert options.
                """
                return PyMenu(self.service, "/solve/set/expert").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Sets surface-tension calculation options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Enables / disables the variable time step size formulation for second-order implicit transient formulations. If you disable the variable time step size formulation, note that any change in the time step size will introduce an error proportional to the change in the time step size ratio.
                """
                return PyMenu(self.service, "/solve/set/second_order_time_options").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Sets buffer layer height, verbosity, and open channel wave theory formulation.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Specifies which open channel wave theory formulation Fluent uses.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Sets the open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Sets the buffer layer height.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enters the warped-face gradient correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables gradient enhancement computations and specifies whether Fluent uses fast or memory saving mode.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enters the pseudo time method menu. This menu is only available for cases that use a pressure-based segregated solver (SIMPLE, SIMPLEC, or PISO) or for steady-state cases that use the pressure-based coupled solver or the density-based implicit solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def formulation(self, *args, **kwargs):
                    """
                    Enables and sets the pseudo time step size formulation or disables the pseudo time method option.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/formulation").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time settings for the calculation when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time Courant number when the local time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enters the relaxation factors menu, where you can set the pseudo time explicit relaxation factors for individual equations. These factors only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enters the advanced options menu, which allows you to enable / disable the pseudo time method for individual equations and define their pseudo time scale factors or under-relaxation factors, respectively. These settings only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity of the messages related to the pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/verbosity").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Enter the menu for specifying quantities and zones for steady and unsteady flow statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    Lists the combinations of zones and quantities that are defined for sampling steady and unsteady flow statistics.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/list_datasets").execute(*args, **kwargs)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Specify zone and quantity combinations for sampling Fourier coefficients of unsteady flows.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_datasets").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Speed Numerics.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/enable").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Sets the level of stabilization used to achieve fast convergence. Enter a number 0-5 corresponding to the Mach number range that best characterizes the flow.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/expert").execute(*args, **kwargs)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Makes available the Pressure Discontinuity Sensor which is a binary identifier equal to 1 if a cell is in proximity of a pressure discontinuity.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)

            class fast_transient_settings(TUIMenu):
                """
                Enters the fast transient settings menu. This menu is only available for transient cases that use the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rk2(self, *args, **kwargs):
                    """
                    Allows you to enable the use of a two-stage Runge-Kutta scheme for time integration, or revert to the default multi-stage Runge-Kutta scheme. This text command is only available for transient cases that use the density-based explicit formulation.
                    """
                    return PyMenu(self.service, "/solve/set/fast_transient_settings/rk2").execute(*args, **kwargs)

            class amg_options(TUIMenu):
                """
                Enters the AMG options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def conservative_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of conservative coarsening techniques for scalar and/or coupled equations that can improve parallel performance and/or convergence for some difficult cases.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                def amg_gpgpu_options(self, *args, **kwargs):
                    """
                    Set GPGPU AMG solver options.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                def aggressive_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of a version of the AMG solver that is optimized for high coarsening rates. This option is recommended if the AMG solver diverges with the default settings.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)
                def laplace_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables Laplace coarsening for scalar and/or coupled equations.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/laplace_coarsening").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Specifies overset meshing solver options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enables/disables a numerical treatment that attempts to assign reasonable data values to orphan cells.
                    """
                    return PyMenu(self.service, "/solve/set/overset/orphan_cell_treatment").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    Uses the pressure gradient of the donor cell in the interpolation of pressure for its receptor cell.
                    """
                    return PyMenu(self.service, "/solve/set/overset/high_order_pressure").execute(*args, **kwargs)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Selects the interpolation method for overset interfaces. Note that the least squares method is recommended for sliding mesh cases.
                    """
                    return PyMenu(self.service, "/solve/set/overset/interpolation_method").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Enters the advanced settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.turbomachinery_specific_numerics = self.__class__.turbomachinery_specific_numerics(path + ["turbomachinery_specific_numerics"], service)
                    self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                    self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                    super().__init__(path, service)
                def show_all_discretization_schemes(self, *args, **kwargs):
                    """
                    Enables/disables the availability of all applicable discretization schemes.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/show_all_discretization_schemes").execute(*args, **kwargs)
                def correction_form(self, *args, **kwargs):
                    """
                    S.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/correction_form").execute(*args, **kwargs)
                def energy_reconstruction_gradient_limiting(self, *args, **kwargs):
                    """
                    Enable limiting of reconstruction gradient for the energy equation.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_reconstruction_gradient_limiting").execute(*args, **kwargs)
                def skewness_correction_enhanced(self, *args, **kwargs):
                    """
                    Enable enhanced skewness correction scheme.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/skewness_correction_enhanced").execute(*args, **kwargs)
                def bcd_weights_freeze(self, *args, **kwargs):
                    """
                    Enables/disables freezing of weighting coefficients of the central differencing and the upwind components of the BCD scheme. This dialog command requires the iteration number, after which the BCD scheme weights are to be frozen at each timestep. Freezing the BCD weighting coefficients may help to improve convergence of the timestep iterations as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_weights_freeze").execute(*args, **kwargs)
                def alternate_wall_temp_formulation(self, *args, **kwargs):
                    """
                    Enables/disables an alternate formulation for wall temperatures.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/alternate_wall_temp_formulation").execute(*args, **kwargs)
                def singhal_et_al_cavitation_model(self, *args, **kwargs):
                    """
                    Enables/disables the availability of the Singhal et al. cavitation model option, which can then be enabled in the Multiphase Model dialog box or by using the following text command: define/phases/set-domain-properties/interaction-domain/heat-mass-reaction/cavitation/cavitation?.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/singhal_et_al_cavitation_model").execute(*args, **kwargs)
                def linearized_mass_transfer_udf(self, *args, **kwargs):
                    """
                    Enables/disables the use of a linearized mass transfer user-defined function (that is, the DEFINE_LINEARIZED_MASS_TRANSFER macro), as opposed to a mass transfer user-defined function (that is, the DEFINE_MASS_TRANSFER macro).
                    """
                    return PyMenu(self.service, "/solve/set/advanced/linearized_mass_transfer_udf").execute(*args, **kwargs)
                def retain_cell_residuals(self, *args, **kwargs):
                    """
                    Enables/disables the retention of cell residuals for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_cell_residuals").execute(*args, **kwargs)
                def bcd_boundedness(self, *args, **kwargs):
                    """
                    Specifies the BCD scheme parameter, which controls the boundedness strength of the BCD scheme in the pressure-based solver, as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_boundedness").execute(*args, **kwargs)
                def retain_temporary_solver_mem(self, *args, **kwargs):
                    """
                    Enables/disables the retention of temporary solver memory, which retains gradient data and makes some advanced options available for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_temporary_solver_mem").execute(*args, **kwargs)
                def anisotropic_solid_heat_transfer(self, *args, **kwargs):
                    """
                    Set up the heat transfer for anisotropic solid zones.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/anisotropic_solid_heat_transfer").execute(*args, **kwargs)
                def energy_numerical_noise_filter(self, *args, **kwargs):
                    """
                    Enables/disables a filter to eliminate non-physical numerical noise in the energy field. Numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present. Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive. This text command is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_numerical_noise_filter").execute(*args, **kwargs)
                def explicit_under_relaxation_value(self, *args, **kwargs):
                    """
                    Explicit under-relaxation value.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/explicit_under_relaxation_value").execute(*args, **kwargs)

                class turbomachinery_specific_numerics(TUIMenu):
                    """
                    Enter turbomachinery specific numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Activate/deactivate turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/enable").execute(*args, **kwargs)
                    def settings(self, *args, **kwargs):
                        """
                        Adjust settings for turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/settings").execute(*args, **kwargs)

                class non_reflecting_boundary_treatment(TUIMenu):
                    """
                    Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)

                class secondary_gradient_limiting(TUIMenu):
                    """
                    Enters the secondary gradient limiting menu. This menu is only available when the define/models/solver/pressure-based text command is enabled.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def energy(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the energy  calculations on coupled two-sided walls. This limiting can help prevent  divergence when the cells on such walls have poor orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                    def mesh_quality_limits(self, *args, **kwargs):
                        """
                        Defines the mesh quality limits used when applying secondary  gradient limiting to faces on coupled two-sided walls. Shifting this  range closer to 1 will decrease the risk of divergence, but at the cost  of accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)
                    def uds(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the user-defined  scalar (UDS) calculations on coupled two-sided walls. This limiting can  help prevent divergence when the cells on such walls have poor  orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/uds").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    super().__init__(path, service)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/verbosity").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enters the menu to specify parameters of the acoustics wave equation solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the menu to specify the expert parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the implicit under-relaxation factor. Should be used only  with bad meshes, when the AMG linear solver does not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the explicit relaxation factor. Should be used only with  bad meshes, when iterations do not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enters the divergence prevention menu. This menu is only available for the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables a divergence prevention option so that Fluent applies under-relaxation to the variables in select cells where the temperature and/or pressure values are approaching the minimum and/or maximum limits.
                    """
                    return PyMenu(self.service, "/solve/set/divergence_prevention/enable").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Provides text commands that allow you to undo enhancements to the default solver behavior.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2022 R1 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2021 R2 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2021 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R3 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enters the transient controls menu, which allows you to define settings related to time advancement for transient flow calculations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Sets the maximum flow time.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_flow_time").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the total number of time steps that the simulation will run (which includes any time steps that have already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to1.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the convective time scale (global Courant number): the time-step-size calculation depends on the mesh density and velocity in interfacial cells. This method is available for all multiphase models using the implicit or explicit volume fraction formulation, except for the wet steam model.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enters the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which a specified period or frequency is the basis for determining the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Sets the total amount of time that the simulation will be run (which includes any time that has already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to2.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_time").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Sets the method by which you will specify the duration of the calculation. The duration can be defined by the total time, the total number of time steps, the incremental time, or the number of incremental time steps. In this context, "total" indicates that Fluent will consider the amount of time / steps that have already been solved and stop appropriately, whereas "incremental" indicates that the solution will proceed for a specified amount of time / steps regardless of what has previously been calculated. This text command is only available when the time stepping is adaptive or based on a user-defined function.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Specifies whether to define the transient advancement either directly by entering a time step size / period / frequency (using the text commands available in thesolve/set/transient-controls menu) or indirectly by entering a Courant number value (using the solve/set/courant-number text command). This text command is only available for the density-based solver when both the explicit formulation and explicit transient formulation are used.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/specified_time_step").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    When enabled, if the truncation error within a time step exceeds the specified tolerance Fluent will automatically undo the current calculation and make another attempt with the time step reduced by 1/2. This will be attempted up to 5 times after which Fluent will accept the result and proceed to the next time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/undo_timestep").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which you directly specify the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Allows you to open theSimulation Status dialog box, which reports details about the simulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solution_status").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Specifies the time interval for acoustic data sampling. This text command is only available when both the Ffowcs Williams and Hawkings model is selected and the density-based solver is used with the explicit formulation and explicit transient formulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size is defined by a user-defined function (UDF) that uses theDEFINE_DELTAT macro.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size used for solid zones is independent from that used for fluid zones. This text command is only available when both a solid zone exists and energy is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Enables / disables an option that allows for better prediction of the flow field in rotating fluid zones at every time step, in order to speed up the calculation. This text command is only available for transient simulations.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the specified truncation error tolerance.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Sets the amount of incremental (that is, additional) time to run the simulation, regardless of how much time has already been run in previous calculations. This text command is only available when the solve/set/transient-controls/duration-specification-method is set to3.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/incremental_time").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation without starting the calculation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation.  This option is available when automatic initialization and case modification is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial conditions at time step n+1. The predictor algorithm is a computation that sets a better initial condition for the time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing the next time step. The predictor algorithm is a computation that sets a better initial condition for the time step. It uses the rate of change between the prediction and the correction as an indicator for whether the next time step should be larger, smaller, or the same as the current one.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/predict_next_time").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Sets the magnitude of the (physical) time step . This text command is only available when the solve/set/transient-controls/fixed-user-specified text command is set toyes.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent as the calculation proceeds such that the Courant–Friedrichs–Lewy (CFL) condition is satisfied, using the specified Courant number.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Enters the menu for setting multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def verbosity(self, *args, **kwargs):
                        """
                        When enabled, various time scales (depending on the selection) are  printed to the console window at every time step. This text command is  available with the moving mesh CFL constraint and with the physics-based  constraint.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Enables/disables the physics-driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Enters the menu for choosing the time-scale options. This menu  becomes available after you enable the physics-driven time-step  constraints using the solve/set/transient-controls/multiphase-specific-time-constraints/physics-based-constraint?  text command.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the acoustic time scale. This option is available only for compressible flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the surface-tension-driven time scale. This option is available only if the surface tension force modeling is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the viscous time scale. This option is disabled by default. This command is not available with inviscid flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the gravitational time scale. This option is available only if gravity is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enters the NITA expert control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Setting this to 1, enables the verbosity for NITA diagnostics. The default value of 0 disables verbosity output for NITA diagnostics.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/set_verbosity").execute(*args, **kwargs)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Enables and sets hybrid NITA options. For more details, see .
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Enables/disables coupling of the neighbor and skewness corrections.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Sets multiphase numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    super().__init__(path, service)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class boiling_parameters(TUIMenu):
                    """
                    Enters the menu for the multiphase boiling model parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        When enabled, considers liquid volume fraction effects by multiplying the heat transfer coefficients by the local liquid volume fraction.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)
                    def thin_film(self, *args, **kwargs):
                        """
                        When enabled, includes multiphase boiling thin film effects using .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Enters the menu for the stability controls for multiphase flows. For more information about the below option, see  and .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        super().__init__(path, service)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)

                    class hybrid_nita(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Sets the number of outer iterations.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Allows you to change the number of initial time-steps and the number of initial outer iterations to control solution stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Enters the menu for the instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Sets the number of outer iterations for an unstable  event.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enables/disables the instability detector to deal with  possible instability problems. Once this option is enabled,  additional instability detection options become  available.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Sets the Courant number limit for detecting unstable  events. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Selects the CFL number type for detection of an unstable  event. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Sets the velocity limit for detecting unstable events.  This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Enters the anti-diffusion menu. This item is available for VOF cases  with the Interfacial Anti-Diffusion option  enabled.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Sets the maximum value of dynamic anti-diffusion strength in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Sets the cosine exponent in the dynamic strength treatment in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enables dynamic strength to reduce compression in the direction tangential to the interface.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            When enabled, solves the flow equation at the end of the iteration. This improves the behavior at the start of new time-step if the solution does not converge properly.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Enters the menu for the pressure-velocity coupling controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            super().__init__(path, service)

                        class coupled_vof(TUIMenu):
                            """
                            Enters the stability control menu for VOF cases that involve the Coupled pressure-velocity coupling scheme.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Allows you to use the linearized buoyancy force and the  blended treatment for the buoyancy force.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Enters the stability controls menu for the Rhie-Chow interpolation.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Enables/disables the low-order velocity interpolation in  the flux calculation.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class skewness_correction(TUIMenu):
                            """
                            Enters the skewness correction menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Enables/disables the limited pressure correction  gradient in skewness terms for the PISO, SIMPLEC, or  fractional step pressure-coupling schemes.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Enters the viscous multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Forces harmonic averaging of cell viscosities to calculate face  viscosity used in momentum equation. This can improve convergence for  highly viscous flow applications (the VOF model only).
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    Enters the solution-stabilization numerics menu. This item is available only for the VOF model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        super().__init__(path, service)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        When enabled, uses additional controls for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        When enabled, modifies solver settings for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Enters the menu for the velocity-limiting-treatment.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Specifies the maximum velocity magnitude.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enables/disables the velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            When enabled, the solver prints the number of velocity limited cells at each iteration.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Enters the menu for additional advanced stability controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Enables/disables the blended compressive discretization scheme.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Enters the porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Allows you to fix the saturation (volume fraction) of the phase at  its user-specified residual saturation value.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Enters the menu for the multiphase heat mass transfer parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Enables the alternative treatment of the energy sources. For more  information, see .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Enters the cavitation heat mass transfer menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enables/disables the turbulent diffusion treatment for a cavitating turbulent flow. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Sets the minimum vapor pressure limit for the cavitation mass-transfer model. The default value is 1 Pa.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the vapor pressure after the turbulence and thermal correction. The default value is five times the vapor pressure, with consideration of turbulent and thermal effects for each cell and phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Sets the evaporation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 1.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Sets the condensation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 0.2.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Enters the menu for the advanced boiling options for the  semi-mechanistic boiling model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes the expert options for the semi-mechanistic boiling model. For more information about these options, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Enables/disables the two-resistance boiling framework to improve the robustness and accuracy of the solution of cases with multiple boiling mechanisms. For more information about this item, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Sets the under-relaxation factor for boiling heat flux. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Enters the menu for the area density.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Enables/disables the interfacial area density Gradient-Symmetric model. For more information about this model, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Sets the minimum volume fraction for the area density and cavitation. This may be useful, for example, in cases when a species mass transfer model (such as the Symmetric model or Particle model) do not consider evaporation or condensation if the volume fraction of one of the phases is zero. The seeding allows for a phase change to occur in the fluid flow. The default value is 1e-6.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Enters the default controls menu. This menu is available only for multiphase flows.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Applies the multiphase defaults (version 2020 R1) to the loaded case  file.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Enters the compressible multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Enables an enhanced numerical treatment that provides better  stability at startup and during calculation of compressible  flows.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Enables an alternative formulation for compressible phases at an  inlet boundary. This formulation calculates static temperature and  pressure using an iterative method based on fundamental thermodynamic  relations.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solve/set/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/expert").execute(*args, **kwargs)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets the relaxation factor.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Selects the variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enters the poor mesh numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.user_defined_on_register_auto = self.__class__.user_defined_on_register_auto(path + ["user_defined_on_register_auto"], service)
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Sets the orthogonal quality threshold used for applying poor mesh numerics when the solve/set/poor-mesh-numerics/cell-quality-based? text command is enabled. By default, cells with an orthogonal quality of 0.05 or lower are corrected.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the cell gradient quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command. This criterion is only available with the pressure-based solver, and is not supported for cases that have periodic boundaries.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells (those with an orthogonal quality of 0, as well as those identified by other enabled criteria), and defines whether the local solution correction is 0th, 1st, or 2nd order.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Prints out a listing of the poor cells for each criterion: default, cell quality, and user-defined, and (if enabled) cell gradient quality and solution and cell quality.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Enables/disables the relocation of select cell centroids, to improve the orthogonality metrics and solution stability. It is applied to cells when the criterion value is equal to or less than a threshold value defined as part of the text command. Note that the enhanced metrics are only apparent when reporting the quality in the solution mode of Fluent, and not in the meshing mode.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells with an orthogonal quality that is equal to or less than the threshold defined by the solve/set/poor-mesh-numerics/set-quality-threshold text command (which by default is set to 0.05).
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the solution and cell quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command, and at a specified frequency (of iterations or time steps). This criterion is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Includes a register for the poor mesh numerics or not.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Resets the list of poor cells included by the default, cell quality, user-defined, cell gradient quality, and solution and cell quality criteria.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)

                class user_defined_on_register_auto(TUIMenu):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def set(self, *args, **kwargs):
                        """
                        Edit a definition for automatic poor mesh numerics.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register_auto/set").execute(*args, **kwargs)
                    def list_properties(self, *args, **kwargs):
                        """
                        List the properties of a definition for automatic poor mesh numerics.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register_auto/list_properties").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enters the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                super().__init__(path, service)
            def lwf_initialization(self, *args, **kwargs):
                """
                Deletes wall film particles and initializes wall film variables to zero. This option is available only with the wall-film DPM boundary condition.
                """
                return PyMenu(self.service, "/solve/initialize/lwf_initialization").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Sets default initial values.
                """
                return PyMenu(self.service, "/solve/initialize/set_defaults").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Sets reference frame to absolute or relative.
                """
                return PyMenu(self.service, "/solve/initialize/reference_frame").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Displays the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_time_sampled").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Opens channel automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specifies the number of timesteps for ramping of sound sources and re-initializes the acoustics wave equation solution. For the initialized acoustics solution, Fluent reports the current state of the sound sources ramping.
                """
                return PyMenu(self.service, "/solve/initialize/init_acoustics_options").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enters the set full-multigrid for initialization menu. Initial values for each variable can be set within this menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Displays the number of iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                Lists default values.
                """
                return PyMenu(self.service, "/solve/initialize/list_defaults").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initializes instantaneous velocity field out of steady state RANS results, for use before enabling a scale resolving simulation such as LES.
                """
                return PyMenu(self.service, "/solve/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Resets discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solve/initialize/dpm_reset").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initializes using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solve/initialize/hyb_initialization").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solve/initialize/patch").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/levelset_auto_init").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solve/initialize/repair_wall_distance").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initializes the flow field with the current default values.
                """
                return PyMenu(self.service, "/solve/initialize/initialize_flow").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enters the hybrid initialization menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initializes using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solve/initialize/fmg_initialization").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initializes unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/init_flow_statistics").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enters the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)
                def set_options(self, *args, **kwargs):
                    """
                    Sets options for patching and smoothing volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Enters the menu for localized turbulent flow initialization.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables localized initialization of turbulent flow variables.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Sets values for the turbulent intensity and turbulent viscosity ratio for localized initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enters the compute default values menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_default