# KSO - Utils

The Koster Seafloor Observatory is an open-source, citizen science and machine learning approach to analyse subsea movies.

<!-- PROJECT SHIELDS -->
<!--
*** I'm using markdown "reference style" links for readability.
*** Reference links are enclosed in brackets [ ] instead of parentheses ( ).
*** See the bottom of this document for the declaration of the reference variables
*** for contributors-url, forks-url, etc. This is an optional, concise syntax you may use.
*** https://www.markdownguide.org/basic-syntax/#reference-style-links
-->
[![Contributors][contributors-shield]][contributors-url]
[![Forks][forks-shield]][forks-url]
[![Stargazers][stars-shield]][stars-url]
[![Issues][issues-shield]][issues-url]
[![MIT License][license-shield]][license-url]

![high-level][high-level-overview]

## Module Overview
This utils module contains scripts and resources that are called by the tutorials used in the [data management module][datammodule] and [Object Detection module][objdecmodule]. 

![utils_module][utils_module]

## Citation

If you use this code or its models in your research, please cite:

Anton V, Germishuys J, Bergström P, Lindegarth M, Obst M (2021) An open-source, citizen science and machine learning approach to analyse subsea movies. Biodiversity Data Journal 9: e60548. https://doi.org/10.3897/BDJ.9.e60548

## Collaborations/questions
You can find out more about the project at https://www.zooniverse.org/projects/victorav/the-koster-seafloor-observatory.

We are always excited to collaborate and help other marine scientists. Please feel free to [contact us](matthias.obst@marine.gu.se) with your questions.

<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
[contributors-shield]: https://img.shields.io/github/contributors/ocean-data-factory-sweden/kso_utils.svg?style=for-the-badge
[contributors-url]: https://https://github.com/ocean-data-factory-sweden/kso_utils/graphs/contributors
[forks-shield]: https://img.shields.io/github/forks/ocean-data-factory-sweden/kso_utils.svg?style=for-the-badge
[forks-url]: https://github.com/ocean-data-factory-sweden/kso_utils/network/members
[stars-shield]: https://img.shields.io/github/stars/ocean-data-factory-sweden/kso_utils.svg?style=for-the-badge
[stars-url]: https://github.com/ocean-data-factory-sweden/kso_utils/stargazers
[issues-shield]: https://img.shields.io/github/issues/ocean-data-factory-sweden/kso_utils.svg?style=for-the-badge
[issues-url]: https://github.com/ocean-data-factory-sweden/kso_utils/issues
[license-shield]: https://img.shields.io/github/license/ocean-data-factory-sweden/kso_utils.svg?style=for-the-badge
[license-url]: https://github.com/ocean-data-factory-sweden/kso_utils/blob/main/LICENSE.txt
[high-level-overview]: https://github.com/ocean-data-factory-sweden/koster_data_management/blob/main/images/high-level-overview.png?raw=true "Overview of the three main modules and the components of the Koster Seafloor Observatory"
[datammodule]: https://github.com/ocean-data-factory-sweden/koster_data_management
[objdecmodule]: https://github.com/ocean-data-factory-sweden/koster_yolov4
[utils_module]: https://github.com/ocean-data-factory-sweden/koster_data_management/blob/main/images/Koster_utils_module.png?raw=true
