# Generated by Django 3.1.3 on 2021-02-06 11:37

from django.db import migrations


def fixup_changes(apps, schema_editor):
    Change = apps.get_model("trans", "Change")
    db_alias = schema_editor.connection.alias
    # ACTION_DICTIONARY_NEW => ACTION_NEW
    Change.objects.using(db_alias).filter(action=10).update(action=5)
    # ACTION_DICTIONARY_EDIT => ACTION_CHANGE
    Change.objects.using(db_alias).filter(action=11).update(action=2)
    # ACTION_DICTIONARY_UPLOAD => ACTION_UPLOAD
    Change.objects.using(db_alias).filter(action=12).update(action=9)


class Migration(migrations.Migration):

    dependencies = [
        ("trans", "0117_remove_change_glossary_term"),
    ]

    operations = [migrations.RunPython(fixup_changes, elidable=True)]
